/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ons.open.trace.core.dispatch.impl;

import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;
import com.aliyun.openservices.ons.api.impl.rocketmq.ClientRPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.namesrv.TopAddressing;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class TraceProducerFactory {
    private static Map<String, Object> dispatcherTable = new ConcurrentHashMap<String, Object>();
    private static AtomicBoolean isStarted = new AtomicBoolean(false);
    private static DefaultMQProducer traceProducer;

    public static DefaultMQProducer getTraceDispatcherProducer(Properties properties) {
        if (traceProducer == null) {
            Object object = new SessionCredentials();
            Properties properties2 = new Properties();
            String string = properties.getProperty("AccessKey");
            String string2 = properties.getProperty("SecretKey");
            properties2.put("AccessKey", string);
            properties2.put("SecretKey", string2);
            ((SessionCredentials)object).updateContent(properties2);
            traceProducer = new DefaultMQProducer(new ClientRPCHook((SessionCredentials)object));
            traceProducer.setProducerGroup(string + "_INNER_TRACE_PRODUCER");
            traceProducer.setSendMsgTimeout(5000);
            traceProducer.setInstanceName(properties.getProperty("InstanceName", String.valueOf(System.currentTimeMillis())));
            object = properties.getProperty("NAMESRV_ADDR");
            if (object == null) {
                object = new TopAddressing(properties.getProperty("ADDRSRV_URL"));
                object = ((TopAddressing)object).fetchNSAddr();
            }
            traceProducer.setNamesrvAddr((String)object);
            traceProducer.setVipChannelEnabled(false);
            int n2 = Integer.parseInt(properties.getProperty("MaxMsgSize", "128000"));
            traceProducer.setMaxMessageSize(n2 - 10000);
        }
        return traceProducer;
    }

    public static DefaultMQProducer getTraceDispatcherProducer(Properties properties, SessionCredentials object) {
        if (traceProducer == null) {
            String string = properties.getProperty("AccessKey");
            traceProducer = new DefaultMQProducer(new ClientRPCHook((SessionCredentials)object));
            traceProducer.setProducerGroup(string.replace('.', '-') + "_INNER_TRACE_PRODUCER");
            traceProducer.setSendMsgTimeout(5000);
            traceProducer.setInstanceName(properties.getProperty("InstanceName", String.valueOf(System.currentTimeMillis())));
            object = properties.getProperty("NAMESRV_ADDR");
            if (object == null) {
                object = new TopAddressing(properties.getProperty("ADDRSRV_URL"));
                object = ((TopAddressing)object).fetchNSAddr();
            }
            traceProducer.setNamesrvAddr((String)object);
            traceProducer.setVipChannelEnabled(false);
            int n2 = Integer.parseInt(properties.getProperty("MaxMsgSize", "128000"));
            traceProducer.setMaxMessageSize(n2 - 10000);
        }
        return traceProducer;
    }

    public static void registerTraceDispatcher(String string) {
        dispatcherTable.put(string, new Object());
        if (traceProducer != null && isStarted.compareAndSet(false, true)) {
            traceProducer.start();
        }
    }

    public static void unregisterTraceDispatcher(String string) {
        dispatcherTable.remove(string);
        if (dispatcherTable.isEmpty() && traceProducer != null && isStarted.get()) {
            traceProducer.shutdown();
        }
    }
}

