/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.bean;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.batch.BatchConsumer;
import com.aliyun.openservices.ons.api.batch.BatchMessageListener;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import java.util.Map;
import java.util.Properties;

public class BatchConsumerBean
implements BatchConsumer {
    private Properties properties;
    private Map<Subscription, BatchMessageListener> subscriptionTable;
    private BatchConsumer batchConsumer;

    @Override
    public boolean isStarted() {
        return this.batchConsumer.isStarted();
    }

    @Override
    public boolean isClosed() {
        return this.batchConsumer.isClosed();
    }

    @Override
    public void start() {
        if (this.properties == null) {
            throw new ONSClientException("properties not set");
        }
        if (this.subscriptionTable == null) {
            throw new ONSClientException("subscriptionTable not set");
        }
        this.batchConsumer = ONSFactory.createBatchConsumer(this.properties);
        for (Map.Entry<Subscription, BatchMessageListener> entry : this.subscriptionTable.entrySet()) {
            this.subscribe(entry.getKey().getTopic(), entry.getKey().getExpression(), entry.getValue());
        }
        this.batchConsumer.start();
    }

    @Override
    public void updateCredential(Properties properties) {
        if (this.batchConsumer != null) {
            this.batchConsumer.updateCredential(properties);
        }
    }

    @Override
    public void shutdown() {
        if (this.batchConsumer != null) {
            this.batchConsumer.shutdown();
        }
    }

    @Override
    public void subscribe(String string, String string2, BatchMessageListener batchMessageListener) {
        if (this.batchConsumer == null) {
            throw new ONSClientException("subscribe must be called after BatchConsumerBean started");
        }
        this.batchConsumer.subscribe(string, string2, batchMessageListener);
    }

    @Override
    public void unsubscribe(String string) {
        if (this.batchConsumer == null) {
            throw new ONSClientException("unsubscribe must be called after BatchConsumerBean started");
        }
        this.batchConsumer.unsubscribe(string);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<Subscription, BatchMessageListener> getSubscriptionTable() {
        return this.subscriptionTable;
    }

    public void setSubscriptionTable(Map<Subscription, BatchMessageListener> map) {
        this.subscriptionTable = map;
    }
}

