/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.bean;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ExpressionType;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.MessageSelector;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.aliyun.openservices.ons.api.bean.SubscriptionExt;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;

public class ConsumerBean
implements Consumer {
    private Properties properties;
    private Map<Subscription, MessageListener> subscriptionTable;
    private Consumer consumer;

    @Override
    public void start() {
        if (this.properties == null) {
            throw new ONSClientException("properties not set");
        }
        if (this.subscriptionTable == null) {
            throw new ONSClientException("subscriptionTable not set");
        }
        this.consumer = ONSFactory.createConsumer(this.properties);
        block2: for (Map.Entry<Subscription, MessageListener> entry : this.subscriptionTable.entrySet()) {
            Subscription subscription;
            if ("com.aliyun.openservices.ons.api.impl.notify.ConsumerImpl".equals(this.consumer.getClass().getCanonicalName()) && entry.getKey() instanceof SubscriptionExt) {
                subscription = (SubscriptionExt)entry.getKey();
                for (Method method : this.consumer.getClass().getMethods()) {
                    if (!"subscribeNotify".equals(method.getName())) continue;
                    try {
                        method.invoke((Object)this.consumer, subscription.getTopic(), subscription.getExpression(), ((SubscriptionExt)subscription).isPersistence(), entry.getValue());
                        continue block2;
                    }
                    catch (Exception exception) {
                        throw new ONSClientException("subscribeNotify invoke exception", exception);
                    }
                }
                continue;
            }
            subscription = entry.getKey();
            if (subscription.getType() == null || ExpressionType.TAG.name().equals(subscription.getType())) {
                this.subscribe(subscription.getTopic(), subscription.getExpression(), entry.getValue());
                continue;
            }
            if (ExpressionType.SQL92.name().equals(subscription.getType())) {
                this.subscribe(subscription.getTopic(), MessageSelector.bySql(subscription.getExpression()), entry.getValue());
                continue;
            }
            throw new ONSClientException(String.format("Expression type %s is unknown!", subscription.getType()));
        }
        this.consumer.start();
    }

    @Override
    public void updateCredential(Properties properties) {
        if (this.consumer != null) {
            this.consumer.updateCredential(properties);
        }
    }

    @Override
    public void shutdown() {
        if (this.consumer != null) {
            this.consumer.shutdown();
        }
    }

    @Override
    public void subscribe(String string, String string2, MessageListener messageListener) {
        if (this.consumer == null) {
            throw new ONSClientException("subscribe must be called after consumerBean started");
        }
        this.consumer.subscribe(string, string2, messageListener);
    }

    @Override
    public void subscribe(String string, MessageSelector messageSelector, MessageListener messageListener) {
        if (this.consumer == null) {
            throw new ONSClientException("subscribe must be called after consumerBean started");
        }
        this.consumer.subscribe(string, messageSelector, messageListener);
    }

    @Override
    public void unsubscribe(String string) {
        if (this.consumer == null) {
            throw new ONSClientException("unsubscribe must be called after consumerBean started");
        }
        this.consumer.unsubscribe(string);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<Subscription, MessageListener> getSubscriptionTable() {
        return this.subscriptionTable;
    }

    public void setSubscriptionTable(Map<Subscription, MessageListener> map) {
        this.subscriptionTable = map;
    }

    @Override
    public boolean isStarted() {
        return this.consumer.isStarted();
    }

    @Override
    public boolean isClosed() {
        return this.consumer.isClosed();
    }
}

