/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.bean;

import com.aliyun.openservices.ons.api.MessageSelector;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.order.MessageOrderListener;
import com.aliyun.openservices.ons.api.order.OrderConsumer;
import java.util.Map;
import java.util.Properties;

public class OrderConsumerBean
implements OrderConsumer {
    private Properties properties;
    private Map<Subscription, MessageOrderListener> subscriptionTable;
    private OrderConsumer orderConsumer;

    @Override
    public boolean isStarted() {
        return this.orderConsumer.isStarted();
    }

    @Override
    public boolean isClosed() {
        return this.orderConsumer.isClosed();
    }

    @Override
    public void start() {
        if (this.properties == null) {
            throw new ONSClientException("properties not set");
        }
        if (this.subscriptionTable == null) {
            throw new ONSClientException("subscriptionTable not set");
        }
        this.orderConsumer = ONSFactory.createOrderedConsumer(this.properties);
        for (Map.Entry<Subscription, MessageOrderListener> entry : this.subscriptionTable.entrySet()) {
            this.subscribe(entry.getKey().getTopic(), entry.getKey().getExpression(), entry.getValue());
        }
        this.orderConsumer.start();
    }

    @Override
    public void updateCredential(Properties properties) {
        if (this.orderConsumer != null) {
            this.orderConsumer.updateCredential(properties);
        }
    }

    @Override
    public void shutdown() {
        if (this.orderConsumer != null) {
            this.orderConsumer.shutdown();
        }
    }

    @Override
    public void subscribe(String string, String string2, MessageOrderListener messageOrderListener) {
        if (this.orderConsumer == null) {
            throw new ONSClientException("subscribe must be called after OrderConsumerBean started");
        }
        this.orderConsumer.subscribe(string, string2, messageOrderListener);
    }

    @Override
    public void subscribe(String string, MessageSelector messageSelector, MessageOrderListener messageOrderListener) {
        if (this.orderConsumer == null) {
            throw new ONSClientException("subscribe must be called after OrderConsumerBean started");
        }
        this.orderConsumer.subscribe(string, messageSelector, messageOrderListener);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<Subscription, MessageOrderListener> getSubscriptionTable() {
        return this.subscriptionTable;
    }

    public void setSubscriptionTable(Map<Subscription, MessageOrderListener> map) {
        this.subscriptionTable = map;
    }
}

