/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.bean;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import java.util.Properties;

public class TransactionProducerBean
implements TransactionProducer {
    private Properties properties;
    private LocalTransactionChecker localTransactionChecker;
    private TransactionProducer transactionProducer;

    @Override
    public void start() {
        if (this.properties == null) {
            throw new ONSClientException("properties not set");
        }
        this.transactionProducer = ONSFactory.createTransactionProducer(this.properties, this.localTransactionChecker);
        this.transactionProducer.start();
    }

    @Override
    public void updateCredential(Properties properties) {
        if (this.transactionProducer != null) {
            this.transactionProducer.updateCredential(properties);
        }
    }

    @Override
    public void shutdown() {
        if (this.transactionProducer != null) {
            this.transactionProducer.shutdown();
        }
    }

    @Override
    public SendResult send(Message message, LocalTransactionExecuter localTransactionExecuter, Object object) {
        return this.transactionProducer.send(message, localTransactionExecuter, object);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public LocalTransactionChecker getLocalTransactionChecker() {
        return this.localTransactionChecker;
    }

    public void setLocalTransactionChecker(LocalTransactionChecker localTransactionChecker) {
        this.localTransactionChecker = localTransactionChecker;
    }

    @Override
    public boolean isStarted() {
        return this.transactionProducer.isStarted();
    }

    @Override
    public boolean isClosed() {
        return this.transactionProducer.isClosed();
    }
}

