/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.authority;

import com.aliyun.openservices.ons.api.impl.authority.SigningAlgorithm;
import com.aliyun.openservices.ons.api.impl.authority.exception.AuthenticationException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.org.apache.commons.codec.binary.Base64;
import java.nio.charset.Charset;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class OnsAuthSigner {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger("RocketmqAuthorize");
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    public static final SigningAlgorithm DEFAULT_ALGORITHM = SigningAlgorithm.HmacSHA1;
    private static final int CAL_SIGNATURE_FAILED = 10015;
    private static final String CAL_SIGNATURE_FAILED_MSG = "[%s:signature-failed] unable to calculate a request signature. error=%s";

    public static String calSignature(String string, String string2) {
        return OnsAuthSigner.calSignature(string, string2, DEFAULT_ALGORITHM, DEFAULT_CHARSET);
    }

    public static String calSignature(String string, String string2, SigningAlgorithm signingAlgorithm, Charset charset) {
        return OnsAuthSigner.signAndBase64Encode(string, string2, signingAlgorithm, charset);
    }

    private static String signAndBase64Encode(String object, String string, SigningAlgorithm signingAlgorithm, Charset charset) {
        try {
            object = OnsAuthSigner.sign(((String)object).getBytes(charset), string.getBytes(charset), signingAlgorithm);
            return new String(Base64.encodeBase64((byte[])object), DEFAULT_CHARSET);
        }
        catch (Exception exception) {
            string = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, exception.getMessage());
            LOGGER.error(string, exception);
            throw new AuthenticationException("CAL_SIGNATURE_FAILED", 10015, string, exception);
        }
    }

    private static byte[] sign(byte[] object, byte[] byArray, SigningAlgorithm signingAlgorithm) {
        try {
            Mac mac = Mac.getInstance(signingAlgorithm.toString());
            mac.init(new SecretKeySpec(byArray, signingAlgorithm.toString()));
            return mac.doFinal((byte[])object);
        }
        catch (Exception exception) {
            object = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, exception.getMessage());
            LOGGER.error((String)object, exception);
            throw new AuthenticationException("CAL_SIGNATURE_FAILED", 10015, (String)object, exception);
        }
    }

    public static String calSignature(byte[] byArray, String string) {
        return OnsAuthSigner.calSignature(byArray, string, DEFAULT_ALGORITHM, DEFAULT_CHARSET);
    }

    public static String calSignature(byte[] byArray, String string, SigningAlgorithm signingAlgorithm, Charset charset) {
        return OnsAuthSigner.signAndBase64Encode(byArray, string, signingAlgorithm, charset);
    }

    private static String signAndBase64Encode(byte[] byArray, String string, SigningAlgorithm signingAlgorithm, Charset charset) {
        try {
            byArray = OnsAuthSigner.sign(byArray, string.getBytes(charset), signingAlgorithm);
            return new String(Base64.encodeBase64(byArray), DEFAULT_CHARSET);
        }
        catch (Exception exception) {
            string = String.format(CAL_SIGNATURE_FAILED_MSG, 10015, exception.getMessage());
            LOGGER.error(string, exception);
            throw new AuthenticationException("CAL_SIGNATURE_FAILED", 10015, string, exception);
        }
    }
}

