/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.authority;

import com.aliyun.openservices.ons.api.impl.rocketmq.ONSChannel;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Properties;

public class SessionCredentials {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    public static final String AccessKey = "AccessKey";
    public static final String SecretKey = "SecretKey";
    public static final String Signature = "Signature";
    public static final String SecurityToken = "SecurityToken";
    public static final String SignatureMethod = "SignatureMethod";
    public static final String ONSChannelKey = "OnsChannel";
    public static final String KeyFile = System.getProperty("rocketmq.client.keyFile", System.getProperty("user.home") + File.separator + "onskey");
    private String accessKey;
    private String secretKey;
    private String securityToken;
    private String signature;
    private String signatureMethod;
    private ONSChannel onsChannel = ONSChannel.ALIYUN;

    public SessionCredentials() {
        Object object = null;
        try {
            object = MixAll.file2String(KeyFile);
        }
        catch (IOException iOException) {}
        if (object != null && (object = MixAll.string2Properties((String)object)) != null) {
            this.updateContent((Properties)object);
        }
    }

    public void updateContent(Properties properties) {
        Object object = properties.getProperty(AccessKey);
        if (object != null) {
            this.accessKey = ((String)object).trim();
        }
        if ((object = properties.getProperty(SecretKey)) != null) {
            this.secretKey = ((String)object).trim();
        }
        if ((object = properties.get(ONSChannelKey)) != null) {
            this.onsChannel = ONSChannel.valueOf(object.toString());
        }
        if ((object = properties.getProperty(SecurityToken)) != null) {
            this.securityToken = ((String)object).trim();
        }
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String string) {
        this.accessKey = string;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String string) {
        this.secretKey = string;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String string) {
        this.signature = string;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public void setSecurityToken(String string) {
        this.securityToken = string;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String string) {
        this.signatureMethod = string;
    }

    public ONSChannel getOnsChannel() {
        return this.onsChannel;
    }

    public void setOnsChannel(ONSChannel oNSChannel) {
        this.onsChannel = oNSChannel;
    }

    public int hashCode() {
        int n2 = 31 + (this.accessKey == null ? 0 : this.accessKey.hashCode());
        n2 = n2 * 31 + (this.secretKey == null ? 0 : this.secretKey.hashCode());
        n2 = n2 * 31 + (this.signature == null ? 0 : this.signature.hashCode());
        n2 = n2 * 31 + (this.signatureMethod == null ? 0 : this.signatureMethod.hashCode());
        n2 = n2 * 31 + (this.onsChannel == null ? 0 : this.onsChannel.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (SessionCredentials)object;
        if (this.accessKey == null ? ((SessionCredentials)object).accessKey != null : !this.accessKey.equals(((SessionCredentials)object).accessKey)) {
            return false;
        }
        if (this.secretKey == null ? ((SessionCredentials)object).secretKey != null : !this.secretKey.equals(((SessionCredentials)object).secretKey)) {
            return false;
        }
        if (this.signature == null ? ((SessionCredentials)object).signature != null : !this.signature.equals(((SessionCredentials)object).signature)) {
            return false;
        }
        if (this.signatureMethod == null ? ((SessionCredentials)object).signatureMethod != null : !this.signatureMethod.equals(((SessionCredentials)object).signatureMethod)) {
            return false;
        }
        return !(this.onsChannel == null ? ((SessionCredentials)object).onsChannel != null : !this.onsChannel.equals((Object)((SessionCredentials)object).onsChannel));
    }

    public String toString() {
        return "SessionCredentials [accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", signature=" + this.signature + ", signatureMethod=" + this.signatureMethod + ", onsChannel=" + (Object)((Object)this.onsChannel) + "]";
    }
}

