/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.aliyun.openservices.ons.api.batch.BatchConsumer;
import com.aliyun.openservices.ons.api.batch.BatchMessageListener;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.BatchConsumerImpl$BatchMessageListenerImpl;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSConsumerAbstract;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class BatchConsumerImpl
extends ONSConsumerAbstract
implements BatchConsumer {
    private static final int MAX_BATCH_SIZE = 32;
    private static final int MIN_BATCH_SIZE = 1;
    private final ConcurrentHashMap<String, BatchMessageListener> subscribeTable = new ConcurrentHashMap();

    public BatchConsumerImpl(Properties object) {
        super((Properties)object);
        boolean bl = Boolean.parseBoolean(((Properties)object).getProperty("PostSubscriptionWhenPull", "false"));
        this.defaultMQPushConsumer.setPostSubscriptionWhenPull(bl);
        String string = ((Properties)object).getProperty("MessageModel", "CLUSTERING");
        this.defaultMQPushConsumer.setMessageModel(MessageModel.valueOf(string));
        object = ((Properties)object).getProperty("ConsumeMessageBatchMaxSize");
        if (!UtilAll.isBlank((String)object)) {
            int n2 = Math.min(32, Integer.valueOf((String)object));
            n2 = Math.max(1, n2);
            this.defaultMQPushConsumer.setConsumeMessageBatchMaxSize(n2);
        }
    }

    @Override
    public void start() {
        this.defaultMQPushConsumer.registerMessageListener(new BatchConsumerImpl$BatchMessageListenerImpl(this));
        super.start();
    }

    @Override
    public void subscribe(String string, String string2, BatchMessageListener batchMessageListener) {
        if (string == null) {
            throw new ONSClientException("topic is null");
        }
        if (batchMessageListener == null) {
            throw new ONSClientException("listener is null");
        }
        this.subscribeTable.put(string, batchMessageListener);
        super.subscribe(string, string2);
    }

    @Override
    public void unsubscribe(String string) {
        if (string != null) {
            this.subscribeTable.remove(string);
            super.unsubscribe(string);
        }
    }

    static /* synthetic */ ConcurrentHashMap access$000(BatchConsumerImpl batchConsumerImpl) {
        return batchConsumerImpl.subscribeTable;
    }
}

