/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.aliyun.openservices.ons.api.Admin;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.authority.SessionCredentials;
import com.aliyun.openservices.ons.api.impl.rocketmq.FAQ;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract$1;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract$2;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.ons.api.impl.util.NameAddrUtils;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.namesrv.TopAddressing;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ONSClientAbstract
implements Admin {
    protected static final String WSADDR_INTERNAL = System.getProperty("com.aliyun.openservices.ons.addr.internal", "http://onsaddr-internal.aliyun.com:8080/rocketmq/nsaddr4client-internal");
    protected static final String WSADDR_INTERNET = System.getProperty("com.aliyun.openservices.ons.addr.internet", "http://onsaddr-internet.aliyun.com/rocketmq/nsaddr4client-internet");
    protected static final long WSADDR_INTERNAL_TIMEOUTMILLS = Long.parseLong(System.getProperty("com.aliyun.openservices.ons.addr.internal.timeoutmills", "3000"));
    protected static final long WSADDR_INTERNET_TIMEOUTMILLS = Long.parseLong(System.getProperty("com.aliyun.openservices.ons.addr.internet.timeoutmills", "5000"));
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    protected final Properties properties;
    protected final SessionCredentials sessionCredentials = new SessionCredentials();
    protected String nameServerAddr = NameAddrUtils.getNameAdd();
    protected AsyncDispatcher traceDispatcher = null;
    protected final AtomicBoolean started = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ONSClientAbstract$1(this));

    public ONSClientAbstract(Properties properties) {
        this.properties = properties;
        this.sessionCredentials.updateContent(properties);
        if (null == this.sessionCredentials.getAccessKey() || "".equals(this.sessionCredentials.getAccessKey())) {
            throw new ONSClientException("please set access key");
        }
        if (null == this.sessionCredentials.getSecretKey() || "".equals(this.sessionCredentials.getSecretKey())) {
            throw new ONSClientException("please set secret key");
        }
        if (null == this.sessionCredentials.getOnsChannel()) {
            throw new ONSClientException("please set ons channel");
        }
        this.nameServerAddr = this.getNameSrvAddrFromProperties();
        if (this.nameServerAddr != null) {
            return;
        }
        this.nameServerAddr = this.fetchNameServerAddr();
        if (this.nameServerAddr == null) {
            throw new ONSClientException(FAQ.errorMessage("Can not find name server, May be your network problem.", "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&namesrv_not_exist"));
        }
        this.scheduledExecutorService.scheduleAtFixedRate(new ONSClientAbstract$2(this), 10000L, 30000L, TimeUnit.MILLISECONDS);
    }

    protected abstract void updateNameServerAddr(String var1);

    private String getNameSrvAddrFromProperties() {
        String string = this.properties.getProperty("NAMESRV_ADDR");
        if (StringUtils.isNotEmpty(string) && NameAddrUtils.NAMESRV_ENDPOINT_PATTERN.matcher(string.trim()).matches()) {
            return string.substring(7);
        }
        return string;
    }

    private String fetchNameServerAddr() {
        Object object = this.properties.getProperty("ONSAddr");
        if (object != null) {
            String string = new TopAddressing((String)object).fetchNSAddr();
            if (string != null) {
                LOGGER.info("connected to user-defined ons addr server, {} success, {}", object, (Object)string);
                return string;
            }
            throw new ONSClientException(FAQ.errorMessage("Can not find name server with onsAddr " + (String)object, "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&namesrv_not_exist"));
        }
        object = new TopAddressing(WSADDR_INTERNAL);
        String string = ((TopAddressing)object).fetchNSAddr(false, WSADDR_INTERNAL_TIMEOUTMILLS);
        if (string != null) {
            LOGGER.info("connected to internal server, {} success, {}", (Object)WSADDR_INTERNAL, (Object)string);
            return string;
        }
        object = new TopAddressing(WSADDR_INTERNET);
        string = ((TopAddressing)object).fetchNSAddr(false, WSADDR_INTERNET_TIMEOUTMILLS);
        if (string != null) {
            LOGGER.info("connected to internet server, {} success, {}", (Object)WSADDR_INTERNET, (Object)string);
        }
        return string;
    }

    public String getNameServerAddr() {
        return this.nameServerAddr;
    }

    protected String buildIntanceName() {
        return Integer.toString(UtilAll.getPid()) + "#" + this.nameServerAddr.hashCode() + "#" + this.sessionCredentials.getAccessKey().hashCode() + "#" + System.nanoTime();
    }

    protected String getNamespace() {
        String string = null;
        String string2 = this.properties.getProperty("NAMESRV_ADDR");
        if (StringUtils.isNotEmpty(string2) && NameAddrUtils.validateInstanceEndpoint(string2)) {
            string = NameAddrUtils.parseInstanceIdFromEndpoint(string2);
            LOGGER.info("User specify namespace by endpoint: {}.", (Object)string);
        }
        if (StringUtils.isNotEmpty(string2 = this.properties.getProperty("INSTANCE_ID", null))) {
            string = string2;
            LOGGER.info("User specify namespace by property: {}.", (Object)string);
        }
        return string;
    }

    protected void checkONSProducerServiceState(DefaultMQProducerImpl defaultMQProducerImpl) {
        switch (defaultMQProducerImpl.getServiceState()) {
            case CREATE_JUST: {
                throw new ONSClientException(FAQ.errorMessage(String.format("You do not have start the producer[" + UtilAll.getPid() + "], %s", new Object[]{defaultMQProducerImpl.getServiceState()}), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"));
            }
            case SHUTDOWN_ALREADY: {
                throw new ONSClientException(FAQ.errorMessage(String.format("Your producer has been shut down, %s", new Object[]{defaultMQProducerImpl.getServiceState()}), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"));
            }
            case START_FAILED: {
                throw new ONSClientException(FAQ.errorMessage(String.format("When you start your service throws an exception, %s", new Object[]{defaultMQProducerImpl.getServiceState()}), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&service_not_ok"));
            }
        }
    }

    @Override
    public void start() {
        if (this.traceDispatcher != null) {
            try {
                this.traceDispatcher.start();
                return;
            }
            catch (MQClientException mQClientException) {
                LOGGER.warn("trace dispatcher start failed ", mQClientException);
            }
        }
    }

    @Override
    public void updateCredential(Properties properties) {
        if (null == properties.getProperty("AccessKey") || "".equals(properties.getProperty("AccessKey"))) {
            throw new ONSClientException("update credential failed. please set access key.");
        }
        if (null == properties.getProperty("SecretKey") || "".equals(properties.getProperty("SecretKey"))) {
            throw new ONSClientException("update credential failed. please set secret key");
        }
        this.sessionCredentials.updateContent(properties);
    }

    @Override
    public void shutdown() {
        if (this.traceDispatcher != null) {
            this.traceDispatcher.shutdown();
        }
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isClosed() {
        return !this.isStarted();
    }

    static /* synthetic */ String access$000(ONSClientAbstract oNSClientAbstract) {
        return oNSClientAbstract.fetchNameServerAddr();
    }

    static /* synthetic */ InternalLogger access$100() {
        return LOGGER;
    }
}

