/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceDispatcherType;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncArrayDispatcher;
import com.aliyun.openservices.ons.api.MessageSelector;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.OnsClientRPCHook;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsConsumeMessageHookImpl;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.Properties;

public class ONSConsumerAbstract
extends ONSClientAbstract {
    static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    protected final DefaultMQPushConsumer defaultMQPushConsumer;
    private static final int MAX_CACHED_MESSAGE_SIZE_IN_MIB = 2048;
    private static final int MIN_CACHED_MESSAGE_SIZE_IN_MIB = 16;
    private static final int MAX_CACHED_MESSAGE_AMOUNT = 50000;
    private static final int MIN_CACHED_MESSAGE_AMOUNT = 100;
    private int maxCachedMessageSizeInMiB = 512;
    private int maxCachedMessageAmount = 5000;

    public ONSConsumerAbstract(Properties object) {
        super((Properties)object);
        String string = ((Properties)object).getProperty("GROUP_ID", ((Properties)object).getProperty("ConsumerId"));
        if (StringUtils.isEmpty(string)) {
            throw new ONSClientException("ConsumerId property is null");
        }
        this.defaultMQPushConsumer = new DefaultMQPushConsumer(this.getNamespace(), string, new OnsClientRPCHook(this.sessionCredentials));
        string = ((Properties)object).getProperty("maxReconsumeTimes");
        if (!UtilAll.isBlank(string)) {
            try {
                this.defaultMQPushConsumer.setMaxReconsumeTimes(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!UtilAll.isBlank(string = ((Properties)object).getProperty("consumeTimeout"))) {
            try {
                this.defaultMQPushConsumer.setConsumeTimeout(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        boolean bl = Boolean.parseBoolean(((Properties)object).getProperty("isVipChannelEnabled", "false"));
        this.defaultMQPushConsumer.setVipChannelEnabled(bl);
        String string2 = ((Properties)object).getProperty("InstanceName", this.buildIntanceName());
        this.defaultMQPushConsumer.setInstanceName(string2);
        this.defaultMQPushConsumer.setNamesrvAddr(this.getNameServerAddr());
        string2 = ((Properties)object).getProperty("ConsumeThreadNums");
        if (!UtilAll.isBlank(string2)) {
            this.defaultMQPushConsumer.setConsumeThreadMin(Integer.valueOf(string2));
            this.defaultMQPushConsumer.setConsumeThreadMax(Integer.valueOf(string2));
        }
        if (!UtilAll.isBlank(string2 = ((Properties)object).getProperty("maxCachedMessageAmount"))) {
            this.maxCachedMessageAmount = Math.min(50000, Integer.valueOf(string2));
            this.maxCachedMessageAmount = Math.max(100, this.maxCachedMessageAmount);
            this.defaultMQPushConsumer.setPullThresholdForTopic(this.maxCachedMessageAmount);
        }
        if (!UtilAll.isBlank(string2 = ((Properties)object).getProperty("maxCachedMessageSizeInMiB"))) {
            this.maxCachedMessageSizeInMiB = Math.min(2048, Integer.valueOf(string2));
            this.maxCachedMessageSizeInMiB = Math.max(16, this.maxCachedMessageSizeInMiB);
            this.defaultMQPushConsumer.setPullThresholdSizeForTopic(this.maxCachedMessageSizeInMiB);
        }
        if (!UtilAll.isBlank((String)(object = ((Properties)object).getProperty("MsgTraceSwitch"))) && !Boolean.parseBoolean((String)object)) {
            LOGGER.info("MQ Client Disable the Trace Hook!");
            return;
        }
        try {
            object = new Properties();
            ((Properties)object).put("AccessKey", this.sessionCredentials.getAccessKey());
            ((Properties)object).put("SecretKey", this.sessionCredentials.getSecretKey());
            ((Properties)object).put("MaxMsgSize", "128000");
            ((Properties)object).put("AsyncBufferSize", "2048");
            ((Properties)object).put("MaxBatchNum", "100");
            ((Properties)object).put("NAMESRV_ADDR", this.getNameServerAddr());
            ((Properties)object).put("InstanceName", "PID_CLIENT_INNER_TRACE_PRODUCER");
            ((Properties)object).put("DispatcherType", OnsTraceDispatcherType.CONSUMER.name());
            object = new AsyncArrayDispatcher((Properties)object, this.sessionCredentials);
            ((AsyncArrayDispatcher)object).setHostConsumer(this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl());
            this.traceDispatcher = object;
            this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().registerConsumeMessageHook(new OnsConsumeMessageHookImpl(this.traceDispatcher));
            return;
        }
        catch (Throwable throwable) {
            LOGGER.error("system mqtrace hook init failed ,maybe can't send msg trace data", throwable);
            return;
        }
    }

    @Override
    protected void updateNameServerAddr(String string) {
        this.defaultMQPushConsumer.getDefaultMQPushConsumerImpl().getmQClientFactory().getMQClientAPIImpl().updateNameServerAddressList(string);
    }

    protected void subscribe(String string, String string2) {
        try {
            this.defaultMQPushConsumer.subscribe(string, string2);
            return;
        }
        catch (MQClientException mQClientException) {
            throw new ONSClientException("defaultMQPushConsumer subscribe exception", mQClientException);
        }
    }

    protected void subscribe(String string, MessageSelector object) {
        String string2 = "*";
        String string3 = "TAG";
        if (object != null) {
            if (((MessageSelector)object).getType() == null) {
                throw new ONSClientException("Expression type is null!");
            }
            string2 = ((MessageSelector)object).getSubExpression();
            string3 = ((MessageSelector)object).getType().name();
        }
        if ("SQL92".equals(string3)) {
            object = com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MessageSelector.bySql(string2);
        } else if ("TAG".equals(string3)) {
            object = com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MessageSelector.byTag(string2);
        } else {
            throw new ONSClientException(String.format("Expression type %s is unknown!", string3));
        }
        try {
            this.defaultMQPushConsumer.subscribe(string, (com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MessageSelector)object);
            return;
        }
        catch (MQClientException mQClientException) {
            throw new ONSClientException("Consumer subscribe exception", mQClientException);
        }
    }

    protected void unsubscribe(String string) {
        this.defaultMQPushConsumer.unsubscribe(string);
    }

    @Override
    public void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                this.defaultMQPushConsumer.start();
                super.start();
            }
            return;
        }
        catch (Exception exception) {
            throw new ONSClientException(exception.getMessage());
        }
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.defaultMQPushConsumer.shutdown();
        }
        super.shutdown();
    }
}

