/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceDispatcherType;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncArrayDispatcher;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.rocketmq.OnsClientRPCHook;
import com.aliyun.openservices.ons.api.impl.rocketmq.OrderProducerImpl$1;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsClientSendMessageHookImpl;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.ons.api.order.OrderProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.Properties;

public class OrderProducerImpl
extends ONSClientAbstract
implements OrderProducer {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private final DefaultMQProducer defaultMQProducer;

    public OrderProducerImpl(Properties object) {
        super((Properties)object);
        String string = ((Properties)object).getProperty("GROUP_ID", ((Properties)object).getProperty("ProducerId"));
        if (StringUtils.isEmpty(string)) {
            string = "__ONS_PRODUCER_DEFAULT_GROUP";
        }
        this.defaultMQProducer = new DefaultMQProducer(this.getNamespace(), string, new OnsClientRPCHook(this.sessionCredentials));
        this.defaultMQProducer.setProducerGroup(string);
        boolean bl = Boolean.parseBoolean(((Properties)object).getProperty("isVipChannelEnabled", "false"));
        this.defaultMQProducer.setVipChannelEnabled(bl);
        String string2 = ((Properties)object).getProperty("SendMsgTimeoutMillis", "3000");
        this.defaultMQProducer.setSendMsgTimeout(Integer.parseInt(string2));
        boolean bl2 = Boolean.parseBoolean(((Properties)object).getProperty("exactlyOnceDelivery", "false"));
        this.defaultMQProducer.setAddExtendUniqInfo(bl2);
        String string3 = ((Properties)object).getProperty("InstanceName", this.buildIntanceName());
        this.defaultMQProducer.setInstanceName(string3);
        this.defaultMQProducer.setNamesrvAddr(this.getNameServerAddr());
        object = ((Properties)object).getProperty("MsgTraceSwitch");
        if (!UtilAll.isBlank((String)object) && !Boolean.parseBoolean((String)object)) {
            LOGGER.info("MQ Client Disable the Trace Hook!");
            return;
        }
        try {
            object = new Properties();
            ((Properties)object).put("AccessKey", this.sessionCredentials.getAccessKey());
            ((Properties)object).put("SecretKey", this.sessionCredentials.getSecretKey());
            ((Properties)object).put("MaxMsgSize", "128000");
            ((Properties)object).put("AsyncBufferSize", "2048");
            ((Properties)object).put("MaxBatchNum", "100");
            ((Properties)object).put("NAMESRV_ADDR", this.getNameServerAddr());
            ((Properties)object).put("InstanceName", "PID_CLIENT_INNER_TRACE_PRODUCER");
            ((Properties)object).put("DispatcherType", OnsTraceDispatcherType.PRODUCER.name());
            object = new AsyncArrayDispatcher((Properties)object, this.sessionCredentials);
            ((AsyncArrayDispatcher)object).setHostProducer(this.defaultMQProducer.getDefaultMQProducerImpl());
            this.traceDispatcher = object;
            this.defaultMQProducer.getDefaultMQProducerImpl().registerSendMessageHook(new OnsClientSendMessageHookImpl(this.traceDispatcher));
            return;
        }
        catch (Throwable throwable) {
            LOGGER.error("system mqtrace hook init failed ,maybe can't send msg trace data", throwable);
            return;
        }
    }

    @Override
    protected void updateNameServerAddr(String string) {
        this.defaultMQProducer.getDefaultMQProducerImpl().getmQClientFactory().getMQClientAPIImpl().updateNameServerAddressList(string);
    }

    @Override
    public void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                this.defaultMQProducer.start();
                super.start();
            }
            return;
        }
        catch (Exception exception) {
            throw new ONSClientException(exception.getMessage());
        }
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.defaultMQProducer.shutdown();
        }
        super.shutdown();
    }

    @Override
    public SendResult send(Message message, String object) {
        if (UtilAll.isBlank((String)object)) {
            throw new ONSClientException("'shardingKey' is blank.");
        }
        message.setShardingKey((String)object);
        OrderProducerImpl orderProducerImpl = this;
        orderProducerImpl.checkONSProducerServiceState(orderProducerImpl.defaultMQProducer.getDefaultMQProducerImpl());
        Object object2 = ONSUtil.msgConvert(message);
        try {
            object = this.defaultMQProducer.send((com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message)object2, new OrderProducerImpl$1(this), object);
            message.setMsgID(((com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult)object).getMsgId());
            object2 = new SendResult();
            ((SendResult)object2).setTopic(message.getTopic());
            ((SendResult)object2).setMessageId(((com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult)object).getMsgId());
            return object2;
        }
        catch (Exception exception) {
            throw new ONSClientException("defaultMQProducer send order exception", exception);
        }
    }
}

