/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceDispatcherType;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncArrayDispatcher;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.aliyun.openservices.ons.api.impl.rocketmq.FAQ;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.rocketmq.OnsClientRPCHook;
import com.aliyun.openservices.ons.api.impl.rocketmq.ProducerImpl$1;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsClientSendMessageHookImpl;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageClientIDSetter;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingConnectException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.exception.RemotingTimeoutException;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

public class ProducerImpl
extends ONSClientAbstract
implements Producer {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    private final DefaultMQProducer defaultMQProducer;

    public ProducerImpl(Properties object) {
        super((Properties)object);
        String string = ((Properties)object).getProperty("GROUP_ID", ((Properties)object).getProperty("ProducerId"));
        if (StringUtils.isEmpty(string)) {
            string = "__ONS_PRODUCER_DEFAULT_GROUP";
        }
        this.defaultMQProducer = new DefaultMQProducer(this.getNamespace(), string, new OnsClientRPCHook(this.sessionCredentials));
        this.defaultMQProducer.setProducerGroup(string);
        boolean bl = Boolean.parseBoolean(((Properties)object).getProperty("isVipChannelEnabled", "false"));
        this.defaultMQProducer.setVipChannelEnabled(bl);
        if (((Properties)object).containsKey("SendMsgTimeoutMillis")) {
            this.defaultMQProducer.setSendMsgTimeout(Integer.valueOf(((Properties)object).get("SendMsgTimeoutMillis").toString()));
        } else {
            this.defaultMQProducer.setSendMsgTimeout(5000);
        }
        if (((Properties)object).containsKey("exactlyOnceDelivery")) {
            this.defaultMQProducer.setAddExtendUniqInfo(Boolean.valueOf(((Properties)object).get("exactlyOnceDelivery").toString()));
        }
        String string2 = ((Properties)object).getProperty("InstanceName", this.buildIntanceName());
        this.defaultMQProducer.setInstanceName(string2);
        this.defaultMQProducer.setNamesrvAddr(this.getNameServerAddr());
        this.defaultMQProducer.setMaxMessageSize(0x400000);
        object = ((Properties)object).getProperty("MsgTraceSwitch");
        if (!UtilAll.isBlank((String)object) && !Boolean.parseBoolean((String)object)) {
            LOGGER.info("MQ Client Disable the Trace Hook!");
            return;
        }
        try {
            object = new Properties();
            ((Properties)object).put("AccessKey", this.sessionCredentials.getAccessKey());
            ((Properties)object).put("SecretKey", this.sessionCredentials.getSecretKey());
            ((Properties)object).put("MaxMsgSize", "128000");
            ((Properties)object).put("AsyncBufferSize", "2048");
            ((Properties)object).put("MaxBatchNum", "100");
            ((Properties)object).put("NAMESRV_ADDR", this.getNameServerAddr());
            ((Properties)object).put("InstanceName", "PID_CLIENT_INNER_TRACE_PRODUCER");
            ((Properties)object).put("DispatcherType", OnsTraceDispatcherType.PRODUCER.name());
            object = new AsyncArrayDispatcher((Properties)object, this.sessionCredentials);
            ((AsyncArrayDispatcher)object).setHostProducer(this.defaultMQProducer.getDefaultMQProducerImpl());
            this.traceDispatcher = object;
            this.defaultMQProducer.getDefaultMQProducerImpl().registerSendMessageHook(new OnsClientSendMessageHookImpl(this.traceDispatcher));
            return;
        }
        catch (Throwable throwable) {
            LOGGER.error("system mqtrace hook init failed ,maybe can't send msg trace data.", throwable);
            return;
        }
    }

    @Override
    protected void updateNameServerAddr(String string) {
        this.defaultMQProducer.getDefaultMQProducerImpl().getmQClientFactory().getMQClientAPIImpl().updateNameServerAddressList(string);
    }

    @Override
    public void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                this.defaultMQProducer.start();
                super.start();
            }
            return;
        }
        catch (Exception exception) {
            throw new ONSClientException(exception.getMessage());
        }
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            this.defaultMQProducer.shutdown();
        }
        super.shutdown();
    }

    @Override
    public SendResult send(Message message) {
        ProducerImpl producerImpl = this;
        producerImpl.checkONSProducerServiceState(producerImpl.defaultMQProducer.getDefaultMQProducerImpl());
        Object object = ONSUtil.msgConvert(message);
        try {
            object = this.defaultMQProducer.send((com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message)object);
            message.setMsgID(((com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult)object).getMsgId());
            SendResult sendResult = new SendResult();
            sendResult.setTopic(((com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult)object).getMessageQueue().getTopic());
            sendResult.setMessageId(((com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult)object).getMsgId());
            return sendResult;
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Send message Exception, %s", message), exception);
            throw this.checkProducerException(message.getTopic(), message.getMsgID(), exception);
        }
    }

    @Override
    public void sendOneway(Message message) {
        ProducerImpl producerImpl = this;
        producerImpl.checkONSProducerServiceState(producerImpl.defaultMQProducer.getDefaultMQProducerImpl());
        com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message message2 = ONSUtil.msgConvert(message);
        try {
            this.defaultMQProducer.sendOneway(message2);
            message.setMsgID(MessageClientIDSetter.getUniqID(message2));
            return;
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Send message oneway Exception, %s", message), exception);
            throw this.checkProducerException(message.getTopic(), message.getMsgID(), exception);
        }
    }

    @Override
    public void sendAsync(Message message, SendCallback sendCallback) {
        ProducerImpl producerImpl = this;
        producerImpl.checkONSProducerServiceState(producerImpl.defaultMQProducer.getDefaultMQProducerImpl());
        com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message message2 = ONSUtil.msgConvert(message);
        try {
            this.defaultMQProducer.send(message2, this.sendCallbackConvert(message, sendCallback));
            message.setMsgID(MessageClientIDSetter.getUniqID(message2));
            return;
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Send message async Exception, %s", message), exception);
            throw this.checkProducerException(message.getTopic(), message.getMsgID(), exception);
        }
    }

    @Override
    public void setCallbackExecutor(ExecutorService executorService) {
        this.defaultMQProducer.setCallbackExecutor(executorService);
    }

    public DefaultMQProducer getDefaultMQProducer() {
        return this.defaultMQProducer;
    }

    private com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendCallback sendCallbackConvert(Message object, SendCallback sendCallback) {
        object = new ProducerImpl$1(this, sendCallback, (Message)object);
        return object;
    }

    private SendResult sendResultConvert(com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult sendResult) {
        SendResult sendResult2 = new SendResult();
        sendResult2.setTopic(sendResult.getMessageQueue().getTopic());
        sendResult2.setMessageId(sendResult.getMsgId());
        return sendResult2;
    }

    private ONSClientException checkProducerException(String string, String string2, Throwable throwable) {
        if (throwable instanceof MQClientException) {
            if (throwable.getCause() != null) {
                if (throwable.getCause() instanceof RemotingConnectException) {
                    return new ONSClientException(FAQ.errorMessage(String.format("Connect broker failed, Topic=%s, msgId=%s", string, string2), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&connect_broker_failed"));
                }
                if (throwable.getCause() instanceof RemotingTimeoutException) {
                    return new ONSClientException(FAQ.errorMessage(String.format("Send message to broker timeout, %dms, Topic=%s, msgId=%s", this.defaultMQProducer.getSendMsgTimeout(), string, string2), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&send_msg_failed"));
                }
                if (throwable.getCause() instanceof MQBrokerException) {
                    MQBrokerException mQBrokerException = (MQBrokerException)throwable.getCause();
                    return new ONSClientException(FAQ.errorMessage(String.format("Receive a broker exception, Topi=%s, msgId=%s, %s", string, string2, mQBrokerException.getErrorMessage()), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&broker_response_exception"));
                }
            } else {
                MQClientException mQClientException = (MQClientException)throwable;
                if (-1 == mQClientException.getResponseCode()) {
                    return new ONSClientException(FAQ.errorMessage(String.format("Topic does not exist, Topic=%s, msgId=%s", string, string2), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&topic_not_exist"));
                }
                if (13 == mQClientException.getResponseCode()) {
                    return new ONSClientException(FAQ.errorMessage(String.format("ONS Client check message exception, Topic=%s, msgId=%s", string, string2), "http://docs.aliyun.com/cn#/pub/ons/faq/exceptions&msg_check_failed"));
                }
            }
        }
        return new ONSClientException("defaultMQProducer send exception", throwable);
    }

    static /* synthetic */ SendResult access$000(ProducerImpl producerImpl, com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult sendResult) {
        return producerImpl.sendResultConvert(sendResult);
    }

    static /* synthetic */ ONSClientException access$100(ProducerImpl producerImpl, String string, String string2, Throwable throwable) {
        return producerImpl.checkProducerException(string, string2, throwable);
    }
}

