/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.rocketmq;

import com.alibaba.ons.open.trace.core.common.OnsTraceDispatcherType;
import com.alibaba.ons.open.trace.core.dispatch.impl.AsyncArrayDispatcher;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSClientAbstract;
import com.aliyun.openservices.ons.api.impl.rocketmq.ONSUtil;
import com.aliyun.openservices.ons.api.impl.rocketmq.OnsClientRPCHook;
import com.aliyun.openservices.ons.api.impl.rocketmq.TransactionProducerImpl$1;
import com.aliyun.openservices.ons.api.impl.tracehook.OnsClientSendMessageHookImpl;
import com.aliyun.openservices.ons.api.impl.util.ClientLoggerUtil;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionCheckListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.TransactionSendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.Properties;

public class TransactionProducerImpl
extends ONSClientAbstract
implements TransactionProducer {
    private static final InternalLogger LOGGER = ClientLoggerUtil.getClientLogger();
    TransactionMQProducer transactionMQProducer = null;
    private Properties properties;

    public TransactionProducerImpl(Properties object, TransactionCheckListener transactionCheckListener) {
        super((Properties)object);
        this.properties = object;
        String string = ((Properties)object).getProperty("GROUP_ID", ((Properties)object).getProperty("ProducerId"));
        if (StringUtils.isEmpty(string)) {
            string = "__ONS_PRODUCER_DEFAULT_GROUP";
        }
        this.transactionMQProducer = new TransactionMQProducer(this.getNamespace(), string, new OnsClientRPCHook(this.sessionCredentials));
        boolean bl = Boolean.parseBoolean(((Properties)object).getProperty("isVipChannelEnabled", "false"));
        this.transactionMQProducer.setVipChannelEnabled(bl);
        String string2 = ((Properties)object).getProperty("InstanceName", this.buildIntanceName());
        this.transactionMQProducer.setInstanceName(string2);
        boolean bl2 = Boolean.parseBoolean(((Properties)object).getProperty("exactlyOnceDelivery", "false"));
        this.transactionMQProducer.setAddExtendUniqInfo(bl2);
        this.transactionMQProducer.setTransactionCheckListener(transactionCheckListener);
        object = ((Properties)object).getProperty("MsgTraceSwitch");
        if (!UtilAll.isBlank((String)object) && !Boolean.parseBoolean((String)object)) {
            LOGGER.info("MQ Client Disable the Trace Hook!");
            return;
        }
        try {
            object = new Properties();
            ((Properties)object).put("AccessKey", this.sessionCredentials.getAccessKey());
            ((Properties)object).put("SecretKey", this.sessionCredentials.getSecretKey());
            ((Properties)object).put("MaxMsgSize", "128000");
            ((Properties)object).put("AsyncBufferSize", "2048");
            ((Properties)object).put("MaxBatchNum", "100");
            ((Properties)object).put("NAMESRV_ADDR", this.getNameServerAddr());
            ((Properties)object).put("InstanceName", "PID_CLIENT_INNER_TRACE_PRODUCER");
            ((Properties)object).put("DispatcherType", OnsTraceDispatcherType.PRODUCER.name());
            object = new AsyncArrayDispatcher((Properties)object, this.sessionCredentials);
            ((AsyncArrayDispatcher)object).setHostProducer(this.transactionMQProducer.getDefaultMQProducerImpl());
            this.traceDispatcher = object;
            this.transactionMQProducer.getDefaultMQProducerImpl().registerSendMessageHook(new OnsClientSendMessageHookImpl(this.traceDispatcher));
            return;
        }
        catch (Throwable throwable) {
            LOGGER.error("system mqtrace hook init failed ,maybe can't send msg trace data", throwable);
            return;
        }
    }

    @Override
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            if (this.transactionMQProducer.getTransactionCheckListener() == null) {
                throw new IllegalArgumentException("TransactionCheckListener is null");
            }
            this.transactionMQProducer.setNamesrvAddr(this.nameServerAddr);
            try {
                ((DefaultMQProducer)this.transactionMQProducer).start();
                super.start();
                return;
            }
            catch (MQClientException mQClientException) {
                throw new RuntimeException(mQClientException);
            }
        }
    }

    @Override
    protected void updateNameServerAddr(String string) {
        this.transactionMQProducer.getDefaultMQProducerImpl().getmQClientFactory().getMQClientAPIImpl().updateNameServerAddressList(string);
    }

    @Override
    public void shutdown() {
        if (this.started.compareAndSet(true, false)) {
            ((DefaultMQProducer)this.transactionMQProducer).shutdown();
        }
        super.shutdown();
    }

    @Override
    public SendResult send(Message object, LocalTransactionExecuter object2, Object object3) {
        TransactionProducerImpl transactionProducerImpl = this;
        transactionProducerImpl.checkONSProducerServiceState(transactionProducerImpl.transactionMQProducer.getDefaultMQProducerImpl());
        com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message message = ONSUtil.msgConvert((Message)object);
        try {
            object = ((DefaultMQProducer)this.transactionMQProducer).sendMessageInTransaction(message, new TransactionProducerImpl$1(this, (Message)object, (LocalTransactionExecuter)object2), object3);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        if (((TransactionSendResult)object).getLocalTransactionState() == LocalTransactionState.ROLLBACK_MESSAGE) {
            throw new RuntimeException("local transaction branch failed ,so transaction rollback");
        }
        object2 = new SendResult();
        ((SendResult)object2).setMessageId(((com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult)object).getMsgId());
        ((SendResult)object2).setTopic(((com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult)object).getMessageQueue().getTopic());
        return object2;
    }
}

