/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.tracehook;

import com.alibaba.ons.open.trace.core.common.OnsTraceBean;
import com.alibaba.ons.open.trace.core.common.OnsTraceContext;
import com.alibaba.ons.open.trace.core.common.OnsTraceType;
import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.SendMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.SendMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import java.util.ArrayList;

public class OnsClientSendMessageHookImpl
implements SendMessageHook {
    private AsyncDispatcher localDispatcher;

    public OnsClientSendMessageHookImpl(AsyncDispatcher asyncDispatcher) {
        this.localDispatcher = asyncDispatcher;
    }

    @Override
    public String hookName() {
        return "OnsClientSendMessageHook";
    }

    @Override
    public void sendMessageBefore(SendMessageContext sendMessageContext) {
        if (sendMessageContext == null || sendMessageContext.getMessage().getTopic().startsWith("rmq_sys_")) {
            return;
        }
        OnsTraceContext onsTraceContext = new OnsTraceContext();
        onsTraceContext.setTraceBeans(new ArrayList<OnsTraceBean>(1));
        sendMessageContext.setMqTraceContext(onsTraceContext);
        onsTraceContext.setTraceType(OnsTraceType.Pub);
        Object object = NamespaceUtil.withoutNamespace(sendMessageContext.getProducerGroup(), sendMessageContext.getNamespace());
        onsTraceContext.setGroupName((String)object);
        object = new OnsTraceBean();
        String string = NamespaceUtil.withoutNamespace(sendMessageContext.getMessage().getTopic(), sendMessageContext.getNamespace());
        ((OnsTraceBean)object).setTopic(string);
        ((OnsTraceBean)object).setTags(sendMessageContext.getMessage().getTags());
        ((OnsTraceBean)object).setKeys(sendMessageContext.getMessage().getKeys());
        ((OnsTraceBean)object).setStoreHost(sendMessageContext.getBrokerAddr());
        ((OnsTraceBean)object).setBodyLength(sendMessageContext.getMessage().getBody().length);
        ((OnsTraceBean)object).setMsgType(sendMessageContext.getMsgType());
        onsTraceContext.getTraceBeans().add((OnsTraceBean)object);
    }

    @Override
    public void sendMessageAfter(SendMessageContext sendMessageContext) {
        if (sendMessageContext == null || sendMessageContext.getMessage().getTopic().startsWith("rmq_sys_TRACE_DATA_") || sendMessageContext.getMqTraceContext() == null) {
            return;
        }
        if (sendMessageContext.getSendResult() == null) {
            return;
        }
        if (sendMessageContext.getSendResult().getRegionId() == null || sendMessageContext.getSendResult().getRegionId().equals("DefaultRegion") || !sendMessageContext.getSendResult().isTraceOn()) {
            return;
        }
        OnsTraceContext onsTraceContext = (OnsTraceContext)sendMessageContext.getMqTraceContext();
        OnsTraceBean onsTraceBean = onsTraceContext.getTraceBeans().get(0);
        int n2 = (int)((System.currentTimeMillis() - onsTraceContext.getTimeStamp()) / (long)onsTraceContext.getTraceBeans().size());
        onsTraceContext.setCostTime(n2);
        if (sendMessageContext.getSendResult().getSendStatus().equals((Object)SendStatus.SEND_OK)) {
            onsTraceContext.setSuccess(true);
        } else {
            onsTraceContext.setSuccess(false);
        }
        onsTraceContext.setRegionId(sendMessageContext.getSendResult().getRegionId());
        onsTraceBean.setMsgId(sendMessageContext.getSendResult().getMsgId());
        onsTraceBean.setOffsetMsgId(sendMessageContext.getSendResult().getOffsetMsgId());
        onsTraceBean.setStoreTime(onsTraceContext.getTimeStamp() + (long)(n2 / 2));
        this.localDispatcher.append(onsTraceContext);
    }
}

