/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.ons.api.impl.tracehook;

import com.alibaba.ons.open.trace.core.common.OnsTraceBean;
import com.alibaba.ons.open.trace.core.common.OnsTraceContext;
import com.alibaba.ons.open.trace.core.common.OnsTraceType;
import com.alibaba.ons.open.trace.core.dispatch.AsyncDispatcher;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeExactlyOnceStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeReturnType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.ConsumeMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.ConsumeMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import java.util.ArrayList;
import java.util.List;

public class OnsConsumeMessageHookImpl
implements ConsumeMessageHook {
    private AsyncDispatcher localDispatcher;

    public OnsConsumeMessageHookImpl(AsyncDispatcher asyncDispatcher) {
        this.localDispatcher = asyncDispatcher;
    }

    @Override
    public String hookName() {
        return "OnsConsumeMessageHook";
    }

    @Override
    public void consumeMessageBefore(ConsumeMessageContext consumeMessageContext) {
        if (consumeMessageContext == null || consumeMessageContext.getMsgList() == null || consumeMessageContext.getMsgList().isEmpty()) {
            return;
        }
        OnsTraceContext onsTraceContext = new OnsTraceContext();
        consumeMessageContext.setMqTraceContext(onsTraceContext);
        onsTraceContext.setTraceType(OnsTraceType.SubBefore);
        Object object = NamespaceUtil.withoutNamespace(consumeMessageContext.getConsumerGroup(), consumeMessageContext.getNamespace());
        onsTraceContext.setGroupName((String)object);
        object = new ArrayList();
        for (MessageExt messageExt : consumeMessageContext.getMsgList()) {
            if (messageExt == null) continue;
            String string = messageExt.getProperty("MSG_REGION");
            Object object2 = messageExt.getProperty("TRACE_ON");
            if (string == null || string.equals("DefaultRegion") || object2 != null && "false".equals(object2)) continue;
            object2 = new OnsTraceBean();
            String string2 = NamespaceUtil.withoutNamespace(messageExt.getTopic(), consumeMessageContext.getNamespace());
            ((OnsTraceBean)object2).setTopic(string2);
            ((OnsTraceBean)object2).setMsgId(messageExt.getMsgId());
            ((OnsTraceBean)object2).setTags(messageExt.getTags());
            ((OnsTraceBean)object2).setKeys(messageExt.getKeys());
            ((OnsTraceBean)object2).setStoreTime(messageExt.getStoreTimestamp());
            ((OnsTraceBean)object2).setBodyLength(messageExt.getStoreSize());
            ((OnsTraceBean)object2).setRetryTimes(messageExt.getReconsumeTimes());
            onsTraceContext.setRegionId(string);
            object.add(object2);
        }
        if (object.size() > 0) {
            onsTraceContext.setTraceBeans((List<OnsTraceBean>)object);
            onsTraceContext.setTimeStamp(System.currentTimeMillis());
            this.localDispatcher.append(onsTraceContext);
        }
    }

    @Override
    public void consumeMessageAfter(ConsumeMessageContext object) {
        if (object == null || ((ConsumeMessageContext)object).getMsgList() == null || ((ConsumeMessageContext)object).getMsgList().isEmpty()) {
            return;
        }
        Object object2 = (OnsTraceContext)((ConsumeMessageContext)object).getMqTraceContext();
        if (((OnsTraceContext)object2).getRegionId().equals("DefaultRegion")) {
            return;
        }
        if (((OnsTraceContext)object2).getTraceBeans() == null || ((OnsTraceContext)object2).getTraceBeans().size() <= 0) {
            return;
        }
        OnsTraceContext onsTraceContext = new OnsTraceContext();
        onsTraceContext.setTraceType(OnsTraceType.SubAfter);
        onsTraceContext.setRegionId(((OnsTraceContext)object2).getRegionId());
        onsTraceContext.setGroupName(((OnsTraceContext)object2).getGroupName());
        onsTraceContext.setRequestId(((OnsTraceContext)object2).getRequestId());
        onsTraceContext.setSuccess(((ConsumeMessageContext)object).isSuccess());
        int n2 = (int)((System.currentTimeMillis() - ((OnsTraceContext)object2).getTimeStamp()) / (long)((ConsumeMessageContext)object).getMsgList().size());
        onsTraceContext.setCostTime(n2);
        onsTraceContext.setTraceBeans(((OnsTraceContext)object2).getTraceBeans());
        object2 = ((ConsumeMessageContext)object).getProps().get("ConsumeContextType");
        if (object2 != null) {
            onsTraceContext.setContextCode(ConsumeReturnType.valueOf((String)object2).ordinal());
        }
        if ((object = ((ConsumeMessageContext)object).getProps().get("ConsumeExactlyOnceStatus")) != null) {
            onsTraceContext.setExactlyOnceStatus(ConsumeExactlyOnceStatus.valueOf((String)object).ordinal());
        }
        this.localDispatcher.append(onsTraceContext);
    }
}

