/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONArray;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject$SecureObjectInputStream;
import com.aliyun.openservices.shade.com.alibaba.fastjson.TypeReference;
import com.aliyun.openservices.shade.com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.ParserConfig;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.TypeUtils;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObject
extends JSON
implements Serializable,
Cloneable,
InvocationHandler,
Map<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<String, Object> map;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null.");
        }
        this.map = map;
    }

    public JSONObject(boolean bl) {
        this(16, bl);
    }

    public JSONObject(int n2) {
        this(n2, false);
    }

    public JSONObject(int n2, boolean bl) {
        if (bl) {
            this.map = new LinkedHashMap<String, Object>(n2);
            return;
        }
        this.map = new HashMap<String, Object>(n2);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Object get(Object object) {
        Object object2 = this.map.get(object);
        if (object2 == null && object instanceof Number) {
            object2 = this.map.get(object.toString());
        }
        return object2;
    }

    public JSONObject getJSONObject(String object) {
        if ((object = this.map.get(object)) instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof String) {
            return JSON.parseObject((String)object);
        }
        return (JSONObject)JSONObject.toJSON(object);
    }

    public JSONArray getJSONArray(String object) {
        if ((object = this.map.get(object)) instanceof JSONArray) {
            return (JSONArray)object;
        }
        if (object instanceof String) {
            return (JSONArray)JSON.parse((String)object);
        }
        return (JSONArray)JSONObject.toJSON(object);
    }

    public <T> T getObject(String object, Class<T> clazz) {
        object = this.map.get(object);
        return TypeUtils.castToJavaBean(object, clazz);
    }

    public <T> T getObject(String object, Type type) {
        object = this.map.get(object);
        return TypeUtils.cast(object, type, ParserConfig.getGlobalInstance());
    }

    public <T> T getObject(String object, TypeReference typeReference) {
        object = this.map.get(object);
        if (typeReference == null) {
            return (T)object;
        }
        return TypeUtils.cast(object, typeReference.getType(), ParserConfig.getGlobalInstance());
    }

    public Boolean getBoolean(String object) {
        if ((object = this.get(object)) == null) {
            return null;
        }
        return TypeUtils.castToBoolean(object);
    }

    public byte[] getBytes(String object) {
        if ((object = this.get(object)) == null) {
            return null;
        }
        return TypeUtils.castToBytes(object);
    }

    public boolean getBooleanValue(String object) {
        object = this.get(object);
        if ((object = TypeUtils.castToBoolean(object)) == null) {
            return false;
        }
        return (Boolean)object;
    }

    public Byte getByte(String object) {
        object = this.get(object);
        return TypeUtils.castToByte(object);
    }

    public byte getByteValue(String object) {
        object = this.get(object);
        if ((object = TypeUtils.castToByte(object)) == null) {
            return 0;
        }
        return (Byte)object;
    }

    public Short getShort(String object) {
        object = this.get(object);
        return TypeUtils.castToShort(object);
    }

    public short getShortValue(String object) {
        object = this.get(object);
        if ((object = TypeUtils.castToShort(object)) == null) {
            return 0;
        }
        return (Short)object;
    }

    public Integer getInteger(String object) {
        object = this.get(object);
        return TypeUtils.castToInt(object);
    }

    public int getIntValue(String object) {
        object = this.get(object);
        if ((object = TypeUtils.castToInt(object)) == null) {
            return 0;
        }
        return (Integer)object;
    }

    public Long getLong(String object) {
        object = this.get(object);
        return TypeUtils.castToLong(object);
    }

    public long getLongValue(String object) {
        object = this.get(object);
        if ((object = TypeUtils.castToLong(object)) == null) {
            return 0L;
        }
        return (Long)object;
    }

    public Float getFloat(String object) {
        object = this.get(object);
        return TypeUtils.castToFloat(object);
    }

    public float getFloatValue(String object) {
        object = this.get(object);
        if ((object = TypeUtils.castToFloat(object)) == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public Double getDouble(String object) {
        object = this.get(object);
        return TypeUtils.castToDouble(object);
    }

    public double getDoubleValue(String object) {
        object = this.get(object);
        if ((object = TypeUtils.castToDouble(object)) == null) {
            return 0.0;
        }
        return (Double)object;
    }

    public BigDecimal getBigDecimal(String object) {
        object = this.get(object);
        return TypeUtils.castToBigDecimal(object);
    }

    public BigInteger getBigInteger(String object) {
        object = this.get(object);
        return TypeUtils.castToBigInteger(object);
    }

    public String getString(String object) {
        if ((object = this.get(object)) == null) {
            return null;
        }
        return object.toString();
    }

    public java.util.Date getDate(String object) {
        object = this.get(object);
        return TypeUtils.castToDate(object);
    }

    public Date getSqlDate(String object) {
        object = this.get(object);
        return TypeUtils.castToSqlDate(object);
    }

    public Timestamp getTimestamp(String object) {
        object = this.get(object);
        return TypeUtils.castToTimestamp(object);
    }

    @Override
    public Object put(String string, Object object) {
        return this.map.put(string, object);
    }

    public JSONObject fluentPut(String string, Object object) {
        this.map.put(string, object);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.map.putAll(map);
    }

    public JSONObject fluentPutAll(Map<? extends String, ? extends Object> map) {
        this.map.putAll(map);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public JSONObject fluentClear() {
        this.map.clear();
        return this;
    }

    @Override
    public Object remove(Object object) {
        return this.map.remove(object);
    }

    public JSONObject fluentRemove(Object object) {
        this.map.remove(object);
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object clone() {
        return new JSONObject(this.map instanceof LinkedHashMap ? new LinkedHashMap<String, Object>(this.map) : new HashMap<String, Object>(this.map));
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        object = method.getParameterTypes();
        if (((Class<?>[])object).length == 1) {
            if (method.getName().equals("equals")) {
                return this.equals(objectArray[0]);
            }
            object = method.getReturnType();
            if (object != Void.TYPE) {
                throw new JSONException("illegal setter");
            }
            object = null;
            JSONField jSONField = method.getAnnotation(JSONField.class);
            if (jSONField != null && jSONField.name().length() != 0) {
                object = jSONField.name();
            }
            if (object == null) {
                object = method.getName();
                if (!((String)object).startsWith("set")) {
                    throw new JSONException("illegal setter");
                }
                if (((String)(object = ((String)object).substring(3))).length() == 0) {
                    throw new JSONException("illegal setter");
                }
                object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
            }
            this.map.put((String)object, objectArray[0]);
            return null;
        }
        if (((Class<?>[])object).length == 0) {
            object = method.getReturnType();
            if (object == Void.TYPE) {
                throw new JSONException("illegal getter");
            }
            object = null;
            JSONField jSONField = method.getAnnotation(JSONField.class);
            if (jSONField != null && jSONField.name().length() != 0) {
                object = jSONField.name();
            }
            if (object == null) {
                object = method.getName();
                if (((String)object).startsWith("get")) {
                    if (((String)(object = ((String)object).substring(3))).length() == 0) {
                        throw new JSONException("illegal getter");
                    }
                    object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
                } else if (((String)object).startsWith("is")) {
                    if (((String)(object = ((String)object).substring(2))).length() == 0) {
                        throw new JSONException("illegal getter");
                    }
                    object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
                } else {
                    if (((String)object).startsWith("hashCode")) {
                        return this.hashCode();
                    }
                    if (((String)object).startsWith("toString")) {
                        return this.toString();
                    }
                    throw new JSONException("illegal getter");
                }
            }
            object = this.map.get(object);
            return TypeUtils.cast(object, method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        }
        throw new UnsupportedOperationException(method.toGenericString());
    }

    public Map<String, Object> getInnerMap() {
        return this.map;
    }

    private void readObject(ObjectInputStream object) {
        JSONObject$SecureObjectInputStream.ensureFields();
        if (JSONObject$SecureObjectInputStream.fields != null && !JSONObject$SecureObjectInputStream.fields_error) {
            object = new JSONObject$SecureObjectInputStream((ObjectInputStream)object);
            ((ObjectInputStream)object).defaultReadObject();
            return;
        }
        ((ObjectInputStream)object).defaultReadObject();
        for (Map.Entry entry : this.map.entrySet()) {
            Object entry2;
            Object k2 = entry.getKey();
            if (k2 != null) {
                ParserConfig.global.checkAutoType(k2.getClass().getName(), null);
            }
            if ((entry2 = entry.getValue()) == null) continue;
            ParserConfig.global.checkAutoType(entry2.getClass().getName(), null);
        }
    }
}

