/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONStreamContext;
import com.aliyun.openservices.shade.com.alibaba.fastjson.TypeReference;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.DefaultJSONParser;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.Feature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.JSONLexer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.JSONReaderScanner;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.TypeUtils;
import java.io.Closeable;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONReader
implements Closeable {
    private final DefaultJSONParser parser;
    private JSONStreamContext context;

    public JSONReader(Reader reader) {
        this(reader, new Feature[0]);
    }

    public JSONReader(Reader featureArray, Feature ... featureArray2) {
        this(new JSONReaderScanner((Reader)featureArray));
        featureArray = featureArray2;
        int n2 = featureArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Feature feature = featureArray[i2];
            this.config(feature, true);
        }
    }

    public JSONReader(JSONLexer jSONLexer) {
        this(new DefaultJSONParser(jSONLexer));
    }

    public JSONReader(DefaultJSONParser defaultJSONParser) {
        this.parser = defaultJSONParser;
    }

    public void setTimzeZone(TimeZone timeZone) {
        this.parser.lexer.setTimeZone(timeZone);
    }

    public void setLocale(Locale locale) {
        this.parser.lexer.setLocale(locale);
    }

    public void config(Feature feature, boolean bl) {
        this.parser.config(feature, bl);
    }

    public Locale getLocal() {
        return this.parser.lexer.getLocale();
    }

    public TimeZone getTimzeZone() {
        return this.parser.lexer.getTimeZone();
    }

    public void startObject() {
        if (this.context == null) {
            this.context = new JSONStreamContext(null, 1001);
        } else {
            this.startStructure();
            this.context = new JSONStreamContext(this.context, 1001);
        }
        this.parser.accept(12, 18);
    }

    public void endObject() {
        this.parser.accept(13);
        this.endStructure();
    }

    public void startArray() {
        if (this.context == null) {
            this.context = new JSONStreamContext(null, 1004);
        } else {
            this.startStructure();
            this.context = new JSONStreamContext(this.context, 1004);
        }
        this.parser.accept(14);
    }

    public void endArray() {
        this.parser.accept(15);
        this.endStructure();
    }

    private void startStructure() {
        int n2 = this.context.state;
        switch (n2) {
            case 1002: {
                this.parser.accept(17);
                return;
            }
            case 1003: 
            case 1005: {
                this.parser.accept(16);
                return;
            }
            case 1001: 
            case 1004: {
                return;
            }
        }
        throw new JSONException("illegal state : " + this.context.state);
    }

    private void endStructure() {
        this.context = this.context.parent;
        if (this.context == null) {
            return;
        }
        int n2 = this.context.state;
        int n3 = -1;
        switch (n2) {
            case 1002: {
                n3 = 1003;
                break;
            }
            case 1004: {
                n3 = 1005;
                break;
            }
            case 1001: 
            case 1003: {
                n3 = 1002;
            }
        }
        if (n3 != -1) {
            this.context.state = n3;
        }
    }

    public boolean hasNext() {
        if (this.context == null) {
            throw new JSONException("context is null");
        }
        int n2 = this.parser.lexer.token();
        int n3 = this.context.state;
        switch (n3) {
            case 1004: 
            case 1005: {
                return n2 != 15;
            }
            case 1001: 
            case 1003: {
                return n2 != 13;
            }
        }
        throw new JSONException("illegal state : " + n3);
    }

    public int peek() {
        return this.parser.lexer.token();
    }

    @Override
    public void close() {
        this.parser.close();
    }

    public Integer readInteger() {
        Object object;
        if (this.context == null) {
            object = this.parser.parse();
        } else {
            this.readBefore();
            object = this.parser.parse();
            this.readAfter();
        }
        return TypeUtils.castToInt(object);
    }

    public Long readLong() {
        Object object;
        if (this.context == null) {
            object = this.parser.parse();
        } else {
            this.readBefore();
            object = this.parser.parse();
            this.readAfter();
        }
        return TypeUtils.castToLong(object);
    }

    public String readString() {
        Object object;
        if (this.context == null) {
            object = this.parser.parse();
        } else {
            this.readBefore();
            JSONLexer jSONLexer = this.parser.lexer;
            if (this.context.state == 1001 && jSONLexer.token() == 18) {
                object = jSONLexer.stringVal();
                jSONLexer.nextToken();
            } else {
                object = this.parser.parse();
            }
            this.readAfter();
        }
        return TypeUtils.castToString(object);
    }

    public <T> T readObject(TypeReference<T> typeReference) {
        return this.readObject(typeReference.getType());
    }

    public <T> T readObject(Type type) {
        if (this.context == null) {
            return this.parser.parseObject(type);
        }
        this.readBefore();
        type = this.parser.parseObject(type);
        this.readAfter();
        return (T)type;
    }

    public <T> T readObject(Class<T> clazz) {
        if (this.context == null) {
            return this.parser.parseObject(clazz);
        }
        this.readBefore();
        clazz = this.parser.parseObject(clazz);
        this.readAfter();
        return (T)clazz;
    }

    public void readObject(Object object) {
        if (this.context == null) {
            this.parser.parseObject(object);
            return;
        }
        this.readBefore();
        this.parser.parseObject(object);
        this.readAfter();
    }

    public Object readObject() {
        Object object;
        if (this.context == null) {
            return this.parser.parse();
        }
        this.readBefore();
        switch (this.context.state) {
            case 1001: 
            case 1003: {
                object = this.parser.parseKey();
                break;
            }
            default: {
                object = this.parser.parse();
            }
        }
        this.readAfter();
        return object;
    }

    public Object readObject(Map object) {
        if (this.context == null) {
            return this.parser.parseObject((Map)object);
        }
        this.readBefore();
        object = this.parser.parseObject((Map)object);
        this.readAfter();
        return object;
    }

    private void readBefore() {
        int n2 = this.context.state;
        switch (n2) {
            case 1002: {
                this.parser.accept(17);
                return;
            }
            case 1003: {
                this.parser.accept(16, 18);
                return;
            }
            case 1005: {
                this.parser.accept(16);
                return;
            }
            case 1001: {
                return;
            }
            case 1004: {
                return;
            }
        }
        throw new JSONException("illegal state : " + n2);
    }

    private void readAfter() {
        int n2 = this.context.state;
        int n3 = -1;
        switch (n2) {
            case 1001: {
                n3 = 1002;
                break;
            }
            case 1002: {
                n3 = 1003;
                break;
            }
            case 1003: {
                n3 = 1002;
                break;
            }
            case 1005: {
                break;
            }
            case 1004: {
                n3 = 1005;
                break;
            }
            default: {
                throw new JSONException("illegal state : " + n2);
            }
        }
        if (n3 != -1) {
            this.context.state = n3;
        }
    }
}

