/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.asm;

import com.aliyun.openservices.shade.com.alibaba.fastjson.asm.ByteVector;
import com.aliyun.openservices.shade.com.alibaba.fastjson.asm.ClassWriter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.asm.Item;
import com.aliyun.openservices.shade.com.alibaba.fastjson.asm.Label;
import com.aliyun.openservices.shade.com.alibaba.fastjson.asm.MethodVisitor;
import com.aliyun.openservices.shade.com.alibaba.fastjson.asm.Type;

public class MethodWriter
implements MethodVisitor {
    MethodWriter next;
    final ClassWriter cw;
    private int access;
    private final int name;
    private final int desc;
    int exceptionCount;
    int[] exceptions;
    private ByteVector code = new ByteVector();
    private int maxStack;
    private int maxLocals;

    public MethodWriter(ClassWriter classWriter, int n2, String string, String string2, String string3, String[] stringArray) {
        if (classWriter.firstMethod == null) {
            classWriter.firstMethod = this;
        } else {
            classWriter.lastMethod.next = this;
        }
        classWriter.lastMethod = this;
        this.cw = classWriter;
        this.access = n2;
        this.name = classWriter.newUTF8(string);
        this.desc = classWriter.newUTF8(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.exceptionCount = stringArray.length;
            this.exceptions = new int[this.exceptionCount];
            for (n2 = 0; n2 < this.exceptionCount; ++n2) {
                this.exceptions[n2] = classWriter.newClassItem((String)stringArray[n2]).index;
            }
        }
    }

    public void visitInsn(int n2) {
        this.code.putByte(n2);
    }

    public void visitIntInsn(int n2, int n3) {
        this.code.put11(n2, n3);
    }

    public void visitVarInsn(int n2, int n3) {
        if (n3 < 4 && n2 != 169) {
            n2 = n2 < 54 ? 26 + (n2 - 21 << 2) + n3 : 59 + (n2 - 54 << 2) + n3;
            this.code.putByte(n2);
            return;
        }
        if (n3 >= 256) {
            this.code.putByte(196).put12(n2, n3);
            return;
        }
        this.code.put11(n2, n3);
    }

    public void visitTypeInsn(int n2, String object) {
        object = this.cw.newClassItem((String)object);
        this.code.put12(n2, ((Item)object).index);
    }

    public void visitFieldInsn(int n2, String object, String string, String string2) {
        object = this.cw.newFieldItem((String)object, string, string2);
        this.code.put12(n2, ((Item)object).index);
    }

    public void visitMethodInsn(int n2, String object, String string, String string2) {
        boolean bl = n2 == 185;
        object = this.cw.newMethodItem((String)object, string, string2, bl);
        int n3 = ((Item)object).intVal;
        if (bl) {
            if (n3 == 0) {
                ((Item)object).intVal = n3 = Type.getArgumentsAndReturnSizes(string2);
            }
            this.code.put12(185, ((Item)object).index).put11(n3 >> 2, 0);
            return;
        }
        this.code.put12(n2, ((Item)object).index);
    }

    public void visitJumpInsn(int n2, Label label) {
        if ((label.status & 2) != 0 && label.position - this.code.length < Short.MIN_VALUE) {
            throw new UnsupportedOperationException();
        }
        this.code.putByte(n2);
        MethodWriter methodWriter = this;
        label.put(methodWriter, methodWriter.code, this.code.length - 1);
    }

    public void visitLabel(Label label) {
        MethodWriter methodWriter = this;
        label.resolve(methodWriter, methodWriter.code.length, this.code.data);
    }

    public void visitLdcInsn(Object object) {
        object = this.cw.newConstItem(object);
        int n2 = ((Item)object).index;
        if (((Item)object).type == 5 || ((Item)object).type == 6) {
            this.code.put12(20, n2);
            return;
        }
        if (n2 >= 256) {
            this.code.put12(19, n2);
            return;
        }
        this.code.put11(18, n2);
    }

    public void visitIincInsn(int n2, int n3) {
        this.code.putByte(132).put11(n2, n3);
    }

    public void visitMaxs(int n2, int n3) {
        this.maxStack = n2;
        this.maxLocals = n3;
    }

    public void visitEnd() {
    }

    final int getSize() {
        int n2 = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            n2 = 8 + (18 + this.code.length);
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            n2 += 8 + 2 * this.exceptionCount;
        }
        return n2;
    }

    final void put(ByteVector byteVector) {
        byteVector.putShort(this.access & 0xFFF9FFFF).putShort(this.name).putShort(this.desc);
        int n2 = 0;
        if (this.code.length > 0) {
            ++n2;
        }
        if (this.exceptionCount > 0) {
            ++n2;
        }
        byteVector.putShort(n2);
        if (this.code.length > 0) {
            n2 = 12 + this.code.length;
            byteVector.putShort(this.cw.newUTF8("Code")).putInt(n2);
            byteVector.putShort(this.maxStack).putShort(this.maxLocals);
            byteVector.putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            byteVector.putShort(0);
            byteVector.putShort(0);
        }
        if (this.exceptionCount > 0) {
            byteVector.putShort(this.cw.newUTF8("Exceptions")).putInt(2 * this.exceptionCount + 2);
            byteVector.putShort(this.exceptionCount);
            for (n2 = 0; n2 < this.exceptionCount; ++n2) {
                byteVector.putShort(this.exceptions[n2]);
            }
        }
    }
}

