/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.asm;

public class Type {
    public static final Type VOID_TYPE = new Type(0, null, 0x56050000, 1);
    public static final Type BOOLEAN_TYPE = new Type(1, null, 1509950721, 1);
    public static final Type CHAR_TYPE = new Type(2, null, 1124075009, 1);
    public static final Type BYTE_TYPE = new Type(3, null, 1107297537, 1);
    public static final Type SHORT_TYPE = new Type(4, null, 1392510721, 1);
    public static final Type INT_TYPE = new Type(5, null, 1224736769, 1);
    public static final Type FLOAT_TYPE = new Type(6, null, 1174536705, 1);
    public static final Type LONG_TYPE = new Type(7, null, 1241579778, 1);
    public static final Type DOUBLE_TYPE = new Type(8, null, 1141048066, 1);
    protected final int sort;
    private final char[] buf;
    private final int off;
    private final int len;

    private Type(int n2, char[] cArray, int n3, int n4) {
        this.sort = n2;
        this.buf = cArray;
        this.off = n3;
        this.len = n4;
    }

    public static Type getType(String string) {
        return Type.getType(string.toCharArray(), 0);
    }

    public static int getArgumentsAndReturnSizes(String string) {
        int n2 = 1;
        int n3 = 1;
        while (true) {
            char c2;
            if ((c2 = string.charAt(n3++)) == ')') {
                c2 = string.charAt(n3);
                return n2 << 2 | (c2 == 'V' ? 0 : (c2 == 'D' || c2 == 'J' ? 2 : 1));
            }
            if (c2 == 'L') {
                while (string.charAt(n3++) != ';') {
                }
                ++n2;
                continue;
            }
            if (c2 == 'D' || c2 == 'J') {
                n2 += 2;
                continue;
            }
            ++n2;
        }
    }

    private static Type getType(char[] cArray, int n2) {
        switch (cArray[n2]) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                int n3 = 1;
                while (cArray[n2 + n3] == '[') {
                    ++n3;
                }
                if (cArray[n2 + n3] == 'L') {
                    ++n3;
                    while (cArray[n2 + n3] != ';') {
                        ++n3;
                    }
                }
                return new Type(9, cArray, n2, n3 + 1);
            }
        }
        int n4 = 1;
        while (cArray[n2 + n4] != ';') {
            ++n4;
        }
        return new Type(10, cArray, n2 + 1, n4 - 1);
    }

    public String getInternalName() {
        return new String(this.buf, this.off, this.len);
    }

    String getDescriptor() {
        return new String(this.buf, this.off, this.len);
    }

    private int getDimensions() {
        int n2 = 1;
        while (this.buf[this.off + n2] == '[') {
            ++n2;
        }
        return n2;
    }

    static Type[] getArgumentTypes(String object) {
        Object object2;
        object = ((String)object).toCharArray();
        int n2 = 1;
        int n3 = 0;
        while ((object2 = object[n2++]) != 41) {
            if (object2 == 76) {
                while (object[n2++] != 59) {
                }
                ++n3;
                continue;
            }
            if (object2 == 91) continue;
            ++n3;
        }
        Type[] typeArray = new Type[n3];
        n2 = 1;
        n3 = 0;
        while (object[n2] != 41) {
            typeArray[n3] = Type.getType((char[])object, n2);
            n2 += typeArray[n3].len + (typeArray[n3].sort == 10 ? 2 : 0);
            ++n3;
        }
        return typeArray;
    }

    protected String getClassName() {
        switch (this.sort) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                Object object = Type.getType(this.buf, this.off + this.getDimensions());
                object = new StringBuilder(((Type)object).getClassName());
                for (int i2 = this.getDimensions(); i2 > 0; --i2) {
                    ((StringBuilder)object).append("[]");
                }
                return ((StringBuilder)object).toString();
            }
        }
        return new String(this.buf, this.off, this.len).replace('/', '.');
    }
}

