/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.parser;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.Feature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.JSONLexer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.JSONScanner;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.JSONToken;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.SymbolTable;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.IOUtils;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JSONLexerBase
implements JSONLexer,
Closeable {
    protected int token;
    protected int pos;
    protected int features;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected boolean hasSpecial;
    protected Calendar calendar = null;
    protected TimeZone timeZone = JSON.defaultTimeZone;
    protected Locale locale = JSON.defaultLocale;
    public int matchStat = 0;
    private static final ThreadLocal<char[]> SBUF_LOCAL = new ThreadLocal();
    protected String stringDefaultValue = null;
    protected static final char[] typeFieldName = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
    protected static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    protected static final int INT_MULTMIN_RADIX_TEN = -214748364;
    protected static final int[] digits = new int[103];

    protected void lexError(String string, Object ... objectArray) {
        this.token = 1;
    }

    public JSONLexerBase(int n2) {
        this.features = n2;
        if ((n2 & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
        this.sbuf = SBUF_LOCAL.get();
        if (this.sbuf == null) {
            this.sbuf = new char[512];
        }
    }

    public final int matchStat() {
        return this.matchStat;
    }

    public void setToken(int n2) {
        this.token = n2;
    }

    @Override
    public final void nextToken() {
        this.sp = 0;
        block19: while (true) {
            this.pos = this.bp;
            if (this.ch == '/') {
                this.skipComment();
                continue;
            }
            if (this.ch == '\"') {
                this.scanString();
                return;
            }
            if (this.ch == ',') {
                this.next();
                this.token = 16;
                return;
            }
            if (this.ch >= '0' && this.ch <= '9') {
                this.scanNumber();
                return;
            }
            if (this.ch == '-') {
                this.scanNumber();
                return;
            }
            switch (this.ch) {
                case '\'': {
                    if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("Feature.AllowSingleQuotes is false");
                    }
                    this.scanStringSingleQuote();
                    return;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.next();
                    continue block19;
                }
                case 't': {
                    this.scanTrue();
                    return;
                }
                case 'f': {
                    this.scanFalse();
                    return;
                }
                case 'n': {
                    this.scanNullOrNew();
                    return;
                }
                case 'N': 
                case 'S': 
                case 'T': 
                case 'u': {
                    this.scanIdent();
                    return;
                }
                case '(': {
                    this.next();
                    this.token = 10;
                    return;
                }
                case ')': {
                    this.next();
                    this.token = 11;
                    return;
                }
                case '[': {
                    this.next();
                    this.token = 14;
                    return;
                }
                case ']': {
                    this.next();
                    this.token = 15;
                    return;
                }
                case '{': {
                    this.next();
                    this.token = 12;
                    return;
                }
                case '}': {
                    this.next();
                    this.token = 13;
                    return;
                }
                case ':': {
                    this.next();
                    this.token = 17;
                    return;
                }
                case ';': {
                    this.next();
                    this.token = 24;
                    return;
                }
                case '.': {
                    this.next();
                    this.token = 25;
                    return;
                }
                case '+': {
                    this.next();
                    this.scanNumber();
                    return;
                }
                case 'x': {
                    this.scanHex();
                    return;
                }
            }
            if (this.isEOF()) {
                if (this.token == 20) {
                    throw new JSONException("EOF error");
                }
                this.token = 20;
                JSONLexerBase jSONLexerBase = this;
                jSONLexerBase.pos = jSONLexerBase.bp = this.eofPos;
                return;
            }
            if (this.ch > '\u001f' && this.ch != '\u007f') break;
            this.next();
        }
        this.lexError("illegal.char", String.valueOf((int)this.ch));
        this.next();
    }

    @Override
    public final void nextToken(int n2) {
        this.sp = 0;
        while (true) {
            switch (n2) {
                case 12: {
                    if (this.ch == '{') {
                        this.token = 12;
                        this.next();
                        return;
                    }
                    if (this.ch != '[') break;
                    this.token = 14;
                    this.next();
                    return;
                }
                case 16: {
                    if (this.ch == ',') {
                        this.token = 16;
                        this.next();
                        return;
                    }
                    if (this.ch == '}') {
                        this.token = 13;
                        this.next();
                        return;
                    }
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 4: {
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 14: {
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 15: {
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                }
                case 20: {
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 18: {
                    this.nextIdent();
                    return;
                }
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        this.nextToken();
    }

    public final void nextIdent() {
        while (JSONLexerBase.isWhitespace(this.ch)) {
            this.next();
        }
        if (this.ch == '_' || this.ch == '$' || Character.isLetter(this.ch)) {
            this.scanIdent();
            return;
        }
        this.nextToken();
    }

    @Override
    public final void nextTokenWithColon() {
        this.nextTokenWithChar(':');
    }

    public final void nextTokenWithChar(char c2) {
        this.sp = 0;
        while (true) {
            if (this.ch == c2) {
                this.next();
                this.nextToken();
                return;
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        throw new JSONException("not match " + c2 + " - " + this.ch + ", info : " + this.info());
    }

    @Override
    public final int token() {
        return this.token;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    public final String stringDefaultValue() {
        return this.stringDefaultValue;
    }

    @Override
    public final Number integerValue() {
        int n2;
        long l2;
        long l3 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        int n3 = this.np;
        int n4 = this.np + this.sp;
        int n5 = 32;
        switch (this.charAt(n4 - 1)) {
            case 'L': {
                --n4;
                n5 = 76;
                break;
            }
            case 'S': {
                --n4;
                n5 = 83;
                break;
            }
            case 'B': {
                --n4;
                n5 = 66;
            }
        }
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np) == '-') {
            bl = true;
            l2 = Long.MIN_VALUE;
            ++n3;
        } else {
            l2 = -9223372036854775807L;
        }
        if (n3 < n4) {
            n2 = this.charAt(n3++) - 48;
            l3 = -n2;
        }
        while (n3 < n4) {
            n2 = this.charAt(n3++) - 48;
            if (l3 < -922337203685477580L) {
                return new BigInteger(this.numberString());
            }
            if ((l3 *= 10L) < l2 + (long)n2) {
                return new BigInteger(this.numberString());
            }
            l3 -= (long)n2;
        }
        if (bl) {
            if (n3 > this.np + 1) {
                if (l3 >= Integer.MIN_VALUE && n5 != 76) {
                    if (n5 == 83) {
                        return (short)l3;
                    }
                    if (n5 == 66) {
                        return (byte)l3;
                    }
                    return (int)l3;
                }
                return l3;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((l3 = -l3) <= Integer.MAX_VALUE && n5 != 76) {
            if (n5 == 83) {
                return (short)l3;
            }
            if (n5 == 66) {
                return (byte)l3;
            }
            return (int)l3;
        }
        return l3;
    }

    @Override
    public final void nextTokenWithColon(int n2) {
        this.nextTokenWithChar(':');
    }

    @Override
    public float floatValue() {
        char c2;
        String string = this.numberString();
        float f2 = Float.parseFloat(string);
        if ((f2 == 0.0f || f2 == Float.POSITIVE_INFINITY) && (c2 = string.charAt(0)) > '0' && c2 <= '9') {
            throw new JSONException("float overflow : " + string);
        }
        return f2;
    }

    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public void config(Feature feature, boolean bl) {
        this.features = Feature.config(this.features, feature, bl);
        if ((this.features & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
    }

    @Override
    public final boolean isEnabled(Feature feature) {
        return this.isEnabled(feature.mask);
    }

    @Override
    public final boolean isEnabled(int n2) {
        return (this.features & n2) != 0;
    }

    public final boolean isEnabled(int n2, int n3) {
        return (this.features & n3) != 0 || (n2 & n3) != 0;
    }

    @Override
    public abstract String numberString();

    public abstract boolean isEOF();

    @Override
    public final char getCurrent() {
        return this.ch;
    }

    public abstract char charAt(int var1);

    @Override
    public abstract char next();

    protected void skipComment() {
        this.next();
        if (this.ch == '/') {
            do {
                this.next();
                if (this.ch != '\n') continue;
                this.next();
                return;
            } while (this.ch != '\u001a');
            return;
        }
        if (this.ch == '*') {
            this.next();
            while (this.ch != '\u001a') {
                if (this.ch == '*') {
                    this.next();
                    if (this.ch != '/') continue;
                    this.next();
                    return;
                }
                this.next();
            }
        } else {
            throw new JSONException("invalid comment");
        }
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable) {
        this.skipWhitespace();
        if (this.ch == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.ch == '\'') {
            if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.ch == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (this.ch == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (this.ch == '\u001a') {
            this.token = 20;
            return null;
        }
        if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    protected abstract void arrayCopy(int var1, char[] var2, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    @Override
    public final String scanSymbol(SymbolTable symbolTable, char c2) {
        void var5_8;
        char c3;
        int n2 = 0;
        this.np = this.bp;
        this.sp = 0;
        boolean bl = false;
        block22: while ((c3 = this.next()) != c2) {
            if (c3 == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (c3 == '\\') {
                if (!bl) {
                    bl = true;
                    if (this.sp >= this.sbuf.length) {
                        c3 = this.sbuf.length << 1;
                        if (this.sp > c3) {
                            c3 = this.sp;
                        }
                        char[] c5 = new char[c3];
                        System.arraycopy(this.sbuf, 0, c5, 0, this.sbuf.length);
                        this.sbuf = c5;
                    }
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.arrayCopy(jSONLexerBase.np + 1, this.sbuf, 0, this.sp);
                }
                c3 = this.next();
                switch (c3) {
                    case '0': {
                        n2 = n2 * 31 + c3;
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        n2 = n2 * 31 + c3;
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        n2 = n2 * 31 + c3;
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        n2 = n2 * 31 + c3;
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        n2 = n2 * 31 + c3;
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        n2 = n2 * 31 + c3;
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        n2 = n2 * 31 + c3;
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        n2 = n2 * 31 + c3;
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        n2 = n2 * 31 + 8;
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        n2 = n2 * 31 + 9;
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        n2 = n2 * 31 + 10;
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        n2 = n2 * 31 + 11;
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        n2 = n2 * 31 + 12;
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        n2 = n2 * 31 + 13;
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        n2 = n2 * 31 + 34;
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        n2 = n2 * 31 + 39;
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        n2 = n2 * 31 + 47;
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        n2 = n2 * 31 + 92;
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        c3 = this.ch = this.next();
                        char n3 = this.ch = this.next();
                        char c3 = (digits[c3] << 4) + digits[n3];
                        c3 = c3;
                        n2 = n2 * 31 + c3;
                        this.putChar(c3);
                        continue block22;
                    }
                    case 'u': {
                        c3 = this.next();
                        char c4 = this.next();
                        char c5 = this.next();
                        char c6 = this.next();
                        c3 = Integer.parseInt(new String(new char[]{c3, c4, c5, c6}), 16);
                        n2 = n2 * 31 + c3;
                        this.putChar(c3);
                        continue block22;
                    }
                }
                this.ch = c3;
                throw new JSONException("unclosed.str.lit");
            }
            n2 = n2 * 31 + c3;
            if (!bl) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c3);
                continue;
            }
            this.sbuf[this.sp++] = c3;
        }
        this.token = 4;
        if (!bl) {
            int n3 = this.np == -1 ? 0 : this.np + 1;
            String string = this.addSymbol(n3, this.sp, n2, symbolTable);
        } else {
            String string = symbolTable.addSymbol(this.sbuf, 0, this.sp, n2);
        }
        this.sp = 0;
        this.next();
        return var5_8;
    }

    @Override
    public final void resetStringPosition() {
        this.sp = 0;
    }

    @Override
    public String info() {
        return "";
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char c2;
        if (this.token == 1 && this.pos == 0 && this.bp == 1) {
            this.bp = 0;
        }
        boolean[] blArray = IOUtils.firstIdentifierFlags;
        int n2 = this.ch;
        boolean bl = this.ch >= blArray.length || blArray[n2];
        if (!bl) {
            throw new JSONException("illegal identifier : " + this.ch + this.info());
        }
        boolean[] blArray2 = IOUtils.identifierFlags;
        this.np = this.bp;
        this.sp = 1;
        while ((c2 = this.next()) >= blArray2.length || blArray2[c2]) {
            n2 = n2 * 31 + c2;
            ++this.sp;
        }
        this.ch = this.charAt(this.bp);
        this.token = 18;
        if (this.sp == 4 && n2 == 3392903) {
            JSONLexerBase jSONLexerBase = this;
            if (jSONLexerBase.charAt(jSONLexerBase.np) == 'n') {
                JSONLexerBase jSONLexerBase2 = this;
                if (jSONLexerBase2.charAt(jSONLexerBase2.np + 1) == 'u') {
                    JSONLexerBase jSONLexerBase3 = this;
                    if (jSONLexerBase3.charAt(jSONLexerBase3.np + 2) == 'l') {
                        JSONLexerBase jSONLexerBase4 = this;
                        if (jSONLexerBase4.charAt(jSONLexerBase4.np + 3) == 'l') {
                            return null;
                        }
                    }
                }
            }
        }
        if (symbolTable == null) {
            JSONLexerBase jSONLexerBase = this;
            return jSONLexerBase.subString(jSONLexerBase.np, this.sp);
        }
        JSONLexerBase jSONLexerBase = this;
        return jSONLexerBase.addSymbol(jSONLexerBase.np, this.sp, n2, symbolTable);
    }

    protected abstract void copyTo(int var1, int var2, char[] var3);

    /*
     * Could not resolve type clashes
     */
    @Override
    public final void scanString() {
        char c2;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((c2 = this.next()) != '\"') {
            if (c2 == '\u001a') {
                if (!this.isEOF()) {
                    this.putChar('\u001a');
                    continue;
                }
                throw new JSONException("unclosed string : " + c2);
            }
            if (c2 == '\\') {
                char c3;
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        c3 = this.sbuf.length << 1;
                        if (this.sp > c3) {
                            c3 = this.sp;
                        }
                        char[] cArray = new char[c3];
                        System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
                        this.sbuf = cArray;
                    }
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.copyTo(jSONLexerBase.np + 1, this.sp, this.sbuf);
                }
                c2 = this.next();
                switch (c2) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        c3 = this.next();
                        c2 = this.next();
                        c2 = (digits[c3] << 4) + digits[c2];
                        c2 = c2;
                        this.putChar(c2);
                        continue block22;
                    }
                    case 'u': {
                        c3 = this.next();
                        char c4 = this.next();
                        char c5 = this.next();
                        c2 = this.next();
                        c2 = Integer.parseInt(new String(new char[]{c3, c4, c5, c2}), 16);
                        this.putChar(c2);
                        continue block22;
                    }
                }
                this.ch = c2;
                throw new JSONException("unclosed string : " + c2);
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c2);
                continue;
            }
            this.sbuf[this.sp++] = c2;
        }
        this.token = 4;
        this.ch = this.next();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public final int intValue() {
        int n2;
        int n3;
        if (this.np == -1) {
            this.np = 0;
        }
        int n4 = 0;
        boolean bl = false;
        int n5 = this.np;
        int n6 = this.np + this.sp;
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np) == '-') {
            bl = true;
            n3 = Integer.MIN_VALUE;
            ++n5;
        } else {
            n3 = -2147483647;
        }
        if (n5 < n6) {
            n2 = this.charAt(n5++) - 48;
            n4 = -n2;
        }
        while (n5 < n6) {
            char c2 = this.charAt(n5++);
            n2 = c2;
            if (c2 == 'L' || n2 == 83 || n2 == 66) break;
            n2 -= 48;
            if ((long)n4 < -214748364L) {
                throw new NumberFormatException(this.numberString());
            }
            if ((n4 *= 10) < n3 + n2) {
                throw new NumberFormatException(this.numberString());
            }
            n4 -= n2;
        }
        if (bl) {
            if (n5 > this.np + 1) {
                return n4;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -n4;
    }

    @Override
    public abstract byte[] bytesValue();

    @Override
    public void close() {
        if (this.sbuf.length <= 8192) {
            SBUF_LOCAL.set(this.sbuf);
        }
        this.sbuf = null;
    }

    @Override
    public final boolean isRef() {
        if (this.sp != 4) {
            return false;
        }
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np + 1) == '$') {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.np + 2) == 'r') {
                JSONLexerBase jSONLexerBase3 = this;
                if (jSONLexerBase3.charAt(jSONLexerBase3.np + 3) == 'e') {
                    JSONLexerBase jSONLexerBase4 = this;
                    if (jSONLexerBase4.charAt(jSONLexerBase4.np + 4) == 'f') {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final int scanType(String string) {
        this.matchStat = 0;
        if (!this.charArrayCompare(typeFieldName)) {
            return -2;
        }
        int n2 = this.bp + typeFieldName.length;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (string.charAt(i2) == this.charAt(n2 + i2)) continue;
            return -1;
        }
        if (this.charAt(n2 += n3) != '\"') {
            return -1;
        }
        this.ch = this.charAt(++n2);
        if (this.ch == ',') {
            this.ch = this.charAt(++n2);
            this.bp = n2;
            this.token = 16;
            return 3;
        }
        if (this.ch == '}') {
            this.ch = this.charAt(++n2);
            if (this.ch == ',') {
                this.token = 16;
                this.ch = this.charAt(++n2);
            } else if (this.ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++n2);
            } else if (this.ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++n2);
            } else if (this.ch == '\u001a') {
                this.token = 20;
            } else {
                return -1;
            }
            this.matchStat = 4;
        }
        this.bp = n2;
        return this.matchStat;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean matchField(char[] cArray) {
        while (!this.charArrayCompare(cArray)) {
            if (!JSONLexerBase.isWhitespace(this.ch)) return false;
            this.next();
        }
        this.bp += cArray.length;
        this.ch = this.charAt(this.bp);
        if (this.ch == '{') {
            this.next();
            this.token = 12;
            return true;
        }
        if (this.ch == '[') {
            this.next();
            this.token = 14;
            return true;
        }
        if (this.ch == 'S') {
            JSONLexerBase jSONLexerBase = this;
            if (jSONLexerBase.charAt(jSONLexerBase.bp + 1) == 'e') {
                JSONLexerBase jSONLexerBase2 = this;
                if (jSONLexerBase2.charAt(jSONLexerBase2.bp + 2) == 't') {
                    JSONLexerBase jSONLexerBase3 = this;
                    if (jSONLexerBase3.charAt(jSONLexerBase3.bp + 3) == '[') {
                        this.bp += 3;
                        this.ch = this.charAt(this.bp);
                        this.token = 21;
                        return true;
                    }
                }
            }
        }
        this.nextToken();
        return true;
    }

    public abstract int indexOf(char var1, int var2);

    public abstract String addSymbol(int var1, int var2, int var3, SymbolTable var4);

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] object) {
        int n2;
        this.matchStat = 0;
        if (!this.charArrayCompare((char[])object)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int n3 = ((char[])object).length;
        JSONLexerBase jSONLexerBase = this;
        if ((n2 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++)) != 34) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        n2 = this.bp + ((char[])object).length + 1;
        if ((n2 = this.indexOf('\"', n2)) == -1) {
            throw new JSONException("unclosed str");
        }
        int n4 = this.bp + ((char[])object).length + 1;
        String string = this.subString(n4, n2 - n4);
        if (string.indexOf(92) != -1) {
            int n5;
            while (true) {
                n5 = 0;
                for (int i2 = n2 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n5, --i2) {
                }
                if (n5 % 2 == 0) break;
                n2 = this.indexOf('\"', n2 + 1);
            }
            n5 = n2 - (this.bp + ((char[])object).length + 1);
            JSONLexerBase jSONLexerBase2 = this;
            char[] cArray = jSONLexerBase2.sub_chars(jSONLexerBase2.bp + ((char[])object).length + 1, n5);
            string = JSONLexerBase.readString(cArray, n5);
        }
        n3 += n2 - (this.bp + ((char[])object).length + 1) + 1;
        JSONLexerBase jSONLexerBase3 = this;
        n2 = jSONLexerBase3.charAt(jSONLexerBase3.bp + n3++);
        String string2 = string;
        if (n2 == 44) {
            this.bp += n3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return string2;
        }
        if (n2 != 125) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        JSONLexerBase jSONLexerBase4 = this;
        char c2 = jSONLexerBase4.charAt(jSONLexerBase4.bp + n3++);
        n2 = c2;
        if (c2 == ',') {
            this.token = 16;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (n2 == 93) {
            this.token = 15;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (n2 == 125) {
            this.token = 13;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else {
            if (n2 != 26) {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.token = 20;
            this.bp += n3 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return string2;
    }

    @Override
    public String scanString(char c2) {
        String string;
        char c3;
        int n2;
        block13: {
            block14: {
                block16: {
                    block15: {
                        this.matchStat = 0;
                        n2 = 0;
                        JSONLexerBase jSONLexerBase = this;
                        ++n2;
                        c3 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
                        if (c3 != 'n') break block14;
                        JSONLexerBase jSONLexerBase2 = this;
                        if (jSONLexerBase2.charAt(jSONLexerBase2.bp + 1) != 'u') break block15;
                        JSONLexerBase jSONLexerBase3 = this;
                        if (jSONLexerBase3.charAt(jSONLexerBase3.bp + 1 + 1) != 'l') break block15;
                        JSONLexerBase jSONLexerBase4 = this;
                        if (jSONLexerBase4.charAt(jSONLexerBase4.bp + 1 + 2) == 'l') break block16;
                    }
                    this.matchStat = -1;
                    return null;
                }
                JSONLexerBase jSONLexerBase = this;
                c3 = jSONLexerBase.charAt(jSONLexerBase.bp + 4);
                if (c3 == c2) {
                    this.bp += 5;
                    this.ch = this.charAt(this.bp);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            while (true) {
                if (c3 == '\"') {
                    c3 = this.bp + n2;
                    int n3 = this.indexOf('\"', c3);
                    if (n3 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    JSONLexerBase jSONLexerBase = this;
                    string = jSONLexerBase.subString(jSONLexerBase.bp + n2, n3 - c3);
                    if (string.indexOf(92) != -1) {
                        int n4;
                        while (true) {
                            n4 = 0;
                            for (int i2 = n3 - 1; i2 >= 0 && this.charAt(i2) == '\\'; --i2) {
                                ++n4;
                            }
                            if (n4 % 2 == 0) break;
                            n3 = this.indexOf('\"', n3 + 1);
                        }
                        n4 = n3 - c3;
                        JSONLexerBase jSONLexerBase5 = this;
                        char[] cArray = jSONLexerBase5.sub_chars(jSONLexerBase5.bp + 1, n4);
                        string = JSONLexerBase.readString(cArray, n4);
                    }
                    n2 += n3 - c3 + 1;
                    break block13;
                }
                if (!JSONLexerBase.isWhitespace(c3)) break;
                JSONLexerBase jSONLexerBase = this;
                c3 = jSONLexerBase.charAt(jSONLexerBase.bp + n2++);
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        JSONLexerBase jSONLexerBase = this;
        c3 = jSONLexerBase.charAt(jSONLexerBase.bp + n2++);
        String string2 = string;
        while (true) {
            if (c3 == c2) {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return string2;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            JSONLexerBase jSONLexerBase6 = this;
            c3 = jSONLexerBase6.charAt(jSONLexerBase6.bp + n2++);
        }
        this.matchStat = -1;
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldSymbol(char[] cArray) {
        long l2;
        char c2;
        int n2;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n2 = cArray.length;
                JSONLexerBase jSONLexerBase = this;
                if ((c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n2++)) != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                l2 = -3750763034362895579L;
                do {
                    JSONLexerBase jSONLexerBase2 = this;
                    if ((c2 = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++)) == '\"') {
                        JSONLexerBase jSONLexerBase3 = this;
                        if ((c2 = jSONLexerBase3.charAt(jSONLexerBase3.bp + n2++)) != ',') break block12;
                        break block13;
                    }
                    l2 ^= (long)c2;
                    l2 *= 1099511628211L;
                } while (c2 != '\\');
                this.matchStat = -1;
                return 0L;
            }
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return l2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0L;
        }
        JSONLexerBase jSONLexerBase = this;
        if ((c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return l2;
    }

    @Override
    public Enum<?> scanEnum(Class<?> clazz, SymbolTable object, char c2) {
        if ((object = this.scanSymbolWithSeperator((SymbolTable)object, c2)) == null) {
            return null;
        }
        return Enum.valueOf(clazz, (String)object);
    }

    @Override
    public String scanSymbolWithSeperator(SymbolTable object, char c2) {
        int n2;
        char c3;
        int n3;
        block8: {
            block9: {
                block11: {
                    block10: {
                        this.matchStat = 0;
                        n3 = 0;
                        JSONLexerBase jSONLexerBase = this;
                        ++n3;
                        c3 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
                        if (c3 != 'n') break block9;
                        JSONLexerBase jSONLexerBase2 = this;
                        if (jSONLexerBase2.charAt(jSONLexerBase2.bp + 1) != 'u') break block10;
                        JSONLexerBase jSONLexerBase3 = this;
                        if (jSONLexerBase3.charAt(jSONLexerBase3.bp + 1 + 1) != 'l') break block10;
                        JSONLexerBase jSONLexerBase4 = this;
                        if (jSONLexerBase4.charAt(jSONLexerBase4.bp + 1 + 2) == 'l') break block11;
                    }
                    this.matchStat = -1;
                    return null;
                }
                JSONLexerBase jSONLexerBase = this;
                c3 = jSONLexerBase.charAt(jSONLexerBase.bp + 4);
                if (c3 == c2) {
                    this.bp += 5;
                    this.ch = this.charAt(this.bp);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            if (c3 != '\"') {
                this.matchStat = -1;
                return null;
            }
            n2 = 0;
            do {
                JSONLexerBase jSONLexerBase = this;
                if ((c3 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++)) == '\"') break block8;
                n2 = n2 * 31 + c3;
            } while (c3 != '\\');
            this.matchStat = -1;
            return null;
        }
        c3 = this.bp + 1;
        int n4 = this.bp + n3 - c3 - 1;
        object = this.addSymbol(c3, n4, n2, (SymbolTable)object);
        JSONLexerBase jSONLexerBase = this;
        c3 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++);
        while (true) {
            if (c3 == c2) {
                this.bp += n3;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return object;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            JSONLexerBase jSONLexerBase5 = this;
            c3 = jSONLexerBase5.charAt(jSONLexerBase5.bp + n3++);
        }
        this.matchStat = -1;
        return object;
    }

    public Collection<String> newCollectionByType(Class<?> object) {
        if (((Class)object).isAssignableFrom(HashSet.class)) {
            object = new HashSet<String>();
            return object;
        }
        if (((Class)object).isAssignableFrom(ArrayList.class)) {
            object = new ArrayList<String>();
            return object;
        }
        try {
            object = (Collection)((Class)object).newInstance();
            return object;
        }
        catch (Exception exception) {
            throw new JSONException(exception.getMessage(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Collection<String> scanFieldStringArray(char[] cArray, Class<?> collection) {
        int n2;
        int n3;
        block20: {
            this.matchStat = 0;
            if (!this.charArrayCompare(cArray)) {
                this.matchStat = -2;
                return null;
            }
            collection = this.newCollectionByType((Class<?>)((Object)collection));
            n3 = cArray.length;
            JSONLexerBase jSONLexerBase = this;
            if ((n2 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++)) != 91) {
                this.matchStat = -1;
                return null;
            }
            do {
                String string;
                block22: {
                    int n4;
                    block23: {
                        block21: {
                            JSONLexerBase jSONLexerBase2 = this;
                            if ((n2 = jSONLexerBase2.charAt(jSONLexerBase2.bp + n3++)) != 34) break block21;
                            n2 = this.bp + n3;
                            if ((n2 = this.indexOf('\"', n2)) == -1) {
                                throw new JSONException("unclosed str");
                            }
                            int n5 = this.bp + n3;
                            string = this.subString(n5, n2 - n5);
                            if (string.indexOf(92) == -1) break block22;
                            break block23;
                        }
                        if (n2 == 110) {
                            JSONLexerBase jSONLexerBase3 = this;
                            if (jSONLexerBase3.charAt(jSONLexerBase3.bp + n3) == 'u') {
                                JSONLexerBase jSONLexerBase4 = this;
                                if (jSONLexerBase4.charAt(jSONLexerBase4.bp + n3 + 1) == 'l') {
                                    JSONLexerBase jSONLexerBase5 = this;
                                    if (jSONLexerBase5.charAt(jSONLexerBase5.bp + n3 + 2) == 'l') {
                                        n3 += 3;
                                        JSONLexerBase jSONLexerBase6 = this;
                                        n2 = jSONLexerBase6.charAt(jSONLexerBase6.bp + n3++);
                                        collection.add(null);
                                        continue;
                                    }
                                }
                            }
                        }
                        if (n2 != 93) throw new JSONException("illega str");
                        if (collection.size() != 0) throw new JSONException("illega str");
                        JSONLexerBase jSONLexerBase7 = this;
                        n2 = jSONLexerBase7.charAt(jSONLexerBase7.bp + n3++);
                        break block20;
                    }
                    while (true) {
                        n4 = 0;
                        for (int i2 = n2 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n4, --i2) {
                        }
                        if (n4 % 2 == 0) break;
                        n2 = this.indexOf('\"', n2 + 1);
                    }
                    n4 = n2 - (this.bp + n3);
                    JSONLexerBase jSONLexerBase8 = this;
                    char[] cArray2 = jSONLexerBase8.sub_chars(jSONLexerBase8.bp + n3, n4);
                    string = JSONLexerBase.readString(cArray2, n4);
                }
                n3 += n2 - (this.bp + n3) + 1;
                JSONLexerBase jSONLexerBase9 = this;
                n2 = jSONLexerBase9.charAt(jSONLexerBase9.bp + n3++);
                collection.add(string);
            } while (n2 == 44);
            if (n2 != 93) {
                this.matchStat = -1;
                return null;
            }
            JSONLexerBase jSONLexerBase10 = this;
            n2 = jSONLexerBase10.charAt(jSONLexerBase10.bp + n3++);
        }
        if (n2 == 44) {
            this.bp += n3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return collection;
        }
        if (n2 != 125) {
            this.matchStat = -1;
            return null;
        }
        JSONLexerBase jSONLexerBase = this;
        char c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++);
        n2 = c2;
        if (c2 == ',') {
            this.token = 16;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (n2 == 93) {
            this.token = 15;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (n2 == 125) {
            this.token = 13;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else {
            if (n2 != 26) {
                this.matchStat = -1;
                return null;
            }
            this.bp += n3 - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return collection;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void scanStringArray(Collection<String> var1_1, char var2_2) {
        block18: {
            this.matchStat = 0;
            var3_3 = 0;
            v0 = this;
            ++var3_3;
            var4_4 = v0.charAt(v0.bp + 0);
            if (var4_4 == 110) {
                v1 = this;
                if (v1.charAt(v1.bp + 1) == 'u') {
                    v2 = this;
                    if (v2.charAt(v2.bp + 1 + 1) == 'l') {
                        v3 = this;
                        if (v3.charAt(v3.bp + 1 + 2) == 'l') {
                            v4 = this;
                            if (v4.charAt(v4.bp + 1 + 3) == var2_2) {
                                this.bp += 5;
                                this.ch = this.charAt(this.bp);
                                this.matchStat = 5;
                                return;
                            }
                        }
                    }
                }
            }
            if (var4_4 != 91) {
                this.matchStat = -1;
                return;
            }
            v5 = this;
            ++var3_3;
            var4_4 = v5.charAt(v5.bp + 1);
            while (true) {
                if (var4_4 != 110) ** GOTO lbl-1000
                v6 = this;
                if (v6.charAt(v6.bp + var3_3) != 'u') ** GOTO lbl-1000
                v7 = this;
                if (v7.charAt(v7.bp + var3_3 + 1) != 'l') ** GOTO lbl-1000
                v8 = this;
                if (v8.charAt(v8.bp + var3_3 + 2) == 'l') {
                    var3_3 += 3;
                    v9 = this;
                    var4_4 = v9.charAt(v9.bp + var3_3++);
                    var1_1.add(null);
                } else lbl-1000:
                // 4 sources

                {
                    if (var4_4 == 93 && var1_1.size() == 0) {
                        v10 = this;
                        var4_4 = v10.charAt(v10.bp + var3_3++);
                        break block18;
                    }
                    if (var4_4 != 34) {
                        this.matchStat = -1;
                        return;
                    }
                    var4_4 = this.bp + var3_3;
                    var5_5 = this.indexOf('\"', var4_4);
                    if (var5_5 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    v11 = this;
                    var6_6 = v11.subString(v11.bp + var3_3, var5_5 - var4_4);
                    if (var6_6.indexOf(92) != -1) {
                        while (true) {
                            var6_8 = 0;
                            for (var7_10 = var5_5 - 1; var7_10 >= 0 && this.charAt(var7_10) == '\\'; --var7_10) {
                                ++var6_8;
                            }
                            if (var6_8 % 2 == 0) break;
                            var5_5 = this.indexOf('\"', var5_5 + 1);
                        }
                        var6_8 = var5_5 - var4_4;
                        v12 = this;
                        var7_9 = v12.sub_chars(v12.bp + var3_3, var6_8);
                        var6_6 = JSONLexerBase.readString(var7_9, var6_8);
                    }
                    var3_3 += var5_5 - (this.bp + var3_3) + 1;
                    v13 = this;
                    var4_4 = v13.charAt(v13.bp + var3_3++);
                    var1_1.add(var6_6);
                }
                if (var4_4 != 44) break;
                v14 = this;
                var4_4 = v14.charAt(v14.bp + var3_3++);
            }
            if (var4_4 == 93) {
                v15 = this;
                var4_4 = v15.charAt(v15.bp + var3_3++);
            } else {
                this.matchStat = -1;
                return;
            }
        }
        if (var4_4 == var2_2) {
            this.bp += var3_3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return;
        }
        this.matchStat = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanFieldInt(char[] cArray) {
        int n2;
        char c2;
        boolean bl;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0;
        }
        int n3 = cArray.length;
        JSONLexerBase jSONLexerBase = this;
        if (bl = (c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++)) == '-') {
            JSONLexerBase jSONLexerBase2 = this;
            c2 = jSONLexerBase2.charAt(jSONLexerBase2.bp + n3++);
        }
        if (c2 >= '0' && c2 <= '9') {
            n2 = c2 - 48;
            while (true) {
                JSONLexerBase jSONLexerBase3 = this;
                if ((c2 = jSONLexerBase3.charAt(jSONLexerBase3.bp + n3++)) < '0' || c2 > '9') break;
                n2 = n2 * 10 + (c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (!(n2 >= 0 && n3 <= 14 + cArray.length || n2 == Integer.MIN_VALUE && n3 == 17 && bl)) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (c2 == ',') {
            this.bp += n3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (bl) {
                return -n2;
            }
            return n2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0;
        }
        JSONLexerBase jSONLexerBase4 = this;
        if ((c2 = jSONLexerBase4.charAt(jSONLexerBase4.bp + n3++)) == ',') {
            this.token = 16;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0;
            }
            this.token = 20;
            this.bp += n3 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            return n2;
        }
        return -n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int[] scanFieldIntArray(char[] cArray) {
        int n2;
        int[] nArray;
        char c2;
        int n3;
        block20: {
            block19: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return null;
                }
                n3 = cArray.length;
                JSONLexerBase jSONLexerBase = this;
                if ((c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++)) != '[') {
                    this.matchStat = -2;
                    return null;
                }
                JSONLexerBase jSONLexerBase2 = this;
                c2 = jSONLexerBase2.charAt(jSONLexerBase2.bp + n3++);
                nArray = new int[16];
                n2 = 0;
                if (c2 == ']') {
                    JSONLexerBase jSONLexerBase3 = this;
                    c2 = jSONLexerBase3.charAt(jSONLexerBase3.bp + n3++);
                } else {
                    while (true) {
                        boolean bl = false;
                        if (c2 == '-') {
                            JSONLexerBase jSONLexerBase4 = this;
                            c2 = jSONLexerBase4.charAt(jSONLexerBase4.bp + n3++);
                            bl = true;
                        }
                        if (c2 < '0' || c2 > '9') break block19;
                        int n4 = c2 - 48;
                        while (true) {
                            JSONLexerBase jSONLexerBase5 = this;
                            if ((c2 = jSONLexerBase5.charAt(jSONLexerBase5.bp + n3++)) < '0' || c2 > '9') break;
                            n4 = n4 * 10 + (c2 - 48);
                        }
                        if (n2 >= nArray.length) {
                            int[] nArray2 = new int[nArray.length * 3 / 2];
                            System.arraycopy(nArray, 0, nArray2, 0, n2);
                            nArray = nArray2;
                        }
                        int n5 = nArray[n2++] = bl ? -n4 : n4;
                        if (c2 == ',') {
                            JSONLexerBase jSONLexerBase6 = this;
                            c2 = jSONLexerBase6.charAt(jSONLexerBase6.bp + n3++);
                            continue;
                        }
                        if (c2 == ']') break;
                    }
                    JSONLexerBase jSONLexerBase7 = this;
                    c2 = jSONLexerBase7.charAt(jSONLexerBase7.bp + n3++);
                }
                break block20;
            }
            this.matchStat = -1;
            return null;
        }
        if (n2 != nArray.length) {
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            nArray = nArray3;
        }
        if (c2 == ',') {
            this.bp += n3 - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return nArray;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        JSONLexerBase jSONLexerBase = this;
        if ((c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++)) == ',') {
            this.token = 16;
            this.bp += n3 - 1;
            this.next();
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n3 - 1;
            this.next();
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n3 - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += n3 - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean scanBoolean(char var1_1) {
        block9: {
            block7: {
                block8: {
                    this.matchStat = 0;
                    var2_2 = 0;
                    v0 = this;
                    ++var2_2;
                    var3_3 = v0.charAt(v0.bp + 0);
                    var4_4 = false;
                    if (var3_3 != 't') break block7;
                    v1 = this;
                    if (v1.charAt(v1.bp + 1) != 'r') break block8;
                    v2 = this;
                    if (v2.charAt(v2.bp + 1 + 1) != 'u') break block8;
                    v3 = this;
                    if (v3.charAt(v3.bp + 1 + 2) != 'e') break block8;
                    var2_2 += 3;
                    v4 = this;
                    ++var2_2;
                    var3_3 = v4.charAt(v4.bp + 4);
                    var4_4 = true;
                    break block9;
                }
                this.matchStat = -1;
                return false;
            }
            if (var3_3 != 'f') ** GOTO lbl41
            v5 = this;
            if (v5.charAt(v5.bp + 1) != 'a') ** GOTO lbl-1000
            v6 = this;
            if (v6.charAt(v6.bp + 1 + 1) != 'l') ** GOTO lbl-1000
            v7 = this;
            if (v7.charAt(v7.bp + 1 + 2) != 's') ** GOTO lbl-1000
            v8 = this;
            if (v8.charAt(v8.bp + 1 + 3) == 'e') {
                var2_2 += 4;
                v9 = this;
                ++var2_2;
                var3_3 = v9.charAt(v9.bp + 5);
                var4_4 = false;
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return false;
lbl41:
                // 1 sources

                if (var3_3 == '1') {
                    v10 = this;
                    ++var2_2;
                    var3_3 = v10.charAt(v10.bp + 1);
                    var4_4 = true;
                } else if (var3_3 == '0') {
                    v11 = this;
                    ++var2_2;
                    var3_3 = v11.charAt(v11.bp + 1);
                    var4_4 = false;
                }
            }
        }
        while (true) {
            if (var3_3 == var1_1) {
                this.bp += var2_2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return var4_4;
            }
            if (!JSONLexerBase.isWhitespace(var3_3)) break;
            v12 = this;
            var3_3 = v12.charAt(v12.bp + var2_2++);
        }
        this.matchStat = -1;
        return var4_4;
    }

    @Override
    public int scanInt(char c2) {
        boolean bl;
        this.matchStat = 0;
        int n2 = 0;
        JSONLexerBase jSONLexerBase = this;
        ++n2;
        char c3 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
        int n3 = c3 == '\"' ? 1 : 0;
        if (n3 != 0) {
            JSONLexerBase jSONLexerBase2 = this;
            ++n2;
            c3 = jSONLexerBase2.charAt(jSONLexerBase2.bp + 1);
        }
        if (bl = c3 == '-') {
            JSONLexerBase jSONLexerBase3 = this;
            c3 = jSONLexerBase3.charAt(jSONLexerBase3.bp + n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            n3 = c3 - 48;
            while (true) {
                JSONLexerBase jSONLexerBase4 = this;
                if ((c3 = jSONLexerBase4.charAt(jSONLexerBase4.bp + n2++)) < '0' || c3 > '9') break;
                n3 = n3 * 10 + (c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (n3 < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            if (c3 == 'n') {
                JSONLexerBase jSONLexerBase5 = this;
                if (jSONLexerBase5.charAt(jSONLexerBase5.bp + n2) == 'u') {
                    JSONLexerBase jSONLexerBase6 = this;
                    if (jSONLexerBase6.charAt(jSONLexerBase6.bp + n2 + 1) == 'l') {
                        JSONLexerBase jSONLexerBase7 = this;
                        if (jSONLexerBase7.charAt(jSONLexerBase7.bp + n2 + 2) == 'l') {
                            this.matchStat = 5;
                            n2 += 3;
                            JSONLexerBase jSONLexerBase8 = this;
                            c3 = jSONLexerBase8.charAt(jSONLexerBase8.bp + n2++);
                            if (n3 != 0 && c3 == '\"') {
                                JSONLexerBase jSONLexerBase9 = this;
                                c3 = jSONLexerBase9.charAt(jSONLexerBase9.bp + n2++);
                            }
                            while (true) {
                                if (c3 == ',') {
                                    this.bp += n2;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0;
                                }
                                if (c3 == ']') {
                                    this.bp += n2;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 15;
                                    return 0;
                                }
                                if (!JSONLexerBase.isWhitespace(c3)) break;
                                JSONLexerBase jSONLexerBase10 = this;
                                c3 = jSONLexerBase10.charAt(jSONLexerBase10.bp + n2++);
                            }
                            this.matchStat = -1;
                            return 0;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (c3 == c2) {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                if (bl) {
                    return -n3;
                }
                return n3;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            JSONLexerBase jSONLexerBase11 = this;
            c3 = jSONLexerBase11.charAt(jSONLexerBase11.bp + n2++);
        }
        this.matchStat = -1;
        if (bl) {
            return -n3;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean scanFieldBoolean(char[] cArray) {
        boolean bl;
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return false;
        }
        int n2 = cArray.length;
        JSONLexerBase jSONLexerBase = this;
        if ((c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n2++)) == 't') {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++) != 'r') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase3 = this;
            if (jSONLexerBase3.charAt(jSONLexerBase3.bp + n2++) != 'u') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase4 = this;
            if (jSONLexerBase4.charAt(jSONLexerBase4.bp + n2++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = true;
        } else {
            if (c2 != 'f') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase5 = this;
            if (jSONLexerBase5.charAt(jSONLexerBase5.bp + n2++) != 'a') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase6 = this;
            if (jSONLexerBase6.charAt(jSONLexerBase6.bp + n2++) != 'l') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase7 = this;
            if (jSONLexerBase7.charAt(jSONLexerBase7.bp + n2++) != 's') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase8 = this;
            if (jSONLexerBase8.charAt(jSONLexerBase8.bp + n2++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = false;
        }
        JSONLexerBase jSONLexerBase9 = this;
        c2 = jSONLexerBase9.charAt(jSONLexerBase9.bp + n2++);
        if (c2 == ',') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return bl;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return false;
        }
        JSONLexerBase jSONLexerBase10 = this;
        if ((c2 = jSONLexerBase10.charAt(jSONLexerBase10.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return false;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] cArray) {
        long l2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0L;
        }
        int n2 = cArray.length;
        JSONLexerBase jSONLexerBase = this;
        char c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n2++);
        boolean bl = false;
        if (c2 == '-') {
            JSONLexerBase jSONLexerBase2 = this;
            c2 = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++);
            bl = true;
        }
        if (c2 >= '0' && c2 <= '9') {
            l2 = c2 - 48;
            while (true) {
                JSONLexerBase jSONLexerBase3 = this;
                if ((c2 = jSONLexerBase3.charAt(jSONLexerBase3.bp + n2++)) < '0' || c2 > '9') break;
                l2 = l2 * 10L + (long)(c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            boolean bl2 = n2 - cArray.length < 21 && (l2 >= 0L || l2 == Long.MIN_VALUE && bl);
            if (!bl2) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (c2 == ',') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (bl) {
                return -l2;
            }
            return l2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0L;
        }
        JSONLexerBase jSONLexerBase4 = this;
        if ((c2 = jSONLexerBase4.charAt(jSONLexerBase4.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            return l2;
        }
        return -l2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long scanLong(char var1_1) {
        this.matchStat = 0;
        var2_3 = 0;
        v0 = this;
        ++var2_3;
        var3_4 = v0.charAt(v0.bp + 0);
        var4_5 = var3_4 == '\"';
        if (var4_5) {
            v1 = this;
            ++var2_3;
            var3_4 = v1.charAt(v1.bp + 1);
        }
        if (var5_6 = var3_4 == '-') {
            v2 = this;
            var3_4 = v2.charAt(v2.bp + var2_3++);
        }
        if (var3_4 >= '0' && var3_4 <= '9') {
            var6_7 = var3_4 - 48;
            while (true) {
                v3 = this;
                if ((var3_4 = v3.charAt(v3.bp + var2_3++)) < '0' || var3_4 > '9') break;
                var6_7 = var6_7 * 10L + (long)(var3_4 - 48);
            }
            if (var3_4 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            var8_8 = var6_7 >= 0L || var6_7 == -9223372036854775808L && var5_6 != false;
            if (!var8_8) {
                v4 = this;
                var1_2 = v4.subString(v4.bp, var2_3 - 1);
                throw new NumberFormatException(var1_2);
            }
        } else {
            if (var3_4 == 'n') {
                v5 = this;
                if (v5.charAt(v5.bp + var2_3) == 'u') {
                    v6 = this;
                    if (v6.charAt(v6.bp + var2_3 + 1) == 'l') {
                        v7 = this;
                        if (v7.charAt(v7.bp + var2_3 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_3 += 3;
                            v8 = this;
                            var3_4 = v8.charAt(v8.bp + var2_3++);
                            if (var4_5 && var3_4 == '\"') {
                                v9 = this;
                                var3_4 = v9.charAt(v9.bp + var2_3++);
                            }
                            while (true) {
                                if (var3_4 == ',') {
                                    this.bp += var2_3;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0L;
                                }
                                if (var3_4 == ']') {
                                    this.bp += var2_3;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 15;
                                    return 0L;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_4)) break;
                                v10 = this;
                                var3_4 = v10.charAt(v10.bp + var2_3++);
                            }
                            this.matchStat = -1;
                            return 0L;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0L;
        }
        if (!var4_5) ** GOTO lbl72
        if (var3_4 != '\"') {
            this.matchStat = -1;
            return 0L;
        }
        do {
            v11 = this;
            var3_4 = v11.charAt(v11.bp + var2_3++);
lbl72:
            // 2 sources

            if (var3_4 != var1_1) continue;
            this.bp += var2_3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (var5_6) {
                return -var6_7;
            }
            return var6_7;
        } while (JSONLexerBase.isWhitespace(var3_4));
        this.matchStat = -1;
        return var6_7;
    }

    /*
     * Unable to fully structure code
     */
    public final float scanFieldFloat(char[] var1_1) {
        block35: {
            block33: {
                block34: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(var1_1)) {
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    var2_5 = var1_1.length;
                    v0 = this;
                    if ((var4_7 = (var3_6 = v0.charAt(v0.bp + var2_5++)) == '\"' ? 1 : 0) != 0) {
                        v1 = this;
                        var3_6 = v1.charAt(v1.bp + var2_5++);
                    }
                    if (var5_8 = var3_6 == '-') {
                        v2 = this;
                        var3_6 = v2.charAt(v2.bp + var2_5++);
                    }
                    if (var3_6 < '0' || var3_6 > '9') break block33;
                    var6_9 = var3_6 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_6 = v3.charAt(v3.bp + var2_5++)) < '0' || var3_6 > '9') break;
                        var6_9 = var6_9 * 10L + (long)(var3_6 - 48);
                    }
                    var8_10 = 1;
                    var9_11 = var3_6 == '.';
                    if (var9_11) {
                        v4 = this;
                        if ((var3_6 = v4.charAt(v4.bp + var2_5++)) >= '0' && var3_6 <= '9') {
                            var6_9 = var6_9 * 10L + (long)(var3_6 - 48);
                            var8_10 = 10;
                            while (true) {
                                v5 = this;
                                if ((var3_6 = v5.charAt(v5.bp + var2_5++)) >= '0' && var3_6 <= '9') {
                                    var6_9 = var6_9 * 10L + (long)(var3_6 - 48);
                                    var8_10 *= 10;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    if (!(var9_11 = var3_6 == 'e' || var3_6 == 'E')) break block34;
                    v6 = this;
                    if ((var3_6 = v6.charAt(v6.bp + var2_5++)) != '+' && var3_6 != '-') ** GOTO lbl42
                    do {
                        v7 = this;
                        var3_6 = v7.charAt(v7.bp + var2_5++);
lbl42:
                        // 2 sources

                    } while (var3_6 >= '0' && var3_6 <= '9');
                }
                if (var4_7 != 0) {
                    if (var3_6 != '\"') {
                        this.matchStat = -1;
                        return 0.0f;
                    }
                    v8 = this;
                    var3_6 = v8.charAt(v8.bp + var2_5++);
                    var1_2 = this.bp + var1_1.length + 1;
                    var4_7 = this.bp + var2_5 - var1_2 - 2;
                } else {
                    var1_2 = this.bp + var1_1.length;
                    var4_7 = this.bp + var2_5 - var1_2 - 1;
                }
                if (!var9_11 && var4_7 < 17) {
                    var1_3 = (float)((double)var6_9 / (double)var8_10);
                    if (var5_8) {
                        var1_3 = -var1_3;
                    }
                } else {
                    var1_4 = this.subString(var1_2, var4_7);
                    var1_3 = Float.parseFloat(var1_4);
                }
                break block35;
            }
            if (var3_6 == 'n') {
                v9 = this;
                if (v9.charAt(v9.bp + var2_5) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.bp + var2_5 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.bp + var2_5 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_5 += 3;
                            v12 = this;
                            var3_6 = v12.charAt(v12.bp + var2_5++);
                            if (var4_7 != 0 && var3_6 == '\"') {
                                v13 = this;
                                var3_6 = v13.charAt(v13.bp + var2_5++);
                            }
                            while (true) {
                                if (var3_6 == ',') {
                                    this.bp += var2_5;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0.0f;
                                }
                                if (var3_6 == '}') {
                                    this.bp += var2_5;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 13;
                                    return 0.0f;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_6)) break;
                                v14 = this;
                                var3_6 = v14.charAt(v14.bp + var2_5++);
                            }
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0f;
        }
        if (var3_6 == ',') {
            this.bp += var2_5;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var1_3;
        }
        if (var3_6 != '}') ** GOTO lbl130
        v15 = this;
        if ((var3_6 = v15.charAt(v15.bp + var2_5++)) == ',') {
            this.token = 16;
            this.bp += var2_5;
            this.ch = this.charAt(this.bp);
        } else if (var3_6 == ']') {
            this.token = 15;
            this.bp += var2_5;
            this.ch = this.charAt(this.bp);
        } else if (var3_6 == '}') {
            this.token = 13;
            this.bp += var2_5;
            this.ch = this.charAt(this.bp);
        } else if (var3_6 == '\u001a') {
            this.bp += var2_5 - 1;
            this.token = 20;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return 0.0f;
lbl130:
            // 1 sources

            this.matchStat = -1;
            return 0.0f;
        }
        this.matchStat = 4;
        return var1_3;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final float scanFloat(char var1_1) {
        block26: {
            block24: {
                block25: {
                    this.matchStat = 0;
                    var2_2 = 0;
                    v0 = this;
                    ++var2_2;
                    var3_3 = v0.charAt(v0.bp + 0);
                    var4_4 = var3_3 == '\"' ? 1 : 0;
                    if (var4_4 != 0) {
                        v1 = this;
                        ++var2_2;
                        var3_3 = v1.charAt(v1.bp + 1);
                    }
                    if (var5_7 = var3_3 == '-') {
                        v2 = this;
                        var3_3 = v2.charAt(v2.bp + var2_2++);
                    }
                    if (var3_3 < '0' || var3_3 > '9') break block24;
                    var6_8 = var3_3 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_3 = v3.charAt(v3.bp + var2_2++)) < '0' || var3_3 > '9') break;
                        var6_8 = var6_8 * 10L + (long)(var3_3 - 48);
                    }
                    var8_9 = 1L;
                    var10_10 = var3_3 == '.';
                    if (var10_10) {
                        v4 = this;
                        if ((var3_3 = v4.charAt(v4.bp + var2_2++)) >= '0' && var3_3 <= '9') {
                            var6_8 = var6_8 * 10L + (long)(var3_3 - 48);
                            var8_9 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_3 = v5.charAt(v5.bp + var2_2++)) >= '0' && var3_3 <= '9') {
                                    var6_8 = var6_8 * 10L + (long)(var3_3 - 48);
                                    var8_9 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    if (!(var10_10 = var3_3 == 'e' || var3_3 == 'E')) break block25;
                    v6 = this;
                    if ((var3_3 = v6.charAt(v6.bp + var2_2++)) != '+' && var3_3 != '-') ** GOTO lbl43
                    do {
                        v7 = this;
                        var3_3 = v7.charAt(v7.bp + var2_2++);
lbl43:
                        // 2 sources

                    } while (var3_3 >= '0' && var3_3 <= '9');
                }
                if (var4_4 != 0) {
                    if (var3_3 != '\"') {
                        this.matchStat = -1;
                        return 0.0f;
                    }
                    v8 = this;
                    var3_3 = v8.charAt(v8.bp + var2_2++);
                    var4_4 = this.bp + 1;
                    var11_11 = this.bp + var2_2 - var4_4 - 2;
                } else {
                    var4_4 = this.bp;
                    var11_11 = this.bp + var2_2 - var4_4 - 1;
                }
                if (!var10_10 && var11_11 < 17) {
                    var4_5 = (float)((double)var6_8 / (double)var8_9);
                    if (var5_7) {
                        var4_5 = -var4_5;
                    }
                } else {
                    var4_6 = this.subString(var4_4, var11_11);
                    var4_5 = Float.parseFloat(var4_6);
                }
                break block26;
            }
            if (var3_3 == 'n') {
                v9 = this;
                if (v9.charAt(v9.bp + var2_2) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.bp + var2_2 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.bp + var2_2 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_2 += 3;
                            v12 = this;
                            var3_3 = v12.charAt(v12.bp + var2_2++);
                            if (var4_4 != 0 && var3_3 == '\"') {
                                v13 = this;
                                var3_3 = v13.charAt(v13.bp + var2_2++);
                            }
                            while (true) {
                                if (var3_3 == ',') {
                                    this.bp += var2_2;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0.0f;
                                }
                                if (var3_3 == ']') {
                                    this.bp += var2_2;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 15;
                                    return 0.0f;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_3)) break;
                                v14 = this;
                                var3_3 = v14.charAt(v14.bp + var2_2++);
                            }
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0f;
        }
        if (var3_3 == var1_1) {
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var4_5;
        }
        this.matchStat = -1;
        return var4_5;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double scanDouble(char var1_1) {
        block26: {
            block24: {
                block25: {
                    this.matchStat = 0;
                    var2_2 = 0;
                    v0 = this;
                    ++var2_2;
                    var3_3 = v0.charAt(v0.bp + 0);
                    var4_4 = var3_3 == '\"' ? 1 : 0;
                    if (var4_4 != 0) {
                        v1 = this;
                        ++var2_2;
                        var3_3 = v1.charAt(v1.bp + 1);
                    }
                    if (var5_6 = var3_3 == '-') {
                        v2 = this;
                        var3_3 = v2.charAt(v2.bp + var2_2++);
                    }
                    if (var3_3 < '0' || var3_3 > '9') break block24;
                    var6_7 = var3_3 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_3 = v3.charAt(v3.bp + var2_2++)) < '0' || var3_3 > '9') break;
                        var6_7 = var6_7 * 10L + (long)(var3_3 - 48);
                    }
                    var8_8 = 1L;
                    var10_9 = var3_3 == '.';
                    if (var10_9) {
                        v4 = this;
                        if ((var3_3 = v4.charAt(v4.bp + var2_2++)) >= '0' && var3_3 <= '9') {
                            var6_7 = var6_7 * 10L + (long)(var3_3 - 48);
                            var8_8 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_3 = v5.charAt(v5.bp + var2_2++)) >= '0' && var3_3 <= '9') {
                                    var6_7 = var6_7 * 10L + (long)(var3_3 - 48);
                                    var8_8 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    if (!(var10_9 = var3_3 == 'e' || var3_3 == 'E')) break block25;
                    v6 = this;
                    if ((var3_3 = v6.charAt(v6.bp + var2_2++)) != '+' && var3_3 != '-') ** GOTO lbl43
                    do {
                        v7 = this;
                        var3_3 = v7.charAt(v7.bp + var2_2++);
lbl43:
                        // 2 sources

                    } while (var3_3 >= '0' && var3_3 <= '9');
                }
                if (var4_4 != 0) {
                    if (var3_3 != '\"') {
                        this.matchStat = -1;
                        return 0.0;
                    }
                    v8 = this;
                    var3_3 = v8.charAt(v8.bp + var2_2++);
                    var4_4 = this.bp + 1;
                    var11_10 = this.bp + var2_2 - var4_4 - 2;
                } else {
                    var4_4 = this.bp;
                    var11_10 = this.bp + var2_2 - var4_4 - 1;
                }
                if (!var10_9 && var11_10 < 17) {
                    var14_11 = (double)var6_7 / (double)var8_8;
                    if (var5_6) {
                        var14_11 = -var14_11;
                    }
                } else {
                    var4_5 = this.subString(var4_4, var11_10);
                    var14_11 = Double.parseDouble(var4_5);
                }
                break block26;
            }
            if (var3_3 == 'n') {
                v9 = this;
                if (v9.charAt(v9.bp + var2_2) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.bp + var2_2 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.bp + var2_2 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_2 += 3;
                            v12 = this;
                            var3_3 = v12.charAt(v12.bp + var2_2++);
                            if (var4_4 != 0 && var3_3 == '\"') {
                                v13 = this;
                                var3_3 = v13.charAt(v13.bp + var2_2++);
                            }
                            while (true) {
                                if (var3_3 == ',') {
                                    this.bp += var2_2;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0.0;
                                }
                                if (var3_3 == ']') {
                                    this.bp += var2_2;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 15;
                                    return 0.0;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_3)) break;
                                v14 = this;
                                var3_3 = v14.charAt(v14.bp + var2_2++);
                            }
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (var3_3 == var1_1) {
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var14_11;
        }
        this.matchStat = -1;
        return var14_11;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public BigDecimal scanDecimal(char var1_1) {
        block31: {
            block29: {
                block30: {
                    this.matchStat = 0;
                    var1_1 = '\u0000';
                    v0 = this;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v0.charAt(v0.bp + 0);
                    var3_3 = var2_2 == '\"' ? 1 : 0;
                    if (var3_3 != 0) {
                        v1 = this;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v1.charAt(v1.bp + 1);
                    }
                    if ((var4_5 = var2_2 == '-' ? 1 : 0) != 0) {
                        v2 = this;
                        v3 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v2.charAt(v2.bp + v3);
                    }
                    if (var2_2 < '0' || var2_2 > '9') break block29;
                    do {
                        v4 = this;
                        v5 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                    } while ((var2_2 = v4.charAt(v4.bp + v5)) >= '0' && var2_2 <= '9');
                    var4_5 = var2_2 == '.' ? 1 : 0;
                    if (var4_5 != 0) {
                        v6 = this;
                        v7 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v6.charAt(v6.bp + v7);
                        if (var2_2 >= '0' && var2_2 <= '9') {
                            while (true) {
                                v8 = this;
                                v9 = var1_1;
                                var1_1 = (char)(var1_1 + 1);
                                var2_2 = v8.charAt(v8.bp + v9);
                                if (var2_2 >= '0' && var2_2 <= '9') {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return null;
                        }
                    }
                    if ((var4_5 = var2_2 == 'e' || var2_2 == 'E' ? 1 : 0) == 0) break block30;
                    v10 = this;
                    v11 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v10.charAt(v10.bp + v11);
                    if (var2_2 != '+' && var2_2 != '-') ** GOTO lbl50
                    do {
                        v12 = this;
                        v13 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v12.charAt(v12.bp + v13);
lbl50:
                        // 2 sources

                    } while (var2_2 >= '0' && var2_2 <= '9');
                }
                if (var3_3 != 0) {
                    if (var2_2 != '\"') {
                        this.matchStat = -1;
                        return null;
                    }
                    v14 = this;
                    v15 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v14.charAt(v14.bp + v15);
                    var3_3 = this.bp + 1;
                    var4_5 = this.bp + var1_1 - var3_3 - 2;
                } else {
                    var3_3 = this.bp;
                    var4_5 = this.bp + var1_1 - var3_3 - 1;
                }
                break block31;
            }
            if (var2_2 == 'n') {
                v16 = this;
                if (v16.charAt(v16.bp + var1_1) == 'u') {
                    v17 = this;
                    if (v17.charAt(v17.bp + var1_1 + 1) == 'l') {
                        v18 = this;
                        if (v18.charAt(v18.bp + var1_1 + 2) == 'l') {
                            this.matchStat = 5;
                            var1_1 = (char)(var1_1 + 3);
                            v19 = this;
                            v20 = var1_1;
                            var1_1 = (char)(var1_1 + 1);
                            var2_2 = v19.charAt(v19.bp + v20);
                            if (var3_3 != 0 && var2_2 == '\"') {
                                v21 = this;
                                v22 = var1_1;
                                var1_1 = (char)(var1_1 + 1);
                                var2_2 = v21.charAt(v21.bp + v22);
                            }
                            while (true) {
                                if (var2_2 == ',') {
                                    this.bp += var1_1;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return null;
                                }
                                if (var2_2 == '}') {
                                    this.bp += var1_1;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 13;
                                    return null;
                                }
                                if (!JSONLexerBase.isWhitespace(var2_2)) break;
                                v23 = this;
                                v24 = var1_1;
                                var1_1 = (char)(var1_1 + 1);
                                var2_2 = v23.charAt(v23.bp + v24);
                            }
                            this.matchStat = -1;
                            return null;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        var3_4 /* !! */  = this.sub_chars(var3_3, var4_5);
        var3_4 /* !! */  = (char[])new BigDecimal(var3_4 /* !! */ );
        if (var2_2 == ',') {
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var3_4 /* !! */ ;
        }
        if (var2_2 != ']') ** GOTO lbl144
        v25 = this;
        v26 = var1_1;
        var1_1 = (char)(var1_1 + 1);
        var2_2 = v25.charAt(v25.bp + v26);
        if (var2_2 == ',') {
            this.token = 16;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == ']') {
            this.token = 15;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == '}') {
            this.token = 13;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == '\u001a') {
            this.token = 20;
            this.bp += var1_1 - '\u0001';
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl144:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4 /* !! */ ;
    }

    /*
     * Unable to fully structure code
     */
    public final float[] scanFieldFloatArray(char[] var1_1) {
        block28: {
            block26: {
                this.matchStat = 0;
                if (!this.charArrayCompare(var1_1)) {
                    this.matchStat = -2;
                    return null;
                }
                var1_2 = var1_1.length;
                v0 = this;
                if ((var2_3 = v0.charAt(v0.bp + var1_2++)) != '[') {
                    this.matchStat = -2;
                    return null;
                }
                v1 = this;
                var2_3 = v1.charAt(v1.bp + var1_2++);
                var3_4 = new float[16];
                var4_5 = 0;
                while (true) {
                    block27: {
                        var5_7 = this.bp + var1_2 - 1;
                        var6_9 = var2_3 == '-';
                        if (var6_9) {
                            v2 = this;
                            var2_3 = v2.charAt(v2.bp + var1_2++);
                        }
                        if (var2_3 < '0' || var2_3 > '9') break block26;
                        var7_12 = var2_3 - 48;
                        while (true) {
                            v3 = this;
                            if ((var2_3 = v3.charAt(v3.bp + var1_2++)) < '0' || var2_3 > '9') break;
                            var7_12 = var7_12 * 10 + (var2_3 - 48);
                        }
                        var8_13 = 1;
                        var9_14 = var2_3 == '.';
                        if (var9_14) {
                            v4 = this;
                            var2_3 = v4.charAt(v4.bp + var1_2++);
                            var8_13 = 10;
                            if (var2_3 >= '0' && var2_3 <= '9') {
                                var7_12 = var7_12 * 10 + (var2_3 - 48);
                                while (true) {
                                    v5 = this;
                                    if ((var2_3 = v5.charAt(v5.bp + var1_2++)) >= '0' && var2_3 <= '9') {
                                        var7_12 = var7_12 * 10 + (var2_3 - 48);
                                        var8_13 *= 10;
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        if (!(var9_14 = var2_3 == 'e' || var2_3 == 'E')) break block27;
                        v6 = this;
                        if ((var2_3 = v6.charAt(v6.bp + var1_2++)) != '+' && var2_3 != '-') ** GOTO lbl50
                        do {
                            v7 = this;
                            var2_3 = v7.charAt(v7.bp + var1_2++);
lbl50:
                            // 2 sources

                        } while (var2_3 >= '0' && var2_3 <= '9');
                    }
                    var10_15 = this.bp + var1_2 - var5_7 - 1;
                    if (!var9_14 && var10_15 < 10) {
                        var5_6 = (float)var7_12 / (float)var8_13;
                        if (var6_9) {
                            var5_6 = -var5_6;
                        }
                    } else {
                        var6_10 = this.subString(var5_7, var10_15);
                        var5_6 = Float.parseFloat(var6_10);
                    }
                    if (var4_5 >= var3_4.length) {
                        var6_11 = new float[var3_4.length * 3 / 2];
                        System.arraycopy(var3_4, 0, var6_11, 0, var4_5);
                        var3_4 = var6_11;
                    }
                    var3_4[var4_5++] = var5_6;
                    if (var2_3 == ',') {
                        v8 = this;
                        var2_3 = v8.charAt(v8.bp + var1_2++);
                        continue;
                    }
                    if (var2_3 == ']') break;
                }
                break block28;
            }
            this.matchStat = -1;
            return null;
        }
        v9 = this;
        var2_3 = v9.charAt(v9.bp + var1_2++);
        if (var4_5 != var3_4.length) {
            var5_8 = new float[var4_5];
            System.arraycopy(var3_4, 0, var5_8, 0, var4_5);
            var3_4 = var5_8;
        }
        if (var2_3 == ',') {
            this.bp += var1_2 - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return var3_4;
        }
        if (var2_3 != '}') ** GOTO lbl116
        v10 = this;
        if ((var2_3 = v10.charAt(v10.bp + var1_2++)) == ',') {
            this.token = 16;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == ']') {
            this.token = 15;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == '}') {
            this.token = 13;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == '\u001a') {
            this.bp += var1_2 - 1;
            this.token = 20;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl116:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final float[][] scanFieldFloatArray2(char[] var1_1) {
        this.matchStat = 0;
        if (!this.charArrayCompare(var1_1)) {
            this.matchStat = -2;
            return null;
        }
        var1_2 = var1_1.length;
        v0 = this;
        if ((var2_3 = v0.charAt(v0.bp + var1_2++)) != '[') {
            this.matchStat = -2;
            return null;
        }
        v1 = this;
        v1.charAt(v1.bp + var1_2++);
        var3_4 /* !! */  = new float[16][];
        var4_5 = 0;
        while (true) {
            block32: {
                block30: {
                    v2 = this;
                    var2_3 = v2.charAt(v2.bp + var1_2++);
                    var5_6 /* !! */  = new float[16];
                    var6_7 = 0;
                    while (true) {
                        block31: {
                            var7_8 = this.bp + var1_2 - 1;
                            var8_12 = var2_3 == '-';
                            if (var8_12) {
                                v3 = this;
                                var2_3 = v3.charAt(v3.bp + var1_2++);
                            }
                            if (var2_3 < '0' || var2_3 > '9') break block30;
                            var9_15 = var2_3 - 48;
                            while (true) {
                                v4 = this;
                                if ((var2_3 = v4.charAt(v4.bp + var1_2++)) < '0' || var2_3 > '9') break;
                                var9_15 = var9_15 * 10 + (var2_3 - 48);
                            }
                            var10_16 = 1;
                            if (var2_3 == '.') {
                                v5 = this;
                                if ((var2_3 = v5.charAt(v5.bp + var1_2++)) >= '0' && var2_3 <= '9') {
                                    var9_15 = var9_15 * 10 + (var2_3 - 48);
                                    var10_16 = 10;
                                    while (true) {
                                        v6 = this;
                                        if ((var2_3 = v6.charAt(v6.bp + var1_2++)) >= '0' && var2_3 <= '9') {
                                            var9_15 = var9_15 * 10 + (var2_3 - 48);
                                            var10_16 *= 10;
                                            continue;
                                        }
                                        break;
                                    }
                                } else {
                                    this.matchStat = -1;
                                    return null;
                                }
                            }
                            if (!(var11_17 = var2_3 == 'e' || var2_3 == 'E')) break block31;
                            v7 = this;
                            if ((var2_3 = v7.charAt(v7.bp + var1_2++)) != '+' && var2_3 != '-') ** GOTO lbl54
                            do {
                                v8 = this;
                                var2_3 = v8.charAt(v8.bp + var1_2++);
lbl54:
                                // 2 sources

                            } while (var2_3 >= '0' && var2_3 <= '9');
                        }
                        var12_18 = this.bp + var1_2 - var7_8 - 1;
                        if (!var11_17 && var12_18 < 10) {
                            var7_9 = (float)var9_15 / (float)var10_16;
                            if (var8_12) {
                                var7_9 = -var7_9;
                            }
                        } else {
                            var8_13 = this.subString(var7_8, var12_18);
                            var7_9 = Float.parseFloat(var8_13);
                        }
                        if (var6_7 >= var5_6 /* !! */ .length) {
                            var8_14 = new float[var5_6 /* !! */ .length * 3 / 2];
                            System.arraycopy(var5_6 /* !! */ , 0, var8_14, 0, var6_7);
                            var5_6 /* !! */  = var8_14;
                        }
                        var5_6 /* !! */ [var6_7++] = var7_9;
                        if (var2_3 == ',') {
                            v9 = this;
                            var2_3 = v9.charAt(v9.bp + var1_2++);
                            continue;
                        }
                        if (var2_3 == ']') break;
                    }
                    break block32;
                }
                this.matchStat = -1;
                return null;
            }
            v10 = this;
            var2_3 = v10.charAt(v10.bp + var1_2++);
            if (var6_7 != var5_6 /* !! */ .length) {
                var7_10 = new float[var6_7];
                System.arraycopy(var5_6 /* !! */ , 0, var7_10, 0, var6_7);
                var5_6 /* !! */  = var7_10;
            }
            if (var4_5 >= var3_4 /* !! */ .length) {
                var7_11 = new float[var3_4 /* !! */ .length * 3 / 2][];
                System.arraycopy(var5_6 /* !! */ , 0, var7_11, 0, var6_7);
                var3_4 /* !! */  = var7_11;
            }
            var3_4 /* !! */ [var4_5++] = var5_6 /* !! */ ;
            if (var2_3 == ',') {
                v11 = this;
                v11.charAt(v11.bp + var1_2++);
                continue;
            }
            if (var2_3 == ']') break;
        }
        v12 = this;
        var2_3 = v12.charAt(v12.bp + var1_2++);
        if (var4_5 != var3_4 /* !! */ .length) {
            var5_6 /* !! */  = (float[])new float[var4_5][];
            System.arraycopy(var3_4 /* !! */ , 0, var5_6 /* !! */ , 0, var4_5);
            var3_4 /* !! */  = (float[][])var5_6 /* !! */ ;
        }
        if (var2_3 == ',') {
            this.bp += var1_2 - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return var3_4 /* !! */ ;
        }
        if (var2_3 != '}') ** GOTO lbl138
        v13 = this;
        if ((var2_3 = v13.charAt(v13.bp + var1_2++)) == ',') {
            this.token = 16;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == ']') {
            this.token = 15;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == '}') {
            this.token = 13;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == '\u001a') {
            this.bp += var1_2 - 1;
            this.token = 20;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl138:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4 /* !! */ ;
    }

    /*
     * Unable to fully structure code
     */
    public final double scanFieldDouble(char[] var1_1) {
        block35: {
            block33: {
                block34: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(var1_1)) {
                        this.matchStat = -2;
                        return 0.0;
                    }
                    var2_4 = var1_1.length;
                    v0 = this;
                    if ((var4_6 = (var3_5 = v0.charAt(v0.bp + var2_4++)) == '\"' ? 1 : 0) != 0) {
                        v1 = this;
                        var3_5 = v1.charAt(v1.bp + var2_4++);
                    }
                    if (var5_7 = var3_5 == '-') {
                        v2 = this;
                        var3_5 = v2.charAt(v2.bp + var2_4++);
                    }
                    if (var3_5 < '0' || var3_5 > '9') break block33;
                    var6_8 = var3_5 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_5 = v3.charAt(v3.bp + var2_4++)) < '0' || var3_5 > '9') break;
                        var6_8 = var6_8 * 10L + (long)(var3_5 - 48);
                    }
                    var8_9 = 1L;
                    var10_10 = var3_5 == '.';
                    if (var10_10) {
                        v4 = this;
                        if ((var3_5 = v4.charAt(v4.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                            var6_8 = var6_8 * 10L + (long)(var3_5 - 48);
                            var8_9 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_5 = v5.charAt(v5.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                                    var6_8 = var6_8 * 10L + (long)(var3_5 - 48);
                                    var8_9 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    if (!(var10_10 = var3_5 == 'e' || var3_5 == 'E')) break block34;
                    v6 = this;
                    if ((var3_5 = v6.charAt(v6.bp + var2_4++)) != '+' && var3_5 != '-') ** GOTO lbl42
                    do {
                        v7 = this;
                        var3_5 = v7.charAt(v7.bp + var2_4++);
lbl42:
                        // 2 sources

                    } while (var3_5 >= '0' && var3_5 <= '9');
                }
                if (var4_6 != 0) {
                    if (var3_5 != '\"') {
                        this.matchStat = -1;
                        return 0.0;
                    }
                    v8 = this;
                    var3_5 = v8.charAt(v8.bp + var2_4++);
                    var1_2 = this.bp + var1_1.length + 1;
                    var4_6 = this.bp + var2_4 - var1_2 - 2;
                } else {
                    var1_2 = this.bp + var1_1.length;
                    var4_6 = this.bp + var2_4 - var1_2 - 1;
                }
                if (!var10_10 && var4_6 < 17) {
                    var14_11 = (double)var6_8 / (double)var8_9;
                    if (var5_7) {
                        var14_11 = -var14_11;
                    }
                } else {
                    var1_3 = this.subString(var1_2, var4_6);
                    var14_11 = Double.parseDouble(var1_3);
                }
                break block35;
            }
            if (var3_5 == 'n') {
                v9 = this;
                if (v9.charAt(v9.bp + var2_4) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.bp + var2_4 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.bp + var2_4 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_4 += 3;
                            v12 = this;
                            var3_5 = v12.charAt(v12.bp + var2_4++);
                            if (var4_6 != 0 && var3_5 == '\"') {
                                v13 = this;
                                var3_5 = v13.charAt(v13.bp + var2_4++);
                            }
                            while (true) {
                                if (var3_5 == ',') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0.0;
                                }
                                if (var3_5 == '}') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 13;
                                    return 0.0;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_5)) break;
                                v14 = this;
                                var3_5 = v14.charAt(v14.bp + var2_4++);
                            }
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (var3_5 == ',') {
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var14_11;
        }
        if (var3_5 != '}') ** GOTO lbl130
        v15 = this;
        if ((var3_5 = v15.charAt(v15.bp + var2_4++)) == ',') {
            this.token = 16;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == ']') {
            this.token = 15;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '}') {
            this.token = 13;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '\u001a') {
            this.token = 20;
            this.bp += var2_4 - 1;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return 0.0;
lbl130:
            // 1 sources

            this.matchStat = -1;
            return 0.0;
        }
        this.matchStat = 4;
        return var14_11;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BigDecimal scanFieldDecimal(char[] var1_1) {
        block32: {
            block30: {
                block31: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(var1_1)) {
                        this.matchStat = -2;
                        return null;
                    }
                    var2_4 = var1_1.length;
                    v0 = this;
                    if ((var4_6 = (var3_5 = v0.charAt(v0.bp + var2_4++)) == '\"' ? 1 : 0) != 0) {
                        v1 = this;
                        var3_5 = v1.charAt(v1.bp + var2_4++);
                    }
                    if (var5_7 = var3_5 == '-') {
                        v2 = this;
                        var3_5 = v2.charAt(v2.bp + var2_4++);
                    }
                    if (var3_5 < '0' || var3_5 > '9') break block30;
                    do {
                        v3 = this;
                    } while ((var3_5 = v3.charAt(v3.bp + var2_4++)) >= '0' && var3_5 <= '9');
                    var5_7 = var3_5 == '.';
                    if (var5_7) {
                        v4 = this;
                        if ((var3_5 = v4.charAt(v4.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                            while (true) {
                                v5 = this;
                                if ((var3_5 = v5.charAt(v5.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return null;
                        }
                    }
                    if (!(var5_7 = var3_5 == 'e' || var3_5 == 'E')) break block31;
                    v6 = this;
                    if ((var3_5 = v6.charAt(v6.bp + var2_4++)) != '+' && var3_5 != '-') ** GOTO lbl34
                    do {
                        v7 = this;
                        var3_5 = v7.charAt(v7.bp + var2_4++);
lbl34:
                        // 2 sources

                    } while (var3_5 >= '0' && var3_5 <= '9');
                }
                if (var4_6 != 0) {
                    if (var3_5 != '\"') {
                        this.matchStat = -1;
                        return null;
                    }
                    v8 = this;
                    var3_5 = v8.charAt(v8.bp + var2_4++);
                    var1_2 = this.bp + var1_1.length + 1;
                    var4_6 = this.bp + var2_4 - var1_2 - 2;
                } else {
                    var1_2 = this.bp + var1_1.length;
                    var4_6 = this.bp + var2_4 - var1_2 - 1;
                }
                break block32;
            }
            if (var3_5 == 'n') {
                v9 = this;
                if (v9.charAt(v9.bp + var2_4) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.bp + var2_4 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.bp + var2_4 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_4 += 3;
                            v12 = this;
                            var3_5 = v12.charAt(v12.bp + var2_4++);
                            if (var4_6 != 0 && var3_5 == '\"') {
                                v13 = this;
                                var3_5 = v13.charAt(v13.bp + var2_4++);
                            }
                            while (true) {
                                if (var3_5 == ',') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return null;
                                }
                                if (var3_5 == '}') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 13;
                                    return null;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_5)) break;
                                v14 = this;
                                var3_5 = v14.charAt(v14.bp + var2_4++);
                            }
                            this.matchStat = -1;
                            return null;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        var1_3 /* !! */  = this.sub_chars(var1_2, var4_6);
        var1_3 /* !! */  = (char[])new BigDecimal(var1_3 /* !! */ );
        if (var3_5 == ',') {
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var1_3 /* !! */ ;
        }
        if (var3_5 != '}') ** GOTO lbl117
        v15 = this;
        if ((var3_5 = v15.charAt(v15.bp + var2_4++)) == ',') {
            this.token = 16;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == ']') {
            this.token = 15;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '}') {
            this.token = 13;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '\u001a') {
            this.token = 20;
            this.bp += var2_4 - 1;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl117:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var1_3 /* !! */ ;
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger scanFieldBigInteger(char[] var1_1) {
        this.matchStat = 0;
        if (!this.charArrayCompare(var1_1)) {
            this.matchStat = -2;
            return null;
        }
        var2_4 = var1_1.length;
        v0 = this;
        if ((var4_6 = (var3_5 = v0.charAt(v0.bp + var2_4++)) == '\"' ? 1 : 0) != 0) {
            v1 = this;
            var3_5 = v1.charAt(v1.bp + var2_4++);
        }
        if (var5_7 = var3_5 == '-') {
            v2 = this;
            var3_5 = v2.charAt(v2.bp + var2_4++);
        }
        if (var3_5 >= '0' && var3_5 <= '9') {
            var6_8 = var3_5 - 48;
            while (true) {
                v3 = this;
                if ((var3_5 = v3.charAt(v3.bp + var2_4++)) < '0' || var3_5 > '9') break;
                var6_8 = var6_8 * 10L + (long)(var3_5 - 48);
            }
            if (var4_6 != 0) {
                if (var3_5 != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                v4 = this;
                var3_5 = v4.charAt(v4.bp + var2_4++);
                var1_2 = this.bp + var1_1.length + 1;
                var4_6 = this.bp + var2_4 - var1_2 - 2;
            } else {
                var1_2 = this.bp + var1_1.length;
                var4_6 = this.bp + var2_4 - var1_2 - 1;
            }
            if (var4_6 < 20 || var5_7 && var4_6 < 21) {
                var1_3 = BigInteger.valueOf(var5_7 != false ? -var6_8 : var6_8);
            } else {
                var1_3 = this.subString(var1_2, var4_6);
                var1_3 = new BigInteger((String)var1_3);
            }
        } else {
            if (var3_5 == 'n') {
                v5 = this;
                if (v5.charAt(v5.bp + var2_4) == 'u') {
                    v6 = this;
                    if (v6.charAt(v6.bp + var2_4 + 1) == 'l') {
                        v7 = this;
                        if (v7.charAt(v7.bp + var2_4 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_4 += 3;
                            v8 = this;
                            var3_5 = v8.charAt(v8.bp + var2_4++);
                            if (var4_6 != 0 && var3_5 == '\"') {
                                v9 = this;
                                var3_5 = v9.charAt(v9.bp + var2_4++);
                            }
                            while (true) {
                                if (var3_5 == ',') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return null;
                                }
                                if (var3_5 == '}') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 13;
                                    return null;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_5)) break;
                                v10 = this;
                                var3_5 = v10.charAt(v10.bp + var2_4++);
                            }
                            this.matchStat = -1;
                            return null;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        if (var3_5 == ',') {
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var1_3;
        }
        if (var3_5 != '}') ** GOTO lbl102
        v11 = this;
        if ((var3_5 = v11.charAt(v11.bp + var2_4++)) == ',') {
            this.token = 16;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == ']') {
            this.token = 15;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '}') {
            this.token = 13;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '\u001a') {
            this.token = 20;
            this.bp += var2_4 - 1;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl102:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var1_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date scanFieldDate(char[] object) {
        void var1_5;
        int n2;
        int n3;
        block24: {
            Object object2;
            block26: {
                int n4;
                block27: {
                    block25: {
                        this.matchStat = 0;
                        if (!this.charArrayCompare((char[])object)) {
                            this.matchStat = -2;
                            return null;
                        }
                        n3 = ((char[])object).length;
                        JSONLexerBase jSONLexerBase = this;
                        if ((n2 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++)) != 34) break block25;
                        n2 = this.bp + ((char[])object).length + 1;
                        if ((n2 = this.indexOf('\"', n2)) == -1) {
                            throw new JSONException("unclosed str");
                        }
                        int n5 = this.bp + ((char[])object).length + 1;
                        object2 = this.subString(n5, n2 - n5);
                        if (((String)object2).indexOf(92) == -1) break block26;
                        break block27;
                    }
                    if (n2 == 45 || n2 >= 48 && n2 <= 57) {
                        long l2 = 0L;
                        boolean bl = false;
                        if (n2 == 45) {
                            JSONLexerBase jSONLexerBase = this;
                            n2 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++);
                            bl = true;
                        }
                        if (n2 >= 48 && n2 <= 57) {
                            l2 = n2 - 48;
                            while (true) {
                                JSONLexerBase jSONLexerBase = this;
                                char c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++);
                                n2 = c2;
                                if (c2 < '0' || n2 > 57) break;
                                l2 = l2 * 10L + (long)(n2 - 48);
                            }
                        }
                        if (l2 < 0L) {
                            this.matchStat = -1;
                            return null;
                        }
                        if (bl) {
                            l2 = -l2;
                        }
                        Date date = new Date(l2);
                        break block24;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                while (true) {
                    n4 = 0;
                    for (int i2 = n2 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n4, --i2) {
                    }
                    if (n4 % 2 == 0) break;
                    n2 = this.indexOf('\"', n2 + 1);
                }
                n4 = n2 - (this.bp + ((char[])object).length + 1);
                JSONLexerBase jSONLexerBase = this;
                char[] cArray = jSONLexerBase.sub_chars(jSONLexerBase.bp + ((char[])object).length + 1, n4);
                object2 = JSONLexerBase.readString(cArray, n4);
            }
            n3 += n2 - (this.bp + ((char[])object).length + 1) + 1;
            JSONLexerBase jSONLexerBase = this;
            n2 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++);
            object2 = new JSONScanner((String)object2);
            try {
                if (!((JSONScanner)object2).scanISO8601DateIfMatch(false)) {
                    this.matchStat = -1;
                    return null;
                }
                Calendar calendar = ((JSONLexerBase)object2).getCalendar();
                Date date = calendar.getTime();
            }
            finally {
                ((JSONLexerBase)object2).close();
            }
        }
        if (n2 == 44) {
            this.bp += n3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return var1_5;
        }
        if (n2 != 125) {
            this.matchStat = -1;
            return null;
        }
        JSONLexerBase jSONLexerBase = this;
        char c3 = jSONLexerBase.charAt(jSONLexerBase.bp + n3++);
        n2 = c3;
        if (c3 == ',') {
            this.token = 16;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (n2 == 93) {
            this.token = 15;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else if (n2 == 125) {
            this.token = 13;
            this.bp += n3;
            this.ch = this.charAt(this.bp);
        } else {
            if (n2 != 26) {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += n3 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return var1_5;
    }

    /*
     * Unable to fully structure code
     */
    public Date scanDate(char var1_1) {
        block25: {
            block26: {
                this.matchStat = 0;
                var1_1 = '\u0000';
                v0 = this;
                var1_1 = (char)(var1_1 + 1);
                var2_3 = v0.charAt(v0.bp + 0);
                if (var2_3 == '\"') {
                    var1_1 = (char)(this.bp + 1);
                    v1 = this.indexOf('\"', var1_1);
                    var1_1 = (char)v1;
                    if (v1 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    var3_4 = this.bp + 1;
                    var3_5 = this.subString(var3_4, var1_1 - var3_4);
                    if (var3_5.indexOf(92) != -1) {
                        while (true) {
                            var3_6 = 0;
                            for (var4_8 = var1_1 - '\u0001'; var4_8 >= 0 && this.charAt(var4_8) == '\\'; --var4_8) {
                                ++var3_6;
                            }
                            if (var3_6 % 2 == 0) break;
                            var1_1 = (char)this.indexOf('\"', var1_1 + '\u0001');
                        }
                        var3_6 = var1_1 - (this.bp + 1);
                        v2 = this;
                        v3 = v2.sub_chars(v2.bp + 1, var3_6);
                        var4_9 = v3;
                        var3_5 = JSONLexerBase.readString(v3, var3_6);
                    }
                    var1_1 = (char)(1 + (var1_1 - (this.bp + 1) + 1));
                    v4 = this;
                    v5 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_3 = v4.charAt(v4.bp + v5);
                    var3_5 = new JSONScanner((String)var3_5);
                    try {
                        if (var3_5.scanISO8601DateIfMatch(false)) {
                            var4_9 = var3_5.getCalendar();
                            var4_9 = var4_9.getTime();
                            break block25;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    finally {
                        var3_5.close();
                    }
                }
                if (var2_3 != '-' && (var2_3 < '0' || var2_3 > '9')) break block26;
                var12_10 = 0L;
                var3_7 = false;
                if (var2_3 == '-') {
                    v6 = this;
                    var1_1 = (char)(var1_1 + 1);
                    var2_3 = v6.charAt(v6.bp + 1);
                    var3_7 = true;
                }
                if (var2_3 >= '0' && var2_3 <= '9') {
                    var12_10 = var2_3 - 48;
                    while (true) {
                        v7 = this;
                        v8 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_3 = v7.charAt(v7.bp + v8);
                        if (var2_3 < '0' || var2_3 > '9') break;
                        var12_10 = var12_10 * 10L + (long)(var2_3 - 48);
                    }
                }
                if (var12_10 < 0L) {
                    this.matchStat = -1;
                    return null;
                }
                if (var3_7) {
                    var12_10 = -var12_10;
                }
                var4_9 = new Date(var12_10);
                break block25;
            }
            if (var2_3 != 'n') ** GOTO lbl-1000
            v9 = this;
            if (v9.charAt(v9.bp + 1) != 'u') ** GOTO lbl-1000
            v10 = this;
            if (v10.charAt(v10.bp + 1 + 1) != 'l') ** GOTO lbl-1000
            v11 = this;
            if (v11.charAt(v11.bp + 1 + 2) == 'l') {
                this.matchStat = 5;
                var4_9 = null;
                var1_1 = (char)(var1_1 + 3);
                v12 = this;
                var1_1 = (char)(var1_1 + 1);
                var2_3 = v12.charAt(v12.bp + 4);
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return null;
            }
        }
        if (var2_3 == ',') {
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var4_9;
        }
        if (var2_3 != ']') ** GOTO lbl120
        v13 = this;
        v14 = var1_1;
        var1_1 = (char)(var1_1 + 1);
        var2_3 = v13.charAt(v13.bp + v14);
        if (var2_3 == ',') {
            this.token = 16;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_3 == ']') {
            this.token = 15;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_3 == '}') {
            this.token = 13;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_3 == '\u001a') {
            this.token = 20;
            this.bp += var1_1 - '\u0001';
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl120:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var4_9;
    }

    /*
     * Unable to fully structure code
     */
    public UUID scanFieldUUID(char[] var1_1) {
        block64: {
            block62: {
                block65: {
                    block63: {
                        this.matchStat = 0;
                        if (!this.charArrayCompare(var1_1)) {
                            this.matchStat = -2;
                            return null;
                        }
                        var2_2 = var1_1.length;
                        v0 = this;
                        if ((var3_3 = v0.charAt(v0.bp + var2_2++)) != 34) break block62;
                        var3_3 = this.bp + var1_1.length + 1;
                        if ((var3_3 = this.indexOf('\"', var3_3)) == -1) {
                            throw new JSONException("unclosed str");
                        }
                        var4_4 = this.bp + var1_1.length + 1;
                        var5_6 = var3_3 - var4_4;
                        if (var5_6 != 36) break block63;
                        var8_7 = 0L;
                        var10_9 = 0L;
                        for (var5_6 = 0; var5_6 < 8; ++var5_6) {
                            var6_11 = this.charAt(var4_4 + var5_6);
                            if (var6_11 >= 48 && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var8_7 <<= 4;
                            var8_7 |= (long)var6_11;
                        }
                        for (var5_6 = 9; var5_6 < 13; ++var5_6) {
                            var6_11 = this.charAt(var4_4 + var5_6);
                            if (var6_11 >= 48 && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var8_7 <<= 4;
                            var8_7 |= (long)var6_11;
                        }
                        for (var5_6 = 14; var5_6 < 18; ++var5_6) {
                            v1 = this.charAt(var4_4 + var5_6);
                            var6_11 = v1;
                            if (v1 >= '0' && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var8_7 <<= 4;
                            var8_7 |= (long)var6_11;
                        }
                        for (var5_6 = 19; var5_6 < 23; ++var5_6) {
                            v2 = this.charAt(var4_4 + var5_6);
                            var6_11 = v2;
                            if (v2 >= '0' && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var10_9 <<= 4;
                            var10_9 |= (long)var6_11;
                        }
                        for (var5_6 = 24; var5_6 < 36; ++var5_6) {
                            v3 = this.charAt(var4_4 + var5_6);
                            var6_11 = v3;
                            if (v3 >= '0' && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var10_9 <<= 4;
                            var10_9 |= (long)var6_11;
                        }
                        var4_5 = new UUID(var8_7, var10_9);
                        var2_2 += var3_3 - (this.bp + var1_1.length + 1) + 1;
                        v4 = this;
                        var3_3 = v4.charAt(v4.bp + var2_2++);
                        break block64;
                    }
                    if (var5_6 != 32) break block65;
                    var8_8 = 0L;
                    var10_10 = 0L;
                    for (var5_6 = 0; var5_6 < 16; ++var5_6) {
                        var6_12 = this.charAt(var4_4 + var5_6);
                        if (var6_12 >= 48 && var6_12 <= 57) {
                            var6_12 -= 48;
                        } else if (var6_12 >= 97 && var6_12 <= 102) {
                            var6_12 = 10 + (var6_12 - 97);
                        } else if (var6_12 >= 65 && var6_12 <= 70) {
                            var6_12 = 10 + (var6_12 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var8_8 <<= 4;
                        var8_8 |= (long)var6_12;
                    }
                    for (var5_6 = 16; var5_6 < 32; ++var5_6) {
                        var6_12 = this.charAt(var4_4 + var5_6);
                        if (var6_12 >= 48 && var6_12 <= 57) {
                            var6_12 -= 48;
                        } else if (var6_12 >= 97 && var6_12 <= 102) {
                            var6_12 = 10 + (var6_12 - 97);
                        } else if (var6_12 >= 65 && var6_12 <= 70) {
                            var6_12 = 10 + (var6_12 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var10_10 <<= 4;
                        var10_10 |= (long)var6_12;
                    }
                    var4_5 = new UUID(var8_8, var10_10);
                    var2_2 += var3_3 - (this.bp + var1_1.length + 1) + 1;
                    v5 = this;
                    var3_3 = v5.charAt(v5.bp + var2_2++);
                    break block64;
                }
                this.matchStat = -1;
                return null;
            }
            if (var3_3 != 110) ** GOTO lbl-1000
            v6 = this;
            if (v6.charAt(v6.bp + var2_2++) != 'u') ** GOTO lbl-1000
            v7 = this;
            if (v7.charAt(v7.bp + var2_2++) != 'l') ** GOTO lbl-1000
            v8 = this;
            if (v8.charAt(v8.bp + var2_2++) == 'l') {
                var4_5 = null;
                v9 = this;
                var3_3 = v9.charAt(v9.bp + var2_2++);
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return null;
            }
        }
        if (var3_3 == 44) {
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return var4_5;
        }
        if (var3_3 != 125) ** GOTO lbl194
        v10 = this;
        v11 = v10.charAt(v10.bp + var2_2++);
        var3_3 = v11;
        if (v11 == ',') {
            this.token = 16;
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
        } else if (var3_3 == 93) {
            this.token = 15;
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
        } else if (var3_3 == 125) {
            this.token = 13;
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
        } else if (var3_3 == 26) {
            this.token = 20;
            this.bp += var2_2 - 1;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl194:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var4_5;
    }

    /*
     * Unable to fully structure code
     */
    public UUID scanUUID(char var1_1) {
        block63: {
            block61: {
                block64: {
                    block62: {
                        this.matchStat = 0;
                        var1_1 = '\u0000';
                        v0 = this;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v0.charAt(v0.bp + 0);
                        if (var2_2 != 34) break block61;
                        var1_1 = (char)(this.bp + 1);
                        v1 = this.indexOf('\"', var1_1);
                        var1_1 = (char)v1;
                        if (v1 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        var2_2 = this.bp + 1;
                        var3_3 = var1_1 - var2_2;
                        if (var3_3 != 36) break block62;
                        var8_5 = 0L;
                        var10_7 = 0L;
                        for (var3_3 = 0; var3_3 < 8; ++var3_3) {
                            var4_9 = this.charAt(var2_2 + var3_3);
                            if (var4_9 >= 48 && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var8_5 <<= 4;
                            var8_5 |= (long)var4_9;
                        }
                        for (var3_3 = 9; var3_3 < 13; ++var3_3) {
                            var4_9 = this.charAt(var2_2 + var3_3);
                            if (var4_9 >= 48 && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var8_5 <<= 4;
                            var8_5 |= (long)var4_9;
                        }
                        for (var3_3 = 14; var3_3 < 18; ++var3_3) {
                            v2 = this.charAt(var2_2 + var3_3);
                            var4_9 = v2;
                            if (v2 >= '0' && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var8_5 <<= 4;
                            var8_5 |= (long)var4_9;
                        }
                        for (var3_3 = 19; var3_3 < 23; ++var3_3) {
                            v3 = this.charAt(var2_2 + var3_3);
                            var4_9 = v3;
                            if (v3 >= '0' && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var10_7 <<= 4;
                            var10_7 |= (long)var4_9;
                        }
                        for (var3_3 = 24; var3_3 < 36; ++var3_3) {
                            v4 = this.charAt(var2_2 + var3_3);
                            var4_9 = v4;
                            if (v4 >= '0' && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var10_7 <<= 4;
                            var10_7 |= (long)var4_9;
                        }
                        var3_4 = new UUID(var8_5, var10_7);
                        var1_1 = (char)(1 + (var1_1 - (this.bp + 1) + 1));
                        v5 = this;
                        v6 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v5.charAt(v5.bp + v6);
                        break block63;
                    }
                    if (var3_3 != 32) break block64;
                    var8_6 = 0L;
                    var10_8 = 0L;
                    for (var3_3 = 0; var3_3 < 16; ++var3_3) {
                        var4_10 = this.charAt(var2_2 + var3_3);
                        if (var4_10 >= 48 && var4_10 <= 57) {
                            var4_10 -= 48;
                        } else if (var4_10 >= 97 && var4_10 <= 102) {
                            var4_10 = 10 + (var4_10 - 97);
                        } else if (var4_10 >= 65 && var4_10 <= 70) {
                            var4_10 = 10 + (var4_10 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var8_6 <<= 4;
                        var8_6 |= (long)var4_10;
                    }
                    for (var3_3 = 16; var3_3 < 32; ++var3_3) {
                        var4_10 = this.charAt(var2_2 + var3_3);
                        if (var4_10 >= 48 && var4_10 <= 57) {
                            var4_10 -= 48;
                        } else if (var4_10 >= 97 && var4_10 <= 102) {
                            var4_10 = 10 + (var4_10 - 97);
                        } else if (var4_10 >= 65 && var4_10 <= 70) {
                            var4_10 = 10 + (var4_10 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var10_8 <<= 4;
                        var10_8 |= (long)var4_10;
                    }
                    var3_4 = new UUID(var8_6, var10_8);
                    var1_1 = (char)(1 + (var1_1 - (this.bp + 1) + 1));
                    v7 = this;
                    v8 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v7.charAt(v7.bp + v8);
                    break block63;
                }
                this.matchStat = -1;
                return null;
            }
            if (var2_2 != 110) ** GOTO lbl-1000
            v9 = this;
            var1_1 = (char)(var1_1 + 1);
            if (v9.charAt(v9.bp + 1) != 'u') ** GOTO lbl-1000
            v10 = this;
            var1_1 = (char)(var1_1 + 1);
            if (v10.charAt(v10.bp + 2) != 'l') ** GOTO lbl-1000
            v11 = this;
            var1_1 = (char)(var1_1 + 1);
            if (v11.charAt(v11.bp + 3) == 'l') {
                var3_4 = null;
                v12 = this;
                var1_1 = (char)(var1_1 + 1);
                var2_2 = v12.charAt(v12.bp + 4);
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return null;
            }
        }
        if (var2_2 == 44) {
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return var3_4;
        }
        if (var2_2 != 93) ** GOTO lbl205
        v13 = this;
        v14 = var1_1;
        var1_1 = (char)(var1_1 + 1);
        v15 = v13.charAt(v13.bp + v14);
        var2_2 = v15;
        if (v15 == ',') {
            this.token = 16;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == 93) {
            this.token = 15;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == 125) {
            this.token = 13;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == 26) {
            this.token = 20;
            this.bp += var1_1 - '\u0001';
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl205:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4;
    }

    public final void scanTrue() {
        if (this.ch != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'r') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'u') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b' || this.ch == ':' || this.ch == '/') {
            this.token = 6;
            return;
        }
        throw new JSONException("scan true error");
    }

    public final void scanNullOrNew() {
        if (this.ch != 'n') {
            throw new JSONException("error parse null or new");
        }
        this.next();
        if (this.ch == 'u') {
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b') {
                this.token = 8;
                return;
            }
            throw new JSONException("scan null error");
        }
        if (this.ch != 'e') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.ch != 'w') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b') {
            this.token = 9;
            return;
        }
        throw new JSONException("scan new error");
    }

    public final void scanFalse() {
        if (this.ch != 'f') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'a') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'l') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 's') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b' || this.ch == ':' || this.ch == '/') {
            this.token = 7;
            return;
        }
        throw new JSONException("scan false error");
    }

    public final void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.next();
        } while (Character.isLetterOrDigit(this.ch));
        String string = this.stringVal();
        if ("null".equalsIgnoreCase(string)) {
            this.token = 8;
            return;
        }
        if ("new".equals(string)) {
            this.token = 9;
            return;
        }
        if ("true".equals(string)) {
            this.token = 6;
            return;
        }
        if ("false".equals(string)) {
            this.token = 7;
            return;
        }
        if ("undefined".equals(string)) {
            this.token = 23;
            return;
        }
        if ("Set".equals(string)) {
            this.token = 21;
            return;
        }
        if ("TreeSet".equals(string)) {
            this.token = 22;
            return;
        }
        this.token = 18;
    }

    @Override
    public abstract String stringVal();

    public abstract String subString(int var1, int var2);

    protected abstract char[] sub_chars(int var1, int var2);

    public static String readString(char[] cArray, int n2) {
        char[] cArray2 = new char[n2];
        int n3 = 0;
        block22: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 != '\\') {
                cArray2[n3++] = c2;
                continue;
            }
            c2 = cArray[++i2];
            switch (c2) {
                case '0': {
                    cArray2[n3++] = '\u0000';
                    continue block22;
                }
                case '1': {
                    cArray2[n3++] = '\u0001';
                    continue block22;
                }
                case '2': {
                    cArray2[n3++] = 2;
                    continue block22;
                }
                case '3': {
                    cArray2[n3++] = 3;
                    continue block22;
                }
                case '4': {
                    cArray2[n3++] = 4;
                    continue block22;
                }
                case '5': {
                    cArray2[n3++] = 5;
                    continue block22;
                }
                case '6': {
                    cArray2[n3++] = 6;
                    continue block22;
                }
                case '7': {
                    cArray2[n3++] = 7;
                    continue block22;
                }
                case 'b': {
                    cArray2[n3++] = 8;
                    continue block22;
                }
                case 't': {
                    cArray2[n3++] = 9;
                    continue block22;
                }
                case 'n': {
                    cArray2[n3++] = 10;
                    continue block22;
                }
                case 'v': {
                    cArray2[n3++] = 11;
                    continue block22;
                }
                case 'F': 
                case 'f': {
                    cArray2[n3++] = 12;
                    continue block22;
                }
                case 'r': {
                    cArray2[n3++] = 13;
                    continue block22;
                }
                case '\"': {
                    cArray2[n3++] = 34;
                    continue block22;
                }
                case '\'': {
                    cArray2[n3++] = 39;
                    continue block22;
                }
                case '/': {
                    cArray2[n3++] = 47;
                    continue block22;
                }
                case '\\': {
                    cArray2[n3++] = 92;
                    continue block22;
                }
                case 'x': {
                    cArray2[n3++] = (char)((digits[cArray[++i2]] << 4) + digits[cArray[++i2]]);
                    continue block22;
                }
                case 'u': {
                    cArray2[n3++] = (char)Integer.parseInt(new String(new char[]{cArray[++i2], cArray[++i2], cArray[++i2], cArray[++i2]}), 16);
                    continue block22;
                }
                default: {
                    throw new JSONException("unclosed.str.lit");
                }
            }
        }
        return new String(cArray2, 0, n3);
    }

    protected abstract boolean charArrayCompare(char[] var1);

    @Override
    public boolean isBlankInput() {
        int n2 = 0;
        while (true) {
            char c2;
            if ((c2 = this.charAt(n2)) == '\u001a') break;
            if (!JSONLexerBase.isWhitespace(c2)) {
                return false;
            }
            ++n2;
        }
        this.token = 20;
        return true;
    }

    @Override
    public final void skipWhitespace() {
        while (this.ch <= '/') {
            if (this.ch == ' ' || this.ch == '\r' || this.ch == '\n' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b') {
                this.next();
                continue;
            }
            if (this.ch != '/') break;
            this.skipComment();
        }
    }

    private void scanStringSingleQuote() {
        char c2;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((c2 = this.next()) != '\'') {
            if (c2 == '\u001a') {
                if (!this.isEOF()) {
                    this.putChar('\u001a');
                    continue;
                }
                throw new JSONException("unclosed single-quote string");
            }
            if (c2 == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp > this.sbuf.length) {
                        char[] cArray = new char[this.sp << 1];
                        System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
                        this.sbuf = cArray;
                    }
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.copyTo(jSONLexerBase.np + 1, this.sp, this.sbuf);
                }
                c2 = this.next();
                switch (c2) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        this.putChar((char)((digits[this.next()] << 4) + digits[this.next()]));
                        continue block22;
                    }
                    case 'u': {
                        this.putChar((char)Integer.parseInt(new String(new char[]{this.next(), this.next(), this.next(), this.next()}), 16));
                        continue block22;
                    }
                }
                this.ch = c2;
                throw new JSONException("unclosed single-quote string");
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c2);
                continue;
            }
            this.sbuf[this.sp++] = c2;
        }
        this.token = 4;
        this.next();
    }

    protected final void putChar(char c2) {
        if (this.sp == this.sbuf.length) {
            char[] cArray = new char[this.sbuf.length << 1];
            System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
            this.sbuf = cArray;
        }
        this.sbuf[this.sp++] = c2;
    }

    public final void scanHex() {
        char c2;
        if (this.ch != 'x') {
            throw new JSONException("illegal state. " + this.ch);
        }
        this.next();
        if (this.ch != '\'') {
            throw new JSONException("illegal state. " + this.ch);
        }
        this.np = this.bp;
        this.next();
        if (this.ch == '\'') {
            this.next();
            this.token = 26;
            return;
        }
        while ((c2 = this.next()) >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F') {
            ++this.sp;
        }
        if (c2 == '\'') {
            ++this.sp;
        } else {
            throw new JSONException("illegal state. " + c2);
        }
        this.next();
        this.token = 26;
    }

    @Override
    public final void scanNumber() {
        boolean bl;
        block12: {
            block16: {
                block17: {
                    block15: {
                        block14: {
                            block13: {
                                block11: {
                                    this.np = this.bp;
                                    if (this.ch == '-') {
                                        ++this.sp;
                                        this.next();
                                    }
                                    while (this.ch >= '0' && this.ch <= '9') {
                                        ++this.sp;
                                        this.next();
                                    }
                                    bl = false;
                                    if (this.ch == '.') {
                                        ++this.sp;
                                        this.next();
                                        bl = true;
                                        while (this.ch >= '0' && this.ch <= '9') {
                                            ++this.sp;
                                            this.next();
                                        }
                                    }
                                    if (this.ch != 'L') break block11;
                                    ++this.sp;
                                    this.next();
                                    break block12;
                                }
                                if (this.ch != 'S') break block13;
                                ++this.sp;
                                this.next();
                                break block12;
                            }
                            if (this.ch != 'B') break block14;
                            ++this.sp;
                            this.next();
                            break block12;
                        }
                        if (this.ch != 'F') break block15;
                        ++this.sp;
                        this.next();
                        break block16;
                    }
                    if (this.ch != 'D') break block17;
                    ++this.sp;
                    this.next();
                    break block16;
                }
                if (this.ch != 'e' && this.ch != 'E') break block12;
                ++this.sp;
                this.next();
                if (this.ch == '+' || this.ch == '-') {
                    ++this.sp;
                    this.next();
                }
                while (this.ch >= '0' && this.ch <= '9') {
                    ++this.sp;
                    this.next();
                }
                if (this.ch == 'D' || this.ch == 'F') {
                    ++this.sp;
                    this.next();
                }
            }
            bl = true;
        }
        if (bl) {
            this.token = 3;
            return;
        }
        this.token = 2;
    }

    @Override
    public final long longValue() {
        int n2;
        long l2;
        long l3 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        int n3 = this.np;
        int n4 = this.np + this.sp;
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np) == '-') {
            bl = true;
            l2 = Long.MIN_VALUE;
            ++n3;
        } else {
            l2 = -9223372036854775807L;
        }
        if (n3 < n4) {
            n2 = this.charAt(n3++) - 48;
            l3 = -n2;
        }
        while (n3 < n4) {
            char c2 = this.charAt(n3++);
            n2 = c2;
            if (c2 == 'L' || n2 == 83 || n2 == 66) break;
            n2 -= 48;
            if (l3 < -922337203685477580L) {
                throw new NumberFormatException(this.numberString());
            }
            if ((l3 *= 10L) < l2 + (long)n2) {
                throw new NumberFormatException(this.numberString());
            }
            l3 -= (long)n2;
        }
        if (bl) {
            if (n3 > this.np + 1) {
                return l3;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -l3;
    }

    @Override
    public final Number decimalValue(boolean bl) {
        JSONLexerBase jSONLexerBase = this;
        char c2 = jSONLexerBase.charAt(jSONLexerBase.np + this.sp - 1);
        try {
            if (c2 == 'F') {
                return Float.valueOf(Float.parseFloat(this.numberString()));
            }
            if (c2 == 'D') {
                return Double.parseDouble(this.numberString());
            }
            if (bl) {
                return this.decimalValue();
            }
            return this.doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSONException(numberFormatException.getMessage() + ", " + this.info());
        }
    }

    @Override
    public abstract BigDecimal decimalValue();

    public static boolean isWhitespace(char c2) {
        return c2 <= ' ' && (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\f' || c2 == '\b');
    }

    public String[] scanFieldStringArray(char[] cArray, int n2, SymbolTable symbolTable) {
        throw new UnsupportedOperationException();
    }

    public boolean matchField2(char[] cArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFeatures() {
        return this.features;
    }

    static {
        int n2 = 48;
        while (n2 <= 57) {
            int n3 = n2++;
            JSONLexerBase.digits[n3] = n3 - 48;
        }
        n2 = 97;
        while (n2 <= 102) {
            int n4 = n2++;
            JSONLexerBase.digits[n4] = n4 - 97 + 10;
        }
        n2 = 65;
        while (n2 <= 70) {
            int n5 = n2++;
            JSONLexerBase.digits[n5] = n5 - 65 + 10;
        }
    }
}

