/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.parser;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.JSONLexerBase;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.SymbolTable;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.IOUtils;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;

public final class JSONReaderScanner
extends JSONLexerBase {
    private static final ThreadLocal<char[]> BUF_LOCAL = new ThreadLocal();
    private Reader reader;
    private char[] buf;
    private int bufLength;

    public JSONReaderScanner(String string) {
        this(string, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(String string, int n2) {
        this(new StringReader(string), n2);
    }

    public JSONReaderScanner(char[] cArray, int n2) {
        this(cArray, n2, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader) {
        this(reader, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader, int n2) {
        super(n2);
        this.reader = reader;
        this.buf = BUF_LOCAL.get();
        if (this.buf != null) {
            BUF_LOCAL.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[16384];
        }
        try {
            this.bufLength = reader.read(this.buf);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        this.bp = -1;
        ((JSONLexerBase)this).next();
        if (this.ch == '\ufeff') {
            ((JSONLexerBase)this).next();
        }
    }

    public JSONReaderScanner(char[] cArray, int n2, int n3) {
        this(new CharArrayReader(cArray, 0, n2), n3);
    }

    public final char charAt(int n2) {
        if (n2 >= this.bufLength) {
            if (this.bufLength == -1) {
                if (n2 < this.sp) {
                    return this.buf[n2];
                }
                return '\u001a';
            }
            if (this.bp == 0) {
                char[] cArray = new char[this.buf.length * 3 / 2];
                System.arraycopy(this.buf, this.bp, cArray, 0, this.bufLength);
                int n3 = cArray.length - this.bufLength;
                try {
                    n3 = this.reader.read(cArray, this.bufLength, n3);
                    this.bufLength += n3;
                    this.buf = cArray;
                }
                catch (IOException iOException) {
                    throw new JSONException(iOException.getMessage(), iOException);
                }
            }
            int n4 = this.bufLength - this.bp;
            if (n4 > 0) {
                System.arraycopy(this.buf, this.bp, this.buf, 0, n4);
            }
            try {
                this.bufLength = this.reader.read(this.buf, n4, this.buf.length - n4);
            }
            catch (IOException iOException) {
                throw new JSONException(iOException.getMessage(), iOException);
            }
            if (this.bufLength == 0) {
                throw new JSONException("illegal state, textLength is zero");
            }
            if (this.bufLength == -1) {
                return '\u001a';
            }
            this.bufLength += n4;
            n2 -= this.bp;
            this.np -= this.bp;
            this.bp = 0;
        }
        return this.buf[n2];
    }

    public final int indexOf(char c2, int n2) {
        n2 -= this.bp;
        while (true) {
            int n3 = this.bp + n2;
            if (c2 == (n3 = (int)((JSONLexerBase)this).charAt(n3))) {
                return n2 + this.bp;
            }
            if (n3 == 26) {
                return -1;
            }
            ++n2;
        }
    }

    public final String addSymbol(int n2, int n3, int n4, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.buf, n2, n3, n4);
    }

    public final char next() {
        int n2 = ++this.bp;
        if (this.bp >= this.bufLength) {
            int n3;
            if (this.bufLength == -1) {
                return '\u001a';
            }
            if (this.sp > 0) {
                n3 = this.bufLength - this.sp;
                if (this.ch == '\"' && n3 > 0) {
                    --n3;
                }
                System.arraycopy(this.buf, n3, this.buf, 0, this.sp);
            }
            this.np = -1;
            n2 = this.bp = this.sp;
            try {
                n3 = this.bp;
                int n4 = this.buf.length - n3;
                if (n4 == 0) {
                    char[] cArray = new char[this.buf.length << 1];
                    System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
                    this.buf = cArray;
                    n4 = this.buf.length - n3;
                }
                this.bufLength = this.reader.read(this.buf, this.bp, n4);
            }
            catch (IOException iOException) {
                throw new JSONException(iOException.getMessage(), iOException);
            }
            if (this.bufLength == 0) {
                throw new JSONException("illegal stat, textLength is zero");
            }
            if (this.bufLength == -1) {
                this.ch = '\u001a';
                return '\u001a';
            }
            this.bufLength += this.bp;
        }
        this.ch = this.buf[n2];
        return this.ch;
    }

    protected final void copyTo(int n2, int n3, char[] cArray) {
        System.arraycopy(this.buf, n2, cArray, 0, n3);
    }

    public final boolean charArrayCompare(char[] cArray) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            JSONReaderScanner jSONReaderScanner = this;
            if (((JSONLexerBase)jSONReaderScanner).charAt(jSONReaderScanner.bp + i2) == cArray[i2]) continue;
            return false;
        }
        return true;
    }

    public final byte[] bytesValue() {
        if (this.token == 26) {
            throw new JSONException("TODO");
        }
        return IOUtils.decodeBase64(this.buf, this.np + 1, this.sp);
    }

    protected final void arrayCopy(int n2, char[] cArray, int n3, int n4) {
        System.arraycopy(this.buf, n2, cArray, n3, n4);
    }

    public final String stringVal() {
        if (!this.hasSpecial) {
            int n2 = this.np + 1;
            if (n2 < 0) {
                throw new IllegalStateException();
            }
            if (n2 > this.buf.length - this.sp) {
                throw new IllegalStateException();
            }
            return new String(this.buf, n2, this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    public final String subString(int n2, int n3) {
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        return new String(this.buf, n2, n3);
    }

    public final char[] sub_chars(int n2, int n3) {
        if (n3 < 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 == 0) {
            return this.buf;
        }
        char[] cArray = new char[n3];
        System.arraycopy(this.buf, n2, cArray, 0, n3);
        return cArray;
    }

    public final String numberString() {
        int n2 = this.np;
        if (n2 == -1) {
            n2 = 0;
        }
        char c2 = ((JSONLexerBase)this).charAt(n2 + this.sp - 1);
        int n3 = this.sp;
        if (c2 == 'L' || c2 == 'S' || c2 == 'B' || c2 == 'F' || c2 == 'D') {
            --n3;
        }
        String string = new String(this.buf, n2, n3);
        return string;
    }

    public final BigDecimal decimalValue() {
        int n2 = this.np;
        if (n2 == -1) {
            n2 = 0;
        }
        char c2 = ((JSONLexerBase)this).charAt(n2 + this.sp - 1);
        int n3 = this.sp;
        if (c2 == 'L' || c2 == 'S' || c2 == 'B' || c2 == 'F' || c2 == 'D') {
            --n3;
        }
        return new BigDecimal(this.buf, n2, n3);
    }

    public final void close() {
        super.close();
        if (this.buf.length <= 65536) {
            BUF_LOCAL.set(this.buf);
        }
        this.buf = null;
        IOUtils.close(this.reader);
    }

    public final boolean isEOF() {
        return this.bufLength == -1 || this.bp == this.buf.length || this.ch == '\u001a' && this.bp + 1 == this.buf.length;
    }

    public final boolean isBlankInput() {
        int n2 = 0;
        while (true) {
            char c2;
            if ((c2 = this.buf[n2]) == '\u001a') break;
            if (!JSONReaderScanner.isWhitespace(c2)) {
                return false;
            }
            ++n2;
        }
        this.token = 20;
        return true;
    }
}

