/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.DefaultJSONParser;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer.ContextObjectDeserializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.BeanContext;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ContextObjectSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.JSONSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeWriter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdk8DateCodec
extends ContextObjectDeserializer
implements ObjectDeserializer,
ContextObjectSerializer,
ObjectSerializer {
    public static final Jdk8DateCodec instance = new Jdk8DateCodec();
    private static final String defaultPatttern = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter defaultFormatter_23 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter formatter_dt19_tw = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_cn = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_cn_1 = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206s\u79d2");
    private static final DateTimeFormatter formatter_dt19_kr = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_us = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_eur = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_de = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_in = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_d8 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter formatter_d10_tw = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter formatter_d10_cn = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5");
    private static final DateTimeFormatter formatter_d10_kr = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c");
    private static final DateTimeFormatter formatter_d10_us = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final DateTimeFormatter formatter_d10_eur = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter formatter_d10_de = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter formatter_d10_in = DateTimeFormatter.ofPattern("dd-MM-yyyy");
    private static final DateTimeFormatter ISO_FIXED_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    private static final String formatter_iso8601_pattern = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String formatter_iso8601_pattern_23 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String formatter_iso8601_pattern_29 = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS";
    private static final DateTimeFormatter formatter_iso8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type type, Object object2, String string, int n2) {
        object = ((DefaultJSONParser)object).lexer;
        if (object.token() == 8) {
            object.nextToken();
            return null;
        }
        if (object.token() == 4) {
            object2 = object.stringVal();
            object.nextToken();
            object = null;
            if (string != null) {
                object = defaultPatttern.equals(string) ? defaultFormatter : DateTimeFormatter.ofPattern(string);
            }
            if ("".equals(object2)) {
                return null;
            }
            if (type == LocalDateTime.class) {
                if (((String)object2).length() == 10 || ((String)object2).length() == 8) {
                    object = this.parseLocalDate((String)object2, string, (DateTimeFormatter)object);
                    object = LocalDateTime.of((LocalDate)object, LocalTime.MIN);
                } else {
                    object = this.parseDateTime((String)object2, (DateTimeFormatter)object);
                }
                return (T)object;
            }
            if (type == LocalDate.class) {
                if (((String)object2).length() == 23) {
                    object = LocalDateTime.parse((CharSequence)object2);
                    object = LocalDate.of(((LocalDateTime)object).getYear(), ((LocalDateTime)object).getMonthValue(), ((LocalDateTime)object).getDayOfMonth());
                } else {
                    object = this.parseLocalDate((String)object2, string, (DateTimeFormatter)object);
                }
                return (T)object;
            }
            if (type == LocalTime.class) {
                if (((String)object2).length() == 23) {
                    object = LocalDateTime.parse((CharSequence)object2);
                    object = LocalTime.of(((LocalDateTime)object).getHour(), ((LocalDateTime)object).getMinute(), ((LocalDateTime)object).getSecond(), ((LocalDateTime)object).getNano());
                } else {
                    object = LocalTime.parse((CharSequence)object2);
                }
                return (T)object;
            }
            if (type == ZonedDateTime.class) {
                if (object == defaultFormatter) {
                    object = ISO_FIXED_FORMAT;
                }
                object = this.parseZonedDateTime((String)object2, (DateTimeFormatter)object);
                return (T)object;
            }
            if (type == OffsetDateTime.class) {
                object = OffsetDateTime.parse((CharSequence)object2);
                return (T)object;
            }
            if (type == OffsetTime.class) {
                object = OffsetTime.parse((CharSequence)object2);
                return (T)object;
            }
            if (type == ZoneId.class) {
                object = ZoneId.of((String)object2);
                return (T)object;
            }
            if (type == Period.class) {
                object = Period.parse((CharSequence)object2);
                return (T)object;
            }
            if (type == Duration.class) {
                object = Duration.parse((CharSequence)object2);
                return (T)object;
            }
            if (type == Instant.class) {
                object = Instant.parse((CharSequence)object2);
                return (T)object;
            }
        } else {
            if (object.token() == 2) {
                long l2 = object.longValue();
                object.nextToken();
                if (type == LocalDateTime.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l2), JSON.defaultTimeZone.toZoneId());
                }
                if (type == LocalDate.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l2), JSON.defaultTimeZone.toZoneId()).toLocalDate();
                }
                if (type == LocalTime.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l2), JSON.defaultTimeZone.toZoneId()).toLocalTime();
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        return null;
    }

    protected LocalDateTime parseDateTime(String string, DateTimeFormatter dateTimeFormatter) {
        block15: {
            int n2;
            block17: {
                block16: {
                    char c2;
                    char c3;
                    block21: {
                        block22: {
                            String string2;
                            block24: {
                                block23: {
                                    char c4;
                                    int n3;
                                    block20: {
                                        block19: {
                                            block18: {
                                                if (dateTimeFormatter != null) break block15;
                                                if (string.length() != 19) break block16;
                                                n2 = string.charAt(4);
                                                n3 = string.charAt(7);
                                                c3 = string.charAt(10);
                                                c4 = string.charAt(13);
                                                c2 = string.charAt(16);
                                                if (c4 != ':' || c2 != ':') break block17;
                                                if (n2 != 45 || n3 != 45) break block18;
                                                if (c3 == 'T') {
                                                    dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                                                } else if (c3 == ' ') {
                                                    dateTimeFormatter = defaultFormatter;
                                                }
                                                break block17;
                                            }
                                            if (n2 != 45 || n3 != 45) break block19;
                                            dateTimeFormatter = defaultFormatter;
                                            break block17;
                                        }
                                        if (n2 != 47 || n3 != 47) break block20;
                                        dateTimeFormatter = formatter_dt19_tw;
                                        break block17;
                                    }
                                    char c5 = string.charAt(0);
                                    n3 = string.charAt(1);
                                    c3 = string.charAt(2);
                                    c4 = string.charAt(3);
                                    c2 = string.charAt(5);
                                    if (c3 != '/' || c2 != '/') break block21;
                                    n3 = (c5 - 48) * 10 + (n3 - 48);
                                    n2 = (c4 - 48) * 10 + (n2 - 48);
                                    if (n3 > 12) break block22;
                                    if (n2 <= 12) break block23;
                                    dateTimeFormatter = formatter_dt19_us;
                                    break block17;
                                }
                                string2 = Locale.getDefault().getCountry();
                                if (!string2.equals("US")) break block24;
                                dateTimeFormatter = formatter_dt19_us;
                                break block17;
                            }
                            if (!string2.equals("BR") && !string2.equals("AU")) break block17;
                        }
                        dateTimeFormatter = formatter_dt19_eur;
                        break block17;
                    }
                    if (c3 == '.' && c2 == '.') {
                        dateTimeFormatter = formatter_dt19_de;
                    } else if (c3 == '-' && c2 == '-') {
                        dateTimeFormatter = formatter_dt19_in;
                    }
                    break block17;
                }
                if (string.length() == 23) {
                    n2 = string.charAt(4);
                    char c6 = string.charAt(7);
                    char c7 = string.charAt(10);
                    char c8 = string.charAt(13);
                    char c9 = string.charAt(16);
                    char c10 = string.charAt(19);
                    if (c8 == ':' && c9 == ':' && n2 == 45 && c6 == '-' && c7 == ' ' && c10 == '.') {
                        dateTimeFormatter = defaultFormatter_23;
                    }
                }
            }
            if (string.length() >= 17) {
                n2 = string.charAt(4);
                if (n2 == 24180) {
                    String string3 = string;
                    dateTimeFormatter = string3.charAt(string3.length() - 1) == '\u79d2' ? formatter_dt19_cn_1 : formatter_dt19_cn;
                } else if (n2 == 45380) {
                    dateTimeFormatter = formatter_dt19_kr;
                }
            }
        }
        if (dateTimeFormatter == null) {
            return LocalDateTime.parse(string);
        }
        return LocalDateTime.parse(string, dateTimeFormatter);
    }

    protected LocalDate parseLocalDate(String string, String string2, DateTimeFormatter dateTimeFormatter) {
        block12: {
            block13: {
                char c2;
                char c3;
                block14: {
                    block15: {
                        String string3;
                        block17: {
                            block16: {
                                if (dateTimeFormatter != null) break block12;
                                if (string.length() == 8) {
                                    dateTimeFormatter = formatter_d8;
                                }
                                if (string.length() != 10) break block13;
                                int n2 = string.charAt(4);
                                int n3 = string.charAt(7);
                                if (n2 == 47 && n3 == 47) {
                                    dateTimeFormatter = formatter_d10_tw;
                                }
                                n3 = string.charAt(0);
                                char c4 = string.charAt(1);
                                c3 = string.charAt(2);
                                char c5 = string.charAt(3);
                                c2 = string.charAt(5);
                                if (c3 != '/' || c2 != '/') break block14;
                                n3 = (n3 - 48) * 10 + (c4 - 48);
                                n2 = (c5 - 48) * 10 + (n2 - 48);
                                if (n3 > 12) break block15;
                                if (n2 <= 12) break block16;
                                dateTimeFormatter = formatter_d10_us;
                                break block13;
                            }
                            string3 = Locale.getDefault().getCountry();
                            if (!string3.equals("US")) break block17;
                            dateTimeFormatter = formatter_d10_us;
                            break block13;
                        }
                        if (!string3.equals("BR") && !string3.equals("AU")) break block13;
                    }
                    dateTimeFormatter = formatter_d10_eur;
                    break block13;
                }
                if (c3 == '.' && c2 == '.') {
                    dateTimeFormatter = formatter_d10_de;
                } else if (c3 == '-' && c2 == '-') {
                    dateTimeFormatter = formatter_d10_in;
                }
            }
            if (string.length() >= 9) {
                char c6 = string.charAt(4);
                if (c6 == '\u5e74') {
                    dateTimeFormatter = formatter_d10_cn;
                } else if (c6 == '\ub144') {
                    dateTimeFormatter = formatter_d10_kr;
                }
            }
        }
        if (dateTimeFormatter == null) {
            return LocalDate.parse(string);
        }
        return LocalDate.parse(string, dateTimeFormatter);
    }

    protected ZonedDateTime parseZonedDateTime(String string, DateTimeFormatter dateTimeFormatter) {
        block13: {
            block14: {
                char c2;
                char c3;
                block18: {
                    block19: {
                        String string2;
                        block21: {
                            block20: {
                                char c4;
                                char c5;
                                int n2;
                                int n3;
                                block17: {
                                    block16: {
                                        block15: {
                                            if (dateTimeFormatter != null) break block13;
                                            if (string.length() != 19) break block14;
                                            n3 = string.charAt(4);
                                            n2 = string.charAt(7);
                                            c5 = string.charAt(10);
                                            c3 = string.charAt(13);
                                            c4 = string.charAt(16);
                                            if (c3 != ':' || c4 != ':') break block14;
                                            if (n3 != 45 || n2 != 45) break block15;
                                            if (c5 == 'T') {
                                                dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                                            } else if (c5 == ' ') {
                                                dateTimeFormatter = defaultFormatter;
                                            }
                                            break block14;
                                        }
                                        if (n3 != 45 || n2 != 45) break block16;
                                        dateTimeFormatter = defaultFormatter;
                                        break block14;
                                    }
                                    if (n3 != 47 || n2 != 47) break block17;
                                    dateTimeFormatter = formatter_dt19_tw;
                                    break block14;
                                }
                                n2 = string.charAt(0);
                                c5 = string.charAt(1);
                                c3 = string.charAt(2);
                                c4 = string.charAt(3);
                                c2 = string.charAt(5);
                                if (c3 != '/' || c2 != '/') break block18;
                                n2 = (n2 - 48) * 10 + (c5 - 48);
                                n3 = (c4 - 48) * 10 + (n3 - 48);
                                if (n2 > 12) break block19;
                                if (n3 <= 12) break block20;
                                dateTimeFormatter = formatter_dt19_us;
                                break block14;
                            }
                            string2 = Locale.getDefault().getCountry();
                            if (!string2.equals("US")) break block21;
                            dateTimeFormatter = formatter_dt19_us;
                            break block14;
                        }
                        if (!string2.equals("BR") && !string2.equals("AU")) break block14;
                    }
                    dateTimeFormatter = formatter_dt19_eur;
                    break block14;
                }
                if (c3 == '.' && c2 == '.') {
                    dateTimeFormatter = formatter_dt19_de;
                } else if (c3 == '-' && c2 == '-') {
                    dateTimeFormatter = formatter_dt19_in;
                }
            }
            if (string.length() >= 17) {
                char c6 = string.charAt(4);
                if (c6 == '\u5e74') {
                    String string3 = string;
                    dateTimeFormatter = string3.charAt(string3.length() - 1) == '\u79d2' ? formatter_dt19_cn_1 : formatter_dt19_cn;
                } else if (c6 == '\ub144') {
                    dateTimeFormatter = formatter_dt19_kr;
                }
            }
        }
        if (dateTimeFormatter == null) {
            return ZonedDateTime.parse(string);
        }
        return ZonedDateTime.parse(string, dateTimeFormatter);
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type clazz, int n2) {
        object2 = jSONSerializer.out;
        if (object == null) {
            ((SerializeWriter)object2).writeNull();
            return;
        }
        if (clazz == null) {
            clazz = object.getClass();
        }
        if (clazz != LocalDateTime.class) {
            ((SerializeWriter)object2).writeString(object.toString());
            return;
        }
        int n3 = SerializerFeature.UseISO8601DateFormat.getMask();
        object = (LocalDateTime)object;
        String string = jSONSerializer.getDateFormatPattern();
        if (string == null) {
            int n4;
            string = (n2 & n3) != 0 || jSONSerializer.isEnabled(SerializerFeature.UseISO8601DateFormat) ? formatter_iso8601_pattern : ((n4 = ((LocalDateTime)object).getNano()) == 0 ? formatter_iso8601_pattern : (n4 % 1000000 == 0 ? formatter_iso8601_pattern_23 : formatter_iso8601_pattern_29));
        }
        if (string != null) {
            this.write((SerializeWriter)object2, (TemporalAccessor)object, string);
            return;
        }
        if (((SerializeWriter)object2).isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
            this.write((SerializeWriter)object2, (TemporalAccessor)object, JSON.DEFFAULT_DATE_FORMAT);
            return;
        }
        ((SerializeWriter)object2).writeLong(((LocalDateTime)object).atZone(JSON.defaultTimeZone.toZoneId()).toInstant().toEpochMilli());
    }

    @Override
    public void write(JSONSerializer object, Object object2, BeanContext object3) {
        object = ((JSONSerializer)object).out;
        object3 = ((BeanContext)object3).getFormat();
        this.write((SerializeWriter)object, (TemporalAccessor)object2, (String)object3);
    }

    private void write(SerializeWriter serializeWriter, TemporalAccessor object, String object2) {
        object2 = object2 == formatter_iso8601_pattern ? formatter_iso8601 : DateTimeFormatter.ofPattern((String)object2);
        object = ((DateTimeFormatter)object2).format((TemporalAccessor)object);
        serializeWriter.writeString((String)object);
    }
}

