/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.DefaultJSONParser;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.JSONLexer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberDeserializer
implements ObjectDeserializer {
    public static final NumberDeserializer instance = new NumberDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type type, Object object2) {
        JSONLexer jSONLexer = ((DefaultJSONParser)object).lexer;
        if (jSONLexer.token() == 2) {
            if (type == Double.TYPE || type == Double.class) {
                object = jSONLexer.numberString();
                jSONLexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble((String)object));
            }
            long l2 = jSONLexer.longValue();
            jSONLexer.nextToken(16);
            if (type == Short.TYPE || type == Short.class) {
                if (l2 > 32767L || l2 < -32768L) {
                    throw new JSONException("short overflow : " + l2);
                }
                return (T)Short.valueOf((short)l2);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                if (l2 > 127L || l2 < -128L) {
                    throw new JSONException("short overflow : " + l2);
                }
                return (T)Byte.valueOf((byte)l2);
            }
            if (l2 >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE) {
                return (T)Integer.valueOf((int)l2);
            }
            return (T)Long.valueOf(l2);
        }
        if (jSONLexer.token() == 3) {
            if (type == Double.TYPE || type == Double.class) {
                object = jSONLexer.numberString();
                jSONLexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble((String)object));
            }
            if (type == Short.TYPE || type == Short.class) {
                object = jSONLexer.decimalValue();
                jSONLexer.nextToken(16);
                short s2 = ((BigDecimal)object).shortValueExact();
                return (T)Short.valueOf(s2);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                object = jSONLexer.decimalValue();
                jSONLexer.nextToken(16);
                byte by = ((BigDecimal)object).byteValueExact();
                return (T)Byte.valueOf(by);
            }
            object = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)object;
        }
        if (jSONLexer.token() == 18 && "NaN".equals(jSONLexer.stringVal())) {
            jSONLexer.nextToken();
            object = null;
            if (type == Double.class) {
                object = Double.NaN;
            } else if (type == Float.class) {
                object = Float.valueOf(Float.NaN);
            }
            return (T)object;
        }
        if ((object = ((DefaultJSONParser)object).parse()) == null) {
            return null;
        }
        if (type == Double.TYPE || type == Double.class) {
            try {
                return (T)TypeUtils.castToDouble(object);
            }
            catch (Exception exception) {
                throw new JSONException("parseDouble error, field : " + object2, exception);
            }
        }
        if (type == Short.TYPE || type == Short.class) {
            try {
                return (T)TypeUtils.castToShort(object);
            }
            catch (Exception exception) {
                throw new JSONException("parseShort error, field : " + object2, exception);
            }
        }
        if (type == Byte.TYPE || type == Byte.class) {
            try {
                return (T)TypeUtils.castToByte(object);
            }
            catch (Exception exception) {
                throw new JSONException("parseByte error, field : " + object2, exception);
            }
        }
        return (T)TypeUtils.castToBigDecimal(object);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

