/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.DefaultJSONParser;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.JSONSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionalCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static OptionalCodec instance = new OptionalCodec();

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type type, Object object2) {
        if (type == OptionalInt.class) {
            object = ((DefaultJSONParser)object).parseObject(Integer.class);
            if ((object = TypeUtils.castToInt(object)) == null) {
                return (T)OptionalInt.empty();
            }
            return (T)OptionalInt.of((Integer)object);
        }
        if (type == OptionalLong.class) {
            object = ((DefaultJSONParser)object).parseObject(Long.class);
            if ((object = TypeUtils.castToLong(object)) == null) {
                return (T)OptionalLong.empty();
            }
            return (T)OptionalLong.of((Long)object);
        }
        if (type == OptionalDouble.class) {
            object = ((DefaultJSONParser)object).parseObject(Double.class);
            if ((object = TypeUtils.castToDouble(object)) == null) {
                return (T)OptionalDouble.empty();
            }
            return (T)OptionalDouble.of((Double)object);
        }
        if ((object = ((DefaultJSONParser)object).parseObject(type = TypeUtils.unwrapOptional(type))) == null) {
            return (T)Optional.empty();
        }
        return (T)Optional.of(object);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        if (object == null) {
            jSONSerializer.writeNull();
            return;
        }
        if (object instanceof Optional) {
            object = ((Optional)(object = (Optional)object)).isPresent() ? ((Optional)object).get() : null;
            jSONSerializer.write(object);
            return;
        }
        if (object instanceof OptionalDouble) {
            if (((OptionalDouble)(object = (OptionalDouble)object)).isPresent()) {
                double d2 = ((OptionalDouble)object).getAsDouble();
                jSONSerializer.write(d2);
                return;
            }
            jSONSerializer.writeNull();
            return;
        }
        if (object instanceof OptionalInt) {
            if (((OptionalInt)(object = (OptionalInt)object)).isPresent()) {
                int n3 = ((OptionalInt)object).getAsInt();
                jSONSerializer.out.writeInt(n3);
                return;
            }
            jSONSerializer.writeNull();
            return;
        }
        if (object instanceof OptionalLong) {
            if (((OptionalLong)(object = (OptionalLong)object)).isPresent()) {
                long l2 = ((OptionalLong)object).getAsLong();
                jSONSerializer.out.writeLong(l2);
                return;
            }
            jSONSerializer.writeNull();
            return;
        }
        throw new JSONException("not support optional : " + object.getClass());
    }
}

