/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.serializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.DefaultJSONParser;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.JSONLexer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.JSONSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeWriter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final BooleanCodec instance = new BooleanCodec();

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type, int n2) {
        object = ((JSONSerializer)object).out;
        if ((object2 = (Boolean)object2) == null) {
            ((SerializeWriter)object).writeNull(SerializerFeature.WriteNullBooleanAsFalse);
            return;
        }
        if (((Boolean)object2).booleanValue()) {
            ((SerializeWriter)object).write("true");
            return;
        }
        ((SerializeWriter)object).write("false");
    }

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type type, Object object2) {
        JSONLexer jSONLexer = ((DefaultJSONParser)object).lexer;
        try {
            if (jSONLexer.token() == 6) {
                jSONLexer.nextToken(16);
                object = Boolean.TRUE;
            } else if (jSONLexer.token() == 7) {
                jSONLexer.nextToken(16);
                object = Boolean.FALSE;
            } else if (jSONLexer.token() == 2) {
                int n2 = jSONLexer.intValue();
                jSONLexer.nextToken(16);
                object = n2 == 1 ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if ((object = ((DefaultJSONParser)object).parse()) == null) {
                    return null;
                }
                object = TypeUtils.castToBoolean(object);
            }
        }
        catch (Exception exception) {
            throw new JSONException("parseBoolean error, field : " + object2, exception);
        }
        if (type == AtomicBoolean.class) {
            return (T)new AtomicBoolean((Boolean)object);
        }
        return (T)object;
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

