/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.serializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONArray;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.DefaultJSONParser;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.JSONSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerialContext;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeWriter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final CollectionCodec instance = new CollectionCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object iterator, Type object2, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        Type type = null;
        if (serializeWriter.isEnabled(SerializerFeature.WriteClassName) || SerializerFeature.isEnabled(n2, SerializerFeature.WriteClassName)) {
            type = TypeUtils.getCollectionItemType((Type)object2);
        }
        object2 = (Collection)object;
        SerialContext serialContext = jSONSerializer.context;
        jSONSerializer.setContext(serialContext, object, iterator, 0);
        if (serializeWriter.isEnabled(SerializerFeature.WriteClassName)) {
            if (HashSet.class == object2.getClass()) {
                serializeWriter.append("Set");
            } else if (TreeSet.class == object2.getClass()) {
                serializeWriter.append("TreeSet");
            }
        }
        try {
            int n3 = 0;
            serializeWriter.append('[');
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                if (n3++ != 0) {
                    serializeWriter.append(',');
                }
                if (object2 == null) {
                    serializeWriter.writeNull();
                    continue;
                }
                Class<?> clazz = object2.getClass();
                if (clazz == Integer.class) {
                    serializeWriter.writeInt((Integer)object2);
                    continue;
                }
                if (clazz == Long.class) {
                    serializeWriter.writeLong((Long)object2);
                    if (!serializeWriter.isEnabled(SerializerFeature.WriteClassName)) continue;
                    serializeWriter.write(76);
                    continue;
                }
                clazz = jSONSerializer.getObjectWriter(clazz);
                if (SerializerFeature.isEnabled(n2, SerializerFeature.WriteClassName) && clazz instanceof JavaBeanSerializer) {
                    clazz = (JavaBeanSerializer)((Object)clazz);
                    ((JavaBeanSerializer)((Object)clazz)).writeNoneASM(jSONSerializer, object2, n3 - 1, type, n2);
                    continue;
                }
                clazz.write(jSONSerializer, object2, n3 - 1, type, n2);
            }
            serializeWriter.append(']');
            return;
        }
        finally {
            jSONSerializer.context = serialContext;
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        if (defaultJSONParser.lexer.token() == 8) {
            defaultJSONParser.lexer.nextToken(16);
            return null;
        }
        if (type == JSONArray.class) {
            JSONArray jSONArray = new JSONArray();
            defaultJSONParser.parseArray(jSONArray);
            return (T)jSONArray;
        }
        Collection collection = TypeUtils.createCollection(type);
        type = TypeUtils.getCollectionItemType(type);
        defaultJSONParser.parseArray(type, collection, object);
        return (T)collection;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

