/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.serializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.shade.com.alibaba.fastjson.annotation.JSONType;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.BeanContext;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ContextObjectSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.DoubleSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.FieldSerializer$RuntimeSerializerInfo;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.FloatCodec;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.JSONSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.JavaBeanSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.MapSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeWriter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.FieldInfo;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.TypeUtils;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldSerializer
implements Comparable<FieldSerializer> {
    public final FieldInfo fieldInfo;
    protected final boolean writeNull;
    protected int features;
    private final String double_quoted_fieldPrefix;
    private String single_quoted_fieldPrefix;
    private String un_quoted_fieldPrefix;
    protected BeanContext fieldContext;
    private String format;
    protected boolean writeEnumUsingToString = false;
    protected boolean writeEnumUsingName = false;
    protected boolean disableCircularReferenceDetect = false;
    protected boolean serializeUsing = false;
    protected boolean persistenceXToMany = false;
    protected boolean browserCompatible;
    private FieldSerializer$RuntimeSerializerInfo runtimeInfo;

    public FieldSerializer(Class<?> object, FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.fieldContext = new BeanContext((Class<?>)object, fieldInfo);
        if (object != null && (fieldInfo.isEnum || fieldInfo.fieldClass == Long.TYPE || fieldInfo.fieldClass == Long.class) && (object = TypeUtils.getAnnotation(object, JSONType.class)) != null) {
            for (SerializerFeature serializerFeature : object.serialzeFeatures()) {
                if (serializerFeature == SerializerFeature.WriteEnumUsingToString) {
                    this.writeEnumUsingToString = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                    this.writeEnumUsingName = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.DisableCircularReferenceDetect) {
                    this.disableCircularReferenceDetect = true;
                    continue;
                }
                if (serializerFeature != SerializerFeature.BrowserCompatible) continue;
                this.browserCompatible = true;
            }
        }
        fieldInfo.setAccessible();
        this.double_quoted_fieldPrefix = "\"" + fieldInfo.name + "\":";
        boolean bl = false;
        JSONField jSONField = fieldInfo.getAnnotation();
        if (jSONField != null) {
            for (SerializerFeature serializerFeature : jSONField.serialzeFeatures()) {
                if ((serializerFeature.getMask() & SerializerFeature.WRITE_MAP_NULL_FEATURES) == 0) continue;
                bl = true;
                break;
            }
            this.format = jSONField.format();
            if (this.format.trim().length() == 0) {
                this.format = null;
            }
            for (SerializerFeature serializerFeature : jSONField.serialzeFeatures()) {
                if (serializerFeature == SerializerFeature.WriteEnumUsingToString) {
                    this.writeEnumUsingToString = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                    this.writeEnumUsingName = true;
                    continue;
                }
                if (serializerFeature == SerializerFeature.DisableCircularReferenceDetect) {
                    this.disableCircularReferenceDetect = true;
                    continue;
                }
                if (serializerFeature != SerializerFeature.BrowserCompatible) continue;
                this.browserCompatible = true;
            }
            this.features = SerializerFeature.of(jSONField.serialzeFeatures());
        }
        this.writeNull = bl;
        this.persistenceXToMany = TypeUtils.isAnnotationPresentOneToMany(fieldInfo.method) || TypeUtils.isAnnotationPresentManyToMany(fieldInfo.method);
    }

    public void writePrefix(JSONSerializer object) {
        object = ((JSONSerializer)object).out;
        if (((SerializeWriter)object).quoteFieldNames) {
            if (((SerializeWriter)object).useSingleQuotes) {
                if (this.single_quoted_fieldPrefix == null) {
                    this.single_quoted_fieldPrefix = "'" + this.fieldInfo.name + "':";
                }
                ((SerializeWriter)object).write(this.single_quoted_fieldPrefix);
                return;
            }
            ((SerializeWriter)object).write(this.double_quoted_fieldPrefix);
            return;
        }
        if (this.un_quoted_fieldPrefix == null) {
            this.un_quoted_fieldPrefix = this.fieldInfo.name + ":";
        }
        ((SerializeWriter)object).write(this.un_quoted_fieldPrefix);
    }

    public Object getPropertyValueDirect(Object object) {
        object = this.fieldInfo.get(object);
        if (this.persistenceXToMany && !TypeUtils.isHibernateInitialized(object)) {
            return null;
        }
        return object;
    }

    public Object getPropertyValue(Object object) {
        object = this.fieldInfo.get(object);
        if (this.format != null && object != null && this.fieldInfo.fieldClass == Date.class) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format, JSON.defaultLocale);
            simpleDateFormat.setTimeZone(JSON.defaultTimeZone);
            return simpleDateFormat.format(object);
        }
        return object;
    }

    @Override
    public int compareTo(FieldSerializer fieldSerializer) {
        return this.fieldInfo.compareTo(fieldSerializer.fieldInfo);
    }

    public void writeValue(JSONSerializer jSONSerializer, Object object) {
        long l2;
        int n2;
        Class<?> clazz;
        Class<?> clazz2;
        if (this.runtimeInfo == null) {
            if (object == null) {
                clazz2 = this.fieldInfo.fieldClass;
                if (clazz2 == Byte.TYPE) {
                    clazz2 = Byte.class;
                } else if (clazz2 == Short.TYPE) {
                    clazz2 = Short.class;
                } else if (clazz2 == Integer.TYPE) {
                    clazz2 = Integer.class;
                } else if (clazz2 == Long.TYPE) {
                    clazz2 = Long.class;
                } else if (clazz2 == Float.TYPE) {
                    clazz2 = Float.class;
                } else if (clazz2 == Double.TYPE) {
                    clazz2 = Double.class;
                } else if (clazz2 == Boolean.TYPE) {
                    clazz2 = Boolean.class;
                }
            } else {
                clazz2 = object.getClass();
            }
            ObjectSerializer objectSerializer = null;
            clazz = this.fieldInfo.getAnnotation();
            if (clazz != null && clazz.serializeUsing() != Void.class) {
                objectSerializer = (ObjectSerializer)clazz.serializeUsing().newInstance();
                this.serializeUsing = true;
            } else {
                if (this.format != null) {
                    if (clazz2 == Double.TYPE || clazz2 == Double.class) {
                        objectSerializer = new DoubleSerializer(this.format);
                    } else if (clazz2 == Float.TYPE || clazz2 == Float.class) {
                        objectSerializer = new FloatCodec(this.format);
                    }
                }
                if (objectSerializer == null) {
                    objectSerializer = jSONSerializer.getObjectWriter(clazz2);
                }
            }
            this.runtimeInfo = new FieldSerializer$RuntimeSerializerInfo(objectSerializer, clazz2);
        }
        clazz2 = this.runtimeInfo;
        int n3 = n2 = this.disableCircularReferenceDetect ? this.fieldInfo.serialzeFeatures | SerializerFeature.DisableCircularReferenceDetect.getMask() : this.fieldInfo.serialzeFeatures;
        if (object == null) {
            clazz = jSONSerializer.out;
            if (this.fieldInfo.fieldClass == Object.class && ((SerializeWriter)((Object)clazz)).isEnabled(SerializerFeature.WRITE_MAP_NULL_FEATURES)) {
                ((SerializeWriter)((Object)clazz)).writeNull();
                return;
            }
            Class<?> clazz3 = ((FieldSerializer$RuntimeSerializerInfo)((Object)clazz2)).runtimeFieldClass;
            if (Number.class.isAssignableFrom(clazz3)) {
                ((SerializeWriter)((Object)clazz)).writeNull(this.features, SerializerFeature.WriteNullNumberAsZero.mask);
                return;
            }
            if (String.class == clazz3) {
                ((SerializeWriter)((Object)clazz)).writeNull(this.features, SerializerFeature.WriteNullStringAsEmpty.mask);
                return;
            }
            if (Boolean.class == clazz3) {
                ((SerializeWriter)((Object)clazz)).writeNull(this.features, SerializerFeature.WriteNullBooleanAsFalse.mask);
                return;
            }
            if (Collection.class.isAssignableFrom(clazz3)) {
                ((SerializeWriter)((Object)clazz)).writeNull(this.features, SerializerFeature.WriteNullListAsEmpty.mask);
                return;
            }
            clazz2 = ((FieldSerializer$RuntimeSerializerInfo)((Object)clazz2)).fieldSerializer;
            if (((SerializeWriter)((Object)clazz)).isEnabled(SerializerFeature.WRITE_MAP_NULL_FEATURES) && clazz2 instanceof JavaBeanSerializer) {
                ((SerializeWriter)((Object)clazz)).writeNull();
                return;
            }
            clazz2.write(jSONSerializer, null, this.fieldInfo.name, this.fieldInfo.fieldType, n2);
            return;
        }
        if (this.fieldInfo.isEnum) {
            if (this.writeEnumUsingName) {
                jSONSerializer.out.writeString(((Enum)object).name());
                return;
            }
            if (this.writeEnumUsingToString) {
                jSONSerializer.out.writeString(((Enum)object).toString());
                return;
            }
        }
        ObjectSerializer objectSerializer = (clazz = object.getClass()) == ((FieldSerializer$RuntimeSerializerInfo)((Object)clazz2)).runtimeFieldClass || this.serializeUsing ? ((FieldSerializer$RuntimeSerializerInfo)((Object)clazz2)).fieldSerializer : jSONSerializer.getObjectWriter(clazz);
        if (this.format != null && !(objectSerializer instanceof DoubleSerializer) && !(objectSerializer instanceof FloatCodec)) {
            if (objectSerializer instanceof ContextObjectSerializer) {
                ((ContextObjectSerializer)objectSerializer).write(jSONSerializer, object, this.fieldContext);
                return;
            }
            jSONSerializer.writeWithFormat(object, this.format);
            return;
        }
        if (this.fieldInfo.unwrapped) {
            if (objectSerializer instanceof JavaBeanSerializer) {
                clazz2 = (JavaBeanSerializer)objectSerializer;
                ((JavaBeanSerializer)((Object)clazz2)).write(jSONSerializer, object, this.fieldInfo.name, this.fieldInfo.fieldType, n2, true);
                return;
            }
            if (objectSerializer instanceof MapSerializer) {
                clazz2 = (MapSerializer)objectSerializer;
                ((MapSerializer)((Object)clazz2)).write(jSONSerializer, object, this.fieldInfo.name, this.fieldInfo.fieldType, n2, true);
                return;
            }
        }
        if ((this.features & SerializerFeature.WriteClassName.mask) != 0 && clazz != this.fieldInfo.fieldClass && JavaBeanSerializer.class.isInstance(objectSerializer)) {
            ((JavaBeanSerializer)objectSerializer).write(jSONSerializer, object, this.fieldInfo.name, this.fieldInfo.fieldType, n2, false);
            return;
        }
        if (!(!this.browserCompatible || object == null || this.fieldInfo.fieldClass != Long.TYPE && this.fieldInfo.fieldClass != Long.class || (l2 = ((Long)object).longValue()) <= 0x1FFFFFFFFFFFFFL && l2 >= -9007199254740991L)) {
            jSONSerializer.getWriter().writeString(Long.toString(l2));
            return;
        }
        objectSerializer.write(jSONSerializer, object, this.fieldInfo.name, this.fieldInfo.fieldType, n2);
    }
}

