/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.serializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.DefaultJSONParser;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.JSONLexer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.JSONSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeWriter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.TypeUtils;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatCodec
implements ObjectDeserializer,
ObjectSerializer {
    private NumberFormat decimalFormat;
    public static FloatCodec instance = new FloatCodec();

    public FloatCodec() {
    }

    public FloatCodec(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public FloatCodec(String string) {
        this(new DecimalFormat(string));
    }

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type, int n2) {
        object = ((JSONSerializer)object).out;
        if (object2 == null) {
            ((SerializeWriter)object).writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        float f2 = ((Float)object2).floatValue();
        if (this.decimalFormat != null) {
            String string = this.decimalFormat.format(f2);
            ((SerializeWriter)object).write(string);
            return;
        }
        ((SerializeWriter)object).writeFloat(f2, true);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        try {
            return FloatCodec.deserialze(defaultJSONParser);
        }
        catch (Exception exception) {
            throw new JSONException("parseLong error, field : " + object, exception);
        }
    }

    public static <T> T deserialze(DefaultJSONParser object) {
        JSONLexer jSONLexer = ((DefaultJSONParser)object).lexer;
        if (jSONLexer.token() == 2) {
            object = jSONLexer.numberString();
            jSONLexer.nextToken(16);
            return (T)Float.valueOf(Float.parseFloat((String)object));
        }
        if (jSONLexer.token() == 3) {
            float f2 = jSONLexer.floatValue();
            jSONLexer.nextToken(16);
            return (T)Float.valueOf(f2);
        }
        if ((object = ((DefaultJSONParser)object).parse()) == null) {
            return null;
        }
        return (T)TypeUtils.castToFloat(object);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

