/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.serializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerialContext;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeConfig;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeFilterable;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeWriter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.StringCodec;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONSerializer
extends SerializeFilterable {
    protected final SerializeConfig config;
    public final SerializeWriter out;
    private int indentCount = 0;
    private String indent = "\t";
    private String dateFormatPattern;
    private DateFormat dateFormat;
    protected IdentityHashMap<Object, SerialContext> references = null;
    protected SerialContext context;
    protected TimeZone timeZone = JSON.defaultTimeZone;
    protected Locale locale = JSON.defaultLocale;

    public JSONSerializer() {
        this(new SerializeWriter(), SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeWriter serializeWriter) {
        this(serializeWriter, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeConfig serializeConfig) {
        this(new SerializeWriter(), serializeConfig);
    }

    public JSONSerializer(SerializeWriter serializeWriter, SerializeConfig serializeConfig) {
        this.out = serializeWriter;
        this.config = serializeConfig;
    }

    public String getDateFormatPattern() {
        if (this.dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)this.dateFormat).toPattern();
        }
        return this.dateFormatPattern;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null && this.dateFormatPattern != null) {
            this.dateFormat = new SimpleDateFormat(this.dateFormatPattern, this.locale);
            this.dateFormat.setTimeZone(this.timeZone);
        }
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        if (this.dateFormatPattern != null) {
            this.dateFormatPattern = null;
        }
    }

    public void setDateFormat(String string) {
        this.dateFormatPattern = string;
        if (this.dateFormat != null) {
            this.dateFormat = null;
        }
    }

    public SerialContext getContext() {
        return this.context;
    }

    public void setContext(SerialContext serialContext) {
        this.context = serialContext;
    }

    public void setContext(SerialContext serialContext, Object object, Object object2, int n2) {
        this.setContext(serialContext, object, object2, n2, 0);
    }

    public void setContext(SerialContext serialContext, Object object, Object object2, int n2, int n3) {
        if (this.out.disableCircularReferenceDetect) {
            return;
        }
        this.context = new SerialContext(serialContext, object, object2, n2, n3);
        if (this.references == null) {
            this.references = new IdentityHashMap();
        }
        this.references.put(object, this.context);
    }

    public void setContext(Object object, Object object2) {
        JSONSerializer jSONSerializer = this;
        jSONSerializer.setContext(jSONSerializer.context, object, object2, 0);
    }

    public void popContext() {
        if (this.context != null) {
            this.context = this.context.parent;
        }
    }

    public final boolean isWriteClassName(Type type, Object object) {
        return this.out.isEnabled(SerializerFeature.WriteClassName) && (type != null || !this.out.isEnabled(SerializerFeature.NotWriteRootClassName) || this.context != null && this.context.parent != null);
    }

    public boolean containsReference(Object object) {
        if (this.references == null) {
            return false;
        }
        if ((object = this.references.get(object)) == null) {
            return false;
        }
        object = ((SerialContext)object).fieldName;
        return object == null || object instanceof Integer || object instanceof String;
    }

    public void writeReference(Object object) {
        SerialContext serialContext = this.context;
        Object object2 = serialContext.object;
        if (object == object2) {
            this.out.write("{\"$ref\":\"@\"}");
            return;
        }
        object2 = serialContext.parent;
        if (object2 != null && object == ((SerialContext)object2).object) {
            this.out.write("{\"$ref\":\"..\"}");
            return;
        }
        while (serialContext.parent != null) {
            serialContext = serialContext.parent;
        }
        if (object == serialContext.object) {
            this.out.write("{\"$ref\":\"$\"}");
            return;
        }
        this.out.write("{\"$ref\":\"");
        object = this.references.get(object).toString();
        this.out.write((String)object);
        this.out.write("\"}");
    }

    public boolean checkValue(SerializeFilterable serializeFilterable) {
        return this.valueFilters != null && this.valueFilters.size() > 0 || this.contextValueFilters != null && this.contextValueFilters.size() > 0 || serializeFilterable.valueFilters != null && serializeFilterable.valueFilters.size() > 0 || serializeFilterable.contextValueFilters != null && serializeFilterable.contextValueFilters.size() > 0 || this.out.writeNonStringValueAsString;
    }

    public boolean hasNameFilters(SerializeFilterable serializeFilterable) {
        return this.nameFilters != null && this.nameFilters.size() > 0 || serializeFilterable.nameFilters != null && serializeFilterable.nameFilters.size() > 0;
    }

    public boolean hasPropertyFilters(SerializeFilterable serializeFilterable) {
        return this.propertyFilters != null && this.propertyFilters.size() > 0 || serializeFilterable.propertyFilters != null && serializeFilterable.propertyFilters.size() > 0;
    }

    public int getIndentCount() {
        return this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void decrementIdent() {
        --this.indentCount;
    }

    public void println() {
        this.out.write(10);
        for (int i2 = 0; i2 < this.indentCount; ++i2) {
            this.out.write(this.indent);
        }
    }

    public SerializeWriter getWriter() {
        return this.out;
    }

    public String toString() {
        return this.out.toString();
    }

    public void config(SerializerFeature serializerFeature, boolean bl) {
        this.out.config(serializerFeature, bl);
    }

    public boolean isEnabled(SerializerFeature serializerFeature) {
        return this.out.isEnabled(serializerFeature);
    }

    public void writeNull() {
        this.out.writeNull();
    }

    public SerializeConfig getMapping() {
        return this.config;
    }

    public static void write(Writer writer, Object object) {
        SerializeWriter serializeWriter = new SerializeWriter();
        try {
            JSONSerializer jSONSerializer = new JSONSerializer(serializeWriter);
            jSONSerializer.write(object);
            serializeWriter.writeTo(writer);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        finally {
            serializeWriter.close();
        }
    }

    public static void write(SerializeWriter object, Object object2) {
        object = new JSONSerializer((SerializeWriter)object);
        ((JSONSerializer)object).write(object2);
    }

    public final void write(Object object) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        Object object2 = object.getClass();
        object2 = this.getObjectWriter((Class<?>)object2);
        try {
            object2.write(this, object, null, null, 0);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeWithFieldName(Object object, Object object2) {
        this.writeWithFieldName(object, object2, null, 0);
    }

    protected final void writeKeyValue(char c2, String string, Object object) {
        if (c2 != '\u0000') {
            this.out.write(c2);
        }
        this.out.writeFieldName(string);
        this.write(object);
    }

    public final void writeWithFieldName(Object object, Object object2, Type type, int n2) {
        try {
            if (object == null) {
                this.out.writeNull();
                return;
            }
            Object object3 = object.getClass();
            object3 = this.getObjectWriter((Class<?>)object3);
            object3.write(this, object, object2, type, n2);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeWithFormat(Object object, String string) {
        block10: {
            block12: {
                byte[] byArray;
                block11: {
                    if (object instanceof Date) {
                        DateFormat dateFormat = this.getDateFormat();
                        if (dateFormat == null) {
                            dateFormat = new SimpleDateFormat(string, this.locale);
                            dateFormat.setTimeZone(this.timeZone);
                        }
                        object = dateFormat.format((Date)object);
                        this.out.writeString((String)object);
                        return;
                    }
                    if (!(object instanceof byte[])) break block10;
                    byArray = (byte[])object;
                    if (!"gzip".equals(string) && !"gzip,base64".equals(string)) break block11;
                    object = null;
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        object = byArray.length < 512 ? new GZIPOutputStream((OutputStream)byteArrayOutputStream, byArray.length) : new GZIPOutputStream(byteArrayOutputStream);
                        ((FilterOutputStream)object).write(byArray);
                        ((GZIPOutputStream)object).finish();
                        this.out.writeByteArray(byteArrayOutputStream.toByteArray());
                    }
                    catch (IOException iOException) {
                        try {
                            throw new JSONException("write gzipBytes error", iOException);
                        }
                        catch (Throwable throwable) {
                            IOUtils.close(object);
                            throw throwable;
                        }
                    }
                    IOUtils.close((Closeable)object);
                    break block12;
                }
                if ("hex".equals(string)) {
                    this.out.writeHex(byArray);
                    return;
                }
                this.out.writeByteArray(byArray);
            }
            return;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            object = collection.iterator();
            this.out.write(91);
            for (int i2 = 0; i2 < collection.size(); ++i2) {
                Object e2 = object.next();
                if (i2 != 0) {
                    this.out.write(44);
                }
                this.writeWithFormat(e2, string);
            }
            this.out.write(93);
            return;
        }
        this.write(object);
    }

    public final void write(String string) {
        StringCodec.instance.write(this, string);
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        return this.config.getObjectWriter(clazz);
    }

    public void close() {
        this.out.close();
    }
}

