/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.serializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONPath;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONStreamAware;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.DefaultJSONParser;
import com.aliyun.openservices.shade.com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.JSONSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ObjectSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeWriter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.IOUtils;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.TypeUtils;
import java.io.File;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiscCodec
implements ObjectDeserializer,
ObjectSerializer {
    private static boolean FILE_RELATIVE_PATH_SUPPORT = false;
    public static final MiscCodec instance = new MiscCodec();
    private static Method method_paths_get;
    private static boolean method_paths_get_error;

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type, int n2) {
        object3 = ((JSONSerializer)object).out;
        if (object2 == null) {
            ((SerializeWriter)object3).writeNull();
            return;
        }
        Class<?> clazz = object2.getClass();
        if (clazz == SimpleDateFormat.class) {
            clazz = ((SimpleDateFormat)object2).toPattern();
            if (((SerializeWriter)object3).isEnabled(SerializerFeature.WriteClassName) && object2.getClass() != type) {
                ((SerializeWriter)object3).write(123);
                ((SerializeWriter)object3).writeFieldName(JSON.DEFAULT_TYPE_KEY);
                ((JSONSerializer)object).write(object2.getClass().getName());
                ((SerializeWriter)object3).writeFieldValue(',', "val", (String)((Object)clazz));
                ((SerializeWriter)object3).write(125);
                return;
            }
            object = clazz;
        } else if (clazz == Class.class) {
            clazz = (Class)object2;
            object = clazz.getName();
        } else {
            if (clazz == InetSocketAddress.class) {
                clazz = (InetSocketAddress)object2;
                object2 = ((InetSocketAddress)((Object)clazz)).getAddress();
                ((SerializeWriter)object3).write(123);
                if (object2 != null) {
                    ((SerializeWriter)object3).writeFieldName("address");
                    ((JSONSerializer)object).write(object2);
                    ((SerializeWriter)object3).write(44);
                }
                ((SerializeWriter)object3).writeFieldName("port");
                ((SerializeWriter)object3).writeInt(((InetSocketAddress)((Object)clazz)).getPort());
                ((SerializeWriter)object3).write(125);
                return;
            }
            if (object2 instanceof File) {
                object = ((File)object2).getPath();
            } else if (object2 instanceof InetAddress) {
                object = ((InetAddress)object2).getHostAddress();
            } else if (object2 instanceof TimeZone) {
                clazz = (TimeZone)object2;
                object = ((TimeZone)((Object)clazz)).getID();
            } else if (object2 instanceof Currency) {
                clazz = (Currency)object2;
                object = ((Currency)((Object)clazz)).getCurrencyCode();
            } else {
                if (object2 instanceof JSONStreamAware) {
                    clazz = (JSONStreamAware)object2;
                    clazz.writeJSONString((Appendable)object3);
                    return;
                }
                if (object2 instanceof Iterator) {
                    clazz = (Iterator)object2;
                    this.writeIterator((JSONSerializer)object, (SerializeWriter)object3, (Iterator<?>)((Object)clazz));
                    return;
                }
                if (object2 instanceof Iterable) {
                    clazz = ((Iterable)object2).iterator();
                    this.writeIterator((JSONSerializer)object, (SerializeWriter)object3, (Iterator<?>)((Object)clazz));
                    return;
                }
                if (object2 instanceof Map.Entry) {
                    clazz = (Map.Entry)object2;
                    object2 = clazz.getKey();
                    type = clazz.getValue();
                    if (object2 instanceof String) {
                        object2 = (String)object2;
                        if (type instanceof String) {
                            object = (String)((Object)type);
                            ((SerializeWriter)object3).writeFieldValueStringWithDoubleQuoteCheck('{', (String)object2, (String)object);
                        } else {
                            ((SerializeWriter)object3).write(123);
                            ((SerializeWriter)object3).writeFieldName((String)object2);
                            ((JSONSerializer)object).write(type);
                        }
                    } else {
                        ((SerializeWriter)object3).write(123);
                        ((JSONSerializer)object).write(object2);
                        ((SerializeWriter)object3).write(58);
                        ((JSONSerializer)object).write(type);
                    }
                    ((SerializeWriter)object3).write(125);
                    return;
                }
                if (object2.getClass().getName().equals("net.sf.json.JSONNull")) {
                    ((SerializeWriter)object3).writeNull();
                    return;
                }
                if (object2 instanceof Node) {
                    object = MiscCodec.toString((Node)object2);
                } else {
                    throw new JSONException("not support class : " + clazz);
                }
            }
        }
        ((SerializeWriter)object3).writeString((String)object);
    }

    private static String toString(Node object) {
        try {
            Object object2 = TransformerFactory.newInstance();
            object2 = ((TransformerFactory)object2).newTransformer();
            object = new DOMSource((Node)object);
            StringWriter stringWriter = new StringWriter();
            ((Transformer)object2).transform((Source)object, new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException transformerException) {
            throw new JSONException("xml node to string error", transformerException);
        }
    }

    protected void writeIterator(JSONSerializer jSONSerializer, SerializeWriter serializeWriter, Iterator<?> iterator) {
        int n2 = 0;
        serializeWriter.write(91);
        while (iterator.hasNext()) {
            if (n2 != 0) {
                serializeWriter.write(44);
            }
            Object obj = iterator.next();
            jSONSerializer.write(obj);
            ++n2;
        }
        serializeWriter.write(93);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type type, Object object2) {
        Object object3;
        String string;
        Object object4;
        object2 = ((DefaultJSONParser)object).lexer;
        if (type == InetSocketAddress.class) {
            if (object2.token() == 8) {
                object2.nextToken();
                return null;
            }
            ((DefaultJSONParser)object).accept(12);
            InetAddress inetAddress = null;
            int n2 = 0;
            while (true) {
                String string2 = object2.stringVal();
                object2.nextToken(17);
                if (string2.equals("address")) {
                    ((DefaultJSONParser)object).accept(17);
                    inetAddress = ((DefaultJSONParser)object).parseObject(InetAddress.class);
                } else if (string2.equals("port")) {
                    ((DefaultJSONParser)object).accept(17);
                    if (object2.token() != 2) {
                        throw new JSONException("port is not int");
                    }
                    n2 = object2.intValue();
                    object2.nextToken();
                } else {
                    ((DefaultJSONParser)object).accept(17);
                    ((DefaultJSONParser)object).parse();
                }
                if (object2.token() != 16) break;
                object2.nextToken();
            }
            ((DefaultJSONParser)object).accept(13);
            return (T)new InetSocketAddress(inetAddress, n2);
        }
        if (((DefaultJSONParser)object).resolveStatus == 2) {
            ((DefaultJSONParser)object).resolveStatus = 0;
            ((DefaultJSONParser)object).accept(16);
            if (object2.token() == 4) {
                if (!"val".equals(object2.stringVal())) {
                    throw new JSONException("syntax error");
                }
            } else {
                throw new JSONException("syntax error");
            }
            object2.nextToken();
            ((DefaultJSONParser)object).accept(17);
            object4 = ((DefaultJSONParser)object).parse();
            ((DefaultJSONParser)object).accept(13);
        } else {
            object4 = ((DefaultJSONParser)object).parse();
        }
        if (object4 == null) {
            string = null;
        } else if (object4 instanceof String) {
            string = (String)object4;
        } else {
            if (object4 instanceof JSONObject) {
                JSONObject jSONObject = (JSONObject)object4;
                if (type == Currency.class) {
                    object = jSONObject.getString("currency");
                    if (object != null) {
                        return (T)Currency.getInstance((String)object);
                    }
                    object = jSONObject.getString("currencyCode");
                    if (object != null) {
                        return (T)Currency.getInstance((String)object);
                    }
                }
                if (type == Map.Entry.class) {
                    return (T)jSONObject.entrySet().iterator().next();
                }
                return jSONObject.toJavaObject(type);
            }
            throw new JSONException("expect string");
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        if (type == UUID.class) {
            return (T)UUID.fromString(string);
        }
        if (type == URI.class) {
            return (T)URI.create(string);
        }
        if (type == URL.class) {
            try {
                return (T)new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new JSONException("create url error", malformedURLException);
            }
        }
        if (type == Pattern.class) {
            return (T)Pattern.compile(string);
        }
        if (type == Locale.class) {
            return (T)TypeUtils.toLocale(string);
        }
        if (type == SimpleDateFormat.class) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, object2.getLocale());
            simpleDateFormat.setTimeZone(object2.getTimeZone());
            return (T)simpleDateFormat;
        }
        if (type == InetAddress.class || type == Inet4Address.class || type == Inet6Address.class) {
            try {
                return (T)InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new JSONException("deserialize inet adress error", unknownHostException);
            }
        }
        if (type == File.class) {
            if (string.indexOf("..") >= 0 && !FILE_RELATIVE_PATH_SUPPORT) {
                throw new JSONException("file relative path not support.");
            }
            return (T)new File(string);
        }
        if (type == TimeZone.class) {
            return (T)TimeZone.getTimeZone(string);
        }
        if (type instanceof ParameterizedType) {
            object3 = (ParameterizedType)type;
            type = object3.getRawType();
        }
        if (type == Class.class) {
            return (T)TypeUtils.loadClass(string, ((DefaultJSONParser)object).getConfig().getDefaultClassLoader(), false);
        }
        if (type == Charset.class) {
            return (T)Charset.forName(string);
        }
        if (type == Currency.class) {
            return (T)Currency.getInstance(string);
        }
        if (type == JSONPath.class) {
            return (T)new JSONPath(string);
        }
        if (type instanceof Class) {
            object3 = ((Class)type).getName();
            if (((String)object3).equals("java.nio.file.Path")) {
                try {
                    if (method_paths_get == null && !method_paths_get_error) {
                        object = TypeUtils.loadClass("java.nio.file.Paths");
                        method_paths_get = ((Class)object).getMethod("get", String.class, String[].class);
                    }
                    if (method_paths_get != null) {
                        return (T)method_paths_get.invoke(null, string, new String[0]);
                    }
                    throw new JSONException("Path deserialize erorr");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    method_paths_get_error = true;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new JSONException("Path deserialize erorr", illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new JSONException("Path deserialize erorr", invocationTargetException);
                }
            }
            throw new JSONException("MiscCodec not support " + (String)object3);
        }
        throw new JSONException("MiscCodec not support " + type.toString());
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }

    static {
        method_paths_get_error = false;
        FILE_RELATIVE_PATH_SUPPORT = "true".equals(IOUtils.getStringProperty("fastjson.deserializer.fileRelativePathSupport"));
    }
}

