/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.serializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.AfterFilter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.BeanContext;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.BeforeFilter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ContextValueFilter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.JSONSerializer;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.LabelFilter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.NameFilter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.PropertyFilter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.PropertyPreFilter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeFilter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.ValueFilter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerializeFilterable {
    protected List<BeforeFilter> beforeFilters = null;
    protected List<AfterFilter> afterFilters = null;
    protected List<PropertyFilter> propertyFilters = null;
    protected List<ValueFilter> valueFilters = null;
    protected List<NameFilter> nameFilters = null;
    protected List<PropertyPreFilter> propertyPreFilters = null;
    protected List<LabelFilter> labelFilters = null;
    protected List<ContextValueFilter> contextValueFilters = null;
    protected boolean writeDirect = true;

    public List<BeforeFilter> getBeforeFilters() {
        if (this.beforeFilters == null) {
            this.beforeFilters = new ArrayList<BeforeFilter>();
            this.writeDirect = false;
        }
        return this.beforeFilters;
    }

    public List<AfterFilter> getAfterFilters() {
        if (this.afterFilters == null) {
            this.afterFilters = new ArrayList<AfterFilter>();
            this.writeDirect = false;
        }
        return this.afterFilters;
    }

    public List<NameFilter> getNameFilters() {
        if (this.nameFilters == null) {
            this.nameFilters = new ArrayList<NameFilter>();
            this.writeDirect = false;
        }
        return this.nameFilters;
    }

    public List<PropertyPreFilter> getPropertyPreFilters() {
        if (this.propertyPreFilters == null) {
            this.propertyPreFilters = new ArrayList<PropertyPreFilter>();
            this.writeDirect = false;
        }
        return this.propertyPreFilters;
    }

    public List<LabelFilter> getLabelFilters() {
        if (this.labelFilters == null) {
            this.labelFilters = new ArrayList<LabelFilter>();
            this.writeDirect = false;
        }
        return this.labelFilters;
    }

    public List<PropertyFilter> getPropertyFilters() {
        if (this.propertyFilters == null) {
            this.propertyFilters = new ArrayList<PropertyFilter>();
            this.writeDirect = false;
        }
        return this.propertyFilters;
    }

    public List<ContextValueFilter> getContextValueFilters() {
        if (this.contextValueFilters == null) {
            this.contextValueFilters = new ArrayList<ContextValueFilter>();
            this.writeDirect = false;
        }
        return this.contextValueFilters;
    }

    public List<ValueFilter> getValueFilters() {
        if (this.valueFilters == null) {
            this.valueFilters = new ArrayList<ValueFilter>();
            this.writeDirect = false;
        }
        return this.valueFilters;
    }

    public void addFilter(SerializeFilter serializeFilter) {
        if (serializeFilter == null) {
            return;
        }
        if (serializeFilter instanceof PropertyPreFilter) {
            this.getPropertyPreFilters().add((PropertyPreFilter)serializeFilter);
        }
        if (serializeFilter instanceof NameFilter) {
            this.getNameFilters().add((NameFilter)serializeFilter);
        }
        if (serializeFilter instanceof ValueFilter) {
            this.getValueFilters().add((ValueFilter)serializeFilter);
        }
        if (serializeFilter instanceof ContextValueFilter) {
            this.getContextValueFilters().add((ContextValueFilter)serializeFilter);
        }
        if (serializeFilter instanceof PropertyFilter) {
            this.getPropertyFilters().add((PropertyFilter)serializeFilter);
        }
        if (serializeFilter instanceof BeforeFilter) {
            this.getBeforeFilters().add((BeforeFilter)serializeFilter);
        }
        if (serializeFilter instanceof AfterFilter) {
            this.getAfterFilters().add((AfterFilter)serializeFilter);
        }
        if (serializeFilter instanceof LabelFilter) {
            this.getLabelFilters().add((LabelFilter)serializeFilter);
        }
    }

    public boolean applyName(JSONSerializer jSONSerializer, Object object, String string) {
        if (jSONSerializer.propertyPreFilters != null) {
            for (PropertyPreFilter propertyPreFilter : jSONSerializer.propertyPreFilters) {
                if (propertyPreFilter.apply(jSONSerializer, object, string)) continue;
                return false;
            }
        }
        if (this.propertyPreFilters != null) {
            for (PropertyPreFilter propertyPreFilter : this.propertyPreFilters) {
                if (propertyPreFilter.apply(jSONSerializer, object, string)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean apply(JSONSerializer iterator, Object object, String string, Object object2) {
        if (((SerializeFilterable)((Object)iterator)).propertyFilters != null) {
            for (PropertyFilter propertyFilter : ((SerializeFilterable)((Object)iterator)).propertyFilters) {
                if (propertyFilter.apply(object, string, object2)) continue;
                return false;
            }
        }
        if (this.propertyFilters != null) {
            for (PropertyFilter propertyFilter : this.propertyFilters) {
                if (propertyFilter.apply(object, string, object2)) continue;
                return false;
            }
        }
        return true;
    }

    protected String processKey(JSONSerializer iterator, Object object, String string, Object object2) {
        if (((SerializeFilterable)((Object)iterator)).nameFilters != null) {
            for (NameFilter nameFilter : ((SerializeFilterable)((Object)iterator)).nameFilters) {
                string = nameFilter.process(object, string, object2);
            }
        }
        if (this.nameFilters != null) {
            for (NameFilter nameFilter : this.nameFilters) {
                string = nameFilter.process(object, string, object2);
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    protected Object processValue(JSONSerializer jSONSerializer, BeanContext beanContext, Object object, String string, Object object2) {
        List<ValueFilter> list;
        if (object2 != null) {
            if ((jSONSerializer.out.writeNonStringValueAsString || beanContext != null && (beanContext.getFeatures() & SerializerFeature.WriteNonStringValueAsString.mask) != 0) && (object2 instanceof Number || object2 instanceof Boolean)) {
                void var6_8;
                Object object32 = null;
                if (object2 instanceof Number && beanContext != null) {
                    String string2 = beanContext.getFormat();
                }
                object2 = var6_8 != null ? new DecimalFormat((String)var6_8).format(object2) : object2.toString();
            } else if (beanContext != null && beanContext.isJsonDirect()) {
                String string3 = (String)object2;
                object2 = JSON.parse(string3);
            }
        }
        if (jSONSerializer.valueFilters != null) {
            for (Iterator<ContextValueFilter> iterator : jSONSerializer.valueFilters) {
                object2 = iterator.process(object, string, object2);
            }
        }
        if ((list = this.valueFilters) != null) {
            for (ValueFilter valueFilter : list) {
                object2 = valueFilter.process(object, string, object2);
            }
        }
        if (jSONSerializer.contextValueFilters != null) {
            for (ContextValueFilter contextValueFilter : jSONSerializer.contextValueFilters) {
                object2 = contextValueFilter.process(beanContext, object, string, object2);
            }
        }
        if (this.contextValueFilters != null) {
            for (ContextValueFilter contextValueFilter : this.contextValueFilters) {
                object2 = contextValueFilter.process(beanContext, object, string, object2);
            }
        }
        return object2;
    }

    protected boolean writeDirect(JSONSerializer jSONSerializer) {
        return jSONSerializer.out.writeDirect && this.writeDirect && jSONSerializer.writeDirect;
    }
}

