/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.serializer;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.IOUtils;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.RyuDouble;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.RyuFloat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializeWriter
extends Writer {
    private static final ThreadLocal<char[]> bufLocal = new ThreadLocal();
    private static final ThreadLocal<byte[]> bytesBufLocal = new ThreadLocal();
    protected char[] buf;
    protected int count;
    protected int features;
    private final Writer writer;
    protected boolean useSingleQuotes;
    protected boolean quoteFieldNames;
    protected boolean sortField;
    protected boolean disableCircularReferenceDetect;
    protected boolean beanToArray;
    protected boolean writeNonStringValueAsString;
    protected boolean notWriteDefaultValue;
    protected boolean writeEnumUsingName;
    protected boolean writeEnumUsingToString;
    protected boolean writeDirect;
    protected char keySeperator;
    protected int maxBufSize = -1;
    protected boolean browserSecure;
    protected long sepcialBits;
    static final int nonDirectFeatures = 0 | SerializerFeature.UseSingleQuotes.mask | SerializerFeature.BrowserCompatible.mask | SerializerFeature.PrettyFormat.mask | SerializerFeature.WriteEnumUsingToString.mask | SerializerFeature.WriteNonStringValueAsString.mask | SerializerFeature.WriteSlashAsSpecial.mask | SerializerFeature.IgnoreErrorGetter.mask | SerializerFeature.WriteClassName.mask | SerializerFeature.NotWriteDefaultValue.mask;

    public SerializeWriter() {
        this((Writer)null);
    }

    public SerializeWriter(Writer writer) {
        this(writer, JSON.DEFAULT_GENERATE_FEATURE, SerializerFeature.EMPTY);
    }

    public SerializeWriter(SerializerFeature ... serializerFeatureArray) {
        this((Writer)null, serializerFeatureArray);
    }

    public SerializeWriter(Writer writer, SerializerFeature ... serializerFeatureArray) {
        this(writer, 0, serializerFeatureArray);
    }

    public SerializeWriter(Writer writer, int n2, SerializerFeature ... serializerFeatureArray) {
        this.writer = writer;
        this.buf = bufLocal.get();
        if (this.buf != null) {
            bufLocal.set(null);
        } else {
            this.buf = new char[2048];
        }
        int n3 = n2;
        SerializerFeature[] serializerFeatureArray2 = serializerFeatureArray;
        int n4 = serializerFeatureArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            SerializerFeature serializerFeature = serializerFeatureArray2[i2];
            n3 |= serializerFeature.getMask();
        }
        this.features = n3;
        this.computeFeatures();
    }

    public final int getMaxBufSize() {
        return this.maxBufSize;
    }

    public final void setMaxBufSize(int n2) {
        if (n2 < this.buf.length) {
            throw new JSONException("must > " + this.buf.length);
        }
        this.maxBufSize = n2;
    }

    public final int getBufferLength() {
        return this.buf.length;
    }

    public SerializeWriter(int n2) {
        this(null, n2);
    }

    public SerializeWriter(Writer writer, int n2) {
        this.writer = writer;
        if (n2 <= 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.buf = new char[n2];
        this.computeFeatures();
    }

    public final void config(SerializerFeature serializerFeature, boolean bl) {
        if (bl) {
            this.features |= serializerFeature.getMask();
            if (serializerFeature == SerializerFeature.WriteEnumUsingToString) {
                this.features &= ~SerializerFeature.WriteEnumUsingName.getMask();
            } else if (serializerFeature == SerializerFeature.WriteEnumUsingName) {
                this.features &= ~SerializerFeature.WriteEnumUsingToString.getMask();
            }
        } else {
            this.features &= ~serializerFeature.getMask();
        }
        this.computeFeatures();
    }

    protected final void computeFeatures() {
        this.quoteFieldNames = (this.features & SerializerFeature.QuoteFieldNames.mask) != 0;
        this.useSingleQuotes = (this.features & SerializerFeature.UseSingleQuotes.mask) != 0;
        this.sortField = (this.features & SerializerFeature.SortField.mask) != 0;
        this.disableCircularReferenceDetect = (this.features & SerializerFeature.DisableCircularReferenceDetect.mask) != 0;
        this.beanToArray = (this.features & SerializerFeature.BeanToArray.mask) != 0;
        this.writeNonStringValueAsString = (this.features & SerializerFeature.WriteNonStringValueAsString.mask) != 0;
        this.notWriteDefaultValue = (this.features & SerializerFeature.NotWriteDefaultValue.mask) != 0;
        this.writeEnumUsingName = (this.features & SerializerFeature.WriteEnumUsingName.mask) != 0;
        this.writeEnumUsingToString = (this.features & SerializerFeature.WriteEnumUsingToString.mask) != 0;
        this.writeDirect = this.quoteFieldNames && (this.features & nonDirectFeatures) == 0 && (this.beanToArray || this.writeEnumUsingName);
        this.keySeperator = (char)(this.useSingleQuotes ? 39 : 34);
        boolean bl = this.browserSecure = (this.features & SerializerFeature.BrowserSecure.mask) != 0;
        this.sepcialBits = this.browserSecure ? 5764610843043954687L : ((this.features & SerializerFeature.WriteSlashAsSpecial.mask) != 0 ? 140758963191807L : 0x4FFFFFFFFL);
    }

    public final boolean isSortField() {
        return this.sortField;
    }

    public final boolean isNotWriteDefaultValue() {
        return this.notWriteDefaultValue;
    }

    public final boolean isEnabled(SerializerFeature serializerFeature) {
        return (this.features & serializerFeature.mask) != 0;
    }

    public final boolean isEnabled(int n2) {
        return (this.features & n2) != 0;
    }

    @Override
    public final void write(int n2) {
        int n3 = this.count + 1;
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                this.flush();
                n3 = 1;
            }
        }
        this.buf[this.count] = (char)n2;
        this.count = n3;
    }

    @Override
    public final void write(char[] cArray, int n2, int n3) {
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n4);
            } else {
                do {
                    n4 = this.buf.length - this.count;
                    System.arraycopy(cArray, n2, this.buf, this.count, n4);
                    this.count = this.buf.length;
                    this.flush();
                    n2 += n4;
                } while ((n3 -= n4) > this.buf.length);
                n4 = n3;
            }
        }
        System.arraycopy(cArray, n2, this.buf, this.count, n3);
        this.count = n4;
    }

    public final void expandCapacity(int n2) {
        if (this.maxBufSize != -1 && n2 >= this.maxBufSize) {
            throw new JSONException("serialize exceeded MAX_OUTPUT_LENGTH=" + this.maxBufSize + ", minimumCapacity=" + n2);
        }
        int n3 = this.buf.length + (this.buf.length >> 1) + 1;
        if (n3 < n2) {
            n3 = n2;
        }
        char[] cArray = new char[n3];
        System.arraycopy(this.buf, 0, cArray, 0, this.count);
        this.buf = cArray;
    }

    @Override
    public final SerializeWriter append(CharSequence charSequence) {
        charSequence = charSequence == null ? "null" : charSequence.toString();
        this.write((String)charSequence, 0, ((String)charSequence).length());
        return this;
    }

    @Override
    public final SerializeWriter append(CharSequence charSequence, int n2, int n3) {
        charSequence = (charSequence == null ? "null" : charSequence).subSequence(n2, n3).toString();
        this.write((String)charSequence, 0, ((String)charSequence).length());
        return this;
    }

    @Override
    public final SerializeWriter append(char c2) {
        this.write(c2);
        return this;
    }

    @Override
    public final void write(String string, int n2, int n3) {
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n4);
            } else {
                do {
                    n4 = this.buf.length - this.count;
                    int n5 = n2;
                    string.getChars(n5, n5 + n4, this.buf, this.count);
                    this.count = this.buf.length;
                    this.flush();
                    n2 += n4;
                } while ((n3 -= n4) > this.buf.length);
                n4 = n3;
            }
        }
        int n6 = n2;
        string.getChars(n6, n6 + n3, this.buf, this.count);
        this.count = n4;
    }

    public final void writeTo(Writer writer) {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        writer.write(this.buf, 0, this.count);
    }

    public final void writeTo(OutputStream outputStream, String string) {
        this.writeTo(outputStream, Charset.forName(string));
    }

    public final void writeTo(OutputStream outputStream, Charset charset) {
        this.writeToEx(outputStream, charset);
    }

    public final int writeToEx(OutputStream outputStream, Charset object) {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        if (object == IOUtils.UTF8) {
            return this.encodeToUTF8(outputStream);
        }
        object = new String(this.buf, 0, this.count).getBytes((Charset)object);
        outputStream.write((byte[])object);
        return ((Object)object).length;
    }

    public final char[] toCharArray() {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        char[] cArray = new char[this.count];
        System.arraycopy(this.buf, 0, cArray, 0, this.count);
        return cArray;
    }

    public final char[] toCharArrayForSpringWebSocket() {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        char[] cArray = new char[this.count - 2];
        System.arraycopy(this.buf, 1, cArray, 0, this.count - 2);
        return cArray;
    }

    public final byte[] toBytes(String string) {
        return this.toBytes(string == null || "UTF-8".equals(string) ? IOUtils.UTF8 : Charset.forName(string));
    }

    public final byte[] toBytes(Charset charset) {
        if (this.writer != null) {
            throw new UnsupportedOperationException("writer not null");
        }
        if (charset == IOUtils.UTF8) {
            return this.encodeToUTF8Bytes();
        }
        return new String(this.buf, 0, this.count).getBytes(charset);
    }

    private int encodeToUTF8(OutputStream outputStream) {
        int n2 = (int)((double)this.count * 3.0);
        byte[] byArray = bytesBufLocal.get();
        if (byArray == null) {
            byArray = new byte[8192];
            bytesBufLocal.set(byArray);
        }
        if (byArray.length < n2) {
            byArray = new byte[n2];
        }
        n2 = IOUtils.encodeUTF8(this.buf, 0, this.count, byArray);
        outputStream.write(byArray, 0, n2);
        return n2;
    }

    private byte[] encodeToUTF8Bytes() {
        int n2 = (int)((double)this.count * 3.0);
        byte[] byArray = bytesBufLocal.get();
        if (byArray == null) {
            byArray = new byte[8192];
            bytesBufLocal.set(byArray);
        }
        if (byArray.length < n2) {
            byArray = new byte[n2];
        }
        n2 = IOUtils.encodeUTF8(this.buf, 0, this.count, byArray);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public final int size() {
        return this.count;
    }

    public final String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public final void close() {
        if (this.writer != null && this.count > 0) {
            this.flush();
        }
        if (this.buf.length <= 131072) {
            bufLocal.set(this.buf);
        }
        this.buf = null;
    }

    @Override
    public final void write(String string) {
        if (string == null) {
            this.writeNull();
            return;
        }
        this.write(string, 0, string.length());
    }

    public final void writeInt(int n2) {
        if (n2 == Integer.MIN_VALUE) {
            this.write("-2147483648");
            return;
        }
        int n3 = n2 < 0 ? IOUtils.stringSize(-n2) + 1 : IOUtils.stringSize(n2);
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n4);
            } else {
                char[] cArray = new char[n3];
                IOUtils.getChars(n2, n3, cArray);
                this.write(cArray, 0, cArray.length);
                return;
            }
        }
        IOUtils.getChars(n2, n4, this.buf);
        this.count = n4;
    }

    public final void writeByteArray(byte[] byArray) {
        int n2;
        if (this.isEnabled(SerializerFeature.WriteClassName.mask)) {
            this.writeHex(byArray);
            return;
        }
        int n3 = byArray.length;
        int n4 = n2 = this.useSingleQuotes ? 39 : 34;
        if (n3 == 0) {
            String string = this.useSingleQuotes ? "''" : "\"\"";
            this.write(string);
            return;
        }
        char[] cArray = IOUtils.CA;
        int n5 = n3 / 3 * 3;
        int n6 = (n3 - 1) / 3 + 1 << 2;
        int n7 = this.count;
        if ((n6 = this.count + n6 + 2) > this.buf.length) {
            if (this.writer != null) {
                this.write(n2);
                int n8 = 0;
                while (n8 < n5) {
                    n7 = (byArray[n8++] & 0xFF) << 16 | (byArray[n8++] & 0xFF) << 8 | byArray[n8++] & 0xFF;
                    this.write(cArray[n7 >>> 18 & 0x3F]);
                    this.write(cArray[n7 >>> 12 & 0x3F]);
                    this.write(cArray[n7 >>> 6 & 0x3F]);
                    this.write(cArray[n7 & 0x3F]);
                }
                n8 = n3 - n5;
                if (n8 > 0) {
                    n7 = (byArray[n5] & 0xFF) << 10 | (n8 == 2 ? (byArray[n3 - 1] & 0xFF) << 2 : 0);
                    this.write(cArray[n7 >> 12]);
                    this.write(cArray[n7 >>> 6 & 0x3F]);
                    this.write(n8 == 2 ? cArray[n7 & 0x3F] : 61);
                    this.write(61);
                }
                this.write(n2);
                return;
            }
            this.expandCapacity(n6);
        }
        this.count = n6;
        this.buf[n7++] = n2;
        int n9 = 0;
        while (n9 < n5) {
            int n10 = (byArray[n9++] & 0xFF) << 16 | (byArray[n9++] & 0xFF) << 8 | byArray[n9++] & 0xFF;
            this.buf[n7++] = cArray[n10 >>> 18 & 0x3F];
            this.buf[n7++] = cArray[n10 >>> 12 & 0x3F];
            this.buf[n7++] = cArray[n10 >>> 6 & 0x3F];
            this.buf[n7++] = cArray[n10 & 0x3F];
        }
        n9 = n3 - n5;
        if (n9 > 0) {
            n7 = (byArray[n5] & 0xFF) << 10 | (n9 == 2 ? (byArray[n3 - 1] & 0xFF) << 2 : 0);
            this.buf[n6 - 5] = cArray[n7 >> 12];
            this.buf[n6 - 4] = cArray[n7 >>> 6 & 0x3F];
            this.buf[n6 - 3] = n9 == 2 ? cArray[n7 & 0x3F] : 61;
            this.buf[n6 - 2] = 61;
        }
        this.buf[n6 - 1] = n2;
    }

    public final void writeHex(byte[] byArray) {
        int n2 = this.count + (byArray.length << 1) + 3;
        if (n2 > this.buf.length) {
            if (this.writer != null) {
                char[] cArray = new char[byArray.length + 3];
                int n3 = 0;
                ++n3;
                cArray[0] = 120;
                ++n3;
                cArray[1] = 39;
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    int n4 = byArray[i2];
                    int n5 = n4 & 0xFF;
                    n4 = n5 >> 4;
                    int n6 = n3++;
                    int n7 = n4;
                    cArray[n6] = (char)(n7 + (n7 < 10 ? 48 : 55));
                    int n8 = n3++;
                    int n9 = n5 &= 0xF;
                    cArray[n8] = (char)(n9 + (n9 < 10 ? 48 : 55));
                }
                cArray[n3] = 39;
                try {
                    this.writer.write(cArray);
                    return;
                }
                catch (IOException iOException) {
                    throw new JSONException("writeBytes error.", iOException);
                }
            }
            this.expandCapacity(n2);
        }
        this.buf[this.count++] = 120;
        this.buf[this.count++] = 39;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byte by = byArray[n2];
            int n10 = by & 0xFF;
            int n11 = n10 >> 4;
            int n12 = n10 & 0xF;
            int n13 = n11;
            this.buf[this.count++] = (char)(n13 + (n13 < 10 ? 48 : 55));
            int n14 = n12;
            this.buf[this.count++] = (char)(n14 + (n14 < 10 ? 48 : 55));
        }
        this.buf[this.count++] = 39;
    }

    public final void writeFloat(float f2, boolean bl) {
        float f3 = f2;
        if (f3 != f3 || f2 == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
            this.writeNull();
            return;
        }
        int n2 = this.count + 15;
        if (n2 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n2);
            } else {
                String string = RyuFloat.toString(f2);
                this.write(string, 0, string.length());
                if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                    this.write(70);
                }
                return;
            }
        }
        int n3 = RyuFloat.toString(f2, this.buf, this.count);
        this.count += n3;
        if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
            this.write(70);
        }
    }

    public final void writeDouble(double d2, boolean bl) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            this.writeNull();
            return;
        }
        int n2 = this.count + 24;
        if (n2 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n2);
            } else {
                String string = RyuDouble.toString(d2);
                this.write(string, 0, string.length());
                if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
                    this.write(68);
                }
                return;
            }
        }
        int n3 = RyuDouble.toString(d2, this.buf, this.count);
        this.count += n3;
        if (bl && this.isEnabled(SerializerFeature.WriteClassName)) {
            this.write(68);
        }
    }

    public final void writeEnum(Enum<?> enum_) {
        if (enum_ == null) {
            this.writeNull();
            return;
        }
        String string = null;
        if (this.writeEnumUsingName && !this.writeEnumUsingToString) {
            string = enum_.name();
        } else if (this.writeEnumUsingToString) {
            string = enum_.toString();
        }
        if (string != null) {
            int n2 = this.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
            this.write(n2);
            this.write(string);
            this.write(n2);
            return;
        }
        this.writeInt(enum_.ordinal());
    }

    public final void writeLongAndChar(long l2, char c2) {
        this.writeLong(l2);
        this.write(c2);
    }

    public final void writeLong(long l2) {
        boolean bl;
        boolean bl2 = bl = this.isEnabled(SerializerFeature.BrowserCompatible) && !this.isEnabled(SerializerFeature.WriteClassName) && (l2 > 0x1FFFFFFFFFFFFFL || l2 < -9007199254740991L);
        if (l2 == Long.MIN_VALUE) {
            if (bl) {
                this.write("\"-9223372036854775808\"");
                return;
            }
            this.write("-9223372036854775808");
            return;
        }
        int n2 = l2 < 0L ? IOUtils.stringSize(-l2) + 1 : IOUtils.stringSize(l2);
        int n3 = this.count + n2;
        if (bl) {
            n3 += 2;
        }
        if (n3 > this.buf.length) {
            if (this.writer == null) {
                this.expandCapacity(n3);
            } else {
                char[] cArray = new char[n2];
                IOUtils.getChars(l2, n2, cArray);
                if (bl) {
                    this.write(34);
                    this.write(cArray, 0, cArray.length);
                    this.write(34);
                    return;
                }
                this.write(cArray, 0, cArray.length);
                return;
            }
        }
        if (bl) {
            this.buf[this.count] = 34;
            IOUtils.getChars(l2, n3 - 1, this.buf);
            this.buf[n3 - 1] = 34;
        } else {
            IOUtils.getChars(l2, n3, this.buf);
        }
        this.count = n3;
    }

    public final void writeNull() {
        this.write("null");
    }

    public final void writeNull(SerializerFeature serializerFeature) {
        this.writeNull(0, serializerFeature.mask);
    }

    public final void writeNull(int n2, int n3) {
        if ((n2 & n3) == 0 && (this.features & n3) == 0) {
            this.writeNull();
            return;
        }
        if (n3 == SerializerFeature.WriteNullListAsEmpty.mask) {
            this.write("[]");
            return;
        }
        if (n3 == SerializerFeature.WriteNullStringAsEmpty.mask) {
            this.writeString("");
            return;
        }
        if (n3 == SerializerFeature.WriteNullBooleanAsFalse.mask) {
            this.write("false");
            return;
        }
        if (n3 == SerializerFeature.WriteNullNumberAsZero.mask) {
            this.write(48);
            return;
        }
        this.writeNull();
    }

    public final void writeStringWithDoubleQuote(String string, char c2) {
        int n2;
        int n3;
        int n4;
        if (string == null) {
            this.writeNull();
            if (c2 != '\u0000') {
                this.write(c2);
            }
            return;
        }
        int n5 = string.length();
        int n6 = this.count + n5 + 2;
        if (c2 != '\u0000') {
            ++n6;
        }
        if (n6 > this.buf.length) {
            if (this.writer != null) {
                this.write(34);
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c3 = string.charAt(i2);
                    if (this.isEnabled(SerializerFeature.BrowserSecure) && (c3 == '(' || c3 == ')' || c3 == '<' || c3 == '>')) {
                        this.write(92);
                        this.write(117);
                        this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                        this.write(IOUtils.DIGITS[c3 & 0xF]);
                        continue;
                    }
                    if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                        if (c3 == '\b' || c3 == '\f' || c3 == '\n' || c3 == '\r' || c3 == '\t' || c3 == '\"' || c3 == '/' || c3 == '\\') {
                            this.write(92);
                            this.write(IOUtils.replaceChars[c3]);
                            continue;
                        }
                        if (c3 < ' ') {
                            this.write(92);
                            this.write(117);
                            this.write(48);
                            this.write(48);
                            this.write(IOUtils.ASCII_CHARS[c3 << 1]);
                            this.write(IOUtils.ASCII_CHARS[(c3 << 1) + 1]);
                            continue;
                        }
                        if (c3 >= '\u007f') {
                            this.write(92);
                            this.write(117);
                            this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 & 0xF]);
                            continue;
                        }
                    } else if (c3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[c3] != 0 || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        if (IOUtils.specicalFlags_doubleQuotes[c3] == 4) {
                            this.write(117);
                            this.write(IOUtils.DIGITS[c3 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[c3 & 0xF]);
                            continue;
                        }
                        this.write(IOUtils.replaceChars[c3]);
                        continue;
                    }
                    this.write(c3);
                }
                this.write(34);
                if (c2 != '\u0000') {
                    this.write(c2);
                }
                return;
            }
            this.expandCapacity(n6);
        }
        int n7 = this.count + 1;
        int n8 = n7 + n5;
        this.buf[this.count] = 34;
        string.getChars(0, n5, this.buf, n7);
        this.count = n6;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            char c4;
            int n9;
            n5 = -1;
            for (n9 = n7; n9 < n8; ++n9) {
                c4 = this.buf[n9];
                if (c4 == '\"' || c4 == '/' || c4 == '\\') {
                    n5 = n9;
                    ++n6;
                    continue;
                }
                if (c4 == '\b' || c4 == '\f' || c4 == '\n' || c4 == '\r' || c4 == '\t') {
                    n5 = n9;
                    ++n6;
                    continue;
                }
                if (c4 < ' ') {
                    n5 = n9;
                    n6 += 5;
                    continue;
                }
                if (c4 < '\u007f') continue;
                n5 = n9;
                n6 += 5;
            }
            if (n6 > this.buf.length) {
                this.expandCapacity(n6);
            }
            this.count = n6;
            for (n9 = n5; n9 >= n7; --n9) {
                c4 = this.buf[n9];
                if (c4 == '\b' || c4 == '\f' || c4 == '\n' || c4 == '\r' || c4 == '\t') {
                    System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 2, n8 - n9 - 1);
                    this.buf[n9] = 92;
                    this.buf[n9 + 1] = IOUtils.replaceChars[c4];
                    ++n8;
                    continue;
                }
                if (c4 == '\"' || c4 == '/' || c4 == '\\') {
                    System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 2, n8 - n9 - 1);
                    this.buf[n9] = 92;
                    this.buf[n9 + 1] = c4;
                    ++n8;
                    continue;
                }
                if (c4 < ' ') {
                    System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 6, n8 - n9 - 1);
                    this.buf[n9] = 92;
                    this.buf[n9 + 1] = 117;
                    this.buf[n9 + 2] = 48;
                    this.buf[n9 + 3] = 48;
                    this.buf[n9 + 4] = IOUtils.ASCII_CHARS[c4 << 1];
                    this.buf[n9 + 5] = IOUtils.ASCII_CHARS[(c4 << 1) + 1];
                    n8 += 5;
                    continue;
                }
                if (c4 < '\u007f') continue;
                System.arraycopy(this.buf, n9 + 1, this.buf, n9 + 6, n8 - n9 - 1);
                this.buf[n9] = 92;
                this.buf[n9 + 1] = 117;
                this.buf[n9 + 2] = IOUtils.DIGITS[c4 >>> 12 & 0xF];
                this.buf[n9 + 3] = IOUtils.DIGITS[c4 >>> 8 & 0xF];
                this.buf[n9 + 4] = IOUtils.DIGITS[c4 >>> 4 & 0xF];
                this.buf[n9 + 5] = IOUtils.DIGITS[c4 & 0xF];
                n8 += 5;
            }
            if (c2 != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = c2;
                return;
            }
            this.buf[this.count - 1] = 34;
            return;
        }
        n5 = 0;
        int n10 = -1;
        int n11 = -1;
        int n12 = 0;
        for (n4 = n7; n4 < n8; ++n4) {
            n3 = this.buf[n4];
            if (n3 >= 93) {
                if (n3 < 127 || n3 != 8232 && n3 != 8233 && n3 >= 160) continue;
                if (n11 == -1) {
                    n11 = n4;
                }
                ++n5;
                n10 = n4;
                n12 = n3;
                n6 += 4;
                continue;
            }
            n2 = n3 < 64 && (this.sepcialBits & 1L << n3) != 0L || n3 == 92 ? 1 : 0;
            if (n2 == 0) continue;
            ++n5;
            n10 = n4;
            n12 = n3;
            if (n3 == 40 || n3 == 41 || n3 == 60 || n3 == 62 || n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                n6 += 4;
            }
            if (n11 != -1) continue;
            n11 = n4;
        }
        if (n5 > 0) {
            if ((n6 += n5) > this.buf.length) {
                this.expandCapacity(n6);
            }
            this.count = n6;
            if (n5 == 1) {
                if (n12 == 8232) {
                    n4 = n10 + 1;
                    n3 = n10 + 6;
                    n2 = n8 - n10 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n10] = 92;
                    this.buf[++n10] = 117;
                    this.buf[++n10] = 50;
                    this.buf[++n10] = 48;
                    this.buf[++n10] = 50;
                    this.buf[++n10] = 56;
                } else if (n12 == 8233) {
                    n4 = n10 + 1;
                    n3 = n10 + 6;
                    n2 = n8 - n10 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n10] = 92;
                    this.buf[++n10] = 117;
                    this.buf[++n10] = 50;
                    this.buf[++n10] = 48;
                    this.buf[++n10] = 50;
                    this.buf[++n10] = 57;
                } else if (n12 == 40 || n12 == 41 || n12 == 60 || n12 == 62) {
                    n4 = n10 + 1;
                    n3 = n10 + 6;
                    n2 = n8 - n10 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n10] = 92;
                    this.buf[++n10] = 117;
                    n5 = n12;
                    this.buf[++n10] = IOUtils.DIGITS[n5 >>> 12 & 0xF];
                    this.buf[++n10] = IOUtils.DIGITS[n5 >>> 8 & 0xF];
                    this.buf[++n10] = IOUtils.DIGITS[n5 >>> 4 & 0xF];
                    this.buf[++n10] = IOUtils.DIGITS[n5 & 0xF];
                } else {
                    n4 = n12;
                    if (n4 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n4] == 4) {
                        n3 = n10 + 1;
                        n2 = n10 + 6;
                        n5 = n8 - n10 - 1;
                        System.arraycopy(this.buf, n3, this.buf, n2, n5);
                        int n13 = n10;
                        this.buf[n13++] = 92;
                        this.buf[n13++] = 117;
                        this.buf[n13++] = IOUtils.DIGITS[n4 >>> 12 & 0xF];
                        this.buf[n13++] = IOUtils.DIGITS[n4 >>> 8 & 0xF];
                        this.buf[n13++] = IOUtils.DIGITS[n4 >>> 4 & 0xF];
                        this.buf[n13] = IOUtils.DIGITS[n4 & 0xF];
                    } else {
                        n3 = n10 + 1;
                        n2 = n10 + 2;
                        n5 = n8 - n10 - 1;
                        System.arraycopy(this.buf, n3, this.buf, n2, n5);
                        this.buf[n10] = 92;
                        this.buf[++n10] = IOUtils.replaceChars[n4];
                    }
                }
            } else if (n5 > 1) {
                n4 = n11 - n7;
                n3 = n11;
                for (n2 = n4; n2 < string.length(); ++n2) {
                    n5 = string.charAt(n2);
                    if (this.browserSecure && (n5 == 40 || n5 == 41 || n5 == 60 || n5 == 62)) {
                        this.buf[n3++] = 92;
                        this.buf[n3++] = 117;
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 12 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 8 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 4 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 & 0xF];
                        continue;
                    }
                    if (n5 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n5] != 0 || n5 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n3++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[n5] == 4) {
                            this.buf[n3++] = 117;
                            this.buf[n3++] = IOUtils.DIGITS[n5 >>> 12 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[n5 >>> 8 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[n5 >>> 4 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[n5 & 0xF];
                            continue;
                        }
                        this.buf[n3++] = IOUtils.replaceChars[n5];
                        continue;
                    }
                    if (n5 == 8232 || n5 == 8233) {
                        this.buf[n3++] = 92;
                        this.buf[n3++] = 117;
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 12 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 8 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 4 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 & 0xF];
                        continue;
                    }
                    this.buf[n3++] = n5;
                }
            }
        }
        if (c2 != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = c2;
            return;
        }
        this.buf[this.count - 1] = 34;
    }

    public final void writeStringWithDoubleQuote(char[] cArray, char c2) {
        int n2;
        int n3;
        int n4;
        if (cArray == null) {
            this.writeNull();
            if (c2 != '\u0000') {
                this.write(c2);
            }
            return;
        }
        int n5 = cArray.length;
        int n6 = this.count + n5 + 2;
        if (c2 != '\u0000') {
            ++n6;
        }
        if (n6 > this.buf.length) {
            if (this.writer != null) {
                this.write(34);
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    n5 = cArray[i2];
                    if (this.isEnabled(SerializerFeature.BrowserSecure) && (n5 == 40 || n5 == 41 || n5 == 60 || n5 == 62)) {
                        this.write(92);
                        this.write(117);
                        this.write(IOUtils.DIGITS[n5 >>> 12 & 0xF]);
                        this.write(IOUtils.DIGITS[n5 >>> 8 & 0xF]);
                        this.write(IOUtils.DIGITS[n5 >>> 4 & 0xF]);
                        this.write(IOUtils.DIGITS[n5 & 0xF]);
                        continue;
                    }
                    if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                        if (n5 == 8 || n5 == 12 || n5 == 10 || n5 == 13 || n5 == 9 || n5 == 34 || n5 == 47 || n5 == 92) {
                            this.write(92);
                            this.write(IOUtils.replaceChars[n5]);
                            continue;
                        }
                        if (n5 < 32) {
                            this.write(92);
                            this.write(117);
                            this.write(48);
                            this.write(48);
                            this.write(IOUtils.ASCII_CHARS[n5 << 1]);
                            this.write(IOUtils.ASCII_CHARS[(n5 << 1) + 1]);
                            continue;
                        }
                        if (n5 >= 127) {
                            this.write(92);
                            this.write(117);
                            this.write(IOUtils.DIGITS[n5 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[n5 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[n5 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[n5 & 0xF]);
                            continue;
                        }
                    } else if (n5 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n5] != 0 || n5 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        if (IOUtils.specicalFlags_doubleQuotes[n5] == 4) {
                            this.write(117);
                            this.write(IOUtils.DIGITS[n5 >>> 12 & 0xF]);
                            this.write(IOUtils.DIGITS[n5 >>> 8 & 0xF]);
                            this.write(IOUtils.DIGITS[n5 >>> 4 & 0xF]);
                            this.write(IOUtils.DIGITS[n5 & 0xF]);
                            continue;
                        }
                        this.write(IOUtils.replaceChars[n5]);
                        continue;
                    }
                    this.write(n5);
                }
                this.write(34);
                if (c2 != '\u0000') {
                    this.write(c2);
                }
                return;
            }
            this.expandCapacity(n6);
        }
        int n7 = this.count + 1;
        n5 = n7 + n5;
        this.buf[this.count] = 34;
        System.arraycopy(cArray, 0, this.buf, n7, cArray.length);
        this.count = n6;
        if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
            char c3;
            int n8;
            int n9 = -1;
            for (n8 = n7; n8 < n5; ++n8) {
                c3 = this.buf[n8];
                if (c3 == '\"' || c3 == '/' || c3 == '\\') {
                    n9 = n8;
                    ++n6;
                    continue;
                }
                if (c3 == '\b' || c3 == '\f' || c3 == '\n' || c3 == '\r' || c3 == '\t') {
                    n9 = n8;
                    ++n6;
                    continue;
                }
                if (c3 < ' ') {
                    n9 = n8;
                    n6 += 5;
                    continue;
                }
                if (c3 < '\u007f') continue;
                n9 = n8;
                n6 += 5;
            }
            if (n6 > this.buf.length) {
                this.expandCapacity(n6);
            }
            this.count = n6;
            for (n8 = n9; n8 >= n7; --n8) {
                c3 = this.buf[n8];
                if (c3 == '\b' || c3 == '\f' || c3 == '\n' || c3 == '\r' || c3 == '\t') {
                    System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n5 - n8 - 1);
                    this.buf[n8] = 92;
                    this.buf[n8 + 1] = IOUtils.replaceChars[c3];
                    ++n5;
                    continue;
                }
                if (c3 == '\"' || c3 == '/' || c3 == '\\') {
                    System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n5 - n8 - 1);
                    this.buf[n8] = 92;
                    this.buf[n8 + 1] = c3;
                    ++n5;
                    continue;
                }
                if (c3 < ' ') {
                    System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 6, n5 - n8 - 1);
                    this.buf[n8] = 92;
                    this.buf[n8 + 1] = 117;
                    this.buf[n8 + 2] = 48;
                    this.buf[n8 + 3] = 48;
                    this.buf[n8 + 4] = IOUtils.ASCII_CHARS[c3 << 1];
                    this.buf[n8 + 5] = IOUtils.ASCII_CHARS[(c3 << 1) + 1];
                    n5 += 5;
                    continue;
                }
                if (c3 < '\u007f') continue;
                System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 6, n5 - n8 - 1);
                this.buf[n8] = 92;
                this.buf[n8 + 1] = 117;
                this.buf[n8 + 2] = IOUtils.DIGITS[c3 >>> 12 & 0xF];
                this.buf[n8 + 3] = IOUtils.DIGITS[c3 >>> 8 & 0xF];
                this.buf[n8 + 4] = IOUtils.DIGITS[c3 >>> 4 & 0xF];
                this.buf[n8 + 5] = IOUtils.DIGITS[c3 & 0xF];
                n5 += 5;
            }
            if (c2 != '\u0000') {
                this.buf[this.count - 2] = 34;
                this.buf[this.count - 1] = c2;
                return;
            }
            this.buf[this.count - 1] = 34;
            return;
        }
        int n10 = 0;
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        for (n4 = n7; n4 < n5; ++n4) {
            n3 = this.buf[n4];
            if (n3 >= 93) {
                if (n3 < 127 || n3 != 8232 && n3 != 8233 && n3 >= 160) continue;
                if (n12 == -1) {
                    n12 = n4;
                }
                ++n10;
                n11 = n4;
                n13 = n3;
                n6 += 4;
                continue;
            }
            n2 = n3 < 64 && (this.sepcialBits & 1L << n3) != 0L || n3 == 92 ? 1 : 0;
            if (n2 == 0) continue;
            ++n10;
            n11 = n4;
            n13 = n3;
            if (n3 == 40 || n3 == 41 || n3 == 60 || n3 == 62 || n3 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n3] == 4) {
                n6 += 4;
            }
            if (n12 != -1) continue;
            n12 = n4;
        }
        if (n10 > 0) {
            if ((n6 += n10) > this.buf.length) {
                this.expandCapacity(n6);
            }
            this.count = n6;
            if (n10 == 1) {
                if (n13 == 8232) {
                    n4 = n11 + 1;
                    n3 = n11 + 6;
                    n2 = n5 - n11 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n11] = 92;
                    this.buf[++n11] = 117;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 48;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 56;
                } else if (n13 == 8233) {
                    n4 = n11 + 1;
                    n3 = n11 + 6;
                    n2 = n5 - n11 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n11] = 92;
                    this.buf[++n11] = 117;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 48;
                    this.buf[++n11] = 50;
                    this.buf[++n11] = 57;
                } else if (n13 == 40 || n13 == 41 || n13 == 60 || n13 == 62) {
                    n4 = n11 + 1;
                    n3 = n11 + 6;
                    n2 = n5 - n11 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    this.buf[n11] = 92;
                    this.buf[++n11] = 117;
                    n5 = n13;
                    this.buf[++n11] = IOUtils.DIGITS[n5 >>> 12 & 0xF];
                    this.buf[++n11] = IOUtils.DIGITS[n5 >>> 8 & 0xF];
                    this.buf[++n11] = IOUtils.DIGITS[n5 >>> 4 & 0xF];
                    this.buf[++n11] = IOUtils.DIGITS[n5 & 0xF];
                } else {
                    n4 = n13;
                    if (n4 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n4] == 4) {
                        n3 = n11 + 1;
                        n2 = n11 + 6;
                        n5 = n5 - n11 - 1;
                        System.arraycopy(this.buf, n3, this.buf, n2, n5);
                        int n14 = n11;
                        this.buf[n14++] = 92;
                        this.buf[n14++] = 117;
                        this.buf[n14++] = IOUtils.DIGITS[n4 >>> 12 & 0xF];
                        this.buf[n14++] = IOUtils.DIGITS[n4 >>> 8 & 0xF];
                        this.buf[n14++] = IOUtils.DIGITS[n4 >>> 4 & 0xF];
                        this.buf[n14] = IOUtils.DIGITS[n4 & 0xF];
                    } else {
                        n3 = n11 + 1;
                        n2 = n11 + 2;
                        n5 = n5 - n11 - 1;
                        System.arraycopy(this.buf, n3, this.buf, n2, n5);
                        this.buf[n11] = 92;
                        this.buf[++n11] = IOUtils.replaceChars[n4];
                    }
                }
            } else if (n10 > 1) {
                n4 = n12 - n7;
                n3 = n12;
                for (n2 = n4; n2 < cArray.length; ++n2) {
                    n5 = cArray[n2];
                    if (this.browserSecure && (n5 == 40 || n5 == 41 || n5 == 60 || n5 == 62)) {
                        this.buf[n3++] = 92;
                        this.buf[n3++] = 117;
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 12 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 8 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 4 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 & 0xF];
                        continue;
                    }
                    if (n5 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n5] != 0 || n5 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n3++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[n5] == 4) {
                            this.buf[n3++] = 117;
                            this.buf[n3++] = IOUtils.DIGITS[n5 >>> 12 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[n5 >>> 8 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[n5 >>> 4 & 0xF];
                            this.buf[n3++] = IOUtils.DIGITS[n5 & 0xF];
                            continue;
                        }
                        this.buf[n3++] = IOUtils.replaceChars[n5];
                        continue;
                    }
                    if (n5 == 8232 || n5 == 8233) {
                        this.buf[n3++] = 92;
                        this.buf[n3++] = 117;
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 12 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 8 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 >>> 4 & 0xF];
                        this.buf[n3++] = IOUtils.DIGITS[n5 & 0xF];
                        continue;
                    }
                    this.buf[n3++] = n5;
                }
            }
        }
        if (c2 != '\u0000') {
            this.buf[this.count - 2] = 34;
            this.buf[this.count - 1] = c2;
            return;
        }
        this.buf[this.count - 1] = 34;
    }

    public final void writeFieldNameDirect(String string) {
        int n2 = string.length();
        int n3 = this.count + n2 + 3;
        if (n3 > this.buf.length) {
            this.expandCapacity(n3);
        }
        int n4 = this.count + 1;
        this.buf[this.count] = 34;
        string.getChars(0, n2, this.buf, n4);
        this.count = n3;
        this.buf[this.count - 2] = 34;
        this.buf[this.count - 1] = 58;
    }

    public final void write(List<String> list) {
        int n2;
        if (list.isEmpty()) {
            this.write("[]");
            return;
        }
        int n3 = n2 = this.count;
        int n4 = list.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            String string = list.get(i2);
            char c2 = '\u0000';
            if (string == null) {
                c2 = '\u0001';
            } else {
                int n6 = string.length();
                for (n5 = 0; n5 < n6 && (c2 = (c2 = string.charAt(n5)) < ' ' || c2 > '~' || c2 == '\"' || c2 == '\\' ? (char)'\u0001' : '\u0000') == '\u0000'; ++n5) {
                }
            }
            if (c2 != '\u0000') {
                this.count = n3;
                this.write(91);
                for (n5 = 0; n5 < list.size(); ++n5) {
                    string = list.get(n5);
                    if (n5 != 0) {
                        this.write(44);
                    }
                    if (string == null) {
                        this.write("null");
                        continue;
                    }
                    this.writeStringWithDoubleQuote(string, '\u0000');
                }
                this.write(93);
                return;
            }
            n5 = n2 + string.length() + 3;
            if (i2 == list.size() - 1) {
                ++n5;
            }
            if (n5 > this.buf.length) {
                this.count = n2;
                this.expandCapacity(n5);
            }
            this.buf[n2++] = i2 == 0 ? 91 : 44;
            this.buf[n2++] = 34;
            string.getChars(0, string.length(), this.buf, n2);
            n2 += string.length();
            this.buf[n2++] = 34;
        }
        this.buf[n2++] = 93;
        this.count = n2;
    }

    public final void writeFieldValue(char c2, String string, char c3) {
        this.write(c2);
        this.writeFieldName(string);
        if (c3 == '\u0000') {
            this.writeString("\u0000");
            return;
        }
        this.writeString(Character.toString(c3));
    }

    public final void writeFieldValue(char c2, String string, boolean bl) {
        if (!this.quoteFieldNames) {
            this.write(c2);
            this.writeFieldName(string);
            this.write(bl);
            return;
        }
        int n2 = bl ? 4 : 5;
        int n3 = string.length();
        n2 = this.count + n3 + 4 + n2;
        if (n2 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeString(string);
                this.write(58);
                this.write(bl);
                return;
            }
            this.expandCapacity(n2);
        }
        int n4 = this.count;
        this.count = n2;
        this.buf[n4] = c2;
        c2 = (char)(n4 + n3 + 1);
        this.buf[n4 + 1] = this.keySeperator;
        string.getChars(0, n3, this.buf, n4 + 2);
        this.buf[c2 + '\u0001'] = this.keySeperator;
        if (bl) {
            System.arraycopy(":true".toCharArray(), 0, this.buf, c2 + 2, 5);
            return;
        }
        System.arraycopy(":false".toCharArray(), 0, this.buf, c2 + 2, 6);
    }

    public final void write(boolean bl) {
        if (bl) {
            this.write("true");
            return;
        }
        this.write("false");
    }

    public final void writeFieldValue(char c2, String string, int n2) {
        if (n2 == Integer.MIN_VALUE || !this.quoteFieldNames) {
            this.write(c2);
            this.writeFieldName(string);
            this.writeInt(n2);
            return;
        }
        int n3 = n2 < 0 ? IOUtils.stringSize(-n2) + 1 : IOUtils.stringSize(n2);
        int n4 = string.length();
        n3 = this.count + n4 + 4 + n3;
        if (n3 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeFieldName(string);
                this.writeInt(n2);
                return;
            }
            this.expandCapacity(n3);
        }
        int n5 = this.count;
        this.count = n3;
        this.buf[n5] = c2;
        c2 = (char)(n5 + n4 + 1);
        this.buf[n5 + 1] = this.keySeperator;
        string.getChars(0, n4, this.buf, n5 + 2);
        this.buf[c2 + '\u0001'] = this.keySeperator;
        this.buf[c2 + 2] = 58;
        IOUtils.getChars(n2, this.count, this.buf);
    }

    public final void writeFieldValue(char c2, String string, long l2) {
        if (l2 == Long.MIN_VALUE || !this.quoteFieldNames) {
            this.write(c2);
            this.writeFieldName(string);
            this.writeLong(l2);
            return;
        }
        int n2 = l2 < 0L ? IOUtils.stringSize(-l2) + 1 : IOUtils.stringSize(l2);
        int n3 = string.length();
        n2 = this.count + n3 + 4 + n2;
        if (n2 > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeFieldName(string);
                this.writeLong(l2);
                return;
            }
            this.expandCapacity(n2);
        }
        int n4 = this.count;
        this.count = n2;
        this.buf[n4] = c2;
        c2 = (char)(n4 + n3 + 1);
        this.buf[n4 + 1] = this.keySeperator;
        string.getChars(0, n3, this.buf, n4 + 2);
        this.buf[c2 + '\u0001'] = this.keySeperator;
        this.buf[c2 + 2] = 58;
        IOUtils.getChars(l2, this.count, this.buf);
    }

    public final void writeFieldValue(char c2, String string, float f2) {
        this.write(c2);
        this.writeFieldName(string);
        this.writeFloat(f2, false);
    }

    public final void writeFieldValue(char c2, String string, double d2) {
        this.write(c2);
        this.writeFieldName(string);
        this.writeDouble(d2, false);
    }

    public final void writeFieldValue(char c2, String string, String string2) {
        if (this.quoteFieldNames) {
            if (this.useSingleQuotes) {
                this.write(c2);
                this.writeFieldName(string);
                if (string2 == null) {
                    this.writeNull();
                    return;
                }
                this.writeString(string2);
                return;
            }
            if (this.isEnabled(SerializerFeature.BrowserCompatible)) {
                this.write(c2);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
                return;
            }
            this.writeFieldValueStringWithDoubleQuoteCheck(c2, string, string2);
            return;
        }
        this.write(c2);
        this.writeFieldName(string);
        if (string2 == null) {
            this.writeNull();
            return;
        }
        this.writeString(string2);
    }

    public final void writeFieldValueStringWithDoubleQuoteCheck(char n2, String string, String string2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = string.length();
        int n8 = this.count;
        if (string2 == null) {
            n6 = 4;
            n8 += n7 + 8;
        } else {
            n6 = string2.length();
            n8 += n7 + n6 + 6;
        }
        if (n8 > this.buf.length) {
            if (this.writer != null) {
                this.write(n2);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
                return;
            }
            this.expandCapacity(n8);
        }
        this.buf[this.count] = n2;
        int n9 = this.count + 2;
        n2 = n9;
        int n10 = n9 + n7;
        this.buf[this.count + 1] = 34;
        string.getChars(0, n7, this.buf, n2);
        this.count = n8;
        this.buf[n10] = 34;
        int n11 = n2 = (int)(n10 + 1);
        n2 = n2 + 1;
        this.buf[n11] = 58;
        if (string2 == null) {
            int n12 = n2;
            n2 = n2 + 1;
            this.buf[n12] = 110;
            int n13 = n2;
            n2 = n2 + 1;
            this.buf[n13] = 117;
            int n14 = n2;
            n2 = n2 + 1;
            this.buf[n14] = 108;
            this.buf[n2] = 108;
            return;
        }
        int n15 = n2;
        n2 = n2 + 1;
        this.buf[n15] = 34;
        int n16 = n2 + n6;
        string2.getChars(0, n6, this.buf, n2);
        n7 = 0;
        n6 = -1;
        n10 = -1;
        int n17 = 0;
        for (n5 = n2; n5 < n16; ++n5) {
            n4 = this.buf[n5];
            if (n4 >= 93) {
                if (n4 < 127 || n4 != 8232 && n4 != 8233 && n4 >= 160) continue;
                if (n10 == -1) {
                    n10 = n5;
                }
                ++n7;
                n6 = n5;
                n17 = n4;
                n8 += 4;
                continue;
            }
            n3 = n4 < 64 && (this.sepcialBits & 1L << n4) != 0L || n4 == 92 ? 1 : 0;
            if (n3 == 0) continue;
            ++n7;
            n6 = n5;
            n17 = n4;
            if (n4 == 40 || n4 == 41 || n4 == 60 || n4 == 62 || n4 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n4] == 4) {
                n8 += 4;
            }
            if (n10 != -1) continue;
            n10 = n5;
        }
        if (n7 > 0) {
            if ((n8 += n7) > this.buf.length) {
                this.expandCapacity(n8);
            }
            this.count = n8;
            if (n7 == 1) {
                if (n17 == 8232) {
                    n5 = n6 + 1;
                    n4 = n6 + 6;
                    n3 = n16 - n6 - 1;
                    System.arraycopy(this.buf, n5, this.buf, n4, n3);
                    this.buf[n6] = 92;
                    this.buf[++n6] = 117;
                    this.buf[++n6] = 50;
                    this.buf[++n6] = 48;
                    this.buf[++n6] = 50;
                    this.buf[++n6] = 56;
                } else if (n17 == 8233) {
                    n5 = n6 + 1;
                    n4 = n6 + 6;
                    n3 = n16 - n6 - 1;
                    System.arraycopy(this.buf, n5, this.buf, n4, n3);
                    this.buf[n6] = 92;
                    this.buf[++n6] = 117;
                    this.buf[++n6] = 50;
                    this.buf[++n6] = 48;
                    this.buf[++n6] = 50;
                    this.buf[++n6] = 57;
                } else if (n17 == 40 || n17 == 41 || n17 == 60 || n17 == 62) {
                    n5 = n17;
                    n4 = n6 + 1;
                    n3 = n6 + 6;
                    n2 = n16 - n6 - 1;
                    System.arraycopy(this.buf, n4, this.buf, n3, n2);
                    n2 = n6;
                    this.buf[n2++] = 92;
                    this.buf[n2++] = 117;
                    this.buf[n2++] = IOUtils.DIGITS[n5 >>> 12 & 0xF];
                    this.buf[n2++] = IOUtils.DIGITS[n5 >>> 8 & 0xF];
                    this.buf[n2++] = IOUtils.DIGITS[n5 >>> 4 & 0xF];
                    this.buf[n2] = IOUtils.DIGITS[n5 & 0xF];
                } else {
                    n5 = n17;
                    if (n5 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n5] == 4) {
                        n4 = n6 + 1;
                        n3 = n6 + 6;
                        n2 = n16 - n6 - 1;
                        System.arraycopy(this.buf, n4, this.buf, n3, n2);
                        n2 = n6;
                        this.buf[n2++] = 92;
                        this.buf[n2++] = 117;
                        this.buf[n2++] = IOUtils.DIGITS[n5 >>> 12 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[n5 >>> 8 & 0xF];
                        this.buf[n2++] = IOUtils.DIGITS[n5 >>> 4 & 0xF];
                        this.buf[n2] = IOUtils.DIGITS[n5 & 0xF];
                    } else {
                        n4 = n6 + 1;
                        n3 = n6 + 2;
                        n2 = n16 - n6 - 1;
                        System.arraycopy(this.buf, n4, this.buf, n3, n2);
                        this.buf[n6] = 92;
                        this.buf[++n6] = IOUtils.replaceChars[n5];
                    }
                }
            } else if (n7 > 1) {
                n5 = n10 - n2;
                n4 = n10;
                for (n3 = n5; n3 < string2.length(); ++n3) {
                    n2 = string2.charAt(n3);
                    if (this.browserSecure && (n2 == 40 || n2 == 41 || n2 == 60 || n2 == 62)) {
                        this.buf[n4++] = 92;
                        this.buf[n4++] = 117;
                        this.buf[n4++] = IOUtils.DIGITS[n2 >>> 12 & 0xF];
                        this.buf[n4++] = IOUtils.DIGITS[n2 >>> 8 & 0xF];
                        this.buf[n4++] = IOUtils.DIGITS[n2 >>> 4 & 0xF];
                        this.buf[n4++] = IOUtils.DIGITS[n2 & 0xF];
                        continue;
                    }
                    if (n2 < IOUtils.specicalFlags_doubleQuotes.length && IOUtils.specicalFlags_doubleQuotes[n2] != 0 || n2 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.buf[n4++] = 92;
                        if (IOUtils.specicalFlags_doubleQuotes[n2] == 4) {
                            this.buf[n4++] = 117;
                            this.buf[n4++] = IOUtils.DIGITS[n2 >>> 12 & 0xF];
                            this.buf[n4++] = IOUtils.DIGITS[n2 >>> 8 & 0xF];
                            this.buf[n4++] = IOUtils.DIGITS[n2 >>> 4 & 0xF];
                            this.buf[n4++] = IOUtils.DIGITS[n2 & 0xF];
                            continue;
                        }
                        this.buf[n4++] = IOUtils.replaceChars[n2];
                        continue;
                    }
                    if (n2 == 8232 || n2 == 8233) {
                        this.buf[n4++] = 92;
                        this.buf[n4++] = 117;
                        this.buf[n4++] = IOUtils.DIGITS[n2 >>> 12 & 0xF];
                        this.buf[n4++] = IOUtils.DIGITS[n2 >>> 8 & 0xF];
                        this.buf[n4++] = IOUtils.DIGITS[n2 >>> 4 & 0xF];
                        this.buf[n4++] = IOUtils.DIGITS[n2 & 0xF];
                        continue;
                    }
                    this.buf[n4++] = n2;
                }
            }
        }
        this.buf[this.count - 1] = 34;
    }

    public final void writeFieldValueStringWithDoubleQuote(char c2, String string, String string2) {
        int n2 = string.length();
        int n3 = this.count;
        int n4 = string2.length();
        if ((n3 += n2 + n4 + 6) > this.buf.length) {
            if (this.writer != null) {
                this.write(c2);
                this.writeStringWithDoubleQuote(string, ':');
                this.writeStringWithDoubleQuote(string2, '\u0000');
                return;
            }
            this.expandCapacity(n3);
        }
        this.buf[this.count] = c2;
        int n5 = this.count + 2;
        c2 = (char)n5;
        int n6 = n5 + n2;
        this.buf[this.count + 1] = 34;
        string.getChars(0, n2, this.buf, c2);
        this.count = n3;
        this.buf[n6] = 34;
        char c3 = c2 = (char)(n6 + 1);
        c2 = (char)(c2 + 1);
        this.buf[c3] = 58;
        char c4 = c2;
        c2 = (char)(c2 + 1);
        this.buf[c4] = 34;
        string2.getChars(0, n4, this.buf, c2);
        this.buf[this.count - 1] = 34;
    }

    public final void writeFieldValue(char c2, String string, Enum<?> enum_) {
        if (enum_ == null) {
            this.write(c2);
            this.writeFieldName(string);
            this.writeNull();
            return;
        }
        if (this.writeEnumUsingName && !this.writeEnumUsingToString) {
            this.writeEnumFieldValue(c2, string, enum_.name());
            return;
        }
        if (this.writeEnumUsingToString) {
            this.writeEnumFieldValue(c2, string, enum_.toString());
            return;
        }
        this.writeFieldValue(c2, string, enum_.ordinal());
    }

    private void writeEnumFieldValue(char c2, String string, String string2) {
        if (this.useSingleQuotes) {
            this.writeFieldValue(c2, string, string2);
            return;
        }
        this.writeFieldValueStringWithDoubleQuote(c2, string, string2);
    }

    public final void writeFieldValue(char c2, String string, BigDecimal bigDecimal) {
        this.write(c2);
        this.writeFieldName(string);
        if (bigDecimal == null) {
            this.writeNull();
            return;
        }
        c2 = (char)bigDecimal.scale();
        SerializeWriter serializeWriter = this;
        serializeWriter.write(serializeWriter.isEnabled(SerializerFeature.WriteBigDecimalAsPlain) && c2 >= '\uffffff9c' && c2 < 'd' ? bigDecimal.toPlainString() : bigDecimal.toString());
    }

    public final void writeString(String string, char c2) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(string);
            this.write(c2);
            return;
        }
        this.writeStringWithDoubleQuote(string, c2);
    }

    public final void writeString(String string) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote(string);
            return;
        }
        this.writeStringWithDoubleQuote(string, '\u0000');
    }

    public final void writeString(char[] object) {
        if (this.useSingleQuotes) {
            this.writeStringWithSingleQuote((char[])object);
            return;
        }
        object = new String((char[])object);
        this.writeStringWithDoubleQuote((String)object, '\u0000');
    }

    protected final void writeStringWithSingleQuote(String string) {
        char c2;
        int n2;
        if (string == null) {
            int n3 = this.count + 4;
            if (n3 > this.buf.length) {
                this.expandCapacity(n3);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = n3;
            return;
        }
        int n4 = string.length();
        int n5 = this.count + n4 + 2;
        if (n5 > this.buf.length) {
            if (this.writer != null) {
                this.write(39);
                for (int i2 = 0; i2 < string.length(); ++i2) {
                    char c3 = string.charAt(i2);
                    if (c3 <= '\r' || c3 == '\\' || c3 == '\'' || c3 == '/' && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[c3]);
                        continue;
                    }
                    this.write(c3);
                }
                this.write(39);
                return;
            }
            this.expandCapacity(n5);
        }
        int n6 = this.count + 1;
        int n7 = n6 + n4;
        this.buf[this.count] = 39;
        string.getChars(0, n4, this.buf, n6);
        this.count = n5;
        int n8 = 0;
        n4 = -1;
        char c4 = '\u0000';
        for (n2 = n6; n2 < n7; ++n2) {
            c2 = this.buf[n2];
            if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++n8;
            n4 = n2;
            c4 = c2;
        }
        if ((n5 += n8) > this.buf.length) {
            this.expandCapacity(n5);
        }
        this.count = n5;
        if (n8 == 1) {
            System.arraycopy(this.buf, n4 + 1, this.buf, n4 + 2, n7 - n4 - 1);
            this.buf[n4] = 92;
            this.buf[++n4] = IOUtils.replaceChars[c4];
        } else if (n8 > 1) {
            System.arraycopy(this.buf, n4 + 1, this.buf, n4 + 2, n7 - n4 - 1);
            this.buf[n4] = 92;
            this.buf[++n4] = IOUtils.replaceChars[c4];
            ++n7;
            for (n2 = n4 - 2; n2 >= n6; --n2) {
                c2 = this.buf[n2];
                if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                System.arraycopy(this.buf, n2 + 1, this.buf, n2 + 2, n7 - n2 - 1);
                this.buf[n2] = 92;
                this.buf[n2 + 1] = IOUtils.replaceChars[c2];
                ++n7;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    protected final void writeStringWithSingleQuote(char[] cArray) {
        char c2;
        int n2;
        if (cArray == null) {
            int n3 = this.count + 4;
            if (n3 > this.buf.length) {
                this.expandCapacity(n3);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = n3;
            return;
        }
        int n4 = cArray.length;
        int n5 = this.count + n4 + 2;
        if (n5 > this.buf.length) {
            if (this.writer != null) {
                this.write(39);
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    n4 = cArray[i2];
                    if (n4 <= 13 || n4 == 92 || n4 == 39 || n4 == 47 && this.isEnabled(SerializerFeature.WriteSlashAsSpecial)) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[n4]);
                        continue;
                    }
                    this.write(n4);
                }
                this.write(39);
                return;
            }
            this.expandCapacity(n5);
        }
        int n6 = this.count + 1;
        n4 = n6 + n4;
        this.buf[this.count] = 39;
        System.arraycopy(cArray, 0, this.buf, n6, cArray.length);
        this.count = n5;
        int n7 = 0;
        int n8 = -1;
        char c3 = '\u0000';
        for (n2 = n6; n2 < n4; ++n2) {
            c2 = this.buf[n2];
            if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
            ++n7;
            n8 = n2;
            c3 = c2;
        }
        if ((n5 += n7) > this.buf.length) {
            this.expandCapacity(n5);
        }
        this.count = n5;
        if (n7 == 1) {
            System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n4 - n8 - 1);
            this.buf[n8] = 92;
            this.buf[++n8] = IOUtils.replaceChars[c3];
        } else if (n7 > 1) {
            System.arraycopy(this.buf, n8 + 1, this.buf, n8 + 2, n4 - n8 - 1);
            this.buf[n8] = 92;
            this.buf[++n8] = IOUtils.replaceChars[c3];
            ++n4;
            for (n2 = n8 - 2; n2 >= n6; --n2) {
                c2 = this.buf[n2];
                if (c2 > '\r' && c2 != '\\' && c2 != '\'' && (c2 != '/' || !this.isEnabled(SerializerFeature.WriteSlashAsSpecial))) continue;
                System.arraycopy(this.buf, n2 + 1, this.buf, n2 + 2, n4 - n2 - 1);
                this.buf[n2] = 92;
                this.buf[n2 + 1] = IOUtils.replaceChars[c2];
                ++n4;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    public final void writeFieldName(String string) {
        this.writeFieldName(string, false);
    }

    public final void writeFieldName(String string, boolean bl) {
        if (string == null) {
            this.write("null:");
            return;
        }
        if (this.useSingleQuotes) {
            if (this.quoteFieldNames) {
                this.writeStringWithSingleQuote(string);
                this.write(58);
                return;
            }
            this.writeKeyWithSingleQuoteIfHasSpecial(string);
            return;
        }
        if (this.quoteFieldNames) {
            this.writeStringWithDoubleQuote(string, ':');
            return;
        }
        bl = string.length() == 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            c2 = c2 < '@' && (this.sepcialBits & 1L << c2) != 0L || c2 == '\\' ? (char)'\u0001' : '\u0000';
            if (c2 == '\u0000') continue;
            bl = true;
            break;
        }
        if (bl) {
            this.writeStringWithDoubleQuote(string, ':');
            return;
        }
        this.write(string);
        this.write(58);
    }

    private void writeKeyWithSingleQuoteIfHasSpecial(String string) {
        byte[] byArray = IOUtils.specicalFlags_singleQuotes;
        int n2 = string.length();
        int n3 = this.count + n2 + 1;
        if (n3 > this.buf.length) {
            if (this.writer != null) {
                char c2;
                int n4;
                if (n2 == 0) {
                    this.write(39);
                    this.write(39);
                    this.write(58);
                    return;
                }
                boolean bl = false;
                for (n4 = 0; n4 < n2; ++n4) {
                    c2 = string.charAt(n4);
                    if (c2 >= byArray.length || byArray[c2] == 0) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.write(39);
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    c2 = string.charAt(n4);
                    if (c2 < byArray.length && byArray[c2] != 0) {
                        this.write(92);
                        this.write(IOUtils.replaceChars[c2]);
                        continue;
                    }
                    this.write(c2);
                }
                if (bl) {
                    this.write(39);
                }
                this.write(58);
                return;
            }
            this.expandCapacity(n3);
        }
        if (n2 == 0) {
            int n5 = this.count + 3;
            if (n5 > this.buf.length) {
                SerializeWriter serializeWriter = this;
                serializeWriter.expandCapacity(serializeWriter.count + 3);
            }
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 39;
            this.buf[this.count++] = 58;
            return;
        }
        int n6 = this.count;
        int n7 = n6 + n2;
        string.getChars(0, n2, this.buf, n6);
        this.count = n3;
        boolean bl = false;
        for (int i2 = n6; i2 < n7; ++i2) {
            n2 = this.buf[i2];
            if (n2 >= byArray.length || byArray[n2] == 0) continue;
            if (!bl) {
                if ((n3 += 3) > this.buf.length) {
                    this.expandCapacity(n3);
                }
                this.count = n3;
                System.arraycopy(this.buf, i2 + 1, this.buf, i2 + 3, n7 - i2 - 1);
                System.arraycopy(this.buf, 0, this.buf, 1, i2);
                this.buf[n6] = 39;
                this.buf[++i2] = 92;
                this.buf[++i2] = IOUtils.replaceChars[n2];
                n7 += 2;
                this.buf[this.count - 2] = 39;
                bl = true;
                continue;
            }
            if (++n3 > this.buf.length) {
                this.expandCapacity(n3);
            }
            this.count = n3;
            System.arraycopy(this.buf, i2 + 1, this.buf, i2 + 2, n7 - i2);
            this.buf[i2] = 92;
            this.buf[++i2] = IOUtils.replaceChars[n2];
            ++n7;
        }
        this.buf[n3 - 1] = 58;
    }

    @Override
    public final void flush() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.write(this.buf, 0, this.count);
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        this.count = 0;
    }
}

