/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.support.jaxrs;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONException;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeFilter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.support.config.FastJsonConfig;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class FastJsonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    public static final Class<?>[] DEFAULT_UNREADABLES = new Class[]{InputStream.class, Reader.class};
    public static final Class<?>[] DEFAULT_UNWRITABLES = new Class[]{InputStream.class, OutputStream.class, Writer.class, StreamingOutput.class, Response.class};
    @Deprecated
    protected Charset charset = Charset.forName("UTF-8");
    @Deprecated
    protected SerializerFeature[] features = new SerializerFeature[0];
    @Deprecated
    protected SerializeFilter[] filters = new SerializeFilter[0];
    @Deprecated
    protected String dateFormat;
    @Context
    protected Providers providers;
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();
    private Class<?>[] clazzes = null;
    private boolean pretty;

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    public FastJsonProvider() {
    }

    public FastJsonProvider(Class<?>[] classArray) {
        this.clazzes = classArray;
    }

    public FastJsonProvider setPretty(boolean bl) {
        this.pretty = bl;
        return this;
    }

    @Deprecated
    public FastJsonProvider(String string) {
        this.fastJsonConfig.setCharset(Charset.forName(string));
    }

    @Deprecated
    public Charset getCharset() {
        return this.fastJsonConfig.getCharset();
    }

    @Deprecated
    public void setCharset(Charset charset) {
        this.fastJsonConfig.setCharset(charset);
    }

    @Deprecated
    public String getDateFormat() {
        return this.fastJsonConfig.getDateFormat();
    }

    @Deprecated
    public void setDateFormat(String string) {
        this.fastJsonConfig.setDateFormat(string);
    }

    @Deprecated
    public SerializerFeature[] getFeatures() {
        return this.fastJsonConfig.getSerializerFeatures();
    }

    @Deprecated
    public void setFeatures(SerializerFeature ... serializerFeatureArray) {
        this.fastJsonConfig.setSerializerFeatures(serializerFeatureArray);
    }

    @Deprecated
    public SerializeFilter[] getFilters() {
        return this.fastJsonConfig.getSerializeFilters();
    }

    @Deprecated
    public void setFilters(SerializeFilter ... serializeFilterArray) {
        this.fastJsonConfig.setSerializeFilters(serializeFilterArray);
    }

    protected boolean isAssignableFrom(Class<?> clazz, Class<?>[] classArray) {
        if (clazz == null) {
            return false;
        }
        for (Class<?> clazz2 : classArray) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    protected boolean isValidType(Class<?> clazz, Annotation[] objectArray) {
        if (clazz == null) {
            return false;
        }
        if (this.clazzes != null) {
            objectArray = this.clazzes;
            int n2 = this.clazzes.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = objectArray[i2];
                if (object != clazz) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean hasMatchingMediaType(MediaType object) {
        if (object != null) {
            return "json".equalsIgnoreCase((String)(object = object.getSubtype())) || ((String)object).endsWith("+json") || "javascript".equals(object) || "x-javascript".equals(object) || "x-json".equals(object) || "x-www-form-urlencoded".equalsIgnoreCase((String)object) || ((String)object).endsWith("x-www-form-urlencoded");
        }
        return true;
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        if (!this.hasMatchingMediaType(mediaType)) {
            return false;
        }
        if (!this.isAssignableFrom(clazz, DEFAULT_UNWRITABLES)) {
            return false;
        }
        return this.isValidType(clazz, annotationArray);
    }

    public long getSize(Object object, Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object object, Class<?> object2, Type serializerFeatureArray, Annotation[] object3, MediaType mediaType, MultivaluedMap<String, Object> multivaluedMap, OutputStream outputStream) {
        object2 = this.locateConfigProvider((Class<?>)object2, mediaType);
        serializerFeatureArray = ((FastJsonConfig)object2).getSerializerFeatures();
        if (this.pretty) {
            if (serializerFeatureArray == null) {
                serializerFeatureArray = new SerializerFeature[]{SerializerFeature.PrettyFormat};
            } else {
                object3 = new ArrayList<SerializerFeature>(Arrays.asList(serializerFeatureArray));
                object3.add((SerializerFeature)SerializerFeature.PrettyFormat);
                serializerFeatureArray = object3.toArray(serializerFeatureArray);
            }
            ((FastJsonConfig)object2).setSerializerFeatures(serializerFeatureArray);
        }
        try {
            JSON.writeJSONString(outputStream, ((FastJsonConfig)object2).getCharset(), object, ((FastJsonConfig)object2).getSerializeConfig(), ((FastJsonConfig)object2).getSerializeFilters(), ((FastJsonConfig)object2).getDateFormat(), JSON.DEFAULT_GENERATE_FEATURE, ((FastJsonConfig)object2).getSerializerFeatures());
            outputStream.flush();
            return;
        }
        catch (JSONException jSONException) {
            throw new WebApplicationException("Could not write JSON: " + jSONException.getMessage(), (Throwable)jSONException);
        }
    }

    public boolean isReadable(Class<?> clazz, Type type, Annotation[] annotationArray, MediaType mediaType) {
        if (!this.hasMatchingMediaType(mediaType)) {
            return false;
        }
        if (!this.isAssignableFrom(clazz, DEFAULT_UNREADABLES)) {
            return false;
        }
        return this.isValidType(clazz, annotationArray);
    }

    public Object readFrom(Class<Object> object, Type type, Annotation[] annotationArray, MediaType mediaType, MultivaluedMap<String, String> multivaluedMap, InputStream inputStream) {
        try {
            object = this.locateConfigProvider((Class<?>)object, mediaType);
            return JSON.parseObject(inputStream, ((FastJsonConfig)object).getCharset(), type, ((FastJsonConfig)object).getFeatures());
        }
        catch (JSONException jSONException) {
            throw new WebApplicationException("JSON parse error: " + jSONException.getMessage(), (Throwable)jSONException);
        }
    }

    protected FastJsonConfig locateConfigProvider(Class<?> clazz, MediaType mediaType) {
        if (this.providers != null) {
            if ((mediaType = this.providers.getContextResolver(FastJsonConfig.class, mediaType)) == null) {
                mediaType = this.providers.getContextResolver(FastJsonConfig.class, null);
            }
            if (mediaType != null) {
                return (FastJsonConfig)mediaType.getContext(clazz);
            }
        }
        return this.fastJsonConfig;
    }
}

