/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.support.spring;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSONPObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializeFilter;
import com.aliyun.openservices.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import com.aliyun.openservices.shade.com.alibaba.fastjson.support.config.FastJsonConfig;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.view.AbstractView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastJsonJsonView
extends AbstractView {
    public static final String DEFAULT_CONTENT_TYPE = "application/json;charset=UTF-8";
    public static final String DEFAULT_JSONP_CONTENT_TYPE = "application/javascript";
    private static final Pattern CALLBACK_PARAM_PATTERN = Pattern.compile("[0-9A-Za-z_\\.]*");
    @Deprecated
    protected Charset charset = Charset.forName("UTF-8");
    @Deprecated
    protected SerializerFeature[] features = new SerializerFeature[0];
    @Deprecated
    protected SerializeFilter[] filters = new SerializeFilter[0];
    @Deprecated
    protected String dateFormat;
    private Set<String> renderedAttributes;
    private boolean disableCaching = true;
    private boolean updateContentLength = true;
    private boolean extractValueFromSingleKeyModel = false;
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();
    private String[] jsonpParameterNames = new String[]{"jsonp", "callback"};

    public FastJsonJsonView() {
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setExposePathVariables(false);
    }

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    @Deprecated
    public void setSerializerFeature(SerializerFeature ... serializerFeatureArray) {
        this.fastJsonConfig.setSerializerFeatures(serializerFeatureArray);
    }

    @Deprecated
    public Charset getCharset() {
        return this.fastJsonConfig.getCharset();
    }

    @Deprecated
    public void setCharset(Charset charset) {
        this.fastJsonConfig.setCharset(charset);
    }

    @Deprecated
    public String getDateFormat() {
        return this.fastJsonConfig.getDateFormat();
    }

    @Deprecated
    public void setDateFormat(String string) {
        this.fastJsonConfig.setDateFormat(string);
    }

    @Deprecated
    public SerializerFeature[] getFeatures() {
        return this.fastJsonConfig.getSerializerFeatures();
    }

    @Deprecated
    public void setFeatures(SerializerFeature ... serializerFeatureArray) {
        this.fastJsonConfig.setSerializerFeatures(serializerFeatureArray);
    }

    @Deprecated
    public SerializeFilter[] getFilters() {
        return this.fastJsonConfig.getSerializeFilters();
    }

    @Deprecated
    public void setFilters(SerializeFilter ... serializeFilterArray) {
        this.fastJsonConfig.setSerializeFilters(serializeFilterArray);
    }

    public void setRenderedAttributes(Set<String> set) {
        this.renderedAttributes = set;
    }

    public boolean isExtractValueFromSingleKeyModel() {
        return this.extractValueFromSingleKeyModel;
    }

    public void setExtractValueFromSingleKeyModel(boolean bl) {
        this.extractValueFromSingleKeyModel = bl;
    }

    public void setJsonpParameterNames(Set<String> set) {
        Assert.notEmpty(set, (String)"jsonpParameterName cannot be empty");
        Set<String> set2 = set;
        this.jsonpParameterNames = set2.toArray(new String[set2.size()]);
    }

    private String getJsonpParameterValue(HttpServletRequest httpServletRequest) {
        if (this.jsonpParameterNames != null) {
            String[] stringArray = this.jsonpParameterNames;
            int n2 = this.jsonpParameterNames.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray[i2];
                if (IOUtils.isValidJsonpQueryParam(string = httpServletRequest.getParameter(string))) {
                    return string;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Ignoring invalid jsonp parameter value: " + string));
            }
        }
        return null;
    }

    protected void renderMergedOutputModel(Map<String, Object> object, HttpServletRequest object2, HttpServletResponse httpServletResponse) {
        object = this.filterModel((Map<String, Object>)object);
        if ((object2 = this.getJsonpParameterValue((HttpServletRequest)object2)) != null) {
            object2 = new JSONPObject((String)object2);
            ((JSONPObject)object2).addParameter(object);
            object = object2;
        }
        object2 = new ByteArrayOutputStream();
        int n2 = JSON.writeJSONString((OutputStream)object2, this.fastJsonConfig.getCharset(), object, this.fastJsonConfig.getSerializeConfig(), this.fastJsonConfig.getSerializeFilters(), this.fastJsonConfig.getDateFormat(), JSON.DEFAULT_GENERATE_FEATURE, this.fastJsonConfig.getSerializerFeatures());
        if (this.updateContentLength) {
            httpServletResponse.setContentLength(n2);
        }
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ((ByteArrayOutputStream)object2).writeTo((OutputStream)servletOutputStream);
        ((ByteArrayOutputStream)object2).close();
        servletOutputStream.flush();
    }

    protected void prepareResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.setResponseContentType(httpServletRequest, httpServletResponse);
        httpServletResponse.setCharacterEncoding(this.fastJsonConfig.getCharset().name());
        if (this.disableCaching) {
            httpServletResponse.addHeader("Pragma", "no-cache");
            httpServletResponse.addHeader("Cache-Control", "no-cache, no-store, max-age=0");
            httpServletResponse.addDateHeader("Expires", 1L);
        }
    }

    public void setDisableCaching(boolean bl) {
        this.disableCaching = bl;
    }

    public void setUpdateContentLength(boolean bl) {
        this.updateContentLength = bl;
    }

    protected Object filterModel(Map<String, Object> iterator) {
        Map.Entry entry;
        HashMap hashMap = new HashMap(iterator.size());
        Set<String> set = !CollectionUtils.isEmpty(this.renderedAttributes) ? this.renderedAttributes : iterator.keySet();
        iterator = iterator.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = (Map.Entry)iterator.next();
            if (entry.getValue() instanceof BindingResult || !set.contains(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue());
        }
        if (this.extractValueFromSingleKeyModel && hashMap.size() == 1 && (iterator = hashMap.entrySet().iterator()).hasNext()) {
            entry = iterator.next();
            return entry.getValue();
        }
        return hashMap;
    }

    protected void setResponseContentType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this.getJsonpParameterValue(httpServletRequest) != null) {
            httpServletResponse.setContentType(DEFAULT_JSONP_CONTENT_TYPE);
            return;
        }
        super.setResponseContentType(httpServletRequest, httpServletResponse);
    }
}

