/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.support.spring;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.support.config.FastJsonConfig;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastJsonRedisSerializer<T>
implements RedisSerializer<T> {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();
    private Class<T> type;

    public FastJsonRedisSerializer(Class<T> clazz) {
        this.type = clazz;
    }

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    public byte[] serialize(T t2) {
        if (t2 == null) {
            return new byte[0];
        }
        try {
            return JSON.toJSONBytes(t2, this.fastJsonConfig.getSerializeConfig(), this.fastJsonConfig.getSerializerFeatures());
        }
        catch (Exception exception) {
            throw new SerializationException("Could not serialize: " + exception.getMessage(), (Throwable)exception);
        }
    }

    public T deserialize(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        try {
            return JSON.parseObject(byArray, this.type, this.fastJsonConfig.getFeatures());
        }
        catch (Exception exception) {
            throw new SerializationException("Could not deserialize: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

