/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.support.spring.messaging;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.alibaba.fastjson.support.config.FastJsonConfig;
import java.nio.charset.Charset;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.util.MimeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingFastJsonMessageConverter
extends AbstractMessageConverter {
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    public MappingFastJsonMessageConverter() {
        super(new MimeType("application", "json", Charset.forName("UTF-8")));
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected boolean canConvertFrom(Message<?> message, Class<?> clazz) {
        return this.supports(clazz);
    }

    protected boolean canConvertTo(Object object, MessageHeaders messageHeaders) {
        return this.supports(object.getClass());
    }

    protected Object convertFromInternal(Message<?> object, Class<?> clazz, Object object2) {
        object = object.getPayload();
        object2 = null;
        if (object instanceof byte[]) {
            object2 = JSON.parseObject((byte[])object, 0, ((byte[])object).length, this.fastJsonConfig.getCharset(), clazz, this.fastJsonConfig.getFeatures());
        } else if (object instanceof String) {
            object2 = JSON.parseObject((String)object, clazz, this.fastJsonConfig.getFeatures());
        }
        return object2;
    }

    protected Object convertToInternal(Object object, MessageHeaders messageHeaders, Object object2) {
        return JSON.toJSONString(object, this.fastJsonConfig.getSerializeConfig(), this.fastJsonConfig.getSerializeFilters(), this.fastJsonConfig.getSerializerFeatures());
    }
}

