/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.fastjson.util;

import com.aliyun.openservices.shade.com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.shade.com.alibaba.fastjson.asm.ClassReader;
import com.aliyun.openservices.shade.com.alibaba.fastjson.asm.TypeCollector;
import com.aliyun.openservices.shade.com.alibaba.fastjson.util.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMUtils {
    public static final String JAVA_VM_NAME = System.getProperty("java.vm.name");
    public static final boolean IS_ANDROID = ASMUtils.isAndroid(JAVA_VM_NAME);

    public static boolean isAndroid(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.toLowerCase()).contains("dalvik") || string.contains("lemur");
    }

    public static String desc(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuilder stringBuilder = new StringBuilder(classArray.length + 1 << 4);
        stringBuilder.append('(');
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuilder.append(ASMUtils.desc(classArray[i2]));
        }
        stringBuilder.append(')');
        stringBuilder.append(ASMUtils.desc(method.getReturnType()));
        return stringBuilder.toString();
    }

    public static String desc(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return ASMUtils.getPrimitiveLetter(clazz);
        }
        if (clazz.isArray()) {
            return "[" + ASMUtils.desc(clazz.getComponentType());
        }
        return "L" + ASMUtils.type(clazz) + ";";
    }

    public static String type(Class<?> object) {
        if (((Class)object).isArray()) {
            return "[" + ASMUtils.desc(((Class)object).getComponentType());
        }
        if (!((Class)object).isPrimitive()) {
            object = ((Class)object).getName();
            return ((String)object).replace('.', '/');
        }
        return ASMUtils.getPrimitiveLetter(object);
    }

    public static String getPrimitiveLetter(Class<?> clazz) {
        if (Integer.TYPE == clazz) {
            return "I";
        }
        if (Void.TYPE == clazz) {
            return "V";
        }
        if (Boolean.TYPE == clazz) {
            return "Z";
        }
        if (Character.TYPE == clazz) {
            return "C";
        }
        if (Byte.TYPE == clazz) {
            return "B";
        }
        if (Short.TYPE == clazz) {
            return "S";
        }
        if (Float.TYPE == clazz) {
            return "F";
        }
        if (Long.TYPE == clazz) {
            return "J";
        }
        if (Double.TYPE == clazz) {
            return "D";
        }
        throw new IllegalStateException("Type: " + clazz.getCanonicalName() + " is not a primitive type");
    }

    public static Type getMethodType(Class<?> genericDeclaration, String string) {
        try {
            genericDeclaration = genericDeclaration.getMethod(string, new Class[0]);
            return ((Method)genericDeclaration).getGenericReturnType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean checkName(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u0000' && c2 <= '\u007f' && c2 != '.') continue;
            return false;
        }
        return true;
    }

    public static String[] lookupParameterNames(AccessibleObject object) {
        Annotation[][] annotationArray;
        Annotation[] annotationArray2;
        String string;
        Object object2;
        if (IS_ANDROID) {
            return new String[0];
        }
        if (object instanceof Method) {
            object = (Method)object;
            object2 = ((Method)object).getParameterTypes();
            string = ((Method)object).getName();
            annotationArray2 = ((Method)object).getDeclaringClass();
            annotationArray = ((Method)object).getParameterAnnotations();
        } else {
            object = (Constructor)object;
            object2 = ((Constructor)object).getParameterTypes();
            annotationArray2 = ((Constructor)object).getDeclaringClass();
            string = "<init>";
            annotationArray = ((Constructor)object).getParameterAnnotations();
        }
        if (((Class<?>[])object2).length == 0) {
            return new String[0];
        }
        object = annotationArray2.getClassLoader();
        if (object == null) {
            object = ClassLoader.getSystemClassLoader();
        }
        annotationArray2 = annotationArray2.getName();
        if ((object = ((ClassLoader)object).getResourceAsStream((String)(annotationArray2 = annotationArray2.replace('.', '/') + ".class"))) == null) {
            return new String[0];
        }
        try {
            annotationArray2 = new ClassReader((InputStream)object, false);
            object2 = new TypeCollector(string, (Class<?>[])object2);
            annotationArray2.accept((TypeCollector)object2);
            object2 = ((TypeCollector)object2).getParameterNamesForMethod();
            for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
                annotationArray2 = annotationArray[i2];
                if (annotationArray2 == null) continue;
                for (int i3 = 0; i3 < annotationArray2.length; ++i3) {
                    if (!(annotationArray2[i3] instanceof JSONField)) continue;
                    Object object3 = (JSONField)annotationArray2[i3];
                    if ((object3 = object3.name()) == null || ((String)object3).length() <= 0) continue;
                    object2[i2] = object3;
                }
            }
            Object object4 = object2;
            return object4;
        }
        catch (IOException iOException) {
            object2 = new String[]{};
            return object2;
        }
        finally {
            IOUtils.close((Closeable)object);
        }
    }
}

