/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.TlsSystemConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.LanguageCode;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class ClientConfig {
    public static final String SEND_MESSAGE_WITH_VIP_CHANNEL_PROPERTY = "com.rocketmq.sendMessageWithVIPChannel";
    public static final String DECODE_READ_BODY = "com.rocketmq.read.body";
    public static final String DECODE_DECOMPRESS_BODY = "com.rocketmq.decompress.body";
    public static final String AUTO_CLEAN_NO_ROUTE_TOPIC = "com.rocketmq.autoclean.noroute.topic";
    public static final String CLIENT_CALLBACK_EXECUTOR_THREAD_NUMS = "client.callback.executor.thread.nums";
    private String namesrvAddr = System.getProperty("rocketmq.namesrv.addr", System.getenv("NAMESRV_ADDR"));
    private String clientIP = RemotingUtil.getLocalAddress();
    private String instanceName = System.getProperty("rocketmq.client.name", "DEFAULT");
    public String namespace;
    private int clientCallbackExecutorThreads = Integer.parseInt(System.getProperty("client.callback.executor.thread.nums", String.valueOf(Runtime.getRuntime().availableProcessors())));
    private int pollNameServerInterval = 30000;
    private int heartbeatBrokerInterval = 30000;
    private int persistConsumerOffsetInterval = 5000;
    private boolean unitMode = false;
    private String unitName;
    private boolean vipChannelEnabled = Boolean.parseBoolean(System.getProperty("com.rocketmq.sendMessageWithVIPChannel", "true"));
    private boolean decodeReadBody = Boolean.parseBoolean(System.getProperty("com.rocketmq.read.body", "true"));
    private boolean decodeDecompressBody = Boolean.parseBoolean(System.getProperty("com.rocketmq.decompress.body", "true"));
    private boolean autoCleanTopicRouteNotFound = Boolean.parseBoolean(System.getProperty("com.rocketmq.autoclean.noroute.topic", "false"));
    private boolean useTLS = TlsSystemConfig.tlsEnable;
    private LanguageCode language = LanguageCode.JAVA;

    public String buildMQClientId() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClientIP());
        stringBuilder.append("@");
        stringBuilder.append(this.getInstanceName());
        if (!UtilAll.isBlank(this.unitName)) {
            stringBuilder.append("@");
            stringBuilder.append(this.unitName);
        }
        return stringBuilder.toString();
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String string) {
        this.clientIP = string;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String string) {
        this.instanceName = string;
    }

    public void changeInstanceNameToPID() {
        if (this.instanceName.equals("DEFAULT")) {
            this.instanceName = String.valueOf(UtilAll.getPid());
        }
    }

    public String withNamespace(String string) {
        return NamespaceUtil.wrapNamespace(this.getNamespace(), string);
    }

    public Set<String> withNamespace(Set<String> object) {
        HashSet<String> hashSet = new HashSet<String>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            hashSet.add(this.withNamespace(string));
        }
        return hashSet;
    }

    public String withoutNamespace(String string) {
        return NamespaceUtil.withoutNamespace(string, this.getNamespace());
    }

    public Set<String> withoutNamespace(Set<String> object) {
        HashSet<String> hashSet = new HashSet<String>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            hashSet.add(this.withoutNamespace(string));
        }
        return hashSet;
    }

    public MessageQueue queueWithNamespace(MessageQueue messageQueue) {
        if (StringUtils.isEmpty(this.getNamespace())) {
            return messageQueue;
        }
        return new MessageQueue(this.withNamespace(messageQueue.getTopic()), messageQueue.getBrokerName(), messageQueue.getQueueId());
    }

    public void resetClientConfig(ClientConfig clientConfig) {
        this.namesrvAddr = clientConfig.namesrvAddr;
        this.clientIP = clientConfig.clientIP;
        this.instanceName = clientConfig.instanceName;
        this.clientCallbackExecutorThreads = clientConfig.clientCallbackExecutorThreads;
        this.pollNameServerInterval = clientConfig.pollNameServerInterval;
        this.heartbeatBrokerInterval = clientConfig.heartbeatBrokerInterval;
        this.persistConsumerOffsetInterval = clientConfig.persistConsumerOffsetInterval;
        this.unitMode = clientConfig.unitMode;
        this.unitName = clientConfig.unitName;
        this.vipChannelEnabled = clientConfig.vipChannelEnabled;
        this.decodeReadBody = clientConfig.decodeReadBody;
        this.decodeDecompressBody = clientConfig.decodeDecompressBody;
        this.useTLS = clientConfig.useTLS;
        this.language = clientConfig.language;
        this.namespace = clientConfig.namespace;
        this.autoCleanTopicRouteNotFound = clientConfig.autoCleanTopicRouteNotFound;
    }

    public ClientConfig cloneClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        new ClientConfig().namesrvAddr = this.namesrvAddr;
        clientConfig.clientIP = this.clientIP;
        clientConfig.instanceName = this.instanceName;
        clientConfig.clientCallbackExecutorThreads = this.clientCallbackExecutorThreads;
        clientConfig.pollNameServerInterval = this.pollNameServerInterval;
        clientConfig.heartbeatBrokerInterval = this.heartbeatBrokerInterval;
        clientConfig.persistConsumerOffsetInterval = this.persistConsumerOffsetInterval;
        clientConfig.unitMode = this.unitMode;
        clientConfig.unitName = this.unitName;
        clientConfig.vipChannelEnabled = this.vipChannelEnabled;
        clientConfig.decodeReadBody = this.decodeReadBody;
        clientConfig.decodeDecompressBody = this.decodeDecompressBody;
        clientConfig.useTLS = this.useTLS;
        clientConfig.language = this.language;
        clientConfig.namespace = this.namespace;
        clientConfig.autoCleanTopicRouteNotFound = this.autoCleanTopicRouteNotFound;
        return clientConfig;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String string) {
        this.namesrvAddr = string;
    }

    public int getClientCallbackExecutorThreads() {
        return this.clientCallbackExecutorThreads;
    }

    public void setClientCallbackExecutorThreads(int n2) {
        this.clientCallbackExecutorThreads = n2;
    }

    public int getPollNameServerInterval() {
        return this.pollNameServerInterval;
    }

    public void setPollNameServerInterval(int n2) {
        this.pollNameServerInterval = n2;
    }

    public int getHeartbeatBrokerInterval() {
        return this.heartbeatBrokerInterval;
    }

    public void setHeartbeatBrokerInterval(int n2) {
        this.heartbeatBrokerInterval = n2;
    }

    public int getPersistConsumerOffsetInterval() {
        return this.persistConsumerOffsetInterval;
    }

    public void setPersistConsumerOffsetInterval(int n2) {
        this.persistConsumerOffsetInterval = n2;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String string) {
        this.unitName = string;
    }

    public boolean isUnitMode() {
        return this.unitMode;
    }

    public void setUnitMode(boolean bl) {
        this.unitMode = bl;
    }

    public boolean isVipChannelEnabled() {
        return this.vipChannelEnabled;
    }

    public void setVipChannelEnabled(boolean bl) {
        this.vipChannelEnabled = bl;
    }

    public boolean isDecodeReadBody() {
        return this.decodeReadBody;
    }

    public void setDecodeReadBody(boolean bl) {
        this.decodeReadBody = bl;
    }

    public boolean isDecodeDecompressBody() {
        return this.decodeDecompressBody;
    }

    public void setDecodeDecompressBody(boolean bl) {
        this.decodeDecompressBody = bl;
    }

    public String getNamespace() {
        return this.namespace;
    }

    protected void setNamespace(String string) {
        this.namespace = string;
    }

    public boolean isUseTLS() {
        return this.useTLS;
    }

    public void setUseTLS(boolean bl) {
        this.useTLS = bl;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public void setLanguage(LanguageCode languageCode) {
        this.language = languageCode;
    }

    public boolean isAutoCleanTopicRouteNotFound() {
        return this.autoCleanTopicRouteNotFound;
    }

    public void setAutoCleanTopicRouteNotFound(boolean bl) {
        this.autoCleanTopicRouteNotFound = bl;
    }

    public String toString() {
        return "ClientConfig [namesrvAddr=" + this.namesrvAddr + ", clientIP=" + this.clientIP + ", instanceName=" + this.instanceName + ", clientCallbackExecutorThreads=" + this.clientCallbackExecutorThreads + ", pollNameServerInterval=" + this.pollNameServerInterval + ", heartbeatBrokerInterval=" + this.heartbeatBrokerInterval + ", persistConsumerOffsetInterval=" + this.persistConsumerOffsetInterval + ", unitMode=" + this.unitMode + ", unitName=" + this.unitName + ", vipChannelEnabled=" + this.vipChannelEnabled + ", decodeReadBody=" + this.decodeReadBody + ", decodeDecompressBody=" + this.decodeDecompressBody + ", useTLS=" + this.useTLS + ", language=" + this.language.name() + ", namespace=" + this.namespace + ", autoCleanNoRouteTopic=" + this.autoCleanTopicRouteNotFound + "]";
    }
}

