/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Validators {
    public static final String VALID_PATTERN_STR = "^[%|a-zA-Z0-9._-]+$";
    public static final Pattern PATTERN = Pattern.compile("^[%|a-zA-Z0-9._-]+$");
    public static final int CHARACTER_MAX_LENGTH = 255;

    public static String getGroupWithRegularExpression(String object, String object2) {
        object = ((Pattern)(object2 = Pattern.compile((String)object2))).matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group(0);
        }
        return null;
    }

    public static void checkGroup(String string) {
        if (UtilAll.isBlank(string)) {
            throw new MQClientException("the specified group is blank", null);
        }
        if (!Validators.regularExpressionMatcher(string, PATTERN)) {
            throw new MQClientException(String.format("the specified group[%s] contains illegal characters, allowing only %s", string, VALID_PATTERN_STR), null);
        }
        if (string.length() > 255) {
            throw new MQClientException("the specified group is longer than group max length 255.", null);
        }
    }

    public static boolean regularExpressionMatcher(String object, Pattern pattern) {
        if (pattern == null) {
            return true;
        }
        object = pattern.matcher((CharSequence)object);
        return ((Matcher)object).matches();
    }

    public static void checkMessage(Message message, DefaultMQProducer defaultMQProducer) {
        if (message == null) {
            throw new MQClientException(13, "the message is null");
        }
        Validators.checkTopic(message.getTopic());
        if (null == message.getBody()) {
            throw new MQClientException(13, "the message body is null");
        }
        if (0 == message.getBody().length) {
            throw new MQClientException(13, "the message body length is zero");
        }
        if (message.getBody().length > defaultMQProducer.getMaxMessageSize()) {
            throw new MQClientException(13, "the message body size over max value, MAX: " + defaultMQProducer.getMaxMessageSize());
        }
    }

    public static void checkTopic(String string) {
        if (UtilAll.isBlank(string)) {
            throw new MQClientException("The specified topic is blank", null);
        }
        if (!Validators.regularExpressionMatcher(string, PATTERN)) {
            throw new MQClientException(String.format("The specified topic[%s] contains illegal characters, allowing only %s", string, VALID_PATTERN_STR), null);
        }
        if (string.length() > 255) {
            throw new MQClientException("The specified topic is longer than topic max length 255.", null);
        }
        if (string.equals("TBW102")) {
            throw new MQClientException(String.format("The topic[%s] is conflict with default topic.", string), null);
        }
    }
}

