/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPullConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MQPullConsumerScheduleService$MessageQueueListenerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MQPullConsumerScheduleService$PullTaskImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MessageQueueListener;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PullTaskCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ThreadFactoryImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MQPullConsumerScheduleService {
    private final InternalLogger log = ClientLogger.getLog();
    private final MessageQueueListener messageQueueListener = new MQPullConsumerScheduleService$MessageQueueListenerImpl(this);
    private final ConcurrentMap<MessageQueue, MQPullConsumerScheduleService$PullTaskImpl> taskTable = new ConcurrentHashMap<MessageQueue, MQPullConsumerScheduleService$PullTaskImpl>();
    private DefaultMQPullConsumer defaultMQPullConsumer;
    private int pullThreadNums = 20;
    private ConcurrentMap<String, PullTaskCallback> callbackTable = new ConcurrentHashMap<String, PullTaskCallback>();
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;

    public MQPullConsumerScheduleService(String string) {
        this.defaultMQPullConsumer = new DefaultMQPullConsumer(string);
        this.defaultMQPullConsumer.setMessageModel(MessageModel.CLUSTERING);
    }

    public void putTask(String object, Set<MessageQueue> object2) {
        Map.Entry entry;
        Iterator iterator = this.taskTable.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!((MessageQueue)entry.getKey()).getTopic().equals(object) || object2.contains(entry.getKey())) continue;
            ((MQPullConsumerScheduleService$PullTaskImpl)entry.getValue()).setCancelled(true);
            iterator.remove();
        }
        entry = object2.iterator();
        while (entry.hasNext()) {
            object = (MessageQueue)entry.next();
            if (this.taskTable.containsKey(object)) continue;
            object2 = new MQPullConsumerScheduleService$PullTaskImpl(this, (MessageQueue)object);
            this.taskTable.put((MessageQueue)object, (MQPullConsumerScheduleService$PullTaskImpl)object2);
            this.scheduledThreadPoolExecutor.schedule((Runnable)object2, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public void start() {
        String string = this.defaultMQPullConsumer.getConsumerGroup();
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(this.pullThreadNums, new ThreadFactoryImpl("PullMsgThread-" + string));
        this.defaultMQPullConsumer.setMessageQueueListener(this.messageQueueListener);
        this.defaultMQPullConsumer.start();
        this.log.info("MQPullConsumerScheduleService start OK, {} {}", (Object)this.defaultMQPullConsumer.getConsumerGroup(), (Object)this.callbackTable);
    }

    public void registerPullTaskCallback(String string, PullTaskCallback pullTaskCallback) {
        this.callbackTable.put(string, pullTaskCallback);
        this.defaultMQPullConsumer.registerMessageQueueListener(string, null);
    }

    public void shutdown() {
        if (this.scheduledThreadPoolExecutor != null) {
            this.scheduledThreadPoolExecutor.shutdown();
        }
        if (this.defaultMQPullConsumer != null) {
            this.defaultMQPullConsumer.shutdown();
        }
    }

    public ConcurrentMap<String, PullTaskCallback> getCallbackTable() {
        return this.callbackTable;
    }

    public void setCallbackTable(ConcurrentHashMap<String, PullTaskCallback> concurrentHashMap) {
        this.callbackTable = concurrentHashMap;
    }

    public int getPullThreadNums() {
        return this.pullThreadNums;
    }

    public void setPullThreadNums(int n2) {
        this.pullThreadNums = n2;
    }

    public DefaultMQPullConsumer getDefaultMQPullConsumer() {
        return this.defaultMQPullConsumer;
    }

    public void setDefaultMQPullConsumer(DefaultMQPullConsumer defaultMQPullConsumer) {
        this.defaultMQPullConsumer = defaultMQPullConsumer;
    }

    public MessageModel getMessageModel() {
        return this.defaultMQPullConsumer.getMessageModel();
    }

    public void setMessageModel(MessageModel messageModel) {
        this.defaultMQPullConsumer.setMessageModel(messageModel);
    }

    static /* synthetic */ DefaultMQPullConsumer access$000(MQPullConsumerScheduleService mQPullConsumerScheduleService) {
        return mQPullConsumerScheduleService.defaultMQPullConsumer;
    }

    static /* synthetic */ ConcurrentMap access$100(MQPullConsumerScheduleService mQPullConsumerScheduleService) {
        return mQPullConsumerScheduleService.callbackTable;
    }

    static /* synthetic */ InternalLogger access$200(MQPullConsumerScheduleService mQPullConsumerScheduleService) {
        return mQPullConsumerScheduleService.log;
    }

    static /* synthetic */ ScheduledThreadPoolExecutor access$300(MQPullConsumerScheduleService mQPullConsumerScheduleService) {
        return mQPullConsumerScheduleService.scheduledThreadPoolExecutor;
    }
}

