/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.LocalFileOffsetStore$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.OffsetSerializeWrapper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.OffsetStore;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.ReadOffsetType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.help.FAQUrl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class LocalFileOffsetStore
implements OffsetStore {
    public static final String LOCAL_OFFSET_STORE_DIR = System.getProperty("rocketmq.client.localOffsetStoreDir", System.getProperty("user.home") + File.separator + ".rocketmq_offsets");
    private static final InternalLogger log = ClientLogger.getLog();
    private final MQClientInstance mQClientFactory;
    private final String groupName;
    private final String storePath;
    private ConcurrentMap<MessageQueue, AtomicLong> offsetTable = new ConcurrentHashMap<MessageQueue, AtomicLong>();

    public LocalFileOffsetStore(MQClientInstance mQClientInstance, String string) {
        this.mQClientFactory = mQClientInstance;
        this.groupName = string;
        this.storePath = LOCAL_OFFSET_STORE_DIR + File.separator + this.mQClientFactory.getClientId() + File.separator + this.groupName + File.separator + "offsets.json";
    }

    @Override
    public void load() {
        OffsetSerializeWrapper offsetSerializeWrapper = this.readLocalOffset();
        if (offsetSerializeWrapper != null && offsetSerializeWrapper.getOffsetTable() != null) {
            this.offsetTable.putAll(offsetSerializeWrapper.getOffsetTable());
            for (MessageQueue messageQueue : offsetSerializeWrapper.getOffsetTable().keySet()) {
                AtomicLong atomicLong = (AtomicLong)offsetSerializeWrapper.getOffsetTable().get(messageQueue);
                log.info("load consumer's offset, {} {} {}", this.groupName, messageQueue, atomicLong.get());
            }
        }
    }

    @Override
    public void updateOffset(MessageQueue messageQueue, long l2, boolean bl) {
        if (messageQueue != null) {
            AtomicLong atomicLong = (AtomicLong)this.offsetTable.get(messageQueue);
            if (atomicLong == null) {
                atomicLong = this.offsetTable.putIfAbsent(messageQueue, new AtomicLong(l2));
            }
            if (atomicLong != null) {
                if (bl) {
                    MixAll.compareAndIncreaseOnly(atomicLong, l2);
                    return;
                }
                atomicLong.set(l2);
            }
        }
    }

    @Override
    public long readOffset(MessageQueue messageQueue, ReadOffsetType object) {
        if (messageQueue != null) {
            switch (LocalFileOffsetStore$1.$SwitchMap$org$apache$rocketmq$client$consumer$store$ReadOffsetType[((Enum)object).ordinal()]) {
                case 1: 
                case 2: {
                    Object object2 = (AtomicLong)this.offsetTable.get(messageQueue);
                    if (object2 != null) {
                        return ((AtomicLong)object2).get();
                    }
                    if (ReadOffsetType.READ_FROM_MEMORY == object) {
                        return -1L;
                    }
                }
                case 3: {
                    Object object2;
                    try {
                        object2 = this.readLocalOffset();
                    }
                    catch (MQClientException mQClientException) {
                        return -1L;
                    }
                    if (object2 == null || ((OffsetSerializeWrapper)object2).getOffsetTable() == null || (object = (AtomicLong)((OffsetSerializeWrapper)object2).getOffsetTable().get(messageQueue)) == null) break;
                    this.updateOffset(messageQueue, ((AtomicLong)object).get(), false);
                    return ((AtomicLong)object).get();
                }
            }
        }
        return -1L;
    }

    @Override
    public void persistAll(Set<MessageQueue> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        OffsetSerializeWrapper offsetSerializeWrapper = new OffsetSerializeWrapper();
        for (Map.Entry entry : this.offsetTable.entrySet()) {
            if (!set.contains(entry.getKey())) continue;
            AtomicLong atomicLong = (AtomicLong)entry.getValue();
            offsetSerializeWrapper.getOffsetTable().put((MessageQueue)entry.getKey(), atomicLong);
        }
        String string = offsetSerializeWrapper.toJson(true);
        if (string != null) {
            try {
                MixAll.string2File(string, this.storePath);
                return;
            }
            catch (IOException iOException) {
                log.error("persistAll consumer offset Exception, " + this.storePath, iOException);
            }
        }
    }

    @Override
    public void persist(MessageQueue messageQueue) {
    }

    @Override
    public void removeOffset(MessageQueue messageQueue) {
    }

    @Override
    public void updateConsumeOffsetToBroker(MessageQueue messageQueue, long l2, boolean bl) {
    }

    @Override
    public Map<MessageQueue, Long> cloneOffsetTable(String string) {
        HashMap<MessageQueue, Long> hashMap = new HashMap<MessageQueue, Long>();
        for (Map.Entry entry : this.offsetTable.entrySet()) {
            MessageQueue messageQueue = (MessageQueue)entry.getKey();
            if (!UtilAll.isBlank(string) && !string.equals(messageQueue.getTopic())) continue;
            hashMap.put(messageQueue, ((AtomicLong)entry.getValue()).get());
        }
        return hashMap;
    }

    private OffsetSerializeWrapper readLocalOffset() {
        OffsetSerializeWrapper offsetSerializeWrapper;
        String string = null;
        try {
            string = MixAll.file2String(this.storePath);
        }
        catch (IOException iOException) {
            log.warn("Load local offset store file exception", iOException);
        }
        if (string == null || string.length() == 0) {
            return this.readLocalOffsetBak();
        }
        try {
            offsetSerializeWrapper = OffsetSerializeWrapper.fromJson(string, OffsetSerializeWrapper.class);
        }
        catch (Exception exception) {
            log.warn("readLocalOffset Exception, and try to correct", exception);
            return this.readLocalOffsetBak();
        }
        return offsetSerializeWrapper;
    }

    private OffsetSerializeWrapper readLocalOffsetBak() {
        String string = null;
        try {
            string = MixAll.file2String(this.storePath + ".bak");
        }
        catch (IOException iOException) {
            log.warn("Load local offset store bak file exception", iOException);
        }
        if (string != null && string.length() > 0) {
            OffsetSerializeWrapper offsetSerializeWrapper;
            try {
                offsetSerializeWrapper = OffsetSerializeWrapper.fromJson(string, OffsetSerializeWrapper.class);
            }
            catch (Exception exception) {
                log.warn("readLocalOffset Exception", exception);
                throw new MQClientException("readLocalOffset Exception, maybe fastjson version too low" + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), exception);
            }
            return offsetSerializeWrapper;
        }
        return null;
    }
}

