/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.OffsetStore;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.ReadOffsetType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.RemoteBrokerOffsetStore$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.FindBrokerResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.QueryConsumerOffsetRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.UpdateConsumerOffsetRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class RemoteBrokerOffsetStore
implements OffsetStore {
    private static final InternalLogger log = ClientLogger.getLog();
    private final MQClientInstance mQClientFactory;
    private final String groupName;
    private ConcurrentMap<MessageQueue, AtomicLong> offsetTable = new ConcurrentHashMap<MessageQueue, AtomicLong>();

    public RemoteBrokerOffsetStore(MQClientInstance mQClientInstance, String string) {
        this.mQClientFactory = mQClientInstance;
        this.groupName = string;
    }

    @Override
    public void load() {
    }

    @Override
    public void updateOffset(MessageQueue messageQueue, long l2, boolean bl) {
        if (messageQueue != null) {
            AtomicLong atomicLong = (AtomicLong)this.offsetTable.get(messageQueue);
            if (atomicLong == null) {
                atomicLong = this.offsetTable.putIfAbsent(messageQueue, new AtomicLong(l2));
            }
            if (atomicLong != null) {
                if (bl) {
                    MixAll.compareAndIncreaseOnly(atomicLong, l2);
                    return;
                }
                atomicLong.set(l2);
            }
        }
    }

    @Override
    public long readOffset(MessageQueue messageQueue, ReadOffsetType object) {
        if (messageQueue != null) {
            switch (RemoteBrokerOffsetStore$1.$SwitchMap$org$apache$rocketmq$client$consumer$store$ReadOffsetType[((Enum)object).ordinal()]) {
                case 1: 
                case 2: {
                    AtomicLong atomicLong = (AtomicLong)this.offsetTable.get(messageQueue);
                    if (atomicLong != null) {
                        return atomicLong.get();
                    }
                    if (ReadOffsetType.READ_FROM_MEMORY == object) {
                        return -1L;
                    }
                }
                case 3: {
                    try {
                        long l2 = this.fetchConsumeOffsetFromBroker(messageQueue);
                        object = new AtomicLong(l2);
                        this.updateOffset(messageQueue, ((AtomicLong)object).get(), false);
                        return l2;
                    }
                    catch (MQBrokerException mQBrokerException) {
                        return -1L;
                    }
                    catch (Exception exception) {
                        log.warn("fetchConsumeOffsetFromBroker exception, " + messageQueue, exception);
                        return -2L;
                    }
                }
            }
        }
        return -1L;
    }

    @Override
    public void persistAll(Set<MessageQueue> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        HashSet<MessageQueue> hashSet = new HashSet<MessageQueue>();
        if (!set.isEmpty()) {
            for (Map.Entry exception : this.offsetTable.entrySet()) {
                MessageQueue messageQueue = (MessageQueue)exception.getKey();
                AtomicLong atomicLong = (AtomicLong)exception.getValue();
                if (atomicLong == null) continue;
                if (set.contains(messageQueue)) {
                    try {
                        this.updateConsumeOffsetToBroker(messageQueue, atomicLong.get());
                        log.info("[persistAll] Group: {} ClientId: {} updateConsumeOffsetToBroker {} {}", this.groupName, this.mQClientFactory.getClientId(), messageQueue, atomicLong.get());
                    }
                    catch (Exception exception2) {
                        log.error("updateConsumeOffsetToBroker exception, " + messageQueue.toString(), exception2);
                    }
                    continue;
                }
                hashSet.add(messageQueue);
            }
        }
        if (!hashSet.isEmpty()) {
            for (MessageQueue messageQueue : hashSet) {
                this.offsetTable.remove(messageQueue);
                log.info("remove unused mq, {}, {}", (Object)messageQueue, (Object)this.groupName);
            }
        }
    }

    @Override
    public void persist(MessageQueue messageQueue) {
        AtomicLong atomicLong = (AtomicLong)this.offsetTable.get(messageQueue);
        if (atomicLong != null) {
            try {
                this.updateConsumeOffsetToBroker(messageQueue, atomicLong.get());
                log.info("[persist] Group: {} ClientId: {} updateConsumeOffsetToBroker {} {}", this.groupName, this.mQClientFactory.getClientId(), messageQueue, atomicLong.get());
                return;
            }
            catch (Exception exception) {
                log.error("updateConsumeOffsetToBroker exception, " + messageQueue.toString(), exception);
            }
        }
    }

    @Override
    public void removeOffset(MessageQueue messageQueue) {
        if (messageQueue != null) {
            this.offsetTable.remove(messageQueue);
            log.info("remove unnecessary messageQueue offset. group={}, mq={}, offsetTableSize={}", this.groupName, messageQueue, this.offsetTable.size());
        }
    }

    @Override
    public Map<MessageQueue, Long> cloneOffsetTable(String string) {
        HashMap<MessageQueue, Long> hashMap = new HashMap<MessageQueue, Long>();
        for (Map.Entry entry : this.offsetTable.entrySet()) {
            MessageQueue messageQueue = (MessageQueue)entry.getKey();
            if (!UtilAll.isBlank(string) && !string.equals(messageQueue.getTopic())) continue;
            hashMap.put(messageQueue, ((AtomicLong)entry.getValue()).get());
        }
        return hashMap;
    }

    private void updateConsumeOffsetToBroker(MessageQueue messageQueue, long l2) {
        this.updateConsumeOffsetToBroker(messageQueue, l2, true);
    }

    @Override
    public void updateConsumeOffsetToBroker(MessageQueue messageQueue, long l2, boolean bl) {
        UpdateConsumerOffsetRequestHeader updateConsumerOffsetRequestHeader;
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInAdmin(messageQueue.getBrokerName());
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(messageQueue.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInAdmin(messageQueue.getBrokerName());
        }
        if (findBrokerResult != null) {
            updateConsumerOffsetRequestHeader = new UpdateConsumerOffsetRequestHeader();
            updateConsumerOffsetRequestHeader.setTopic(messageQueue.getTopic());
            updateConsumerOffsetRequestHeader.setConsumerGroup(this.groupName);
            updateConsumerOffsetRequestHeader.setQueueId(messageQueue.getQueueId());
            updateConsumerOffsetRequestHeader.setCommitOffset(l2);
            if (!bl) {
                this.mQClientFactory.getMQClientAPIImpl().updateConsumerOffset(findBrokerResult.getBrokerAddr(), updateConsumerOffsetRequestHeader, 5000L);
                return;
            }
        } else {
            throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
        }
        this.mQClientFactory.getMQClientAPIImpl().updateConsumerOffsetOneway(findBrokerResult.getBrokerAddr(), updateConsumerOffsetRequestHeader, 5000L);
    }

    private long fetchConsumeOffsetFromBroker(MessageQueue messageQueue) {
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInAdmin(messageQueue.getBrokerName());
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(messageQueue.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInAdmin(messageQueue.getBrokerName());
        }
        if (findBrokerResult != null) {
            QueryConsumerOffsetRequestHeader queryConsumerOffsetRequestHeader = new QueryConsumerOffsetRequestHeader();
            queryConsumerOffsetRequestHeader.setTopic(messageQueue.getTopic());
            queryConsumerOffsetRequestHeader.setConsumerGroup(this.groupName);
            queryConsumerOffsetRequestHeader.setQueueId(messageQueue.getQueueId());
            return this.mQClientFactory.getMQClientAPIImpl().queryConsumerOffset(findBrokerResult.getBrokerAddr(), queryConsumerOffsetRequestHeader, 5000L);
        }
        throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
    }
}

