/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.producer.MQProducerInner;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageDecoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ConsumerRunningInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.GetConsumerStatusBody;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ResetOffsetBody;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.CheckTransactionStateRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.ConsumeMessageDirectlyResultRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.GetConsumerRunningInfoRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.GetConsumerStatusRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.NotifyConsumerIdsChangedRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.ResetOffsetRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.netty.NettyRequestProcessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingCommand;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.protocol.RemotingSerializable;
import com.aliyun.openservices.shade.io.netty.channel.ChannelHandlerContext;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class ClientRemotingProcessor
implements NettyRequestProcessor {
    private final InternalLogger log = ClientLogger.getLog();
    private final MQClientInstance mqClientFactory;

    public ClientRemotingProcessor(MQClientInstance mQClientInstance) {
        this.mqClientFactory = mQClientInstance;
    }

    @Override
    public RemotingCommand processRequest(ChannelHandlerContext channelHandlerContext, RemotingCommand remotingCommand) {
        switch (remotingCommand.getCode()) {
            case 39: {
                return this.checkTransactionState(channelHandlerContext, remotingCommand);
            }
            case 40: {
                return this.notifyConsumerIdsChanged(channelHandlerContext, remotingCommand);
            }
            case 220: {
                return this.resetOffset(channelHandlerContext, remotingCommand);
            }
            case 221: {
                return this.getConsumeStatus(channelHandlerContext, remotingCommand);
            }
            case 307: {
                return this.getConsumerRunningInfo(channelHandlerContext, remotingCommand);
            }
            case 309: {
                return this.consumeMessageDirectly(channelHandlerContext, remotingCommand);
            }
        }
        return null;
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }

    public RemotingCommand checkTransactionState(ChannelHandlerContext object, RemotingCommand object2) {
        CheckTransactionStateRequestHeader checkTransactionStateRequestHeader = (CheckTransactionStateRequestHeader)((RemotingCommand)object2).decodeCommandCustomHeader(CheckTransactionStateRequestHeader.class);
        object2 = ByteBuffer.wrap(((RemotingCommand)object2).getBody());
        if ((object2 = MessageDecoder.decode((ByteBuffer)object2)) != null) {
            String string;
            if (StringUtils.isNotEmpty(this.mqClientFactory.getClientConfig().getNamespace())) {
                Object object3 = object2;
                ((Message)object3).setTopic(NamespaceUtil.withoutNamespace(((Message)object3).getTopic(), this.mqClientFactory.getClientConfig().getNamespace()));
            }
            if ((string = ((Message)object2).getProperty("PGROUP")) != null) {
                MQProducerInner mQProducerInner = this.mqClientFactory.selectProducer(string);
                if (mQProducerInner != null) {
                    object = RemotingHelper.parseChannelRemoteAddr(object.channel());
                    mQProducerInner.checkTransactionState((String)object, (MessageExt)object2, checkTransactionStateRequestHeader);
                } else {
                    this.log.debug("checkTransactionState, pick producer by group[{}] failed", (Object)string);
                }
            } else {
                this.log.warn("checkTransactionState, pick producer group failed");
            }
        } else {
            this.log.warn("checkTransactionState, decode message failed");
        }
        return null;
    }

    public RemotingCommand notifyConsumerIdsChanged(ChannelHandlerContext channelHandlerContext, RemotingCommand object) {
        try {
            object = (NotifyConsumerIdsChangedRequestHeader)((RemotingCommand)object).decodeCommandCustomHeader(NotifyConsumerIdsChangedRequestHeader.class);
            this.log.info("receive broker's notification[{}], the consumer group: {} changed, rebalance immediately", (Object)RemotingHelper.parseChannelRemoteAddr(channelHandlerContext.channel()), (Object)((NotifyConsumerIdsChangedRequestHeader)object).getConsumerGroup());
            this.mqClientFactory.rebalanceImmediately();
        }
        catch (Exception exception) {
            this.log.error("notifyConsumerIdsChanged exception", (Object)RemotingHelper.exceptionSimpleDesc(exception));
        }
        return null;
    }

    public RemotingCommand resetOffset(ChannelHandlerContext map, RemotingCommand remotingCommand) {
        ResetOffsetRequestHeader resetOffsetRequestHeader = (ResetOffsetRequestHeader)remotingCommand.decodeCommandCustomHeader(ResetOffsetRequestHeader.class);
        this.log.info("invoke reset offset operation from broker. brokerAddr={}, topic={}, group={}, timestamp={}", RemotingHelper.parseChannelRemoteAddr(map.channel()), resetOffsetRequestHeader.getTopic(), resetOffsetRequestHeader.getGroup(), resetOffsetRequestHeader.getTimestamp());
        map = new HashMap();
        if (remotingCommand.getBody() != null) {
            map = ResetOffsetBody.decode(remotingCommand.getBody(), ResetOffsetBody.class);
            map = ((ResetOffsetBody)((Object)map)).getOffsetTable();
        }
        this.mqClientFactory.resetOffset(resetOffsetRequestHeader.getTopic(), resetOffsetRequestHeader.getGroup(), map);
        return null;
    }

    @Deprecated
    public RemotingCommand getConsumeStatus(ChannelHandlerContext object, RemotingCommand map) {
        object = RemotingCommand.createResponseCommand(null);
        map = (GetConsumerStatusRequestHeader)((RemotingCommand)((Object)map)).decodeCommandCustomHeader(GetConsumerStatusRequestHeader.class);
        map = this.mqClientFactory.getConsumerStatus(((GetConsumerStatusRequestHeader)((Object)map)).getTopic(), ((GetConsumerStatusRequestHeader)((Object)map)).getGroup());
        GetConsumerStatusBody getConsumerStatusBody = new GetConsumerStatusBody();
        getConsumerStatusBody.setMessageQueueTable(map);
        ((RemotingCommand)object).setBody(getConsumerStatusBody.encode());
        ((RemotingCommand)object).setCode(0);
        return object;
    }

    private RemotingCommand getConsumerRunningInfo(ChannelHandlerContext object, RemotingCommand object2) {
        object = RemotingCommand.createResponseCommand(null);
        ConsumerRunningInfo consumerRunningInfo = this.mqClientFactory.consumerRunningInfo(((GetConsumerRunningInfoRequestHeader)(object2 = (GetConsumerRunningInfoRequestHeader)((RemotingCommand)object2).decodeCommandCustomHeader(GetConsumerRunningInfoRequestHeader.class))).getConsumerGroup());
        if (consumerRunningInfo != null) {
            if (((GetConsumerRunningInfoRequestHeader)object2).isJstackEnable()) {
                object2 = Thread.getAllStackTraces();
                object2 = UtilAll.jstack(object2);
                consumerRunningInfo.setJstack((String)object2);
            }
            ((RemotingCommand)object).setCode(0);
            ((RemotingCommand)object).setBody(consumerRunningInfo.encode());
        } else {
            ((RemotingCommand)object).setCode(1);
            ((RemotingCommand)object).setRemark(String.format("The Consumer Group <%s> not exist in this consumer", ((GetConsumerRunningInfoRequestHeader)object2).getConsumerGroup()));
        }
        return object;
    }

    private RemotingCommand consumeMessageDirectly(ChannelHandlerContext object, RemotingCommand object2) {
        object = RemotingCommand.createResponseCommand(null);
        ConsumeMessageDirectlyResultRequestHeader consumeMessageDirectlyResultRequestHeader = (ConsumeMessageDirectlyResultRequestHeader)((RemotingCommand)object2).decodeCommandCustomHeader(ConsumeMessageDirectlyResultRequestHeader.class);
        object2 = MessageDecoder.decode(ByteBuffer.wrap(((RemotingCommand)object2).getBody()));
        if ((object2 = this.mqClientFactory.consumeMessageDirectly((MessageExt)object2, consumeMessageDirectlyResultRequestHeader.getConsumerGroup(), consumeMessageDirectlyResultRequestHeader.getBrokerName())) != null) {
            ((RemotingCommand)object).setCode(0);
            ((RemotingCommand)object).setBody(((RemotingSerializable)object2).encode());
        } else {
            ((RemotingCommand)object).setCode(1);
            ((RemotingCommand)object).setRemark(String.format("The Consumer Group <%s> not exist in this consumer", consumeMessageDirectlyResultRequestHeader.getConsumerGroup()));
        }
        return object;
    }
}

