/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.ClientConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class MQClientManager {
    private static final InternalLogger log = ClientLogger.getLog();
    private static MQClientManager instance = new MQClientManager();
    private AtomicInteger factoryIndexGenerator = new AtomicInteger();
    private ConcurrentMap<String, MQClientInstance> factoryTable = new ConcurrentHashMap<String, MQClientInstance>();

    private MQClientManager() {
    }

    public static MQClientManager getInstance() {
        return instance;
    }

    public MQClientInstance getAndCreateMQClientInstance(ClientConfig clientConfig) {
        return this.getAndCreateMQClientInstance(clientConfig, null);
    }

    public MQClientInstance getAndCreateMQClientInstance(ClientConfig clientConfig, RPCHook rPCHook) {
        return this.getAndCreateMQClientInstance(clientConfig, rPCHook, null, null);
    }

    public MQClientInstance getAndCreateMQClientInstance(ClientConfig object, RPCHook rPCHook, EventLoopGroup eventLoopGroup, EventExecutorGroup eventExecutorGroup) {
        String string = ((ClientConfig)object).buildMQClientId();
        Object object2 = (MQClientInstance)this.factoryTable.get(string);
        if (object2 == null) {
            object2 = new MQClientInstance(((ClientConfig)object).cloneClientConfig(), this.factoryIndexGenerator.getAndIncrement(), string, rPCHook, eventLoopGroup, eventExecutorGroup);
            if ((object = this.factoryTable.putIfAbsent(string, (MQClientInstance)object2)) != null) {
                object2 = object;
                log.warn("Returned Previous MQClientInstance for clientId:[{}]", (Object)string);
            } else {
                log.info("Created new MQClientInstance for clientId:[{}]", (Object)string);
            }
        }
        return object2;
    }

    public void removeClientFactory(String string) {
        this.factoryTable.remove(string);
    }
}

