/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeReturnType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.ConsumeMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ConsumeMessageConcurrentlyService;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ProcessQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

class ConsumeMessageConcurrentlyService$ConsumeRequest
implements Runnable {
    private final List<MessageExt> msgs;
    private final ProcessQueue processQueue;
    private final MessageQueue messageQueue;
    final /* synthetic */ ConsumeMessageConcurrentlyService this$0;

    public ConsumeMessageConcurrentlyService$ConsumeRequest(ConsumeMessageConcurrentlyService consumeMessageConcurrentlyService, List<MessageExt> list, ProcessQueue processQueue, MessageQueue messageQueue) {
        this.this$0 = consumeMessageConcurrentlyService;
        this.msgs = list;
        this.processQueue = processQueue;
        this.messageQueue = messageQueue;
    }

    public List<MessageExt> getMsgs() {
        return this.msgs;
    }

    public ProcessQueue getProcessQueue() {
        return this.processQueue;
    }

    @Override
    public void run() {
        if (this.processQueue.isDropped()) {
            ConsumeMessageConcurrentlyService.access$300().info("the message queue not be able to consume, because it's dropped. group={} {}", (Object)ConsumeMessageConcurrentlyService.access$200(this.this$0), (Object)this.messageQueue);
            return;
        }
        MessageListenerConcurrently messageListenerConcurrently = ConsumeMessageConcurrentlyService.access$400(this.this$0);
        ConsumeConcurrentlyContext consumeConcurrentlyContext = new ConsumeConcurrentlyContext(this.messageQueue);
        ConsumeConcurrentlyStatus consumeConcurrentlyStatus = null;
        ConsumeMessageConcurrentlyService.access$600(this.this$0).resetRetryAndNamespace(this.msgs, ConsumeMessageConcurrentlyService.access$500(this.this$0).getConsumerGroup());
        ConsumeMessageContext consumeMessageContext = null;
        if (ConsumeMessageConcurrentlyService.access$600(this.this$0).hasHook()) {
            consumeMessageContext = new ConsumeMessageContext();
            consumeMessageContext.setNamespace(ConsumeMessageConcurrentlyService.access$500(this.this$0).getNamespace());
            consumeMessageContext.setConsumerGroup(ConsumeMessageConcurrentlyService.access$500(this.this$0).getConsumerGroup());
            consumeMessageContext.setProps(new HashMap<String, String>());
            consumeMessageContext.setMq(this.messageQueue);
            consumeMessageContext.setMsgList(this.msgs);
            consumeMessageContext.setSuccess(false);
            ConsumeMessageConcurrentlyService.access$600(this.this$0).executeHookBefore(consumeMessageContext);
        }
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        ConsumeReturnType consumeReturnType = ConsumeReturnType.SUCCESS;
        try {
            if (this.msgs != null && !this.msgs.isEmpty()) {
                for (MessageExt messageExt : this.msgs) {
                    MessageAccessor.setConsumeStartTimeStamp(messageExt, String.valueOf(System.currentTimeMillis()));
                }
            }
            consumeConcurrentlyStatus = messageListenerConcurrently.consumeMessage(Collections.unmodifiableList(this.msgs), consumeConcurrentlyContext);
        }
        catch (Throwable throwable) {
            ConsumeMessageConcurrentlyService.access$300().warn("consumeMessage exception: {} Group: {} Msgs: {} MQ: {}", RemotingHelper.exceptionSimpleDesc(throwable), ConsumeMessageConcurrentlyService.access$200(this.this$0), this.msgs, this.messageQueue);
            bl = true;
        }
        long l3 = System.currentTimeMillis() - l2;
        if (consumeConcurrentlyStatus == null) {
            consumeReturnType = bl ? ConsumeReturnType.EXCEPTION : ConsumeReturnType.RETURNNULL;
        } else if (l3 >= ConsumeMessageConcurrentlyService.access$500(this.this$0).getConsumeTimeout() * 60L * 1000L) {
            consumeReturnType = ConsumeReturnType.TIME_OUT;
        } else if (ConsumeConcurrentlyStatus.RECONSUME_LATER == consumeConcurrentlyStatus) {
            consumeReturnType = ConsumeReturnType.FAILED;
        } else if (ConsumeConcurrentlyStatus.CONSUME_SUCCESS == consumeConcurrentlyStatus) {
            consumeReturnType = ConsumeReturnType.SUCCESS;
        }
        if (consumeConcurrentlyStatus == null) {
            ConsumeMessageConcurrentlyService.access$300().warn("consumeMessage return null, Group: {} Msgs: {} MQ: {}", ConsumeMessageConcurrentlyService.access$200(this.this$0), this.msgs, this.messageQueue);
            consumeConcurrentlyStatus = ConsumeConcurrentlyStatus.RECONSUME_LATER;
        }
        if (ConsumeMessageConcurrentlyService.access$600(this.this$0).hasHook()) {
            consumeMessageContext.getProps().put("ConsumeContextType", consumeReturnType.name());
            consumeMessageContext.getProps().put("ConsumeExactlyOnceStatus", consumeConcurrentlyContext.getExactlyOnceStatus().name());
            consumeMessageContext.setStatus(consumeConcurrentlyStatus.toString());
            consumeMessageContext.setSuccess(ConsumeConcurrentlyStatus.CONSUME_SUCCESS == consumeConcurrentlyStatus);
            ConsumeMessageConcurrentlyService.access$600(this.this$0).executeHookAfter(consumeMessageContext);
        }
        this.this$0.getConsumerStatsManager().incConsumeRT(ConsumeMessageConcurrentlyService.access$200(this.this$0), this.messageQueue.getTopic(), l3);
        if (!this.processQueue.isDropped()) {
            this.this$0.processConsumeResult(consumeConcurrentlyStatus, consumeConcurrentlyContext, this);
            return;
        }
        ConsumeMessageConcurrentlyService.access$300().warn("processQueue is dropped without process consume result. messageQueue={}, msgs={}", (Object)this.messageQueue, (Object)this.msgs);
    }

    public MessageQueue getMessageQueue() {
        return this.messageQueue;
    }
}

