/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.ClientConfig;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.QueryResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.Validators;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.AckCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPullConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.MQPopConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.NotificationCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PollingInfoCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PopCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PopResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PullCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PullMessageSelector;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PullResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.StatisticsMessagesCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.LocalFileOffsetStore;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.OffsetStore;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.ReadOffsetType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.RemoteBrokerOffsetStore;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQBrokerException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.ConsumeMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.ConsumeMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.FilterMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.CommunicationMode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.FindBrokerResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.MQClientManager;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultMQPullConsumerImpl$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.MQConsumerInner;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ProcessQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.PullAPIWrapper;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.RebalanceImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.RebalancePullImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MixAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ServiceState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.consumer.ConsumeFromWhere;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.filter.FilterAPI;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.help.FAQUrl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.NamespaceUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ConsumerRunningInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.AckMessageRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.ChangeInvisibleTimeRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.ExtraInfoUtil;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.NotificationRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.PeekMessageRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.PollingInfoRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.PopMessageRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.StatisticsMessagesRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.ConsumeType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.SubscriptionData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.sysflag.PullSysFlag;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.RPCHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingHelper;
import com.aliyun.openservices.shade.io.netty.channel.EventLoopGroup;
import com.aliyun.openservices.shade.io.netty.util.concurrent.EventExecutorGroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class DefaultMQPullConsumerImpl
implements MQPopConsumer,
MQConsumerInner {
    private final InternalLogger log = ClientLogger.getLog();
    private final DefaultMQPullConsumer defaultMQPullConsumer;
    private final long consumerStartTimestamp = System.currentTimeMillis();
    private final RPCHook rpcHook;
    private final ArrayList<ConsumeMessageHook> consumeMessageHookList = new ArrayList();
    private final ArrayList<FilterMessageHook> filterMessageHookList = new ArrayList();
    private volatile ServiceState serviceState = ServiceState.CREATE_JUST;
    protected MQClientInstance mQClientFactory;
    private PullAPIWrapper pullAPIWrapper;
    private OffsetStore offsetStore;
    private RebalanceImpl rebalanceImpl = new RebalancePullImpl(this);
    private EventLoopGroup eventLoopGroup;
    private EventExecutorGroup eventExecutorGroup;

    public DefaultMQPullConsumerImpl(DefaultMQPullConsumer defaultMQPullConsumer, RPCHook rPCHook) {
        this.defaultMQPullConsumer = defaultMQPullConsumer;
        this.rpcHook = rPCHook;
    }

    public void registerConsumeMessageHook(ConsumeMessageHook consumeMessageHook) {
        this.consumeMessageHookList.add(consumeMessageHook);
        this.log.info("register consumeMessageHook Hook, {}", (Object)consumeMessageHook.hookName());
    }

    public void createTopic(String string, String string2, int n2) {
        this.createTopic(string, string2, n2, 0);
    }

    public void createTopic(String string, String string2, int n2, int n3) {
        this.makeSureStateOK();
        this.mQClientFactory.getMQAdminImpl().createTopic(string, string2, n2, n3);
    }

    private void makeSureStateOK() {
        if (this.serviceState != ServiceState.RUNNING) {
            throw new MQClientException("The consumer service state not OK, " + (Object)((Object)this.serviceState) + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
        }
    }

    public long fetchConsumeOffset(MessageQueue messageQueue, boolean bl) {
        this.makeSureStateOK();
        return this.offsetStore.readOffset(messageQueue, bl ? ReadOffsetType.READ_FROM_STORE : ReadOffsetType.MEMORY_FIRST_THEN_STORE);
    }

    public Set<MessageQueue> fetchMessageQueuesInBalance(String string) {
        this.makeSureStateOK();
        if (string == null) {
            throw new IllegalArgumentException("topic is null");
        }
        ConcurrentMap<MessageQueue, ProcessQueue> concurrentMap = this.rebalanceImpl.getProcessQueueTable();
        HashSet<MessageQueue> hashSet = new HashSet<MessageQueue>();
        for (MessageQueue messageQueue : concurrentMap.keySet()) {
            if (!messageQueue.getTopic().equals(string)) continue;
            hashSet.add(messageQueue);
        }
        return this.parseSubscribeMessageQueues(hashSet);
    }

    public List<MessageQueue> fetchPublishMessageQueues(String string) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().fetchPublishMessageQueues(string);
    }

    public Set<MessageQueue> fetchSubscribeMessageQueues(String string) {
        this.makeSureStateOK();
        Set<MessageQueue> set = (Set<MessageQueue>)this.rebalanceImpl.getTopicSubscribeInfoTable().get(string);
        if (set == null) {
            set = this.mQClientFactory.getMQAdminImpl().fetchSubscribeMessageQueues(string);
        }
        return this.parseSubscribeMessageQueues(set);
    }

    public Set<MessageQueue> parseSubscribeMessageQueues(Set<MessageQueue> object) {
        HashSet<MessageQueue> hashSet = new HashSet<MessageQueue>();
        object = object.iterator();
        while (object.hasNext()) {
            MessageQueue messageQueue = (MessageQueue)object.next();
            String string = NamespaceUtil.withoutNamespace(messageQueue.getTopic(), this.defaultMQPullConsumer.getNamespace());
            hashSet.add(new MessageQueue(string, messageQueue.getBrokerName(), messageQueue.getQueueId()));
        }
        return hashSet;
    }

    public long earliestMsgStoreTime(MessageQueue messageQueue) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().earliestMsgStoreTime(messageQueue);
    }

    public long maxOffset(MessageQueue messageQueue) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().maxOffset(messageQueue);
    }

    public long minOffset(MessageQueue messageQueue) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().minOffset(messageQueue);
    }

    public PullResult pull(MessageQueue messageQueue, PullMessageSelector pullMessageSelector) {
        long l2 = pullMessageSelector.getTimeout() > 0L ? pullMessageSelector.getTimeout() : this.defaultMQPullConsumer.getConsumerPullTimeoutMillis();
        return this.pullSyncImpl(messageQueue, pullMessageSelector.getExpression(), pullMessageSelector.getOffset(), pullMessageSelector.getMaxNums(), pullMessageSelector.isBlockIfNotFound(), l2, pullMessageSelector.getPropertiesStr());
    }

    public void pull(MessageQueue messageQueue, PullMessageSelector pullMessageSelector, PullCallback pullCallback) {
        long l2 = pullMessageSelector.getTimeout() > 0L ? pullMessageSelector.getTimeout() : this.defaultMQPullConsumer.getConsumerPullTimeoutMillis();
        this.pullAsyncImpl(messageQueue, pullMessageSelector.getExpression(), pullMessageSelector.getOffset(), pullMessageSelector.getMaxNums(), pullCallback, pullMessageSelector.isBlockIfNotFound(), l2, pullMessageSelector.getPropertiesStr());
    }

    public PullResult pull(MessageQueue messageQueue, String string, long l2, int n2) {
        return this.pull(messageQueue, string, l2, n2, this.defaultMQPullConsumer.getConsumerPullTimeoutMillis());
    }

    public PullResult pull(MessageQueue messageQueue, String string, long l2, int n2, long l3) {
        return this.pullSyncImpl(messageQueue, string, l2, n2, false, l3, null);
    }

    private PullResult pullSyncImpl(MessageQueue messageQueue, String object, long l2, int n2, boolean bl, long l3, String string) {
        this.makeSureStateOK();
        if (messageQueue == null) {
            throw new MQClientException("mq is null", null);
        }
        if (l2 < 0L) {
            throw new MQClientException("offset < 0", null);
        }
        if (n2 <= 0) {
            throw new MQClientException("maxNums <= 0", null);
        }
        this.subscriptionAutomatically(messageQueue.getTopic());
        int n3 = PullSysFlag.buildSysFlag(false, bl, true, false);
        try {
            object = FilterAPI.buildSubscriptionData(this.defaultMQPullConsumer.getConsumerGroup(), messageQueue.getTopic(), (String)object);
        }
        catch (Exception exception) {
            throw new MQClientException("parse subscription error", exception);
        }
        long l4 = bl ? this.defaultMQPullConsumer.getConsumerTimeoutMillisWhenSuspend() : l3;
        PullResult pullResult = this.pullAPIWrapper.pullKernelImpl(messageQueue, ((SubscriptionData)object).getSubString(), 0L, l2, n2, n3, 0L, this.defaultMQPullConsumer.getBrokerSuspendMaxTimeMillis(), l4, CommunicationMode.SYNC, null, string);
        this.pullAPIWrapper.processPullResult(messageQueue, pullResult, (SubscriptionData)object);
        this.resetTopic(pullResult.getMsgFoundList());
        if (!this.consumeMessageHookList.isEmpty()) {
            object = new ConsumeMessageContext();
            ((ConsumeMessageContext)object).setNamespace(this.defaultMQPullConsumer.getNamespace());
            ((ConsumeMessageContext)object).setConsumerGroup(this.groupName());
            ((ConsumeMessageContext)object).setMq(messageQueue);
            ((ConsumeMessageContext)object).setMsgList(pullResult.getMsgFoundList());
            ((ConsumeMessageContext)object).setSuccess(false);
            this.executeHookBefore((ConsumeMessageContext)object);
            ((ConsumeMessageContext)object).setStatus(ConsumeConcurrentlyStatus.CONSUME_SUCCESS.toString());
            ((ConsumeMessageContext)object).setSuccess(true);
            this.executeHookAfter((ConsumeMessageContext)object);
        }
        return pullResult;
    }

    public void resetTopic(List<MessageExt> object) {
        if (object == null || object.size() == 0) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            MessageExt messageExt = (MessageExt)object.next();
            if (null == this.getDefaultMQPullConsumer().getNamespace()) continue;
            MessageExt messageExt2 = messageExt;
            messageExt2.setTopic(NamespaceUtil.withoutNamespace(messageExt2.getTopic(), this.defaultMQPullConsumer.getNamespace()));
        }
    }

    public void subscriptionAutomatically(String string) {
        if (!this.defaultMQPullConsumer.isAutoAddSubscription()) {
            return;
        }
        if (!this.rebalanceImpl.getSubscriptionInner().containsKey(string)) {
            try {
                SubscriptionData subscriptionData = FilterAPI.buildSubscriptionData(this.defaultMQPullConsumer.getConsumerGroup(), string, "*");
                this.rebalanceImpl.subscriptionInner.putIfAbsent(string, subscriptionData);
                return;
            }
            catch (Exception exception) {}
        }
    }

    public void unsubscribe(String string) {
        this.rebalanceImpl.getSubscriptionInner().remove(string);
    }

    @Override
    public String groupName() {
        return this.defaultMQPullConsumer.getConsumerGroup();
    }

    public void executeHookBefore(ConsumeMessageContext consumeMessageContext) {
        if (!this.consumeMessageHookList.isEmpty()) {
            for (ConsumeMessageHook consumeMessageHook : this.consumeMessageHookList) {
                try {
                    consumeMessageHook.consumeMessageBefore(consumeMessageContext);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void executeHookAfter(ConsumeMessageContext consumeMessageContext) {
        if (!this.consumeMessageHookList.isEmpty()) {
            for (ConsumeMessageHook consumeMessageHook : this.consumeMessageHookList) {
                try {
                    consumeMessageHook.consumeMessageAfter(consumeMessageContext);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public MessageModel messageModel() {
        return this.defaultMQPullConsumer.getMessageModel();
    }

    @Override
    public ConsumeType consumeType() {
        return ConsumeType.CONSUME_ACTIVELY;
    }

    @Override
    public ConsumeFromWhere consumeFromWhere() {
        return ConsumeFromWhere.CONSUME_FROM_LAST_OFFSET;
    }

    @Override
    public Set<SubscriptionData> subscriptions() {
        HashSet<SubscriptionData> hashSet = new HashSet<SubscriptionData>();
        Set<String> set = this.defaultMQPullConsumer.getRegisterTopics();
        if (set != null) {
            Set<String> set2 = set;
            synchronized (set2) {
                for (String string : set) {
                    SubscriptionData subscriptionData = null;
                    try {
                        subscriptionData = FilterAPI.buildSubscriptionData(this.groupName(), string, "*");
                    }
                    catch (Exception exception) {
                        this.log.error("parse subscription error", exception);
                    }
                    subscriptionData.setSubVersion(0L);
                    hashSet.add(subscriptionData);
                }
            }
        }
        return hashSet;
    }

    @Override
    public void doRebalance() {
        if (this.rebalanceImpl != null) {
            this.rebalanceImpl.doRebalance(false);
        }
    }

    @Override
    public void persistConsumerOffset() {
        try {
            this.makeSureStateOK();
            HashSet<MessageQueue> hashSet = new HashSet<MessageQueue>();
            Set set = this.rebalanceImpl.getProcessQueueTable().keySet();
            hashSet.addAll(set);
            this.offsetStore.persistAll(hashSet);
            return;
        }
        catch (Exception exception) {
            this.log.error("group: " + this.defaultMQPullConsumer.getConsumerGroup() + " persistConsumerOffset exception", exception);
            return;
        }
    }

    @Override
    public void updateTopicSubscribeInfo(String string, Set<MessageQueue> set) {
        ConcurrentMap<String, SubscriptionData> concurrentMap = this.rebalanceImpl.getSubscriptionInner();
        if (concurrentMap != null && concurrentMap.containsKey(string)) {
            this.rebalanceImpl.getTopicSubscribeInfoTable().put(string, set);
        }
    }

    @Override
    public void removeTopicSubscribeInfo(String string) {
        if (!this.defaultMQPullConsumer.isAutoCleanTopicRouteNotFound()) {
            return;
        }
        Object object = this.rebalanceImpl.getTopicSubscribeInfoTable();
        if (object != null && (object = (Set)object.remove(string)) != null) {
            this.log.info("removeTopicSubscribeInfo remove TopicSubscribeInfoTable: {}, {}", (Object)string, object);
            object = object.iterator();
            while (object.hasNext()) {
                MessageQueue messageQueue = (MessageQueue)object.next();
                this.rebalanceImpl.removeProcessQueue(messageQueue);
            }
        }
        if ((object = this.rebalanceImpl.getSubscriptionInner()) != null && (object = (SubscriptionData)object.remove(string)) != null) {
            this.log.info("removeTopicSubscribeInfo remove SubscriptionInner: {}, {}", (Object)string, object);
        }
    }

    @Override
    public boolean isSubscribeTopicNeedUpdate(String string) {
        ConcurrentMap<String, SubscriptionData> concurrentMap = this.rebalanceImpl.getSubscriptionInner();
        if (concurrentMap != null && concurrentMap.containsKey(string)) {
            return !this.rebalanceImpl.topicSubscribeInfoTable.containsKey(string);
        }
        return false;
    }

    @Override
    public boolean isUnitMode() {
        return ((ClientConfig)this.defaultMQPullConsumer).isUnitMode();
    }

    @Override
    public ConsumerRunningInfo consumerRunningInfo() {
        ConsumerRunningInfo consumerRunningInfo = new ConsumerRunningInfo();
        Properties properties = MixAll.object2Properties(this.defaultMQPullConsumer);
        properties.put("PROP_CONSUMER_START_TIMESTAMP", String.valueOf(this.consumerStartTimestamp));
        consumerRunningInfo.setProperties(properties);
        consumerRunningInfo.getSubscriptionSet().addAll(this.subscriptions());
        return consumerRunningInfo;
    }

    public void pull(MessageQueue messageQueue, String string, long l2, int n2, PullCallback pullCallback) {
        this.pull(messageQueue, string, l2, n2, pullCallback, this.defaultMQPullConsumer.getConsumerPullTimeoutMillis());
    }

    public void pull(MessageQueue messageQueue, String string, long l2, int n2, PullCallback pullCallback, long l3) {
        this.pullAsyncImpl(messageQueue, string, l2, n2, pullCallback, false, l3, null);
    }

    private void pullAsyncImpl(MessageQueue messageQueue, String object, long l2, int n2, PullCallback pullCallback, boolean bl, long l3, String string) {
        this.makeSureStateOK();
        if (messageQueue == null) {
            throw new MQClientException("mq is null", null);
        }
        if (l2 < 0L) {
            throw new MQClientException("offset < 0", null);
        }
        if (n2 <= 0) {
            throw new MQClientException("maxNums <= 0", null);
        }
        if (pullCallback == null) {
            throw new MQClientException("pullCallback is null", null);
        }
        this.subscriptionAutomatically(messageQueue.getTopic());
        try {
            int n3 = PullSysFlag.buildSysFlag(false, bl, true, false);
            try {
                object = FilterAPI.buildSubscriptionData(this.defaultMQPullConsumer.getConsumerGroup(), messageQueue.getTopic(), (String)object);
            }
            catch (Exception exception) {
                throw new MQClientException("parse subscription error", exception);
            }
            long l4 = bl ? this.defaultMQPullConsumer.getConsumerTimeoutMillisWhenSuspend() : l3;
            this.pullAPIWrapper.pullKernelImpl(messageQueue, ((SubscriptionData)object).getSubString(), 0L, l2, n2, n3, 0L, this.defaultMQPullConsumer.getBrokerSuspendMaxTimeMillis(), l4, CommunicationMode.ASYNC, new DefaultMQPullConsumerImpl$1(this, messageQueue, (SubscriptionData)object, pullCallback), string);
            return;
        }
        catch (MQBrokerException mQBrokerException) {
            throw new MQClientException("pullAsync unknow exception", mQBrokerException);
        }
    }

    public PullResult pullBlockIfNotFound(MessageQueue messageQueue, String string, long l2, int n2) {
        return this.pullSyncImpl(messageQueue, string, l2, n2, true, this.getDefaultMQPullConsumer().getConsumerPullTimeoutMillis(), null);
    }

    public DefaultMQPullConsumer getDefaultMQPullConsumer() {
        return this.defaultMQPullConsumer;
    }

    public void pullBlockIfNotFound(MessageQueue messageQueue, String string, long l2, int n2, PullCallback pullCallback) {
        this.pullAsyncImpl(messageQueue, string, l2, n2, pullCallback, true, this.getDefaultMQPullConsumer().getConsumerPullTimeoutMillis(), null);
    }

    public QueryResult queryMessage(String string, String string2, int n2, long l2, long l3) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessage(string, string2, n2, l2, l3);
    }

    public MessageExt queryMessageByUniqKey(String string, String string2) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().queryMessageByUniqKey(string, string2);
    }

    public long searchOffset(MessageQueue messageQueue, long l2) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().searchOffset(messageQueue, l2);
    }

    public void sendMessageBack(MessageExt messageExt, int n2, String string) {
        this.sendMessageBack(messageExt, n2, string, this.defaultMQPullConsumer.getConsumerGroup());
    }

    public void updateConsumeOffsetToBroker(MessageQueue messageQueue, long l2, boolean bl) {
        this.offsetStore.updateConsumeOffsetToBroker(messageQueue, l2, bl);
    }

    public void sendMessageBack(MessageExt messageExt, int n2, String string, String string2) {
        try {
            String string3 = string = string != null ? this.mQClientFactory.findBrokerAddressInPublish(string) : RemotingHelper.parseSocketAddressAddr(messageExt.getStoreHost());
            if (UtilAll.isBlank(string2)) {
                string2 = this.defaultMQPullConsumer.getConsumerGroup();
            }
            this.mQClientFactory.getMQClientAPIImpl().consumerSendMessageBack(string, messageExt, string2, n2, 3000L, this.defaultMQPullConsumer.getMaxReconsumeTimes());
            return;
        }
        catch (Exception exception) {
            this.log.error("sendMessageBack Exception, " + this.defaultMQPullConsumer.getConsumerGroup(), exception);
            Message message = new Message(MixAll.getRetryTopic(this.defaultMQPullConsumer.getConsumerGroup()), messageExt.getBody());
            String string4 = MessageAccessor.getOriginMessageId(messageExt);
            MessageAccessor.setOriginMessageId(message, UtilAll.isBlank(string4) ? messageExt.getMsgId() : string4);
            message.setFlag(messageExt.getFlag());
            MessageAccessor.setProperties(message, messageExt.getProperties());
            MessageAccessor.putProperty(message, "RETRY_TOPIC", messageExt.getTopic());
            MessageAccessor.setReconsumeTime(message, String.valueOf(messageExt.getReconsumeTimes() + 1));
            MessageAccessor.setMaxReconsumeTimes(message, String.valueOf(this.defaultMQPullConsumer.getMaxReconsumeTimes()));
            message.setDelayTimeLevel(3 + messageExt.getReconsumeTimes());
            this.mQClientFactory.getDefaultMQProducer().send(message);
            return;
        }
        finally {
            MessageExt messageExt2 = messageExt;
            messageExt2.setTopic(NamespaceUtil.withoutNamespace(messageExt2.getTopic(), this.defaultMQPullConsumer.getNamespace()));
        }
    }

    public synchronized void shutdown() {
        switch (this.serviceState) {
            case CREATE_JUST: {
                return;
            }
            case RUNNING: {
                this.persistConsumerOffset();
                this.mQClientFactory.unregisterConsumer(this.defaultMQPullConsumer.getConsumerGroup());
                this.mQClientFactory.shutdown();
                this.log.info("the consumer [{}] shutdown OK", (Object)this.defaultMQPullConsumer.getConsumerGroup());
                this.serviceState = ServiceState.SHUTDOWN_ALREADY;
            }
        }
    }

    public synchronized void start() {
        switch (this.serviceState) {
            case CREATE_JUST: {
                this.serviceState = ServiceState.START_FAILED;
                this.checkConfig();
                this.copySubscription();
                if (this.defaultMQPullConsumer.getMessageModel() == MessageModel.CLUSTERING) {
                    this.defaultMQPullConsumer.changeInstanceNameToPID();
                }
                this.mQClientFactory = MQClientManager.getInstance().getAndCreateMQClientInstance(this.defaultMQPullConsumer, this.rpcHook, this.eventLoopGroup, this.eventExecutorGroup);
                this.rebalanceImpl.setConsumerGroup(this.defaultMQPullConsumer.getConsumerGroup());
                this.rebalanceImpl.setMessageModel(this.defaultMQPullConsumer.getMessageModel());
                this.rebalanceImpl.setAllocateMessageQueueStrategy(this.defaultMQPullConsumer.getAllocateMessageQueueStrategy());
                this.rebalanceImpl.setmQClientFactory(this.mQClientFactory);
                this.pullAPIWrapper = new PullAPIWrapper(this.mQClientFactory, this.defaultMQPullConsumer.getConsumerGroup(), this.isUnitMode());
                this.pullAPIWrapper.registerFilterMessageHook(this.filterMessageHookList);
                if (this.defaultMQPullConsumer.getOffsetStore() != null) {
                    this.offsetStore = this.defaultMQPullConsumer.getOffsetStore();
                } else {
                    switch (this.defaultMQPullConsumer.getMessageModel()) {
                        case BROADCASTING: {
                            this.offsetStore = new LocalFileOffsetStore(this.mQClientFactory, this.defaultMQPullConsumer.getConsumerGroup());
                            break;
                        }
                        case CLUSTERING: {
                            this.offsetStore = new RemoteBrokerOffsetStore(this.mQClientFactory, this.defaultMQPullConsumer.getConsumerGroup());
                        }
                    }
                    this.defaultMQPullConsumer.setOffsetStore(this.offsetStore);
                }
                this.offsetStore.load();
                boolean bl = this.mQClientFactory.registerConsumer(this.defaultMQPullConsumer.getConsumerGroup(), this);
                if (!bl) {
                    this.serviceState = ServiceState.CREATE_JUST;
                    throw new MQClientException("The consumer group[" + this.defaultMQPullConsumer.getConsumerGroup() + "] has been created before, specify another name please." + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
                }
                this.mQClientFactory.start();
                this.log.info("the consumer [{}] start OK", (Object)this.defaultMQPullConsumer.getConsumerGroup());
                this.serviceState = ServiceState.RUNNING;
                return;
            }
            case RUNNING: 
            case SHUTDOWN_ALREADY: 
            case START_FAILED: {
                throw new MQClientException("The PullConsumer service state not OK, maybe started once, " + (Object)((Object)this.serviceState) + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
            }
        }
    }

    private void checkConfig() {
        Validators.checkGroup(this.defaultMQPullConsumer.getConsumerGroup());
        if (null == this.defaultMQPullConsumer.getConsumerGroup()) {
            throw new MQClientException("consumerGroup is null" + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
        }
        if (this.defaultMQPullConsumer.getConsumerGroup().equals("DEFAULT_CONSUMER")) {
            throw new MQClientException("consumerGroup can not equal DEFAULT_CONSUMER, please specify another one." + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
        }
        if (null == this.defaultMQPullConsumer.getMessageModel()) {
            throw new MQClientException("messageModel is null" + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
        }
        if (null == this.defaultMQPullConsumer.getAllocateMessageQueueStrategy()) {
            throw new MQClientException("allocateMessageQueueStrategy is null" + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
        }
        if (this.defaultMQPullConsumer.getConsumerTimeoutMillisWhenSuspend() < this.defaultMQPullConsumer.getBrokerSuspendMaxTimeMillis()) {
            throw new MQClientException("Long polling mode, the consumer consumerTimeoutMillisWhenSuspend must greater than brokerSuspendMaxTimeMillis" + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/"), null);
        }
    }

    private void copySubscription() {
        try {
            Object object = this.defaultMQPullConsumer.getRegisterTopics();
            if (object != null) {
                object = object.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    SubscriptionData subscriptionData = FilterAPI.buildSubscriptionData(this.defaultMQPullConsumer.getConsumerGroup(), string, "*");
                    this.rebalanceImpl.getSubscriptionInner().put(string, subscriptionData);
                }
            }
            return;
        }
        catch (Exception exception) {
            throw new MQClientException("subscription exception", exception);
        }
    }

    public void updateConsumeOffset(MessageQueue messageQueue, long l2) {
        this.makeSureStateOK();
        this.offsetStore.updateOffset(messageQueue, l2, false);
    }

    public MessageExt viewMessage(String string) {
        this.makeSureStateOK();
        return this.mQClientFactory.getMQAdminImpl().viewMessage(string);
    }

    @Override
    public PopResult pop(MessageQueue object, long l2, int n2, String string, long l3, int n3) {
        this.subscriptionAutomatically(((MessageQueue)object).getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(((MessageQueue)object).getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(((MessageQueue)object).getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(((MessageQueue)object).getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            PopMessageRequestHeader popMessageRequestHeader = new PopMessageRequestHeader();
            popMessageRequestHeader.setConsumerGroup(string);
            popMessageRequestHeader.setTopic(((MessageQueue)object).getTopic());
            popMessageRequestHeader.setQueueId(((MessageQueue)object).getQueueId());
            popMessageRequestHeader.setMaxMsgNums(n2);
            popMessageRequestHeader.setInvisibleTime(l2);
            popMessageRequestHeader.setInitMode(n3);
            String string2 = findBrokerResult.getBrokerAddr();
            object = this.mQClientFactory.getMQClientAPIImpl().popMessage(((MessageQueue)object).getBrokerName(), string2, popMessageRequestHeader, l3);
            return object;
        }
        throw new MQClientException("The broker[" + ((MessageQueue)object).getBrokerName() + "] not exist", null);
    }

    @Override
    public PopResult pop(MessageQueue object, long l2, int n2, String string, long l3, int n3, String string2, String string3) {
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(((MessageQueue)object).getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(((MessageQueue)object).getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(((MessageQueue)object).getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            PopMessageRequestHeader popMessageRequestHeader = new PopMessageRequestHeader();
            popMessageRequestHeader.setConsumerGroup(string);
            popMessageRequestHeader.setTopic(((MessageQueue)object).getTopic());
            popMessageRequestHeader.setQueueId(((MessageQueue)object).getQueueId());
            popMessageRequestHeader.setMaxMsgNums(n2);
            popMessageRequestHeader.setInvisibleTime(l2);
            popMessageRequestHeader.setInitMode(n3);
            popMessageRequestHeader.setExpType(string2);
            popMessageRequestHeader.setExp(string3);
            String string4 = findBrokerResult.getBrokerAddr();
            object = this.mQClientFactory.getMQClientAPIImpl().popMessage(((MessageQueue)object).getBrokerName(), string4, popMessageRequestHeader, l3);
            return object;
        }
        throw new MQClientException("The broker[" + ((MessageQueue)object).getBrokerName() + "] not exist", null);
    }

    @Override
    public void popAsync(MessageQueue messageQueue, long l2, int n2, String string, long l3, PopCallback popCallback, boolean bl, int n3) {
        this.subscriptionAutomatically(messageQueue.getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(messageQueue.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            PopMessageRequestHeader popMessageRequestHeader = new PopMessageRequestHeader();
            popMessageRequestHeader.setConsumerGroup(string);
            popMessageRequestHeader.setTopic(messageQueue.getTopic());
            popMessageRequestHeader.setQueueId(messageQueue.getQueueId());
            popMessageRequestHeader.setMaxMsgNums(n2);
            popMessageRequestHeader.setInvisibleTime(l2);
            popMessageRequestHeader.setInitMode(n3);
            if (bl) {
                popMessageRequestHeader.setPollTime(l3);
                popMessageRequestHeader.setBornTime(System.currentTimeMillis());
                l3 += 10000L;
            }
            String string2 = findBrokerResult.getBrokerAddr();
            this.mQClientFactory.getMQClientAPIImpl().popMessageAsync(messageQueue.getBrokerName(), string2, popMessageRequestHeader, l3, popCallback);
            return;
        }
        throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
    }

    @Override
    public void popAsync(MessageQueue messageQueue, long l2, int n2, String string, long l3, PopCallback popCallback, boolean bl, int n3, String string2, String string3) {
        this.subscriptionAutomatically(messageQueue.getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(messageQueue.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            PopMessageRequestHeader popMessageRequestHeader = new PopMessageRequestHeader();
            popMessageRequestHeader.setConsumerGroup(string);
            popMessageRequestHeader.setTopic(messageQueue.getTopic());
            popMessageRequestHeader.setQueueId(messageQueue.getQueueId());
            popMessageRequestHeader.setMaxMsgNums(n2);
            popMessageRequestHeader.setInvisibleTime(l2);
            popMessageRequestHeader.setInitMode(n3);
            popMessageRequestHeader.setExpType(string2);
            popMessageRequestHeader.setExp(string3);
            if (bl) {
                popMessageRequestHeader.setPollTime(l3);
                popMessageRequestHeader.setBornTime(System.currentTimeMillis());
                l3 += 10000L;
            }
            String string4 = findBrokerResult.getBrokerAddr();
            this.mQClientFactory.getMQClientAPIImpl().popMessageAsync(messageQueue.getBrokerName(), string4, popMessageRequestHeader, l3, popCallback);
            return;
        }
        throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
    }

    @Override
    public void notificationAsync(MessageQueue messageQueue, String string, long l2, NotificationCallback notificationCallback) {
        this.subscriptionAutomatically(messageQueue.getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(messageQueue.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            NotificationRequestHeader notificationRequestHeader = new NotificationRequestHeader();
            notificationRequestHeader.setConsumerGroup(string);
            notificationRequestHeader.setTopic(messageQueue.getTopic());
            notificationRequestHeader.setQueueId(messageQueue.getQueueId());
            notificationRequestHeader.setPollTime(l2);
            notificationRequestHeader.setBornTime(System.currentTimeMillis());
            string = findBrokerResult.getBrokerAddr();
            this.mQClientFactory.getMQClientAPIImpl().notificationAsync(messageQueue.getBrokerName(), string, notificationRequestHeader, l2 += 10000L, notificationCallback);
            return;
        }
        throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
    }

    @Override
    public void getPollingNumAsync(MessageQueue messageQueue, String string, long l2, PollingInfoCallback pollingInfoCallback) {
        this.subscriptionAutomatically(messageQueue.getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(messageQueue.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            PollingInfoRequestHeader pollingInfoRequestHeader = new PollingInfoRequestHeader();
            pollingInfoRequestHeader.setConsumerGroup(string);
            pollingInfoRequestHeader.setTopic(messageQueue.getTopic());
            pollingInfoRequestHeader.setQueueId(messageQueue.getQueueId());
            string = findBrokerResult.getBrokerAddr();
            this.mQClientFactory.getMQClientAPIImpl().pollingInfoAsync(messageQueue.getBrokerName(), string, pollingInfoRequestHeader, l2, pollingInfoCallback);
            return;
        }
        throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
    }

    @Override
    public void peekAsync(MessageQueue messageQueue, int n2, String string, long l2, PopCallback popCallback) {
        this.subscriptionAutomatically(messageQueue.getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(messageQueue.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            PeekMessageRequestHeader peekMessageRequestHeader = new PeekMessageRequestHeader();
            peekMessageRequestHeader.setTopic(messageQueue.getTopic());
            peekMessageRequestHeader.setQueueId(messageQueue.getQueueId());
            peekMessageRequestHeader.setMaxMsgNums(n2);
            peekMessageRequestHeader.setConsumerGroup(string);
            String string2 = findBrokerResult.getBrokerAddr();
            this.mQClientFactory.getMQClientAPIImpl().peekMessageAsync(messageQueue.getBrokerName(), string2, peekMessageRequestHeader, l2, popCallback);
            return;
        }
        throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
    }

    @Override
    public PopResult peek(MessageQueue object, int n2, String string, long l2) {
        this.subscriptionAutomatically(((MessageQueue)object).getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(((MessageQueue)object).getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(((MessageQueue)object).getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(((MessageQueue)object).getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            PeekMessageRequestHeader peekMessageRequestHeader = new PeekMessageRequestHeader();
            peekMessageRequestHeader.setTopic(((MessageQueue)object).getTopic());
            peekMessageRequestHeader.setQueueId(((MessageQueue)object).getQueueId());
            peekMessageRequestHeader.setMaxMsgNums(n2);
            peekMessageRequestHeader.setConsumerGroup(string);
            String string2 = findBrokerResult.getBrokerAddr();
            object = this.mQClientFactory.getMQClientAPIImpl().peekMessage(((MessageQueue)object).getBrokerName(), string2, peekMessageRequestHeader, l2);
            return object;
        }
        throw new MQClientException("The broker[" + ((MessageQueue)object).getBrokerName() + "] not exist", null);
    }

    @Override
    public void ack(MessageQueue messageQueue, long l2, String string, String string2) {
        this.subscriptionAutomatically(messageQueue.getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(messageQueue.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            AckMessageRequestHeader ackMessageRequestHeader = new AckMessageRequestHeader();
            String[] stringArray = ExtraInfoUtil.split(string2);
            ackMessageRequestHeader.setTopic(ExtraInfoUtil.getRealTopic(stringArray, messageQueue.getTopic(), string));
            ackMessageRequestHeader.setQueueId(messageQueue.getQueueId());
            ackMessageRequestHeader.setOffset(l2);
            ackMessageRequestHeader.setConsumerGroup(string);
            ackMessageRequestHeader.setExtraInfo(string2);
            this.mQClientFactory.getMQClientAPIImpl().ackMessage(findBrokerResult.getBrokerAddr(), ackMessageRequestHeader);
            return;
        }
        throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
    }

    @Override
    public void ackAsync(MessageQueue messageQueue, long l2, String string, String string2, long l3, AckCallback ackCallback) {
        this.subscriptionAutomatically(messageQueue.getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(messageQueue.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            AckMessageRequestHeader ackMessageRequestHeader = new AckMessageRequestHeader();
            String[] stringArray = ExtraInfoUtil.split(string2);
            ackMessageRequestHeader.setTopic(ExtraInfoUtil.getRealTopic(stringArray, messageQueue.getTopic(), string));
            ackMessageRequestHeader.setQueueId(messageQueue.getQueueId());
            ackMessageRequestHeader.setOffset(l2);
            ackMessageRequestHeader.setConsumerGroup(string);
            ackMessageRequestHeader.setExtraInfo(string2);
            this.mQClientFactory.getMQClientAPIImpl().ackMessageAsync(findBrokerResult.getBrokerAddr(), l3, ackCallback, ackMessageRequestHeader);
            return;
        }
        throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
    }

    @Override
    public void changeInvisibleTimeAsync(MessageQueue messageQueue, long l2, String string, String string2, long l3, long l4, AckCallback ackCallback) {
        this.subscriptionAutomatically(messageQueue.getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(messageQueue.getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(messageQueue.getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            ChangeInvisibleTimeRequestHeader changeInvisibleTimeRequestHeader = new ChangeInvisibleTimeRequestHeader();
            String[] stringArray = ExtraInfoUtil.split(string2);
            changeInvisibleTimeRequestHeader.setTopic(ExtraInfoUtil.getRealTopic(stringArray, messageQueue.getTopic(), string));
            changeInvisibleTimeRequestHeader.setQueueId(messageQueue.getQueueId());
            changeInvisibleTimeRequestHeader.setOffset(l2);
            changeInvisibleTimeRequestHeader.setConsumerGroup(string);
            changeInvisibleTimeRequestHeader.setExtraInfo(string2);
            changeInvisibleTimeRequestHeader.setInvisibleTime(l3);
            this.mQClientFactory.getMQClientAPIImpl().changeInvisibleTimeAsync(messageQueue.getBrokerName(), findBrokerResult.getBrokerAddr(), changeInvisibleTimeRequestHeader, l4, ackCallback);
            return;
        }
        throw new MQClientException("The broker[" + messageQueue.getBrokerName() + "] not exist", null);
    }

    public void registerFilterMessageHook(FilterMessageHook filterMessageHook) {
        this.filterMessageHookList.add(filterMessageHook);
        this.log.info("register FilterMessageHook Hook, {}", (Object)filterMessageHook.hookName());
    }

    @Override
    public void statisticsMessages(MessageQueue object, String string, long l2, long l3, long l4, StatisticsMessagesCallback statisticsMessagesCallback) {
        this.subscriptionAutomatically(((MessageQueue)object).getTopic());
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(((MessageQueue)object).getBrokerName(), 0L, true);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(((MessageQueue)object).getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(((MessageQueue)object).getBrokerName(), 0L, true);
        }
        if (findBrokerResult != null) {
            StatisticsMessagesRequestHeader statisticsMessagesRequestHeader = new StatisticsMessagesRequestHeader();
            statisticsMessagesRequestHeader.setConsumerGroup(string);
            statisticsMessagesRequestHeader.setTopic(((MessageQueue)object).getTopic());
            statisticsMessagesRequestHeader.setQueueId(((MessageQueue)object).getQueueId());
            statisticsMessagesRequestHeader.setFromTime(l2);
            statisticsMessagesRequestHeader.setToTime(l3);
            object = findBrokerResult.getBrokerAddr();
            this.mQClientFactory.getMQClientAPIImpl().statisticsMessagesAsync((String)object, statisticsMessagesRequestHeader, l4, statisticsMessagesCallback);
            return;
        }
        throw new MQClientException("The broker[" + ((MessageQueue)object).getBrokerName() + "] not exist", null);
    }

    public OffsetStore getOffsetStore() {
        return this.offsetStore;
    }

    public void setOffsetStore(OffsetStore offsetStore) {
        this.offsetStore = offsetStore;
    }

    public PullAPIWrapper getPullAPIWrapper() {
        return this.pullAPIWrapper;
    }

    public void setPullAPIWrapper(PullAPIWrapper pullAPIWrapper) {
        this.pullAPIWrapper = pullAPIWrapper;
    }

    public ServiceState getServiceState() {
        return this.serviceState;
    }

    @Deprecated
    public void setServiceState(ServiceState serviceState) {
        this.serviceState = serviceState;
    }

    public long getConsumerStartTimestamp() {
        return this.consumerStartTimestamp;
    }

    public RebalanceImpl getRebalanceImpl() {
        return this.rebalanceImpl;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public void setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }

    public EventExecutorGroup getEventExecutorGroup() {
        return this.eventExecutorGroup;
    }

    public void setEventExecutorGroup(EventExecutorGroup eventExecutorGroup) {
        this.eventExecutorGroup = eventExecutorGroup;
    }

    static /* synthetic */ PullAPIWrapper access$000(DefaultMQPullConsumerImpl defaultMQPullConsumerImpl) {
        return defaultMQPullConsumerImpl.pullAPIWrapper;
    }
}

