/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.DefaultMQPushConsumer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.body.ProcessQueueInfo;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ProcessQueue {
    public static final long REBALANCE_LOCK_MAX_LIVE_TIME = Long.parseLong(System.getProperty("rocketmq.client.rebalance.lockMaxLiveTime", "30000"));
    public static final long REBALANCE_LOCK_INTERVAL = Long.parseLong(System.getProperty("rocketmq.client.rebalance.lockInterval", "20000"));
    private static final long PULL_MAX_IDLE_TIME = Long.parseLong(System.getProperty("rocketmq.client.pull.pullMaxIdleTime", "120000"));
    private final InternalLogger log = ClientLogger.getLog();
    private final ReadWriteLock lockTreeMap = new ReentrantReadWriteLock();
    private final TreeMap<Long, MessageExt> msgTreeMap = new TreeMap();
    private final AtomicLong msgCount = new AtomicLong();
    private final AtomicLong msgSize = new AtomicLong();
    private final Lock lockConsume = new ReentrantLock();
    private final TreeMap<Long, MessageExt> consumingMsgOrderlyTreeMap = new TreeMap();
    private final AtomicLong tryUnlockTimes = new AtomicLong(0L);
    private volatile long queueOffsetMax = 0L;
    private volatile boolean dropped = false;
    private volatile long lastPullTimestamp = System.currentTimeMillis();
    private volatile long lastConsumeTimestamp = System.currentTimeMillis();
    private volatile boolean locked = false;
    private volatile long lastLockTimestamp = System.currentTimeMillis();
    private volatile boolean consuming = false;
    private volatile long msgAccCnt = 0L;

    public boolean isLockExpired() {
        return System.currentTimeMillis() - this.lastLockTimestamp > REBALANCE_LOCK_MAX_LIVE_TIME;
    }

    public boolean isPullExpired() {
        return System.currentTimeMillis() - this.lastPullTimestamp > PULL_MAX_IDLE_TIME;
    }

    public void cleanExpiredMsg(DefaultMQPushConsumer defaultMQPushConsumer) {
        if (defaultMQPushConsumer.getDefaultMQPushConsumerImpl().isConsumeOrderly()) {
            return;
        }
        int n2 = this.msgTreeMap.size() < 16 ? this.msgTreeMap.size() : 16;
        for (int i2 = 0; i2 < n2; ++i2) {
            Message message;
            block17: {
                message = null;
                try {
                    this.lockTreeMap.readLock().lockInterruptibly();
                    try {
                        if (!this.msgTreeMap.isEmpty() && System.currentTimeMillis() - Long.parseLong(MessageAccessor.getConsumeStartTimeStamp(this.msgTreeMap.firstEntry().getValue())) > defaultMQPushConsumer.getConsumeTimeout() * 60L * 1000L) {
                            message = this.msgTreeMap.firstEntry().getValue();
                            break block17;
                        }
                        return;
                    }
                    finally {
                        this.lockTreeMap.readLock().unlock();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.log.error("getExpiredMsg exception", interruptedException);
                }
            }
            try {
                defaultMQPushConsumer.sendMessageBack((MessageExt)message, 3);
                this.log.info("send expire msg back. topic={}, msgId={}, storeHost={}, queueId={}, queueOffset={}", message.getTopic(), ((MessageExt)message).getMsgId(), ((MessageExt)message).getStoreHost(), ((MessageExt)message).getQueueId(), ((MessageExt)message).getQueueOffset());
                try {
                    this.lockTreeMap.writeLock().lockInterruptibly();
                    try {
                        if (this.msgTreeMap.isEmpty() || ((MessageExt)message).getQueueOffset() != this.msgTreeMap.firstKey().longValue()) continue;
                        try {
                            this.removeMessage(Collections.singletonList(message));
                        }
                        catch (Exception exception) {
                            this.log.error("send expired msg exception", exception);
                        }
                    }
                    finally {
                        this.lockTreeMap.writeLock().unlock();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.log.error("getExpiredMsg exception", interruptedException);
                }
                continue;
            }
            catch (Exception exception) {
                this.log.error("send expired msg exception", exception);
            }
        }
    }

    public boolean putMessage(List<MessageExt> list) {
        boolean bl = false;
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                int n2 = 0;
                for (MessageExt object : list) {
                    MessageExt messageExt = this.msgTreeMap.put(object.getQueueOffset(), object);
                    if (messageExt != null) continue;
                    ++n2;
                    this.queueOffsetMax = object.getQueueOffset();
                    this.msgSize.addAndGet(object.getBody() != null ? (long)object.getBody().length : 0L);
                }
                this.msgCount.addAndGet(n2);
                if (!this.msgTreeMap.isEmpty() && !this.consuming) {
                    bl = true;
                    this.consuming = true;
                }
                if (!list.isEmpty()) {
                    long l2;
                    List<MessageExt> list2 = list;
                    MessageExt messageExt = list2.get(list2.size() - 1);
                    String string = messageExt.getProperty("MAX_OFFSET");
                    if (string != null && (l2 = Long.parseLong(string) - messageExt.getQueueOffset()) > 0L) {
                        this.msgAccCnt = l2;
                    }
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("putMessage exception", interruptedException);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getMaxSpan() {
        try {
            this.lockTreeMap.readLock().lockInterruptibly();
            try {
                if (this.msgTreeMap.isEmpty()) return 0L;
                long l2 = this.msgTreeMap.lastKey() - this.msgTreeMap.firstKey();
                return l2;
            }
            finally {
                this.lockTreeMap.readLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("getMaxSpan exception", interruptedException);
        }
        return 0L;
    }

    public long removeMessage(List<MessageExt> object) {
        long l2 = -1L;
        long l3 = System.currentTimeMillis();
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            this.lastConsumeTimestamp = l3;
            try {
                if (!this.msgTreeMap.isEmpty()) {
                    l2 = this.queueOffsetMax + 1L;
                    int n2 = 0;
                    object = object.iterator();
                    while (object.hasNext()) {
                        MessageExt messageExt = (MessageExt)object.next();
                        MessageExt messageExt2 = this.msgTreeMap.remove(messageExt.getQueueOffset());
                        if (messageExt2 == null) continue;
                        --n2;
                        this.msgSize.addAndGet(messageExt.getBody() != null ? (long)(0 - messageExt.getBody().length) : 0L);
                    }
                    this.msgCount.addAndGet(n2);
                    if (!this.msgTreeMap.isEmpty()) {
                        l2 = this.msgTreeMap.firstKey();
                    }
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (Throwable throwable) {
            this.log.error("removeMessage exception", throwable);
        }
        return l2;
    }

    public TreeMap<Long, MessageExt> getMsgTreeMap() {
        return this.msgTreeMap;
    }

    public AtomicLong getMsgCount() {
        return this.msgCount;
    }

    public AtomicLong getMsgSize() {
        return this.msgSize;
    }

    public boolean isDropped() {
        return this.dropped;
    }

    public void setDropped(boolean bl) {
        this.dropped = bl;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public void rollback() {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                this.msgTreeMap.putAll(this.consumingMsgOrderlyTreeMap);
                this.consumingMsgOrderlyTreeMap.clear();
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("rollback exception", interruptedException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long commit() {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                Long l2 = this.consumingMsgOrderlyTreeMap.lastKey();
                this.msgCount.addAndGet(0 - this.consumingMsgOrderlyTreeMap.size());
                for (MessageExt messageExt : this.consumingMsgOrderlyTreeMap.values()) {
                    this.msgSize.addAndGet(messageExt.getBody() != null ? (long)(0 - messageExt.getBody().length) : 0L);
                }
                this.consumingMsgOrderlyTreeMap.clear();
                if (l2 == null) return -1L;
                long l3 = l2 + 1L;
                return l3;
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("commit exception", interruptedException);
        }
        return -1L;
    }

    public void makeMessageToCosumeAgain(List<MessageExt> object) {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                object = object.iterator();
                while (object.hasNext()) {
                    MessageExt messageExt = (MessageExt)object.next();
                    this.consumingMsgOrderlyTreeMap.remove(messageExt.getQueueOffset());
                    this.msgTreeMap.put(messageExt.getQueueOffset(), messageExt);
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("makeMessageToCosumeAgain exception", interruptedException);
        }
    }

    public List<MessageExt> takeMessags(int n2) {
        ArrayList<MessageExt> arrayList = new ArrayList<MessageExt>(n2);
        long l2 = System.currentTimeMillis();
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            this.lastConsumeTimestamp = l2;
            try {
                if (!this.msgTreeMap.isEmpty()) {
                    Map.Entry<Long, MessageExt> entry;
                    for (int i2 = 0; i2 < n2 && (entry = this.msgTreeMap.pollFirstEntry()) != null; ++i2) {
                        arrayList.add(entry.getValue());
                        this.consumingMsgOrderlyTreeMap.put(entry.getKey(), entry.getValue());
                    }
                }
                if (arrayList.isEmpty()) {
                    this.consuming = false;
                }
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("take Messages exception", interruptedException);
        }
        return arrayList;
    }

    public boolean hasTempMessage() {
        this.lockTreeMap.readLock().lockInterruptibly();
        try {
            boolean bl = !this.msgTreeMap.isEmpty();
            this.lockTreeMap.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.lockTreeMap.readLock().unlock();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                return true;
            }
        }
    }

    public void clear() {
        try {
            this.lockTreeMap.writeLock().lockInterruptibly();
            try {
                this.msgTreeMap.clear();
                this.consumingMsgOrderlyTreeMap.clear();
                this.msgCount.set(0L);
                this.msgSize.set(0L);
                this.queueOffsetMax = 0L;
            }
            finally {
                this.lockTreeMap.writeLock().unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.error("rollback exception", interruptedException);
        }
    }

    public long getLastLockTimestamp() {
        return this.lastLockTimestamp;
    }

    public void setLastLockTimestamp(long l2) {
        this.lastLockTimestamp = l2;
    }

    public Lock getLockConsume() {
        return this.lockConsume;
    }

    public long getLastPullTimestamp() {
        return this.lastPullTimestamp;
    }

    public void setLastPullTimestamp(long l2) {
        this.lastPullTimestamp = l2;
    }

    public long getMsgAccCnt() {
        return this.msgAccCnt;
    }

    public void setMsgAccCnt(long l2) {
        this.msgAccCnt = l2;
    }

    public long getTryUnlockTimes() {
        return this.tryUnlockTimes.get();
    }

    public void incTryUnlockTimes() {
        this.tryUnlockTimes.incrementAndGet();
    }

    public void fillProcessQueueInfo(ProcessQueueInfo processQueueInfo) {
        try {
            this.lockTreeMap.readLock().lockInterruptibly();
            if (!this.msgTreeMap.isEmpty()) {
                processQueueInfo.setCachedMsgMinOffset(this.msgTreeMap.firstKey());
                processQueueInfo.setCachedMsgMaxOffset(this.msgTreeMap.lastKey());
                processQueueInfo.setCachedMsgCount(this.msgTreeMap.size());
                processQueueInfo.setCachedMsgSizeInMiB((int)(this.msgSize.get() / 0x100000L));
            }
            if (!this.consumingMsgOrderlyTreeMap.isEmpty()) {
                processQueueInfo.setTransactionMsgMinOffset(this.consumingMsgOrderlyTreeMap.firstKey());
                processQueueInfo.setTransactionMsgMaxOffset(this.consumingMsgOrderlyTreeMap.lastKey());
                processQueueInfo.setTransactionMsgCount(this.consumingMsgOrderlyTreeMap.size());
            }
            processQueueInfo.setLocked(this.locked);
            processQueueInfo.setTryUnlockTimes(this.tryUnlockTimes.get());
            processQueueInfo.setLastLockTimestamp(this.lastLockTimestamp);
            processQueueInfo.setDroped(this.dropped);
            processQueueInfo.setLastPullTimestamp(this.lastPullTimestamp);
            processQueueInfo.setLastConsumeTimestamp(this.lastConsumeTimestamp);
            return;
        }
        catch (Exception exception) {
            return;
        }
        finally {
            this.lockTreeMap.readLock().unlock();
        }
    }

    public long getLastConsumeTimestamp() {
        return this.lastConsumeTimestamp;
    }

    public void setLastConsumeTimestamp(long l2) {
        this.lastConsumeTimestamp = l2;
    }
}

