/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PullCallback;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PullResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.PullStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.FilterMessageContext;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.hook.FilterMessageHook;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.CommunicationMode;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.FindBrokerResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.PullResultExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.MQVersion$Version;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.filter.ExpressionType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageDecoder;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageExt;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.header.PullMessageRequestHeader;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.SubscriptionData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.route.TopicRouteData;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.sysflag.PullSysFlag;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class PullAPIWrapper {
    private final InternalLogger log = ClientLogger.getLog();
    private final MQClientInstance mQClientFactory;
    private final String consumerGroup;
    private final boolean unitMode;
    private ConcurrentMap<MessageQueue, AtomicLong> pullFromWhichNodeTable = new ConcurrentHashMap<MessageQueue, AtomicLong>(32);
    private volatile boolean connectBrokerByUser = false;
    private volatile long defaultBrokerId = 0L;
    private Random random = new Random(System.currentTimeMillis());
    private ArrayList<FilterMessageHook> filterMessageHookList = new ArrayList();

    public PullAPIWrapper(MQClientInstance mQClientInstance, String string, boolean bl) {
        this.mQClientFactory = mQClientInstance;
        this.consumerGroup = string;
        this.unitMode = bl;
    }

    public PullResult processPullResult(MessageQueue iterator, PullResult pullResult, SubscriptionData subscriptionData) {
        PullResultExt pullResultExt = (PullResultExt)pullResult;
        this.updatePullFromWhichNode((MessageQueue)((Object)iterator), pullResultExt.getSuggestWhichBrokerId());
        if (PullStatus.FOUND == pullResult.getPullStatus()) {
            iterator = ByteBuffer.wrap(pullResultExt.getMessageBinary());
            iterator = MessageDecoder.decodesBatch((ByteBuffer)((Object)iterator), this.mQClientFactory.getClientConfig().isDecodeReadBody(), this.mQClientFactory.getClientConfig().isDecodeDecompressBody(), true);
            List<MessageExt> list = iterator;
            if (!subscriptionData.getTagsSet().isEmpty() && !subscriptionData.isClassFilterMode()) {
                list = new ArrayList<MessageExt>(iterator.size());
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    MessageExt messageExt = (MessageExt)iterator.next();
                    if (messageExt.getTags() == null || !subscriptionData.getTagsSet().contains(messageExt.getTags())) continue;
                    list.add(messageExt);
                }
            }
            if (this.hasHook()) {
                iterator = new FilterMessageContext();
                ((FilterMessageContext)((Object)iterator)).setUnitMode(this.unitMode);
                ((FilterMessageContext)((Object)iterator)).setMsgList(list);
                this.executeHook((FilterMessageContext)((Object)iterator));
            }
            for (MessageExt messageExt : list) {
                MessageAccessor.putProperty(messageExt, "MIN_OFFSET", Long.toString(pullResult.getMinOffset()));
                MessageAccessor.putProperty(messageExt, "MAX_OFFSET", Long.toString(pullResult.getMaxOffset()));
            }
            pullResultExt.setMsgFoundList(list);
        }
        pullResultExt.setMessageBinary(null);
        return pullResult;
    }

    public void updatePullFromWhichNode(MessageQueue messageQueue, long l2) {
        AtomicLong atomicLong = (AtomicLong)this.pullFromWhichNodeTable.get(messageQueue);
        if (atomicLong == null) {
            this.pullFromWhichNodeTable.put(messageQueue, new AtomicLong(l2));
            return;
        }
        atomicLong.set(l2);
    }

    public boolean hasHook() {
        return !this.filterMessageHookList.isEmpty();
    }

    public void executeHook(FilterMessageContext filterMessageContext) {
        if (!this.filterMessageHookList.isEmpty()) {
            for (FilterMessageHook filterMessageHook : this.filterMessageHookList) {
                try {
                    filterMessageHook.filterMessage(filterMessageContext);
                }
                catch (Throwable throwable) {
                    this.log.error("execute hook error. hookName={}", (Object)filterMessageHook.hookName());
                }
            }
        }
    }

    public PullResult pullKernelImpl(MessageQueue object, String string, String string2, long l2, long l3, int n2, int n3, long l4, long l5, long l6, CommunicationMode communicationMode, PullCallback pullCallback, String string3) {
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(((MessageQueue)object).getBrokerName(), this.recalculatePullFromWhichNode((MessageQueue)object), false);
        if (findBrokerResult == null) {
            this.mQClientFactory.updateTopicRouteInfoFromNameServer(((MessageQueue)object).getTopic());
            findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(((MessageQueue)object).getBrokerName(), this.recalculatePullFromWhichNode((MessageQueue)object), false);
        }
        if (findBrokerResult != null) {
            if (!ExpressionType.isTagType(string2) && findBrokerResult.getBrokerVersion() < MQVersion$Version.V4_1_0_SNAPSHOT.ordinal()) {
                throw new MQClientException("The broker[" + ((MessageQueue)object).getBrokerName() + ", " + findBrokerResult.getBrokerVersion() + "] does not upgrade to support for filter message by " + string2, null);
            }
            int n4 = n3;
            if (findBrokerResult.isSlave()) {
                n4 = PullSysFlag.clearCommitOffsetFlag(n3);
            }
            PullMessageRequestHeader pullMessageRequestHeader = new PullMessageRequestHeader();
            pullMessageRequestHeader.setConsumerGroup(this.consumerGroup);
            pullMessageRequestHeader.setTopic(((MessageQueue)object).getTopic());
            pullMessageRequestHeader.setQueueId(((MessageQueue)object).getQueueId());
            pullMessageRequestHeader.setQueueOffset(l3);
            pullMessageRequestHeader.setMaxMsgNums(n2);
            pullMessageRequestHeader.setSysFlag(n4);
            pullMessageRequestHeader.setCommitOffset(l4);
            pullMessageRequestHeader.setSuspendTimeoutMillis(l5);
            pullMessageRequestHeader.setSubscription(string);
            pullMessageRequestHeader.setSubVersion(l2);
            pullMessageRequestHeader.setSubProperties(string3);
            pullMessageRequestHeader.setExpressionType(string2);
            string = findBrokerResult.getBrokerAddr();
            if (PullSysFlag.hasClassFilterFlag(n4)) {
                string = this.computPullFromWhichFilterServer(((MessageQueue)object).getTopic(), string);
            }
            object = this.mQClientFactory.getMQClientAPIImpl().pullMessage(string, pullMessageRequestHeader, l6, communicationMode, pullCallback);
            return object;
        }
        throw new MQClientException("The broker[" + ((MessageQueue)object).getBrokerName() + "] not exist", null);
    }

    public PullResult pullKernelImpl(MessageQueue messageQueue, String string, long l2, long l3, int n2, int n3, long l4, long l5, long l6, CommunicationMode communicationMode, PullCallback pullCallback, String string2) {
        return this.pullKernelImpl(messageQueue, string, "TAG", l2, l3, n2, n3, l4, l5, l6, communicationMode, pullCallback, string2);
    }

    public long recalculatePullFromWhichNode(MessageQueue serializable) {
        if (this.isConnectBrokerByUser()) {
            return this.defaultBrokerId;
        }
        if ((serializable = (AtomicLong)this.pullFromWhichNodeTable.get(serializable)) != null) {
            return ((AtomicLong)serializable).get();
        }
        return 0L;
    }

    private String computPullFromWhichFilterServer(String string, String string2) {
        Object object = this.mQClientFactory.getTopicRouteTable();
        if (object != null) {
            object = (TopicRouteData)object.get(string);
            if ((object = ((TopicRouteData)object).getFilterServerTable().get(string2)) != null && !object.isEmpty()) {
                return object.get(this.randomNum() % object.size());
            }
        }
        throw new MQClientException("Find Filter Server Failed, Broker Addr: " + string2 + " topic: " + string, null);
    }

    public boolean isConnectBrokerByUser() {
        return this.connectBrokerByUser;
    }

    public void setConnectBrokerByUser(boolean bl) {
        this.connectBrokerByUser = bl;
    }

    public int randomNum() {
        int n2 = this.random.nextInt();
        if (n2 < 0 && (n2 = Math.abs(n2)) < 0) {
            n2 = 0;
        }
        return n2;
    }

    public void registerFilterMessageHook(ArrayList<FilterMessageHook> arrayList) {
        this.filterMessageHookList = arrayList;
    }

    public long getDefaultBrokerId() {
        return this.defaultBrokerId;
    }

    public void setDefaultBrokerId(long l2) {
        this.defaultBrokerId = l2;
    }
}

