/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.MQConsumerInner;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.PullMessageService$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.PullMessageService$2;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.PullRequest;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.log.ClientLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.ServiceThread;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.utils.ThreadUtils;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PullMessageService
extends ServiceThread {
    private final InternalLogger log = ClientLogger.getLog();
    private final LinkedBlockingQueue<PullRequest> pullRequestQueue = new LinkedBlockingQueue();
    private final MQClientInstance mQClientFactory;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new PullMessageService$1(this));

    public PullMessageService(MQClientInstance mQClientInstance) {
        this.mQClientFactory = mQClientInstance;
    }

    public void executePullRequestLater(PullRequest pullRequest, long l2) {
        if (!this.isStopped()) {
            this.scheduledExecutorService.schedule(new PullMessageService$2(this, pullRequest), l2, TimeUnit.MILLISECONDS);
            return;
        }
        this.log.warn("PullMessageServiceScheduledThread has shutdown");
    }

    public void executePullRequestImmediately(PullRequest pullRequest) {
        try {
            this.pullRequestQueue.put(pullRequest);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.log.error("executePullRequestImmediately pullRequestQueue.put", interruptedException);
            return;
        }
    }

    public void executeTaskLater(Runnable runnable, long l2) {
        if (!this.isStopped()) {
            this.scheduledExecutorService.schedule(runnable, l2, TimeUnit.MILLISECONDS);
            return;
        }
        this.log.warn("PullMessageServiceScheduledThread has shutdown");
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    private void pullMessage(PullRequest pullRequest) {
        MQConsumerInner mQConsumerInner = this.mQClientFactory.selectConsumer(pullRequest.getConsumerGroup());
        if (mQConsumerInner != null) {
            mQConsumerInner = (DefaultMQPushConsumerImpl)mQConsumerInner;
            ((DefaultMQPushConsumerImpl)mQConsumerInner).pullMessage(pullRequest);
            return;
        }
        this.log.warn("No matched consumer for the PullRequest {}, drop it", (Object)pullRequest);
    }

    @Override
    public void run() {
        this.log.info(((ServiceThread)this).getServiceName() + " service started");
        while (!this.isStopped()) {
            try {
                PullRequest pullRequest = this.pullRequestQueue.take();
                this.pullMessage(pullRequest);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception exception) {
                this.log.error("Pull Message Service Run Method exception", exception);
            }
        }
        this.log.info(((ServiceThread)this).getServiceName() + " service end");
    }

    @Override
    public void shutdown(boolean bl) {
        super.shutdown(bl);
        ThreadUtils.shutdownGracefully(this.scheduledExecutorService, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public String getServiceName() {
        return PullMessageService.class.getSimpleName();
    }
}

