/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.OffsetStore;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer.store.ReadOffsetType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.ProcessQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.PullRequest;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.RebalanceImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.consumer.RebalancePushImpl$1;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.impl.factory.MQClientInstance;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.UtilAll;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.consumer.ConsumeFromWhere;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageQueue;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.ConsumeType;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.MessageModel;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.protocol.heartbeat.SubscriptionData;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RebalancePushImpl
extends RebalanceImpl {
    private static final long UNLOCK_DELAY_TIME_MILLS = Long.parseLong(System.getProperty("rocketmq.client.unlockDelayTimeMills", "20000"));
    private final DefaultMQPushConsumerImpl defaultMQPushConsumerImpl;

    public RebalancePushImpl(DefaultMQPushConsumerImpl defaultMQPushConsumerImpl) {
        this(null, null, null, null, defaultMQPushConsumerImpl);
    }

    public RebalancePushImpl(String string, MessageModel messageModel, AllocateMessageQueueStrategy allocateMessageQueueStrategy, MQClientInstance mQClientInstance, DefaultMQPushConsumerImpl defaultMQPushConsumerImpl) {
        super(string, messageModel, allocateMessageQueueStrategy, mQClientInstance);
        this.defaultMQPushConsumerImpl = defaultMQPushConsumerImpl;
    }

    @Override
    public void messageQueueChanged(String string, Set<MessageQueue> object, Set<MessageQueue> set) {
        object = (SubscriptionData)this.subscriptionInner.get(string);
        long l2 = System.currentTimeMillis();
        log.info("{} Rebalance changed, also update version: {}, {}", string, ((SubscriptionData)object).getSubVersion(), l2);
        ((SubscriptionData)object).setSubVersion(l2);
        int n2 = this.processQueueTable.size();
        if (n2 != 0) {
            int n3 = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdForTopic();
            if (n3 != -1) {
                n3 = Math.max(1, n3 / n2);
                log.info("The pullThresholdForQueue is changed from {} to {}", (Object)this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdForQueue(), (Object)n3);
                this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().setPullThresholdForQueue(n3);
            }
            if ((n3 = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdSizeForTopic()) != -1) {
                n2 = Math.max(1, n3 / n2);
                log.info("The pullThresholdSizeForQueue is changed from {} to {}", (Object)this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getPullThresholdSizeForQueue(), (Object)n2);
                this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().setPullThresholdSizeForQueue(n2);
            }
        }
        this.getmQClientFactory().sendHeartbeatToAllBrokerWithLock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeUnnecessaryMessageQueue(MessageQueue messageQueue, ProcessQueue processQueue) {
        this.defaultMQPushConsumerImpl.getOffsetStore().persist(messageQueue);
        this.defaultMQPushConsumerImpl.getOffsetStore().removeOffset(messageQueue);
        if (!this.defaultMQPushConsumerImpl.isConsumeOrderly()) return true;
        if (!MessageModel.CLUSTERING.equals((Object)this.defaultMQPushConsumerImpl.messageModel())) return true;
        try {
            if (!processQueue.getLockConsume().tryLock(1000L, TimeUnit.MILLISECONDS)) {
                log.warn("[WRONG]mq is consuming, so can not unlock it, {}. maybe hanged for a while, {}", (Object)messageQueue, (Object)processQueue.getTryUnlockTimes());
                processQueue.incTryUnlockTimes();
                return false;
            }
            try {
                boolean bl = this.unlockDelay(messageQueue, processQueue);
                return bl;
            }
            finally {
                processQueue.getLockConsume().unlock();
            }
        }
        catch (Exception exception) {
            log.error("removeUnnecessaryMessageQueue Exception", exception);
        }
        return false;
    }

    private boolean unlockDelay(MessageQueue messageQueue, ProcessQueue processQueue) {
        if (processQueue.hasTempMessage()) {
            log.info("[{}]unlockDelay, begin {} ", (Object)messageQueue.hashCode(), (Object)messageQueue);
            this.defaultMQPushConsumerImpl.getmQClientFactory().getScheduledExecutorService().schedule(new RebalancePushImpl$1(this, messageQueue), UNLOCK_DELAY_TIME_MILLS, TimeUnit.MILLISECONDS);
        } else {
            this.unlock(messageQueue, true);
        }
        return true;
    }

    @Override
    public ConsumeType consumeType() {
        return ConsumeType.CONSUME_PASSIVELY;
    }

    @Override
    public void removeDirtyOffset(MessageQueue messageQueue) {
        this.defaultMQPushConsumerImpl.getOffsetStore().removeOffset(messageQueue);
    }

    @Override
    public long computePullFromWhere(MessageQueue messageQueue) {
        long l2 = -1L;
        ConsumeFromWhere consumeFromWhere = this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getConsumeFromWhere();
        OffsetStore offsetStore = this.defaultMQPushConsumerImpl.getOffsetStore();
        switch (consumeFromWhere) {
            case CONSUME_FROM_LAST_OFFSET_AND_FROM_MIN_WHEN_BOOT_FIRST: 
            case CONSUME_FROM_MIN_OFFSET: 
            case CONSUME_FROM_MAX_OFFSET: 
            case CONSUME_FROM_LAST_OFFSET: {
                long l3 = offsetStore.readOffset(messageQueue, ReadOffsetType.READ_FROM_STORE);
                if (l3 >= 0L) {
                    l2 = l3;
                    break;
                }
                if (-1L == l3) {
                    if (messageQueue.getTopic().startsWith("%RETRY%")) {
                        l2 = 0L;
                        break;
                    }
                    try {
                        l2 = this.mQClientFactory.getMQAdminImpl().maxOffset(messageQueue);
                    }
                    catch (MQClientException mQClientException) {
                        l2 = -1L;
                    }
                    break;
                }
                l2 = -1L;
                break;
            }
            case CONSUME_FROM_FIRST_OFFSET: {
                long l4 = offsetStore.readOffset(messageQueue, ReadOffsetType.READ_FROM_STORE);
                if (l4 >= 0L) {
                    l2 = l4;
                    break;
                }
                if (-1L == l4) {
                    l2 = 0L;
                    break;
                }
                l2 = -1L;
                break;
            }
            case CONSUME_FROM_TIMESTAMP: {
                long l5 = offsetStore.readOffset(messageQueue, ReadOffsetType.READ_FROM_STORE);
                if (l5 >= 0L) {
                    l2 = l5;
                    break;
                }
                if (-1L == l5) {
                    if (messageQueue.getTopic().startsWith("%RETRY%")) {
                        try {
                            l2 = this.mQClientFactory.getMQAdminImpl().maxOffset(messageQueue);
                        }
                        catch (MQClientException mQClientException) {
                            l2 = -1L;
                        }
                        break;
                    }
                    try {
                        long l6 = UtilAll.parseDate(this.defaultMQPushConsumerImpl.getDefaultMQPushConsumer().getConsumeTimestamp(), "yyyyMMddHHmmss").getTime();
                        l2 = this.mQClientFactory.getMQAdminImpl().searchOffset(messageQueue, l6);
                        break;
                    }
                    catch (MQClientException mQClientException) {}
                }
                l2 = -1L;
            }
        }
        return l2;
    }

    @Override
    public void dispatchPullRequest(List<PullRequest> object) {
        object = object.iterator();
        while (object.hasNext()) {
            PullRequest pullRequest = (PullRequest)object.next();
            this.defaultMQPushConsumerImpl.executePullRequestImmediately(pullRequest);
            log.info("doRebalance, {}, add a new pull request {}", (Object)this.consumerGroup, (Object)pullRequest);
        }
    }
}

